import { Component, Input } from "@angular/core";
import { StiLabelElement } from "../../../../elements/StiLabelElement";
import { StiTableElement } from "../../../../elements/StiTableElement";
import { StiTotalsFieldItem } from "../../../../elements/table/StiTotalsFieldItem";
import { StiSingleSelectionElement } from "../../../../elements/StiSingleSelectionElement";
import { StiMultipleSelectionElement } from "../../../../elements/StiMultipleSelectionElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-expression.service";
import * as i5 from "@angular/common";
import * as i6 from "@angular/forms";
import * as i7 from "../../../../directives/sti-input-text.directive";
export class StiTextEditorComponent {
    constructor(model, helper, theme, expressionService) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.expressionService = expressionService;
    }
    ngOnInit() { }
    get haveExpression() {
        return (this.model.selectedComponent?.element instanceof StiLabelElement &&
            this.property.property == "text.value") ||
            (this.model.selectedComponent?.element instanceof StiTableElement && this.property.property == "expression")
            ? true
            : false;
    }
    setInfo() {
        if (this.object instanceof StiLabelElement) {
            this.model.currentExpressionInfo = 3;
        }
        else if (this.object instanceof StiTotalsFieldItem) {
            this.model.currentExpressionInfo = 2;
        }
        else {
            this.model.currentExpressionInfo = 1;
        }
        this.expressionService.currentSelectedObject = this.object;
        this.model.showExpressionEditor = true;
    }
    get content() {
        return this.helper.getProperty(this.object, this.property.property);
    }
    set content(value) {
        if (this.property.property == "customOptionText") {
            if (this.object instanceof StiSingleSelectionElement) {
                if (this.object.selectedOption == this.object.customOptionText) {
                    this.object.selectedOption = value;
                }
            }
            else if (this.object instanceof StiMultipleSelectionElement) {
                if (this.object.selectedOptions.indexOf(this.object?.customOptionText) >= 0) {
                    this.object.selectedOptions?.forEach((option) => {
                        if (this.object.options?.indexOf(option) == -1) {
                            this.object.selectedOptions?.splice(this.object.selectedOptions.indexOf(option), 1);
                        }
                    });
                    this.object.selectedOptions.push(value);
                }
            }
        }
        this.helper.setProperty(this.object, this.property.property, value);
        this.model.formEvents.next({ name: "ValueChanged" });
    }
}
StiTextEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTextEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiExpressionService }], target: i0.ɵɵFactoryTarget.Component });
StiTextEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTextEditorComponent, selector: "sti-text-editor", inputs: { property: "property", object: "object", disabled: "disabled" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property != 'font' && content.length >= 0">
        <td colspan="7" [style.width]="'100%'">
          <input
            type="text"
            stiInputText
            [(ngModel)]="content"
            class="{{ disabled ? 'disabled' : '' }}"
            spellcheck="false"
            [style]="{ width: '100%' }"
            [attr.maxLength]="
              property.property == 'this' && this.model.selectedComponent.element.maximum
                ? this.model.selectedComponent.element.maximum
                : null
            "
          />
        </td>
        <td *ngIf="haveExpression">
          <div class="expression-image" (click)="setInfo()">
            <img [src]="model.getImage('images.Properties.Expression.png')" />
          </div>
        </td>
      </tr>
    </table>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      td {
        padding: 0;
      }
      .disabled {
        background-color: lightgray;
        pointer-events: none;
      }
      .expression-image {
        height: 23.6px;
        width: 23.6px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        margin-left: 3px;
        margin-right: 0px;
        float: right;
      }
      img {
        height: 16px;
        width: 16px;
      }
      .expression-image:hover {
        background-color: var(--hover-color);
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      td {\n        padding: 0;\n      }\n      .disabled {\n        background-color: lightgray;\n        pointer-events: none;\n      }\n      .expression-image {\n        height: 23.6px;\n        width: 23.6px;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        border: 1px solid var(--inputBorder-color);\n        border-radius: 3px;\n        margin-left: 3px;\n        margin-right: 0px;\n        float: right;\n      }\n      img {\n        height: 16px;\n        width: 16px;\n      }\n      .expression-image:hover {\n        background-color: var(--hover-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i6.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i6.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i7.StiInputTextDirective, selector: "[stiInputText]" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTextEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-text-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property != 'font' && content.length >= 0">
        <td colspan="7" [style.width]="'100%'">
          <input
            type="text"
            stiInputText
            [(ngModel)]="content"
            class="{{ disabled ? 'disabled' : '' }}"
            spellcheck="false"
            [style]="{ width: '100%' }"
            [attr.maxLength]="
              property.property == 'this' && this.model.selectedComponent.element.maximum
                ? this.model.selectedComponent.element.maximum
                : null
            "
          />
        </td>
        <td *ngIf="haveExpression">
          <div class="expression-image" (click)="setInfo()">
            <img [src]="model.getImage('images.Properties.Expression.png')" />
          </div>
        </td>
      </tr>
    </table>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      td {
        padding: 0;
      }
      .disabled {
        background-color: lightgray;
        pointer-events: none;
      }
      .expression-image {
        height: 23.6px;
        width: 23.6px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        margin-left: 3px;
        margin-right: 0px;
        float: right;
      }
      img {
        height: 16px;
        width: 16px;
      }
      .expression-image:hover {
        background-color: var(--hover-color);
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiExpressionService }]; }, propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXRleHQtZWRpdG9yLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3Byb3BlcnR5R3JpZC9lZGl0b3JzL3N0aS10ZXh0LWVkaXRvci9zdGktdGV4dC1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBQ3pELE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxzQ0FBc0MsQ0FBQztBQUN2RSxPQUFPLEVBQUUsZUFBZSxFQUFFLE1BQU0sc0NBQXNDLENBQUM7QUFDdkUsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0sK0NBQStDLENBQUM7QUFNbkYsT0FBTyxFQUFFLHlCQUF5QixFQUFFLE1BQU0sZ0RBQWdELENBQUM7QUFDM0YsT0FBTyxFQUFFLDJCQUEyQixFQUFFLE1BQU0sa0RBQWtELENBQUM7Ozs7Ozs7OztBQStEL0YsTUFBTSxPQUFPLHNCQUFzQjtJQUtqQyxZQUNTLEtBQXNCLEVBQ3RCLE1BQXdCLEVBQ3hCLEtBQXNCLEVBQ3RCLGlCQUF1QztRQUh2QyxVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQUN0QixXQUFNLEdBQU4sTUFBTSxDQUFrQjtRQUN4QixVQUFLLEdBQUwsS0FBSyxDQUFpQjtRQUN0QixzQkFBaUIsR0FBakIsaUJBQWlCLENBQXNCO0lBQzdDLENBQUM7SUFFSixRQUFRLEtBQVUsQ0FBQztJQUVuQixJQUFXLGNBQWM7UUFDdkIsT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsT0FBTyxZQUFZLGVBQWU7WUFDdEUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksWUFBWSxDQUFDO1lBQ3ZDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxPQUFPLFlBQVksZUFBZSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLFlBQVksQ0FBQztZQUM1RyxDQUFDLENBQUMsSUFBSTtZQUNOLENBQUMsQ0FBQyxLQUFLLENBQUM7SUFDWixDQUFDO0lBQ0QsT0FBTztRQUNMLElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSxlQUFlLEVBQUU7WUFDMUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsR0FBRyxDQUFDLENBQUM7U0FDdEM7YUFBTSxJQUFJLElBQUksQ0FBQyxNQUFNLFlBQVksa0JBQWtCLEVBQUU7WUFDcEQsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsR0FBRyxDQUFDLENBQUM7U0FDdEM7YUFBTTtZQUNMLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLEdBQUcsQ0FBQyxDQUFDO1NBQ3RDO1FBQ0QsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7UUFDM0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUN0RSxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBSztRQUN0QixJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLGtCQUFrQixFQUFFO1lBQ2hELElBQUksSUFBSSxDQUFDLE1BQU0sWUFBWSx5QkFBeUIsRUFBRTtnQkFDcEQsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLGdCQUFnQixFQUFFO29CQUM5RCxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7aUJBQ3BDO2FBQ0Y7aUJBQU0sSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLDJCQUEyQixFQUFFO2dCQUM3RCxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLGdCQUFnQixDQUFDLElBQUksQ0FBQyxFQUFFO29CQUMzRSxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTt3QkFDOUMsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUU7NEJBQzlDLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7eUJBQ3JGO29CQUNILENBQUMsQ0FBQyxDQUFDO29CQUNILElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztpQkFDekM7YUFDRjtTQUNGO1FBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNwRSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsY0FBYyxFQUFFLENBQUMsQ0FBQztJQUN2RCxDQUFDOzttSEF0RFUsc0JBQXNCO3VHQUF0QixzQkFBc0IsaUlBM0R2Qjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBeURUOzJGQUVVLHNCQUFzQjtrQkE3RGxDLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLGlCQUFpQjtvQkFDM0IsUUFBUSxFQUFFOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0F5RFQ7aUJBQ0Y7c01BRVUsUUFBUTtzQkFBaEIsS0FBSztnQkFDRyxNQUFNO3NCQUFkLEtBQUs7Z0JBQ0csUUFBUTtzQkFBaEIsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aUxhYmVsRWxlbWVudCB9IGZyb20gXCIuLi8uLi8uLi8uLi9lbGVtZW50cy9TdGlMYWJlbEVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpVGFibGVFbGVtZW50IH0gZnJvbSBcIi4uLy4uLy4uLy4uL2VsZW1lbnRzL1N0aVRhYmxlRWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlUb3RhbHNGaWVsZEl0ZW0gfSBmcm9tIFwiLi4vLi4vLi4vLi4vZWxlbWVudHMvdGFibGUvU3RpVG90YWxzRmllbGRJdGVtXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUVkaXRvclByb3BlcnR5IH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL29iamVjdHNcIjtcclxuaW1wb3J0IHsgU3RpRXhwcmVzc2lvblNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vLi4vc2VydmljZXMvc3RpLWV4cHJlc3Npb24uc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlIZWxwZXJTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3N0aS1oZWxwZXIuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlUaGVtZVNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vLi4vc2VydmljZXMvdGhlbWUuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlTaW5nbGVTZWxlY3Rpb25FbGVtZW50IH0gZnJvbSBcIi4uLy4uLy4uLy4uL2VsZW1lbnRzL1N0aVNpbmdsZVNlbGVjdGlvbkVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpTXVsdGlwbGVTZWxlY3Rpb25FbGVtZW50IH0gZnJvbSBcIi4uLy4uLy4uLy4uL2VsZW1lbnRzL1N0aU11bHRpcGxlU2VsZWN0aW9uRWxlbWVudFwiO1xyXG5cclxuQENvbXBvbmVudCh7XHJcbiAgc2VsZWN0b3I6IFwic3RpLXRleHQtZWRpdG9yXCIsXHJcbiAgdGVtcGxhdGU6IGBcclxuICAgIDx0YWJsZSBjbGFzcz1cInN0aS1jbGVhclwiIFtzdHlsZV09XCJ7IHdpZHRoOiAnMTAwJScgfVwiPlxyXG4gICAgICA8dHIgKm5nSWY9XCJwcm9wZXJ0eS5wcm9wZXJ0eSAhPSAnZm9udCcgJiYgY29udGVudC5sZW5ndGggPj0gMFwiPlxyXG4gICAgICAgIDx0ZCBjb2xzcGFuPVwiN1wiIFtzdHlsZS53aWR0aF09XCInMTAwJSdcIj5cclxuICAgICAgICAgIDxpbnB1dFxyXG4gICAgICAgICAgICB0eXBlPVwidGV4dFwiXHJcbiAgICAgICAgICAgIHN0aUlucHV0VGV4dFxyXG4gICAgICAgICAgICBbKG5nTW9kZWwpXT1cImNvbnRlbnRcIlxyXG4gICAgICAgICAgICBjbGFzcz1cInt7IGRpc2FibGVkID8gJ2Rpc2FibGVkJyA6ICcnIH19XCJcclxuICAgICAgICAgICAgc3BlbGxjaGVjaz1cImZhbHNlXCJcclxuICAgICAgICAgICAgW3N0eWxlXT1cInsgd2lkdGg6ICcxMDAlJyB9XCJcclxuICAgICAgICAgICAgW2F0dHIubWF4TGVuZ3RoXT1cIlxyXG4gICAgICAgICAgICAgIHByb3BlcnR5LnByb3BlcnR5ID09ICd0aGlzJyAmJiB0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50LmVsZW1lbnQubWF4aW11bVxyXG4gICAgICAgICAgICAgICAgPyB0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50LmVsZW1lbnQubWF4aW11bVxyXG4gICAgICAgICAgICAgICAgOiBudWxsXHJcbiAgICAgICAgICAgIFwiXHJcbiAgICAgICAgICAvPlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgICAgPHRkICpuZ0lmPVwiaGF2ZUV4cHJlc3Npb25cIj5cclxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJleHByZXNzaW9uLWltYWdlXCIgKGNsaWNrKT1cInNldEluZm8oKVwiPlxyXG4gICAgICAgICAgICA8aW1nIFtzcmNdPVwibW9kZWwuZ2V0SW1hZ2UoJ2ltYWdlcy5Qcm9wZXJ0aWVzLkV4cHJlc3Npb24ucG5nJylcIiAvPlxyXG4gICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgPC90ZD5cclxuICAgICAgPC90cj5cclxuICAgIDwvdGFibGU+XHJcbiAgICA8c3R5bGU+XHJcbiAgICAgIHRyIHtcclxuICAgICAgICBwYWRkaW5nOiAzcHggMHB4IDNweCAwcHg7XHJcbiAgICAgIH1cclxuICAgICAgdGQge1xyXG4gICAgICAgIHBhZGRpbmc6IDA7XHJcbiAgICAgIH1cclxuICAgICAgLmRpc2FibGVkIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiBsaWdodGdyYXk7XHJcbiAgICAgICAgcG9pbnRlci1ldmVudHM6IG5vbmU7XHJcbiAgICAgIH1cclxuICAgICAgLmV4cHJlc3Npb24taW1hZ2Uge1xyXG4gICAgICAgIGhlaWdodDogMjMuNnB4O1xyXG4gICAgICAgIHdpZHRoOiAyMy42cHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG4gICAgICAgIGN1cnNvcjogcG9pbnRlcjtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCB2YXIoLS1pbnB1dEJvcmRlci1jb2xvcik7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIG1hcmdpbi1sZWZ0OiAzcHg7XHJcbiAgICAgICAgbWFyZ2luLXJpZ2h0OiAwcHg7XHJcbiAgICAgICAgZmxvYXQ6IHJpZ2h0O1xyXG4gICAgICB9XHJcbiAgICAgIGltZyB7XHJcbiAgICAgICAgaGVpZ2h0OiAxNnB4O1xyXG4gICAgICAgIHdpZHRoOiAxNnB4O1xyXG4gICAgICB9XHJcbiAgICAgIC5leHByZXNzaW9uLWltYWdlOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1ob3Zlci1jb2xvcik7XHJcbiAgICAgIH1cclxuICAgIDwvc3R5bGU+XHJcbiAgYCxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aVRleHRFZGl0b3JDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIEBJbnB1dCgpIHByb3BlcnR5OiBTdGlFZGl0b3JQcm9wZXJ0eTtcclxuICBASW5wdXQoKSBvYmplY3Q/OiBhbnk7XHJcbiAgQElucHV0KCkgZGlzYWJsZWQ/OiBib29sZWFuO1xyXG5cclxuICBjb25zdHJ1Y3RvcihcclxuICAgIHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLFxyXG4gICAgcHVibGljIGhlbHBlcjogU3RpSGVscGVyU2VydmljZSxcclxuICAgIHB1YmxpYyB0aGVtZTogU3RpVGhlbWVTZXJ2aWNlLFxyXG4gICAgcHVibGljIGV4cHJlc3Npb25TZXJ2aWNlOiBTdGlFeHByZXNzaW9uU2VydmljZVxyXG4gICkge31cclxuXHJcbiAgbmdPbkluaXQoKTogdm9pZCB7fVxyXG5cclxuICBwdWJsaWMgZ2V0IGhhdmVFeHByZXNzaW9uKCkge1xyXG4gICAgcmV0dXJuICh0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50Py5lbGVtZW50IGluc3RhbmNlb2YgU3RpTGFiZWxFbGVtZW50ICYmXHJcbiAgICAgIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJ0ZXh0LnZhbHVlXCIpIHx8XHJcbiAgICAgICh0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50Py5lbGVtZW50IGluc3RhbmNlb2YgU3RpVGFibGVFbGVtZW50ICYmIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJleHByZXNzaW9uXCIpXHJcbiAgICAgID8gdHJ1ZVxyXG4gICAgICA6IGZhbHNlO1xyXG4gIH1cclxuICBzZXRJbmZvKCkge1xyXG4gICAgaWYgKHRoaXMub2JqZWN0IGluc3RhbmNlb2YgU3RpTGFiZWxFbGVtZW50KSB7XHJcbiAgICAgIHRoaXMubW9kZWwuY3VycmVudEV4cHJlc3Npb25JbmZvID0gMztcclxuICAgIH0gZWxzZSBpZiAodGhpcy5vYmplY3QgaW5zdGFuY2VvZiBTdGlUb3RhbHNGaWVsZEl0ZW0pIHtcclxuICAgICAgdGhpcy5tb2RlbC5jdXJyZW50RXhwcmVzc2lvbkluZm8gPSAyO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5tb2RlbC5jdXJyZW50RXhwcmVzc2lvbkluZm8gPSAxO1xyXG4gICAgfVxyXG4gICAgdGhpcy5leHByZXNzaW9uU2VydmljZS5jdXJyZW50U2VsZWN0ZWRPYmplY3QgPSB0aGlzLm9iamVjdDtcclxuICAgIHRoaXMubW9kZWwuc2hvd0V4cHJlc3Npb25FZGl0b3IgPSB0cnVlO1xyXG4gIH1cclxuICBwdWJsaWMgZ2V0IGNvbnRlbnQoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5oZWxwZXIuZ2V0UHJvcGVydHkodGhpcy5vYmplY3QsIHRoaXMucHJvcGVydHkucHJvcGVydHkpO1xyXG4gIH1cclxuICBwdWJsaWMgc2V0IGNvbnRlbnQodmFsdWUpIHtcclxuICAgIGlmICh0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwiY3VzdG9tT3B0aW9uVGV4dFwiKSB7XHJcbiAgICAgIGlmICh0aGlzLm9iamVjdCBpbnN0YW5jZW9mIFN0aVNpbmdsZVNlbGVjdGlvbkVsZW1lbnQpIHtcclxuICAgICAgICBpZiAodGhpcy5vYmplY3Quc2VsZWN0ZWRPcHRpb24gPT0gdGhpcy5vYmplY3QuY3VzdG9tT3B0aW9uVGV4dCkge1xyXG4gICAgICAgICAgdGhpcy5vYmplY3Quc2VsZWN0ZWRPcHRpb24gPSB2YWx1ZTtcclxuICAgICAgICB9XHJcbiAgICAgIH0gZWxzZSBpZiAodGhpcy5vYmplY3QgaW5zdGFuY2VvZiBTdGlNdWx0aXBsZVNlbGVjdGlvbkVsZW1lbnQpIHtcclxuICAgICAgICBpZiAodGhpcy5vYmplY3Quc2VsZWN0ZWRPcHRpb25zLmluZGV4T2YodGhpcy5vYmplY3Q/LmN1c3RvbU9wdGlvblRleHQpID49IDApIHtcclxuICAgICAgICAgIHRoaXMub2JqZWN0LnNlbGVjdGVkT3B0aW9ucz8uZm9yRWFjaCgob3B0aW9uKSA9PiB7XHJcbiAgICAgICAgICAgIGlmICh0aGlzLm9iamVjdC5vcHRpb25zPy5pbmRleE9mKG9wdGlvbikgPT0gLTEpIHtcclxuICAgICAgICAgICAgICB0aGlzLm9iamVjdC5zZWxlY3RlZE9wdGlvbnM/LnNwbGljZSh0aGlzLm9iamVjdC5zZWxlY3RlZE9wdGlvbnMuaW5kZXhPZihvcHRpb24pLCAxKTtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgICB0aGlzLm9iamVjdC5zZWxlY3RlZE9wdGlvbnMucHVzaCh2YWx1ZSk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICB0aGlzLmhlbHBlci5zZXRQcm9wZXJ0eSh0aGlzLm9iamVjdCwgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSwgdmFsdWUpO1xyXG4gICAgdGhpcy5tb2RlbC5mb3JtRXZlbnRzLm5leHQoeyBuYW1lOiBcIlZhbHVlQ2hhbmdlZFwiIH0pO1xyXG4gIH1cclxufVxyXG4iXX0=