import { Component, Input } from "@angular/core";
import { Enum } from "../../../../system/Enum";
import { StiBodyBrush, StiQRCodeBodyShapeType, StiQRCodeErrorCorrectionLevel, StiQRCodeEyeBallShapeType, StiQRCodeEyeFrameShapeType, StiQRCodeSize, } from "../../../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../sti-dropdown-editor/sti-dropdown-editor.component";
export class StiSimpleEnumEditorComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    get type() {
        if (this.property.property == "matrixSize") {
            return StiQRCodeSize[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "errorCorrectionLevel") {
            return StiQRCodeErrorCorrectionLevel[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property.includes("BrushType")) {
            return StiBodyBrush[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "bodyShapeType") {
            return StiQRCodeBodyShapeType[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "eyeBallShapeType") {
            return StiQRCodeEyeBallShapeType[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "eyeFrameShapeType") {
            return StiQRCodeEyeFrameShapeType[this.helper.getProperty(this.object, this.property.property)];
        }
    }
    set type(value) {
        if (this.property.property == "matrixSize") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeSize, value, false));
        }
        else if (this.property.property == "errorCorrectionLevel") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeErrorCorrectionLevel, value));
        }
        else if (this.property.property.includes("BrushType")) {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiBodyBrush, value));
        }
        else if (this.property.property == "bodyShapeType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeBodyShapeType, value));
        }
        else if (this.property.property == "eyeBallShapeType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeEyeBallShapeType, value));
        }
        else if (this.property.property == "eyeFrameShapeType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeEyeFrameShapeType, value));
        }
        this.model.needToRefreshInnerProperties.next(true);
    }
    get enum() {
        if (this.property.property == "matrixSize") {
            return this.helper.dataMatrixSize;
        }
        else if (this.property.property == "errorCorrectionLevel") {
            return this.helper.errorCorrectionLevel;
        }
        else if (this.property.property.includes("BrushType")) {
            return this.helper.bodyBrush;
        }
        else if (this.property.property == "bodyShapeType") {
            return this.helper.bodyShapeType;
        }
        else if (this.property.property == "eyeBallShapeType") {
            return this.helper.eyeBallShapeType;
        }
        else if (this.property.property == "eyeFrameShapeType") {
            return this.helper.eyeFrameShapeType;
        }
    }
    ngOnInit() { }
}
StiSimpleEnumEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSimpleEnumEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component });
StiSimpleEnumEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiSimpleEnumEditorComponent, selector: "sti-simple-enum-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      span {\n        margin-left: 2px;\n        color: var(--text-color);\n        font-weight: normal;\n      }\n    "], dependencies: [{ kind: "component", type: i3.StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: ["value", "options", "optionLabel", "optionValue", "editable"], outputs: ["valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSimpleEnumEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-simple-enum-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }]; }, propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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