import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../../../../directives/sti-input-text.directive";
export class StiPaddingEditorComponent {
    constructor(model) {
        this.model = model;
        this.PADDINGS = ["left", "top", "right", "bottom"];
        this.CLASSES = ["pi pi-arrow-left", "pi pi-arrow-up", "pi pi-arrow-right", "pi pi-arrow-down"];
    }
    get padding() {
        return (this.model.selectedComponent?.element[this.property.property] ??
            (this.model.selectedPage ? this.model.selectedPage[this.property.property] : this.model.form.settings.padding));
    }
    setPadding(str, padding) {
        let value = !isNaN(parseFloat(str)) ? parseFloat(str) : 0;
        if (this.isValid(value, padding)) {
            if (value <= 0) {
                this.padding[padding] = 0;
                this.model.previousPadding[padding] = 0;
            }
            else {
                this.padding[padding] = value;
                this.model.previousPadding[padding] = value;
            }
            if (padding == "left" || padding == "right") {
                this.model.previousContentAreaWidth = this.model.lastUsedPage?.contentAreaWidth;
            }
        }
    }
    isValid(value, padding) {
        let maxHeight = this.model.selectedPage
            ? this.model.selectedPage.height
            : this.model.getElementPage(this.model.selectedComponent?.element)
                ? this.model.getElementPage(this.model.selectedComponent?.element).contentAreaHeight
                : this.model.getElementPanel(this.model.selectedComponent?.element)
                    ? this.model.getElementPanel(this.model.selectedComponent?.element).contentAreaHeight
                    : null;
        let maxWidth = this.model.selectedPage
            ? this.model.selectedPage.width
            : this.model.getElementPage(this.model.selectedComponent?.element)
                ? this.model.getElementPage(this.model.selectedComponent?.element).contentAreaWidth
                : this.model.getElementPanel(this.model.selectedComponent?.element)
                    ? this.model.getElementPanel(this.model.selectedComponent?.element).contentAreaWidth
                    : null;
        if (!maxHeight || !maxWidth) {
            maxHeight = this.model?.form?.pages[0].contentAreaHeight;
            maxWidth = this.model?.form?.pages[0].contentAreaWidth;
        }
        if (maxHeight && maxWidth) {
            let isValid = false;
            switch (padding) {
                case "left":
                    isValid = value + this.padding["right"] < maxWidth;
                    break;
                case "right":
                    isValid = value + this.padding["left"] < maxWidth;
                    break;
                case "top":
                    isValid = value + this.padding["bottom"] < maxHeight;
                    break;
                case "bottom":
                    isValid = value + this.padding["top"] < maxHeight;
                    break;
            }
            return isValid;
        }
        else {
            return true;
        }
    }
}
StiPaddingEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPaddingEditorComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiPaddingEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiPaddingEditorComponent, selector: "sti-padding-editor", inputs: { property: "property" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr [style]="{ width: '100%' }">
        <td *ngFor="let p of PADDINGS; index as i" [style]="{ minWidth: '50px' }">
          <span class="p-input-icon-left">
            <i [class]="CLASSES[i]" [style]="{ position: 'absolute', left: '3px', top: '17px' }"></i>
            <input
              type="text"
              stiInputText
              [ngModel]="padding[p]"
              spellcheck="false"
              (input)="setPadding($event.target.value, p)"
              [style]="{ width: '100%', paddingLeft: '11px' }"
            />
          </span>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n    "], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i4.StiInputTextDirective, selector: "[stiInputText]" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPaddingEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-padding-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr [style]="{ width: '100%' }">
        <td *ngFor="let p of PADDINGS; index as i" [style]="{ minWidth: '50px' }">
          <span class="p-input-icon-left">
            <i [class]="CLASSES[i]" [style]="{ position: 'absolute', left: '3px', top: '17px' }"></i>
            <input
              type="text"
              stiInputText
              [ngModel]="padding[p]"
              spellcheck="false"
              (input)="setPadding($event.target.value, p)"
              [style]="{ width: '100%', paddingLeft: '11px' }"
            />
          </span>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { property: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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