import { Component, Input, ViewChild } from "@angular/core";
import { StiNumberBoxElement } from "../../../../elements/StiNumberBoxElement";
import StiRectangleGeometryLayout from "../../../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "@angular/forms";
export class StiNumberEditorComponent {
    constructor(model, helper, theme, loc, render) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.render = render;
        this.isIncrement = false;
        this.isDecrement = false;
    }
    get gridCounter() {
        return this._gridCounter;
    }
    set gridCounter(value) {
        if (this.property.property == "gridColumns") {
            if (value <= 12) {
                this._gridCounter = 12;
            }
            else if (value > this.model.form.pages[this.model.form.pages.length - 1].contentAreaWidth) {
                this._gridCounter = this.model.form.pages[this.model.form.pages.length - 1].contentAreaWidth;
            }
            else {
                this._gridCounter = value;
            }
        }
        else {
            if (value <= 1) {
                this._gridCounter = 1;
            }
            else if (value > this.model.form.pages[this.model.form.pages.length - 1].contentAreaHeight) {
                this._gridCounter = this.model.form.pages[this.model.form.pages.length - 1].contentAreaHeight;
            }
            else {
                this._gridCounter = value;
            }
        }
    }
    ngOnDestroy() {
        if (this.numberInput) {
            if (this.numberInput.nativeElement.value && Number(this.numberInput.nativeElement.value) != this.counter) {
                this.onLostFocus(this.numberInput.nativeElement.value);
            }
        }
    }
    ngOnInit() {
        if (this.property.property == "gridColumns" || this.property.property == "gridVerticalStep") {
            this.gridCounter = this.helper.getProperty(this.element, this.property.property)
                ? parseFloat(this.helper.getProperty(this.element, this.property.property))
                : this.helper.getProperty(this.element, this.property.property);
        }
    }
    onLostFocus(value) {
        if (this.property.property == "gridColumns" || this.property.property == "gridVerticalStep") {
            this.gridCounter = Number(value);
            return;
        }
        this.helper.setProperty(this.obj ?? this.element, this.property.property, Number(value));
        if (this.element instanceof StiNumberBoxElement && this.element.useRange && this.property.property == "value") {
            this.model.checkNumberRange(this.element);
        }
        else if (this.element instanceof StiNumberBoxElement && this.property.property == "decimalDigits") {
            this.model.needToRefresh.next(true);
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    applySettings() {
        this.helper.setProperty(this.element, this.property.property, this.gridCounter);
        this.model.formEvents.next({ name: "ValueChanged" });
        setTimeout(() => {
            this.checkOutputs();
        }, 300);
    }
    checkOutputs() {
        this.model.form.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element.x + element.width > page.contentAreaWidth) {
                    element.x = 0;
                }
            });
        });
        this.checkOnOverlay();
        this.model.form.pages.forEach((page) => {
            this.render.checkOutputs(page);
        });
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    checkOnOverlay() {
        let hasOverlayedElements = false;
        this.model.form.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                let overlayedElements = page.allElements.filter((elem) => elem.x == element.x && elem.y == element.x);
                if (overlayedElements.length > 1) {
                    overlayedElements.forEach((overlayedElement, index) => {
                        if (index != 0) {
                            hasOverlayedElements = true;
                            overlayedElement.y += index;
                        }
                    });
                }
            });
        });
        if (hasOverlayedElements) {
            this.model.form.allElements.forEach((element) => {
                let container = this.model.getElementPage(element) ?? this.model.getElementPanel(element);
                this.render.insertElement(element, container.contentAreaWidth);
            });
        }
    }
    clearTimers() {
        this.isIncrement = false;
        this.isDecrement = false;
        clearTimeout(this.timeout);
        clearInterval(this.interval);
    }
    iterate() {
        if (this.isIncrement) {
            if (this.model.selectedPage) {
                this.model.selectedPage[this.property.property] += 1;
            }
            else {
                this.counter += 1;
            }
        }
        else if (this.isDecrement) {
            if (this.model.selectedPage) {
                this.model.selectedPage[this.property.property] -= 1;
            }
            else {
                this.counter -= 1;
            }
        }
    }
    setIncrementInterval() {
        this.isIncrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    setDecrementInterval() {
        this.isDecrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    get element() {
        return this.model.selectedComponent?.element ?? this.model.form.settings;
    }
    get counter() {
        if (this.property.property != "gridColumns" && this.property.property != "gridVerticalStep") {
            if (this.obj) {
                return this.helper.getProperty(this.obj, this.property.property)
                    ? parseFloat(this.helper.getProperty(this.obj, this.property.property))
                    : this.helper.getProperty(this.obj, this.property.property);
            }
            return this.helper.getProperty(this.element, this.property.property);
        }
        else {
            return this.gridCounter;
        }
    }
    validNegativeValue() {
        if (this.obj instanceof StiNumberBoxElement) {
            if (this.property.property == "value" ||
                this.property.property == "minimum" ||
                this.property.property == "maximum") {
                return true;
            }
            else
                return false;
        }
        else {
            return false;
        }
    }
    set counter(value) {
        if (value < 0 && !this.validNegativeValue()) {
            return;
        }
        if (this.property.property != "gridColumns" && this.property.property != "gridVerticalStep") {
            if (this.obj) {
                this.helper.setProperty(this.obj, this.property.property, value);
            }
            else {
                this.helper.setProperty(this.element, this.property.property, value);
                if (this.element instanceof StiNumberBoxElement && this.element.useRange && this.property.property == "value") {
                    this.model.checkNumberRange(this.element);
                }
            }
        }
        else {
            this.gridCounter = value;
            this.model.formEvents.next({ name: "ValueChanged" });
        }
    }
}
StiNumberEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiNumberEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Component });
StiNumberEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiNumberEditorComponent, selector: "sti-number-editor", inputs: { property: "property", obj: "obj" }, viewQueries: [{ propertyName: "numberInput", first: true, predicate: ["numberInput"], descendants: true }], ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'pageNumberEditor'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                [(ngModel)]="model.selectedPage[property.property]"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>

      <tr *ngIf="property.type === 'NumberEditor' || property.type === 'Number'">
        <td [colSpan]="this.property.property == 'label.width' ? 5 : 7">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                #numberInput
                (blur)="onLostFocus($event.currentTarget.value)"
                (keyup.enter)="onLostFocus($event.currentTarget.value)"
                [value]="counter"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
        <td
          *ngIf="
            property.type === 'Number' &&
            (property.property == 'gridColumns' || property.property == 'gridVerticalStep')
          "
        >
          <div class="apply-button" (click)="applySettings()">
            <label>{{ loc.getP("Apply") }}</label>
          </div>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 1px;
      }
      label {
        margin: 0;
        font-size: 12px;
        font-weight: 500;
        color: var(--text-color);
        white-space: nowrap;
        outline: none;
        overflow: hidden;
        scroll-behavior: smooth;
      }
      .apply-button {
        height: 24px;
        width: 100%;
        min-width: 60px;
        border-radius: 3px;
        background-color: var(--hover-color);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 3px;
      }
      .apply-button:hover {
        background-color: var(--active-color);
      }
      .value:hover {
        cursor: text;
      }
      .image-upload > input {
        display: none;
      }
      .number-box {
        width: 100%;
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        background-color: var(--input-color);
        position: relative;
        display: flex;
      }
      .value {
        outline: none;
        width: 100%;
        height: 100%;
      }
      .value input {
        outline: none;
        background-color: var(--input-color);
        -moz-appearance: textfield;
        color: var(--text-color);
        border: 0px;
      }
      .value input[type="number"]::-webkit-inner-spin-button,
      .value input[type="number"]::-webkit-outer-spin-button {
        -webkit-appearance: none;
        margin: 0;
        opacity: 0;
      }

      .value:after {
        content: "";
        position: absolute;
        right: 22px;
        z-index: 100;
        top: 2px;
        width: 1px;
        height: 18px;
        background-color: var(--inputBorder-color);
      }
      .buttons {
        width: 22px;
        height: 100%;
        align-self: flex-end;
        display: flex;
        flex-direction: column;

        color: rgb(186, 185, 184);
      }
      .button-up {
        width: 22px;
        position: relative;
        height: 11px;
        border-bottom: 1px solid var(--inputBorder-color);
        text-align: center;
      }
      .button-up:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-up:active {
        background-color: rgb(195, 195, 195);
      }
      .button-down {
        width: 22px;
        position: relative;
        height: 11px;
        text-align: center;
      }
      .button-down:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-down:active {
        background-color: rgb(195, 195, 195);
      }
      i {
        position: absolute;
        left: 5px;
        height: 8px;
        width: 8px;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 1px;\n      }\n      label {\n        margin: 0;\n        font-size: 12px;\n        font-weight: 500;\n        color: var(--text-color);\n        white-space: nowrap;\n        outline: none;\n        overflow: hidden;\n        scroll-behavior: smooth;\n      }\n      .apply-button {\n        height: 24px;\n        width: 100%;\n        min-width: 60px;\n        border-radius: 3px;\n        background-color: var(--hover-color);\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        margin-left: 3px;\n      }\n      .apply-button:hover {\n        background-color: var(--active-color);\n      }\n      .value:hover {\n        cursor: text;\n      }\n      .image-upload > input {\n        display: none;\n      }\n      .number-box {\n        width: 100%;\n        height: 24px;\n        border: 1px solid var(--inputBorder-color);\n        border-radius: 3px;\n        background-color: var(--input-color);\n        position: relative;\n        display: flex;\n      }\n      .value {\n        outline: none;\n        width: 100%;\n        height: 100%;\n      }\n      .value input {\n        outline: none;\n        background-color: var(--input-color);\n        -moz-appearance: textfield;\n        color: var(--text-color);\n        border: 0px;\n      }\n      .value input[type=\"number\"]::-webkit-inner-spin-button,\n      .value input[type=\"number\"]::-webkit-outer-spin-button {\n        -webkit-appearance: none;\n        margin: 0;\n        opacity: 0;\n      }\n\n      .value:after {\n        content: \"\";\n        position: absolute;\n        right: 22px;\n        z-index: 100;\n        top: 2px;\n        width: 1px;\n        height: 18px;\n        background-color: var(--inputBorder-color);\n      }\n      .buttons {\n        width: 22px;\n        height: 100%;\n        align-self: flex-end;\n        display: flex;\n        flex-direction: column;\n\n        color: rgb(186, 185, 184);\n      }\n      .button-up {\n        width: 22px;\n        position: relative;\n        height: 11px;\n        border-bottom: 1px solid var(--inputBorder-color);\n        text-align: center;\n      }\n      .button-up:hover {\n        background-color: rgb(209, 208, 207);\n      }\n      .button-up:active {\n        background-color: rgb(195, 195, 195);\n      }\n      .button-down {\n        width: 22px;\n        position: relative;\n        height: 11px;\n        text-align: center;\n      }\n      .button-down:hover {\n        background-color: rgb(209, 208, 207);\n      }\n      .button-down:active {\n        background-color: rgb(195, 195, 195);\n      }\n      i {\n        position: absolute;\n        left: 5px;\n        height: 8px;\n        width: 8px;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i6.NumberValueAccessor, selector: "input[type=number][formControlName],input[type=number][formControl],input[type=number][ngModel]" }, { kind: "directive", type: i6.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i6.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiNumberEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-number-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'pageNumberEditor'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                [(ngModel)]="model.selectedPage[property.property]"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>

      <tr *ngIf="property.type === 'NumberEditor' || property.type === 'Number'">
        <td [colSpan]="this.property.property == 'label.width' ? 5 : 7">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                #numberInput
                (blur)="onLostFocus($event.currentTarget.value)"
                (keyup.enter)="onLostFocus($event.currentTarget.value)"
                [value]="counter"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setDecrementInterval()"
                (mouseup)="clearTimers()"
                (mouseleave)="clearTimers()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
        <td
          *ngIf="
            property.type === 'Number' &&
            (property.property == 'gridColumns' || property.property == 'gridVerticalStep')
          "
        >
          <div class="apply-button" (click)="applySettings()">
            <label>{{ loc.getP("Apply") }}</label>
          </div>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 1px;
      }
      label {
        margin: 0;
        font-size: 12px;
        font-weight: 500;
        color: var(--text-color);
        white-space: nowrap;
        outline: none;
        overflow: hidden;
        scroll-behavior: smooth;
      }
      .apply-button {
        height: 24px;
        width: 100%;
        min-width: 60px;
        border-radius: 3px;
        background-color: var(--hover-color);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 3px;
      }
      .apply-button:hover {
        background-color: var(--active-color);
      }
      .value:hover {
        cursor: text;
      }
      .image-upload > input {
        display: none;
      }
      .number-box {
        width: 100%;
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        border-radius: 3px;
        background-color: var(--input-color);
        position: relative;
        display: flex;
      }
      .value {
        outline: none;
        width: 100%;
        height: 100%;
      }
      .value input {
        outline: none;
        background-color: var(--input-color);
        -moz-appearance: textfield;
        color: var(--text-color);
        border: 0px;
      }
      .value input[type="number"]::-webkit-inner-spin-button,
      .value input[type="number"]::-webkit-outer-spin-button {
        -webkit-appearance: none;
        margin: 0;
        opacity: 0;
      }

      .value:after {
        content: "";
        position: absolute;
        right: 22px;
        z-index: 100;
        top: 2px;
        width: 1px;
        height: 18px;
        background-color: var(--inputBorder-color);
      }
      .buttons {
        width: 22px;
        height: 100%;
        align-self: flex-end;
        display: flex;
        flex-direction: column;

        color: rgb(186, 185, 184);
      }
      .button-up {
        width: 22px;
        position: relative;
        height: 11px;
        border-bottom: 1px solid var(--inputBorder-color);
        text-align: center;
      }
      .button-up:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-up:active {
        background-color: rgb(195, 195, 195);
      }
      .button-down {
        width: 22px;
        position: relative;
        height: 11px;
        text-align: center;
      }
      .button-down:hover {
        background-color: rgb(209, 208, 207);
      }
      .button-down:active {
        background-color: rgb(195, 195, 195);
      }
      i {
        position: absolute;
        left: 5px;
        height: 8px;
        width: 8px;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }, { type: StiRectangleGeometryLayout }]; }, propDecorators: { numberInput: [{
                type: ViewChild,
                args: ["numberInput"]
            }], property: [{
                type: Input
            }], obj: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLW51bWJlci1lZGl0b3IuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvcHJvcGVydHlHcmlkL2VkaXRvcnMvc3RpLW51bWJlci1lZGl0b3Ivc3RpLW51bWJlci1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQWMsS0FBSyxFQUFxQixTQUFTLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDM0YsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sMENBQTBDLENBQUM7QUFNL0UsT0FBTywwQkFBMEIsTUFBTSxpREFBaUQsQ0FBQzs7Ozs7Ozs7QUF1TnpGLE1BQU0sT0FBTyx3QkFBd0I7SUFpQ25DLFlBQ1MsS0FBc0IsRUFDdEIsTUFBd0IsRUFDeEIsS0FBc0IsRUFDdEIsR0FBMkIsRUFDM0IsTUFBa0M7UUFKbEMsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsV0FBTSxHQUFOLE1BQU0sQ0FBa0I7UUFDeEIsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsUUFBRyxHQUFILEdBQUcsQ0FBd0I7UUFDM0IsV0FBTSxHQUFOLE1BQU0sQ0FBNEI7UUFsQ3BDLGdCQUFXLEdBQVksS0FBSyxDQUFDO1FBQzdCLGdCQUFXLEdBQVksS0FBSyxDQUFDO0lBa0NqQyxDQUFDO0lBOUJKLElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSxhQUFhLEVBQUU7WUFDM0MsSUFBSSxLQUFLLElBQUksRUFBRSxFQUFFO2dCQUNmLElBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFDO2FBQ3hCO2lCQUFNLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixFQUFFO2dCQUMzRixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDO2FBQzlGO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO2FBQzNCO1NBQ0Y7YUFBTTtZQUNMLElBQUksS0FBSyxJQUFJLENBQUMsRUFBRTtnQkFDZCxJQUFJLENBQUMsWUFBWSxHQUFHLENBQUMsQ0FBQzthQUN2QjtpQkFBTSxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxpQkFBaUIsRUFBRTtnQkFDNUYsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxpQkFBaUIsQ0FBQzthQUMvRjtpQkFBTTtnQkFDTCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQzthQUMzQjtTQUNGO0lBQ0gsQ0FBQztJQVVELFdBQVc7UUFDVCxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDcEIsSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQyxLQUFLLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7Z0JBQ3hHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7YUFDeEQ7U0FDRjtJQUNILENBQUM7SUFDRCxRQUFRO1FBQ04sSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSxhQUFhLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksa0JBQWtCLEVBQUU7WUFDM0YsSUFBSSxDQUFDLFdBQVcsR0FBSSxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFZO2dCQUMxRixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztnQkFDM0UsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUNuRTtJQUNILENBQUM7SUFFRCxXQUFXLENBQUMsS0FBSztRQUNmLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksYUFBYSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLGtCQUFrQixFQUFFO1lBQzNGLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2pDLE9BQU87U0FDUjtRQUNELElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsRUFBRSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUN6RixJQUFJLElBQUksQ0FBQyxPQUFPLFlBQVksbUJBQW1CLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksT0FBTyxFQUFFO1lBQzdHLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1NBQzNDO2FBQU0sSUFBSSxJQUFJLENBQUMsT0FBTyxZQUFZLG1CQUFtQixJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLGVBQWUsRUFBRTtZQUNuRyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDckM7UUFDRCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsY0FBYyxFQUFFLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQsYUFBYTtRQUNYLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ2hGLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQyxDQUFDO1FBQ3JELFVBQVUsQ0FBQyxHQUFHLEVBQUU7WUFDZCxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7UUFDdEIsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ1YsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFO1lBQ3JDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0JBQ25DLElBQUksT0FBTyxDQUFDLENBQUMsR0FBRyxPQUFPLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRTtvQkFDckQsT0FBTyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7aUJBQ2Y7WUFDSCxDQUFDLENBQUMsQ0FBQztRQUNMLENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1FBQ3RCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUNyQyxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNqQyxDQUFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxjQUFjO1FBQ1osSUFBSSxvQkFBb0IsR0FBRyxLQUFLLENBQUM7UUFDakMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFO1lBQ3JDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0JBQ25DLElBQUksaUJBQWlCLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLENBQUMsSUFBSSxJQUFJLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDdEcsSUFBSSxpQkFBaUIsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO29CQUNoQyxpQkFBaUIsQ0FBQyxPQUFPLENBQUMsQ0FBQyxnQkFBZ0IsRUFBRSxLQUFLLEVBQUUsRUFBRTt3QkFDcEQsSUFBSSxLQUFLLElBQUksQ0FBQyxFQUFFOzRCQUNkLG9CQUFvQixHQUFHLElBQUksQ0FBQzs0QkFDNUIsZ0JBQWdCLENBQUMsQ0FBQyxJQUFJLEtBQUssQ0FBQzt5QkFDN0I7b0JBQ0gsQ0FBQyxDQUFDLENBQUM7aUJBQ0o7WUFDSCxDQUFDLENBQUMsQ0FBQztRQUNMLENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxvQkFBb0IsRUFBRTtZQUN4QixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUU7Z0JBQzlDLElBQUksU0FBUyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDO2dCQUMxRixJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEVBQUUsU0FBUyxDQUFDLGdCQUFnQixDQUFDLENBQUM7WUFDakUsQ0FBQyxDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7SUFDRCxXQUFXO1FBQ1QsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7UUFDekIsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7UUFDekIsWUFBWSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUMzQixhQUFhLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFDRCxPQUFPO1FBQ0wsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFO1lBQ3BCLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEVBQUU7Z0JBQzNCLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ3REO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxPQUFPLElBQUksQ0FBQyxDQUFDO2FBQ25CO1NBQ0Y7YUFBTSxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDM0IsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRTtnQkFDM0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7YUFDdEQ7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLENBQUM7YUFDbkI7U0FDRjtJQUNILENBQUM7SUFDRCxvQkFBb0I7UUFDbEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7UUFDeEIsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBQ2YsSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxPQUFPLEdBQUcsVUFBVSxDQUFDO1lBQ3hCLEtBQUssQ0FBQyxRQUFRLEdBQUcsV0FBVyxDQUFDO2dCQUMzQixLQUFLLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDbEIsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ1QsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ1YsQ0FBQztJQUNELG9CQUFvQjtRQUNsQixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztRQUN4QixJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDZixJQUFJLEtBQUssR0FBRyxJQUFJLENBQUM7UUFDakIsSUFBSSxDQUFDLE9BQU8sR0FBRyxVQUFVLENBQUM7WUFDeEIsS0FBSyxDQUFDLFFBQVEsR0FBRyxXQUFXLENBQUM7Z0JBQzNCLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUNsQixDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDVCxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDVixDQUFDO0lBQ0QsSUFBSSxPQUFPO1FBQ1QsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLE9BQU8sSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDM0UsQ0FBQztJQUVELElBQUksT0FBTztRQUNULElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksYUFBYSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLGtCQUFrQixFQUFFO1lBQzNGLElBQUksSUFBSSxDQUFDLEdBQUcsRUFBRTtnQkFDWixPQUFRLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQVk7b0JBQzFFLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO29CQUN2RSxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO2FBQy9EO1lBQ0QsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDdEU7YUFBTTtZQUNMLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztTQUN6QjtJQUNILENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxJQUFJLENBQUMsR0FBRyxZQUFZLG1CQUFtQixFQUFFO1lBQzNDLElBQ0UsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksT0FBTztnQkFDakMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksU0FBUztnQkFDbkMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksU0FBUyxFQUNuQztnQkFDQSxPQUFPLElBQUksQ0FBQzthQUNiOztnQkFBTSxPQUFPLEtBQUssQ0FBQztTQUNyQjthQUFNO1lBQ0wsT0FBTyxLQUFLLENBQUM7U0FDZDtJQUNILENBQUM7SUFDRCxJQUFJLE9BQU8sQ0FBQyxLQUFhO1FBQ3ZCLElBQUksS0FBSyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxFQUFFO1lBQzNDLE9BQU87U0FDUjtRQUNELElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUksYUFBYSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLGtCQUFrQixFQUFFO1lBQzNGLElBQUksSUFBSSxDQUFDLEdBQUcsRUFBRTtnQkFDWixJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDO2FBQ2xFO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7Z0JBQ3JFLElBQUksSUFBSSxDQUFDLE9BQU8sWUFBWSxtQkFBbUIsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSxPQUFPLEVBQUU7b0JBQzdHLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO2lCQUMzQzthQUNGO1NBQ0Y7YUFBTTtZQUNMLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO1lBQ3pCLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQyxDQUFDO1NBQ3REO0lBQ0gsQ0FBQzs7cUhBdk1VLHdCQUF3QixzSkF2TjlCLDBCQUEwQjt5R0F1TnBCLHdCQUF3QixtTkFuTnpCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQWlOVDsyRkFFVSx3QkFBd0I7a0JBck5wQyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxtQkFBbUI7b0JBQzdCLFFBQVEsRUFBRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FpTlQ7aUJBQ0Y7MExBdE5NLDBCQUEwQiwwQkF3TkwsV0FBVztzQkFBcEMsU0FBUzt1QkFBQyxhQUFhO2dCQThCZixRQUFRO3NCQUFoQixLQUFLO2dCQUNHLEdBQUc7c0JBQVgsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgRWxlbWVudFJlZiwgSW5wdXQsIE9uRGVzdHJveSwgT25Jbml0LCBWaWV3Q2hpbGQgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlOdW1iZXJCb3hFbGVtZW50IH0gZnJvbSBcIi4uLy4uLy4uLy4uL2VsZW1lbnRzL1N0aU51bWJlckJveEVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpRWRpdG9yUHJvcGVydHkgfSBmcm9tIFwiLi4vLi4vLi4vLi4vc2VydmljZXMvb2JqZWN0c1wiO1xyXG5pbXBvcnQgeyBTdGlIZWxwZXJTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3N0aS1oZWxwZXIuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlUaGVtZVNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vLi4vc2VydmljZXMvdGhlbWUuc2VydmljZVwiO1xyXG5pbXBvcnQgU3RpUmVjdGFuZ2xlR2VvbWV0cnlMYXlvdXQgZnJvbSBcIi4uLy4uLy4uLy4uL2NvbXB1dGVkL1N0aVJlY3RhbmdsZUdlb21ldHJ5TGF5b3V0XCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJzdGktbnVtYmVyLWVkaXRvclwiLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8dGFibGUgY2xhc3M9XCJzdGktY2xlYXJcIiBbc3R5bGVdPVwieyB3aWR0aDogJzEwMCUnIH1cIj5cclxuICAgICAgPHRyICpuZ0lmPVwicHJvcGVydHkudHlwZSA9PT0gJ3BhZ2VOdW1iZXJFZGl0b3InXCI+XHJcbiAgICAgICAgPHRkIGNvbHNwYW49XCI1XCIgW3N0eWxlXT1cInsgd2lkdGg6ICcxMDAlJyB9XCI+XHJcbiAgICAgICAgICA8ZGl2IGNsYXNzPVwibnVtYmVyLWJveFwiPlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwidmFsdWVcIj5cclxuICAgICAgICAgICAgICA8aW5wdXRcclxuICAgICAgICAgICAgICAgIHR5cGU9XCJudW1iZXJcIlxyXG4gICAgICAgICAgICAgICAgWyhuZ01vZGVsKV09XCJtb2RlbC5zZWxlY3RlZFBhZ2VbcHJvcGVydHkucHJvcGVydHldXCJcclxuICAgICAgICAgICAgICAgIGNsYXNzPVwicC1pbnB1dG51bWJlci1idXR0b25cIlxyXG4gICAgICAgICAgICAgICAgW3N0eWxlXT1cIntcclxuICAgICAgICAgICAgICAgICAgd2lkdGg6ICcxMDAlJyxcclxuICAgICAgICAgICAgICAgICAgaGVpZ2h0OiAnMTAwJScsXHJcbiAgICAgICAgICAgICAgICAgIGZvbnRTaXplOiAnMTJweCcsXHJcbiAgICAgICAgICAgICAgICAgIGZvbnRXZWlnaHQ6ICc1MDAnLFxyXG4gICAgICAgICAgICAgICAgICBwYWRkaW5nOiAnM3B4IDVweCcsXHJcbiAgICAgICAgICAgICAgICAgIGJvcmRlclJhZGl1czogJzNweCdcclxuICAgICAgICAgICAgICAgIH1cIlxyXG4gICAgICAgICAgICAgIC8+XHJcbiAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwiYnV0dG9uc1wiPlxyXG4gICAgICAgICAgICAgIDxkaXZcclxuICAgICAgICAgICAgICAgIGNsYXNzPVwiYnV0dG9uLXVwXCJcclxuICAgICAgICAgICAgICAgIChtb3VzZWRvd24pPVwic2V0SW5jcmVtZW50SW50ZXJ2YWwoKVwiXHJcbiAgICAgICAgICAgICAgICAobW91c2V1cCk9XCJjbGVhclRpbWVycygpXCJcclxuICAgICAgICAgICAgICAgIChtb3VzZWxlYXZlKT1cImNsZWFyVGltZXJzKClcIlxyXG4gICAgICAgICAgICAgID5cclxuICAgICAgICAgICAgICAgIDxpIGNsYXNzPVwicGkgcGktYW5nbGUtdXBcIj48L2k+XHJcbiAgICAgICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgICAgICAgPGRpdlxyXG4gICAgICAgICAgICAgICAgY2xhc3M9XCJidXR0b24tZG93blwiXHJcbiAgICAgICAgICAgICAgICAobW91c2Vkb3duKT1cInNldERlY3JlbWVudEludGVydmFsKClcIlxyXG4gICAgICAgICAgICAgICAgKG1vdXNldXApPVwiY2xlYXJUaW1lcnMoKVwiXHJcbiAgICAgICAgICAgICAgICAobW91c2VsZWF2ZSk9XCJjbGVhclRpbWVycygpXCJcclxuICAgICAgICAgICAgICA+XHJcbiAgICAgICAgICAgICAgICA8aSBjbGFzcz1cInBpIHBpLWFuZ2xlLWRvd25cIj48L2k+XHJcbiAgICAgICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgPC90ZD5cclxuICAgICAgPC90cj5cclxuXHJcbiAgICAgIDx0ciAqbmdJZj1cInByb3BlcnR5LnR5cGUgPT09ICdOdW1iZXJFZGl0b3InIHx8IHByb3BlcnR5LnR5cGUgPT09ICdOdW1iZXInXCI+XHJcbiAgICAgICAgPHRkIFtjb2xTcGFuXT1cInRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gJ2xhYmVsLndpZHRoJyA/IDUgOiA3XCI+XHJcbiAgICAgICAgICA8ZGl2IGNsYXNzPVwibnVtYmVyLWJveFwiPlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwidmFsdWVcIj5cclxuICAgICAgICAgICAgICA8aW5wdXRcclxuICAgICAgICAgICAgICAgIHR5cGU9XCJudW1iZXJcIlxyXG4gICAgICAgICAgICAgICAgI251bWJlcklucHV0XHJcbiAgICAgICAgICAgICAgICAoYmx1cik9XCJvbkxvc3RGb2N1cygkZXZlbnQuY3VycmVudFRhcmdldC52YWx1ZSlcIlxyXG4gICAgICAgICAgICAgICAgKGtleXVwLmVudGVyKT1cIm9uTG9zdEZvY3VzKCRldmVudC5jdXJyZW50VGFyZ2V0LnZhbHVlKVwiXHJcbiAgICAgICAgICAgICAgICBbdmFsdWVdPVwiY291bnRlclwiXHJcbiAgICAgICAgICAgICAgICBjbGFzcz1cInAtaW5wdXRudW1iZXItYnV0dG9uXCJcclxuICAgICAgICAgICAgICAgIFtzdHlsZV09XCJ7XHJcbiAgICAgICAgICAgICAgICAgIHdpZHRoOiAnMTAwJScsXHJcbiAgICAgICAgICAgICAgICAgIGhlaWdodDogJzEwMCUnLFxyXG4gICAgICAgICAgICAgICAgICBmb250U2l6ZTogJzEycHgnLFxyXG4gICAgICAgICAgICAgICAgICBmb250V2VpZ2h0OiAnNTAwJyxcclxuICAgICAgICAgICAgICAgICAgcGFkZGluZzogJzNweCA1cHgnLFxyXG4gICAgICAgICAgICAgICAgICBib3JkZXJSYWRpdXM6ICczcHgnXHJcbiAgICAgICAgICAgICAgICB9XCJcclxuICAgICAgICAgICAgICAvPlxyXG4gICAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImJ1dHRvbnNcIj5cclxuICAgICAgICAgICAgICA8ZGl2XHJcbiAgICAgICAgICAgICAgICBjbGFzcz1cImJ1dHRvbi11cFwiXHJcbiAgICAgICAgICAgICAgICAobW91c2Vkb3duKT1cInNldEluY3JlbWVudEludGVydmFsKClcIlxyXG4gICAgICAgICAgICAgICAgKG1vdXNldXApPVwiY2xlYXJUaW1lcnMoKVwiXHJcbiAgICAgICAgICAgICAgICAobW91c2VsZWF2ZSk9XCJjbGVhclRpbWVycygpXCJcclxuICAgICAgICAgICAgICA+XHJcbiAgICAgICAgICAgICAgICA8aSBjbGFzcz1cInBpIHBpLWFuZ2xlLXVwXCI+PC9pPlxyXG4gICAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgICAgIDxkaXZcclxuICAgICAgICAgICAgICAgIGNsYXNzPVwiYnV0dG9uLWRvd25cIlxyXG4gICAgICAgICAgICAgICAgKG1vdXNlZG93bik9XCJzZXREZWNyZW1lbnRJbnRlcnZhbCgpXCJcclxuICAgICAgICAgICAgICAgIChtb3VzZXVwKT1cImNsZWFyVGltZXJzKClcIlxyXG4gICAgICAgICAgICAgICAgKG1vdXNlbGVhdmUpPVwiY2xlYXJUaW1lcnMoKVwiXHJcbiAgICAgICAgICAgICAgPlxyXG4gICAgICAgICAgICAgICAgPGkgY2xhc3M9XCJwaSBwaS1hbmdsZS1kb3duXCI+PC9pPlxyXG4gICAgICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgICAgPHRkXHJcbiAgICAgICAgICAqbmdJZj1cIlxyXG4gICAgICAgICAgICBwcm9wZXJ0eS50eXBlID09PSAnTnVtYmVyJyAmJlxyXG4gICAgICAgICAgICAocHJvcGVydHkucHJvcGVydHkgPT0gJ2dyaWRDb2x1bW5zJyB8fCBwcm9wZXJ0eS5wcm9wZXJ0eSA9PSAnZ3JpZFZlcnRpY2FsU3RlcCcpXHJcbiAgICAgICAgICBcIlxyXG4gICAgICAgID5cclxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJhcHBseS1idXR0b25cIiAoY2xpY2spPVwiYXBwbHlTZXR0aW5ncygpXCI+XHJcbiAgICAgICAgICAgIDxsYWJlbD57eyBsb2MuZ2V0UChcIkFwcGx5XCIpIH19PC9sYWJlbD5cclxuICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgIDwvdHI+XHJcbiAgICA8L3RhYmxlPlxyXG5cclxuICAgIDxzdHlsZT5cclxuICAgICAgdGQge1xyXG4gICAgICAgIHBhZGRpbmc6IDFweDtcclxuICAgICAgfVxyXG4gICAgICBsYWJlbCB7XHJcbiAgICAgICAgbWFyZ2luOiAwO1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMTJweDtcclxuICAgICAgICBmb250LXdlaWdodDogNTAwO1xyXG4gICAgICAgIGNvbG9yOiB2YXIoLS10ZXh0LWNvbG9yKTtcclxuICAgICAgICB3aGl0ZS1zcGFjZTogbm93cmFwO1xyXG4gICAgICAgIG91dGxpbmU6IG5vbmU7XHJcbiAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcclxuICAgICAgICBzY3JvbGwtYmVoYXZpb3I6IHNtb290aDtcclxuICAgICAgfVxyXG4gICAgICAuYXBwbHktYnV0dG9uIHtcclxuICAgICAgICBoZWlnaHQ6IDI0cHg7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgbWluLXdpZHRoOiA2MHB4O1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1ob3Zlci1jb2xvcik7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG4gICAgICAgIG1hcmdpbi1sZWZ0OiAzcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmFwcGx5LWJ1dHRvbjpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tYWN0aXZlLWNvbG9yKTtcclxuICAgICAgfVxyXG4gICAgICAudmFsdWU6aG92ZXIge1xyXG4gICAgICAgIGN1cnNvcjogdGV4dDtcclxuICAgICAgfVxyXG4gICAgICAuaW1hZ2UtdXBsb2FkID4gaW5wdXQge1xyXG4gICAgICAgIGRpc3BsYXk6IG5vbmU7XHJcbiAgICAgIH1cclxuICAgICAgLm51bWJlci1ib3gge1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIGhlaWdodDogMjRweDtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCB2YXIoLS1pbnB1dEJvcmRlci1jb2xvcik7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHZhcigtLWlucHV0LWNvbG9yKTtcclxuICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgfVxyXG4gICAgICAudmFsdWUge1xyXG4gICAgICAgIG91dGxpbmU6IG5vbmU7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgaGVpZ2h0OiAxMDAlO1xyXG4gICAgICB9XHJcbiAgICAgIC52YWx1ZSBpbnB1dCB7XHJcbiAgICAgICAgb3V0bGluZTogbm9uZTtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1pbnB1dC1jb2xvcik7XHJcbiAgICAgICAgLW1vei1hcHBlYXJhbmNlOiB0ZXh0ZmllbGQ7XHJcbiAgICAgICAgY29sb3I6IHZhcigtLXRleHQtY29sb3IpO1xyXG4gICAgICAgIGJvcmRlcjogMHB4O1xyXG4gICAgICB9XHJcbiAgICAgIC52YWx1ZSBpbnB1dFt0eXBlPVwibnVtYmVyXCJdOjotd2Via2l0LWlubmVyLXNwaW4tYnV0dG9uLFxyXG4gICAgICAudmFsdWUgaW5wdXRbdHlwZT1cIm51bWJlclwiXTo6LXdlYmtpdC1vdXRlci1zcGluLWJ1dHRvbiB7XHJcbiAgICAgICAgLXdlYmtpdC1hcHBlYXJhbmNlOiBub25lO1xyXG4gICAgICAgIG1hcmdpbjogMDtcclxuICAgICAgICBvcGFjaXR5OiAwO1xyXG4gICAgICB9XHJcblxyXG4gICAgICAudmFsdWU6YWZ0ZXIge1xyXG4gICAgICAgIGNvbnRlbnQ6IFwiXCI7XHJcbiAgICAgICAgcG9zaXRpb246IGFic29sdXRlO1xyXG4gICAgICAgIHJpZ2h0OiAyMnB4O1xyXG4gICAgICAgIHotaW5kZXg6IDEwMDtcclxuICAgICAgICB0b3A6IDJweDtcclxuICAgICAgICB3aWR0aDogMXB4O1xyXG4gICAgICAgIGhlaWdodDogMThweDtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1pbnB1dEJvcmRlci1jb2xvcik7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbnMge1xyXG4gICAgICAgIHdpZHRoOiAyMnB4O1xyXG4gICAgICAgIGhlaWdodDogMTAwJTtcclxuICAgICAgICBhbGlnbi1zZWxmOiBmbGV4LWVuZDtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XHJcblxyXG4gICAgICAgIGNvbG9yOiByZ2IoMTg2LCAxODUsIDE4NCk7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbi11cCB7XHJcbiAgICAgICAgd2lkdGg6IDIycHg7XHJcbiAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xyXG4gICAgICAgIGhlaWdodDogMTFweDtcclxuICAgICAgICBib3JkZXItYm90dG9tOiAxcHggc29saWQgdmFyKC0taW5wdXRCb3JkZXItY29sb3IpO1xyXG4gICAgICAgIHRleHQtYWxpZ246IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuYnV0dG9uLXVwOmhvdmVyIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjA5LCAyMDgsIDIwNyk7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbi11cDphY3RpdmUge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigxOTUsIDE5NSwgMTk1KTtcclxuICAgICAgfVxyXG4gICAgICAuYnV0dG9uLWRvd24ge1xyXG4gICAgICAgIHdpZHRoOiAyMnB4O1xyXG4gICAgICAgIHBvc2l0aW9uOiByZWxhdGl2ZTtcclxuICAgICAgICBoZWlnaHQ6IDExcHg7XHJcbiAgICAgICAgdGV4dC1hbGlnbjogY2VudGVyO1xyXG4gICAgICB9XHJcbiAgICAgIC5idXR0b24tZG93bjpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIwOSwgMjA4LCAyMDcpO1xyXG4gICAgICB9XHJcbiAgICAgIC5idXR0b24tZG93bjphY3RpdmUge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigxOTUsIDE5NSwgMTk1KTtcclxuICAgICAgfVxyXG4gICAgICBpIHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgbGVmdDogNXB4O1xyXG4gICAgICAgIGhlaWdodDogOHB4O1xyXG4gICAgICAgIHdpZHRoOiA4cHg7XHJcbiAgICAgIH1cclxuICAgIDwvc3R5bGU+XHJcbiAgYCxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aU51bWJlckVkaXRvckNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgT25EZXN0cm95IHtcclxuICBAVmlld0NoaWxkKFwibnVtYmVySW5wdXRcIikgbnVtYmVySW5wdXQ6IEVsZW1lbnRSZWY7XHJcblxyXG4gIHB1YmxpYyBpbnRlcnZhbDtcclxuICBwdWJsaWMgaXNJbmNyZW1lbnQ6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgaXNEZWNyZW1lbnQ6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgdGltZW91dDtcclxuICBwcml2YXRlIF9ncmlkQ291bnRlcjogbnVtYmVyO1xyXG5cclxuICBwdWJsaWMgZ2V0IGdyaWRDb3VudGVyKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5fZ3JpZENvdW50ZXI7XHJcbiAgfVxyXG4gIHB1YmxpYyBzZXQgZ3JpZENvdW50ZXIodmFsdWU6IG51bWJlcikge1xyXG4gICAgaWYgKHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJncmlkQ29sdW1uc1wiKSB7XHJcbiAgICAgIGlmICh2YWx1ZSA8PSAxMikge1xyXG4gICAgICAgIHRoaXMuX2dyaWRDb3VudGVyID0gMTI7XHJcbiAgICAgIH0gZWxzZSBpZiAodmFsdWUgPiB0aGlzLm1vZGVsLmZvcm0ucGFnZXNbdGhpcy5tb2RlbC5mb3JtLnBhZ2VzLmxlbmd0aCAtIDFdLmNvbnRlbnRBcmVhV2lkdGgpIHtcclxuICAgICAgICB0aGlzLl9ncmlkQ291bnRlciA9IHRoaXMubW9kZWwuZm9ybS5wYWdlc1t0aGlzLm1vZGVsLmZvcm0ucGFnZXMubGVuZ3RoIC0gMV0uY29udGVudEFyZWFXaWR0aDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLl9ncmlkQ291bnRlciA9IHZhbHVlO1xyXG4gICAgICB9XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICBpZiAodmFsdWUgPD0gMSkge1xyXG4gICAgICAgIHRoaXMuX2dyaWRDb3VudGVyID0gMTtcclxuICAgICAgfSBlbHNlIGlmICh2YWx1ZSA+IHRoaXMubW9kZWwuZm9ybS5wYWdlc1t0aGlzLm1vZGVsLmZvcm0ucGFnZXMubGVuZ3RoIC0gMV0uY29udGVudEFyZWFIZWlnaHQpIHtcclxuICAgICAgICB0aGlzLl9ncmlkQ291bnRlciA9IHRoaXMubW9kZWwuZm9ybS5wYWdlc1t0aGlzLm1vZGVsLmZvcm0ucGFnZXMubGVuZ3RoIC0gMV0uY29udGVudEFyZWFIZWlnaHQ7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgdGhpcy5fZ3JpZENvdW50ZXIgPSB2YWx1ZTtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuICBASW5wdXQoKSBwcm9wZXJ0eTogU3RpRWRpdG9yUHJvcGVydHk7XHJcbiAgQElucHV0KCkgb2JqPzogYW55O1xyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UsXHJcbiAgICBwdWJsaWMgaGVscGVyOiBTdGlIZWxwZXJTZXJ2aWNlLFxyXG4gICAgcHVibGljIHRoZW1lOiBTdGlUaGVtZVNlcnZpY2UsXHJcbiAgICBwdWJsaWMgbG9jOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLFxyXG4gICAgcHVibGljIHJlbmRlcjogU3RpUmVjdGFuZ2xlR2VvbWV0cnlMYXlvdXRcclxuICApIHt9XHJcbiAgbmdPbkRlc3Ryb3koKTogdm9pZCB7XHJcbiAgICBpZiAodGhpcy5udW1iZXJJbnB1dCkge1xyXG4gICAgICBpZiAodGhpcy5udW1iZXJJbnB1dC5uYXRpdmVFbGVtZW50LnZhbHVlICYmIE51bWJlcih0aGlzLm51bWJlcklucHV0Lm5hdGl2ZUVsZW1lbnQudmFsdWUpICE9IHRoaXMuY291bnRlcikge1xyXG4gICAgICAgIHRoaXMub25Mb3N0Rm9jdXModGhpcy5udW1iZXJJbnB1dC5uYXRpdmVFbGVtZW50LnZhbHVlKTtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuICBuZ09uSW5pdCgpOiB2b2lkIHtcclxuICAgIGlmICh0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwiZ3JpZENvbHVtbnNcIiB8fCB0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwiZ3JpZFZlcnRpY2FsU3RlcFwiKSB7XHJcbiAgICAgIHRoaXMuZ3JpZENvdW50ZXIgPSAodGhpcy5oZWxwZXIuZ2V0UHJvcGVydHkodGhpcy5lbGVtZW50LCB0aGlzLnByb3BlcnR5LnByb3BlcnR5KSBhcyBzdHJpbmcpXHJcbiAgICAgICAgPyBwYXJzZUZsb2F0KHRoaXMuaGVscGVyLmdldFByb3BlcnR5KHRoaXMuZWxlbWVudCwgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSkpXHJcbiAgICAgICAgOiB0aGlzLmhlbHBlci5nZXRQcm9wZXJ0eSh0aGlzLmVsZW1lbnQsIHRoaXMucHJvcGVydHkucHJvcGVydHkpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgb25Mb3N0Rm9jdXModmFsdWUpIHtcclxuICAgIGlmICh0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwiZ3JpZENvbHVtbnNcIiB8fCB0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwiZ3JpZFZlcnRpY2FsU3RlcFwiKSB7XHJcbiAgICAgIHRoaXMuZ3JpZENvdW50ZXIgPSBOdW1iZXIodmFsdWUpO1xyXG4gICAgICByZXR1cm47XHJcbiAgICB9XHJcbiAgICB0aGlzLmhlbHBlci5zZXRQcm9wZXJ0eSh0aGlzLm9iaiA/PyB0aGlzLmVsZW1lbnQsIHRoaXMucHJvcGVydHkucHJvcGVydHksIE51bWJlcih2YWx1ZSkpO1xyXG4gICAgaWYgKHRoaXMuZWxlbWVudCBpbnN0YW5jZW9mIFN0aU51bWJlckJveEVsZW1lbnQgJiYgdGhpcy5lbGVtZW50LnVzZVJhbmdlICYmIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJ2YWx1ZVwiKSB7XHJcbiAgICAgIHRoaXMubW9kZWwuY2hlY2tOdW1iZXJSYW5nZSh0aGlzLmVsZW1lbnQpO1xyXG4gICAgfSBlbHNlIGlmICh0aGlzLmVsZW1lbnQgaW5zdGFuY2VvZiBTdGlOdW1iZXJCb3hFbGVtZW50ICYmIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJkZWNpbWFsRGlnaXRzXCIpIHtcclxuICAgICAgdGhpcy5tb2RlbC5uZWVkVG9SZWZyZXNoLm5leHQodHJ1ZSk7XHJcbiAgICB9XHJcbiAgICB0aGlzLm1vZGVsLmZvcm1FdmVudHMubmV4dCh7IG5hbWU6IFwiVmFsdWVDaGFuZ2VkXCIgfSk7XHJcbiAgfVxyXG5cclxuICBhcHBseVNldHRpbmdzKCkge1xyXG4gICAgdGhpcy5oZWxwZXIuc2V0UHJvcGVydHkodGhpcy5lbGVtZW50LCB0aGlzLnByb3BlcnR5LnByb3BlcnR5LCB0aGlzLmdyaWRDb3VudGVyKTtcclxuICAgIHRoaXMubW9kZWwuZm9ybUV2ZW50cy5uZXh0KHsgbmFtZTogXCJWYWx1ZUNoYW5nZWRcIiB9KTtcclxuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICB0aGlzLmNoZWNrT3V0cHV0cygpO1xyXG4gICAgfSwgMzAwKTtcclxuICB9XHJcbiAgcHVibGljIGNoZWNrT3V0cHV0cygpIHtcclxuICAgIHRoaXMubW9kZWwuZm9ybS5wYWdlcy5mb3JFYWNoKChwYWdlKSA9PiB7XHJcbiAgICAgIHBhZ2UuYWxsRWxlbWVudHMuZm9yRWFjaCgoZWxlbWVudCkgPT4ge1xyXG4gICAgICAgIGlmIChlbGVtZW50LnggKyBlbGVtZW50LndpZHRoID4gcGFnZS5jb250ZW50QXJlYVdpZHRoKSB7XHJcbiAgICAgICAgICBlbGVtZW50LnggPSAwO1xyXG4gICAgICAgIH1cclxuICAgICAgfSk7XHJcbiAgICB9KTtcclxuICAgIHRoaXMuY2hlY2tPbk92ZXJsYXkoKTtcclxuICAgIHRoaXMubW9kZWwuZm9ybS5wYWdlcy5mb3JFYWNoKChwYWdlKSA9PiB7XHJcbiAgICAgIHRoaXMucmVuZGVyLmNoZWNrT3V0cHV0cyhwYWdlKTtcclxuICAgIH0pO1xyXG4gICAgdGhpcy5tb2RlbC5mb3JtRXZlbnRzLm5leHQoeyBuYW1lOiBcIlZhbHVlQ2hhbmdlZFwiIH0pO1xyXG4gIH1cclxuICBjaGVja09uT3ZlcmxheSgpIHtcclxuICAgIGxldCBoYXNPdmVybGF5ZWRFbGVtZW50cyA9IGZhbHNlO1xyXG4gICAgdGhpcy5tb2RlbC5mb3JtLnBhZ2VzLmZvckVhY2goKHBhZ2UpID0+IHtcclxuICAgICAgcGFnZS5hbGxFbGVtZW50cy5mb3JFYWNoKChlbGVtZW50KSA9PiB7XHJcbiAgICAgICAgbGV0IG92ZXJsYXllZEVsZW1lbnRzID0gcGFnZS5hbGxFbGVtZW50cy5maWx0ZXIoKGVsZW0pID0+IGVsZW0ueCA9PSBlbGVtZW50LnggJiYgZWxlbS55ID09IGVsZW1lbnQueCk7XHJcbiAgICAgICAgaWYgKG92ZXJsYXllZEVsZW1lbnRzLmxlbmd0aCA+IDEpIHtcclxuICAgICAgICAgIG92ZXJsYXllZEVsZW1lbnRzLmZvckVhY2goKG92ZXJsYXllZEVsZW1lbnQsIGluZGV4KSA9PiB7XHJcbiAgICAgICAgICAgIGlmIChpbmRleCAhPSAwKSB7XHJcbiAgICAgICAgICAgICAgaGFzT3ZlcmxheWVkRWxlbWVudHMgPSB0cnVlO1xyXG4gICAgICAgICAgICAgIG92ZXJsYXllZEVsZW1lbnQueSArPSBpbmRleDtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgIH0pO1xyXG4gICAgaWYgKGhhc092ZXJsYXllZEVsZW1lbnRzKSB7XHJcbiAgICAgIHRoaXMubW9kZWwuZm9ybS5hbGxFbGVtZW50cy5mb3JFYWNoKChlbGVtZW50KSA9PiB7XHJcbiAgICAgICAgbGV0IGNvbnRhaW5lciA9IHRoaXMubW9kZWwuZ2V0RWxlbWVudFBhZ2UoZWxlbWVudCkgPz8gdGhpcy5tb2RlbC5nZXRFbGVtZW50UGFuZWwoZWxlbWVudCk7XHJcbiAgICAgICAgdGhpcy5yZW5kZXIuaW5zZXJ0RWxlbWVudChlbGVtZW50LCBjb250YWluZXIuY29udGVudEFyZWFXaWR0aCk7XHJcbiAgICAgIH0pO1xyXG4gICAgfVxyXG4gIH1cclxuICBjbGVhclRpbWVycygpIHtcclxuICAgIHRoaXMuaXNJbmNyZW1lbnQgPSBmYWxzZTtcclxuICAgIHRoaXMuaXNEZWNyZW1lbnQgPSBmYWxzZTtcclxuICAgIGNsZWFyVGltZW91dCh0aGlzLnRpbWVvdXQpO1xyXG4gICAgY2xlYXJJbnRlcnZhbCh0aGlzLmludGVydmFsKTtcclxuICB9XHJcbiAgaXRlcmF0ZSgpIHtcclxuICAgIGlmICh0aGlzLmlzSW5jcmVtZW50KSB7XHJcbiAgICAgIGlmICh0aGlzLm1vZGVsLnNlbGVjdGVkUGFnZSkge1xyXG4gICAgICAgIHRoaXMubW9kZWwuc2VsZWN0ZWRQYWdlW3RoaXMucHJvcGVydHkucHJvcGVydHldICs9IDE7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgdGhpcy5jb3VudGVyICs9IDE7XHJcbiAgICAgIH1cclxuICAgIH0gZWxzZSBpZiAodGhpcy5pc0RlY3JlbWVudCkge1xyXG4gICAgICBpZiAodGhpcy5tb2RlbC5zZWxlY3RlZFBhZ2UpIHtcclxuICAgICAgICB0aGlzLm1vZGVsLnNlbGVjdGVkUGFnZVt0aGlzLnByb3BlcnR5LnByb3BlcnR5XSAtPSAxO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMuY291bnRlciAtPSAxO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG4gIHNldEluY3JlbWVudEludGVydmFsKCkge1xyXG4gICAgdGhpcy5pc0luY3JlbWVudCA9IHRydWU7XHJcbiAgICB0aGlzLml0ZXJhdGUoKTtcclxuICAgIGxldCB0aGlzXyA9IHRoaXM7XHJcbiAgICB0aGlzLnRpbWVvdXQgPSBzZXRUaW1lb3V0KGZ1bmN0aW9uICgpIHtcclxuICAgICAgdGhpc18uaW50ZXJ2YWwgPSBzZXRJbnRlcnZhbChmdW5jdGlvbiAoKSB7XHJcbiAgICAgICAgdGhpc18uaXRlcmF0ZSgpO1xyXG4gICAgICB9LCA1MCk7XHJcbiAgICB9LCAzMDApO1xyXG4gIH1cclxuICBzZXREZWNyZW1lbnRJbnRlcnZhbCgpIHtcclxuICAgIHRoaXMuaXNEZWNyZW1lbnQgPSB0cnVlO1xyXG4gICAgdGhpcy5pdGVyYXRlKCk7XHJcbiAgICBsZXQgdGhpc18gPSB0aGlzO1xyXG4gICAgdGhpcy50aW1lb3V0ID0gc2V0VGltZW91dChmdW5jdGlvbiAoKSB7XHJcbiAgICAgIHRoaXNfLmludGVydmFsID0gc2V0SW50ZXJ2YWwoZnVuY3Rpb24gKCkge1xyXG4gICAgICAgIHRoaXNfLml0ZXJhdGUoKTtcclxuICAgICAgfSwgNTApO1xyXG4gICAgfSwgMzAwKTtcclxuICB9XHJcbiAgZ2V0IGVsZW1lbnQoKTogYW55IHtcclxuICAgIHJldHVybiB0aGlzLm1vZGVsLnNlbGVjdGVkQ29tcG9uZW50Py5lbGVtZW50ID8/IHRoaXMubW9kZWwuZm9ybS5zZXR0aW5ncztcclxuICB9XHJcblxyXG4gIGdldCBjb3VudGVyKCk6IG51bWJlciB7XHJcbiAgICBpZiAodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSAhPSBcImdyaWRDb2x1bW5zXCIgJiYgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSAhPSBcImdyaWRWZXJ0aWNhbFN0ZXBcIikge1xyXG4gICAgICBpZiAodGhpcy5vYmopIHtcclxuICAgICAgICByZXR1cm4gKHRoaXMuaGVscGVyLmdldFByb3BlcnR5KHRoaXMub2JqLCB0aGlzLnByb3BlcnR5LnByb3BlcnR5KSBhcyBzdHJpbmcpXHJcbiAgICAgICAgICA/IHBhcnNlRmxvYXQodGhpcy5oZWxwZXIuZ2V0UHJvcGVydHkodGhpcy5vYmosIHRoaXMucHJvcGVydHkucHJvcGVydHkpKVxyXG4gICAgICAgICAgOiB0aGlzLmhlbHBlci5nZXRQcm9wZXJ0eSh0aGlzLm9iaiwgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSk7XHJcbiAgICAgIH1cclxuICAgICAgcmV0dXJuIHRoaXMuaGVscGVyLmdldFByb3BlcnR5KHRoaXMuZWxlbWVudCwgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gdGhpcy5ncmlkQ291bnRlcjtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIHZhbGlkTmVnYXRpdmVWYWx1ZSgpOiBib29sZWFuIHtcclxuICAgIGlmICh0aGlzLm9iaiBpbnN0YW5jZW9mIFN0aU51bWJlckJveEVsZW1lbnQpIHtcclxuICAgICAgaWYgKFxyXG4gICAgICAgIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJ2YWx1ZVwiIHx8XHJcbiAgICAgICAgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcIm1pbmltdW1cIiB8fFxyXG4gICAgICAgIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJtYXhpbXVtXCJcclxuICAgICAgKSB7XHJcbiAgICAgICAgcmV0dXJuIHRydWU7XHJcbiAgICAgIH0gZWxzZSByZXR1cm4gZmFsc2U7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHNldCBjb3VudGVyKHZhbHVlOiBudW1iZXIpIHtcclxuICAgIGlmICh2YWx1ZSA8IDAgJiYgIXRoaXMudmFsaWROZWdhdGl2ZVZhbHVlKCkpIHtcclxuICAgICAgcmV0dXJuO1xyXG4gICAgfVxyXG4gICAgaWYgKHRoaXMucHJvcGVydHkucHJvcGVydHkgIT0gXCJncmlkQ29sdW1uc1wiICYmIHRoaXMucHJvcGVydHkucHJvcGVydHkgIT0gXCJncmlkVmVydGljYWxTdGVwXCIpIHtcclxuICAgICAgaWYgKHRoaXMub2JqKSB7XHJcbiAgICAgICAgdGhpcy5oZWxwZXIuc2V0UHJvcGVydHkodGhpcy5vYmosIHRoaXMucHJvcGVydHkucHJvcGVydHksIHZhbHVlKTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLmhlbHBlci5zZXRQcm9wZXJ0eSh0aGlzLmVsZW1lbnQsIHRoaXMucHJvcGVydHkucHJvcGVydHksIHZhbHVlKTtcclxuICAgICAgICBpZiAodGhpcy5lbGVtZW50IGluc3RhbmNlb2YgU3RpTnVtYmVyQm94RWxlbWVudCAmJiB0aGlzLmVsZW1lbnQudXNlUmFuZ2UgJiYgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcInZhbHVlXCIpIHtcclxuICAgICAgICAgIHRoaXMubW9kZWwuY2hlY2tOdW1iZXJSYW5nZSh0aGlzLmVsZW1lbnQpO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy5ncmlkQ291bnRlciA9IHZhbHVlO1xyXG4gICAgICB0aGlzLm1vZGVsLmZvcm1FdmVudHMubmV4dCh7IG5hbWU6IFwiVmFsdWVDaGFuZ2VkXCIgfSk7XHJcbiAgICB9XHJcbiAgfVxyXG59XHJcbiJdfQ==