import { Component, Input, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../../../../directives/sti-input-text.directive";
export class StiNameEditorComponent {
    constructor(model) {
        this.model = model;
        this.hasName = false;
        this.required = false;
    }
    get name() {
        return this.model.selectedComponent.element[this.property.property];
    }
    ngOnInit() { }
    onInput(name) {
        this.hasName = false;
        this.required = false;
        if (name) {
            this.nameEditor.nativeElement?.classList.remove("ng-invalid");
            this.model.form.pages.forEach((page) => {
                page.allElements.forEach((element) => {
                    if (element.name == name && element != this.model.selectedComponent.element) {
                        this.hasName = true;
                    }
                });
            });
            if (this.hasName == false && this.isValid(name)) {
                this.model.selectedComponent.element.name = name;
                this.nameEditor.nativeElement?.classList.remove("ng-invalid");
            }
            else {
                this.nameEditor.nativeElement?.classList.add("ng-invalid");
            }
        }
        else {
            this.required = true;
            this.nameEditor.nativeElement?.classList.add("ng-invalid");
        }
    }
    onFocus() {
        this.nameEditor.nativeElement?.classList.add("valid");
    }
    onBlur() {
        this.nameEditor.nativeElement?.classList.remove("valid");
    }
    isValid(name) {
        let valid = true;
        let chars = name.trim().split("");
        let isValid = true;
        chars.forEach((char) => {
            if (!this.isLetterOrDigit(char)) {
                valid = false;
            }
        });
        return valid;
    }
    isLetterOrDigit(char) {
        let numberPattern = new RegExp(/^\d+$/);
        let isNumber = numberPattern.test(char);
        let isDivider = char == "-" || char == "_";
        return char.toLowerCase() != char.toUpperCase() || isNumber || isDivider;
    }
}
StiNameEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiNameEditorComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiNameEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiNameEditorComponent, selector: "sti-name-editor", inputs: { property: "property" }, viewQueries: [{ propertyName: "nameEditor", first: true, predicate: ["nameEditor"], descendants: true }], ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'nameEditor'">
        <td colspan="7">
          <input
            type="text"
            #nameEditor
            stiInputText
            [ngModel]="name"
            spellcheck="false"
            (input)="onInput($event.target.value)"
            (focus)="onFocus()"
            (blur)="onBlur()"
            [style]="{ width: '100%' }"
          />
          <span style="color: #a80000; vertical-align:middle;" *ngIf="hasName">Name is used.</span>
          <span style="color: #a80000; vertical-align:middle;" *ngIf="required">This field is required.</span>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      input {
        font-size: 12px;
        font-weight: 500;
        padding: 3px 5px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
      td {
        padding: 0;
      }
    </style>
  `, isInline: true, styles: ["\n      input {\n        font-size: 12px;\n        font-weight: 500;\n        padding: 3px 5px;\n      }\n      .valid {\n        border-color: rgb(0, 128, 0);\n      }\n      td {\n        padding: 0;\n      }\n    "], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i4.StiInputTextDirective, selector: "[stiInputText]" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiNameEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-name-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'nameEditor'">
        <td colspan="7">
          <input
            type="text"
            #nameEditor
            stiInputText
            [ngModel]="name"
            spellcheck="false"
            (input)="onInput($event.target.value)"
            (focus)="onFocus()"
            (blur)="onBlur()"
            [style]="{ width: '100%' }"
          />
          <span style="color: #a80000; vertical-align:middle;" *ngIf="hasName">Name is used.</span>
          <span style="color: #a80000; vertical-align:middle;" *ngIf="required">This field is required.</span>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      input {
        font-size: 12px;
        font-weight: 500;
        padding: 3px 5px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
      td {
        padding: 0;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { property: [{
                type: Input
            }], nameEditor: [{
                type: ViewChild,
                args: ["nameEditor"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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