import { Component, Input } from "@angular/core";
import { StiTableElement } from "../../../../elements/StiTableElement";
import { StiCheckBoxCellItem } from "../../../../elements/table/cells/StiCheckBoxCellItem";
import { StiComboBoxCellItem } from "../../../../elements/table/cells/StiComboBoxCellItem";
import { StiNumberBoxCellItem } from "../../../../elements/table/cells/StiNumberBoxCellItem";
import { StiRadioButtonCellItem } from "../../../../elements/table/cells/StiRadioButtonCellItem";
import { StiTextBoxCellItem } from "../../../../elements/table/cells/StiTextBoxCellItem";
import { StiCheckBoxColumnItem } from "../../../../elements/table/columns/StiCheckBoxColumnItem";
import { StiComboBoxColumnItem } from "../../../../elements/table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "../../../../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../../../../elements/table/columns/StiNumberBoxColumnItem";
import { StiRadioButtonColumnItem } from "../../../../elements/table/columns/StiRadioButtonColumnItem";
import { StiTextBoxColumnItem } from "../../../../elements/table/columns/StiTextBoxColumnItem";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "@angular/forms";
import * as i5 from "../../../../directives/sti-input-text-area.directive";
export class StiMultilineStringEditorComponent {
    constructor(model, helper, theme) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
    }
    ngOnInit() { }
    get options() {
        if (this.object) {
            return this.object.comboBoxOptions;
        }
        else {
            return this.optionsElement.options ? this.optionsElement.options : this.optionsElement.rowLabels;
        }
    }
    get values() {
        return this.options.join("\n");
    }
    get optionsElement() {
        return this.model.selectedComponent.element
            ? this.model.selectedComponent.element
            : this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
    }
    onInput(value) {
        let rows = this.optionsElement.rowLabels;
        if (this.object) {
            this.object.comboBoxOptions = value.split("\n");
        }
        else {
            this.optionsElement.options
                ? (this.optionsElement.options = value.split("\n"))
                : this.helper.setProperty(this.model.selectedComponent.element, this.property.property, value.split("\n"));
            if ("selectedOption" in this.optionsElement) {
                try {
                    if (this.optionsElement.options.indexOf(this.optionsElement.selectedOption) < 0) {
                        this.optionsElement.selectedOption = null;
                    }
                }
                catch {
                    this.optionsElement.selectedOption = null;
                }
            }
        }
        if (rows &&
            rows != this.optionsElement.RowLabels &&
            this.model.selectedComponent.element instanceof StiTableElement) {
            let values = value.split("\n");
            values.forEach(() => {
                this.model.selectedComponent.element.columns.forEach((column) => {
                    if (column.type == "CheckBoxColumn" && column instanceof StiCheckBoxColumnItem) {
                        column.cells.push(new StiCheckBoxCellItem("", false));
                    }
                    else if (column.type == "ComboBoxColumn" && column instanceof StiComboBoxColumnItem) {
                        column.cells.push(new StiComboBoxCellItem("", 0));
                    }
                    else if (column.type == "RadioButtonColumn" && column instanceof StiRadioButtonColumnItem) {
                        column.cells.push(new StiRadioButtonCellItem("", false));
                    }
                    else if (column.type == "TextBoxColumn" && column instanceof StiTextBoxColumnItem) {
                        column.cells.push(new StiTextBoxCellItem("", ""));
                    }
                    else if (column.type == "NumberBoxColumn" && column instanceof StiNumberBoxColumnItem) {
                        column.cells.push(new StiNumberBoxCellItem("", 0));
                    }
                    else if (column.type == "LabelColumn" && column instanceof StiLabelColumnItem) {
                        column.cells.push("");
                    }
                });
            });
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
}
StiMultilineStringEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMultilineStringEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }], target: i0.ɵɵFactoryTarget.Component });
StiMultilineStringEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiMultilineStringEditorComponent, selector: "sti-multiline-string-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr [style]="{ width: '100%' }">
        <td colspan="7">
          <textarea
            stiInputTextArea
            [ngModel]="values"
            (input)="onInput($event.target.value)"
            [style]="{ width: '100%', resize: 'none' }"
            [style.height]="object ? 'max-content' : '100px'"
          ></textarea>
        </td>
      </tr>
      <style>
        tr {
          padding: 3px 0px 3px 0px;
        }
        textarea {
          font-size: 13px;
          font-weight: 600;
          padding: 2px 4px;
        }
        td {
          padding: 0;
        }
      </style>
    </table>
  `, isInline: true, styles: ["\n        tr {\n          padding: 3px 0px 3px 0px;\n        }\n        textarea {\n          font-size: 13px;\n          font-weight: 600;\n          padding: 2px 4px;\n        }\n        td {\n          padding: 0;\n        }\n      "], dependencies: [{ kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i5.StiInputTextAreaDirective, selector: "[stiInputTextArea]" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMultilineStringEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-multiline-string-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr [style]="{ width: '100%' }">
        <td colspan="7">
          <textarea
            stiInputTextArea
            [ngModel]="values"
            (input)="onInput($event.target.value)"
            [style]="{ width: '100%', resize: 'none' }"
            [style.height]="object ? 'max-content' : '100px'"
          ></textarea>
        </td>
      </tr>
      <style>
        tr {
          padding: 3px 0px 3px 0px;
        }
        textarea {
          font-size: 13px;
          font-weight: 600;
          padding: 2px 4px;
        }
        td {
          padding: 0;
        }
      </style>
    </table>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }]; }, propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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