import { Component, Input } from "@angular/core";
import StiRectangleGeometryLayout from "../../../../computed/StiRectangleGeometryLayout";
import { StiFormSettings } from "../../../../elements/settings/StiFormSettings";
import { StiLabelAlignment } from "../../../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../../sti-tooltip/sti-tooltip.directive";
import * as i7 from "../../../sti-select-button/sti-select-button.component";
export class StiLabelAlignmentEditorComponent {
    constructor(model, helper, theme, render, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.render = render;
        this.loc = loc;
        this.hasName = false;
        this.required = false;
        this.prop = { type: "verticalAlignment", property: "label.verticalAlignment", label: "verticalAlignment" };
    }
    get hasVerticalAlignment() {
        return !(this.obj instanceof StiFormSettings) && this.obj.label?.isUnchangedVAlign() ? false : true;
    }
    get obj() {
        return this.model.selectedComponent?.element ?? this.model.form.settings;
    }
    get verticalAlignment() {
        return this.helper.getProperty(this.obj, this.prop.property);
    }
    set verticalAlignment(value) {
        this.helper.setProperty(this.obj, this.prop.property, value);
    }
    get alignment() {
        return this.helper.getProperty(this.obj, this.property.property);
    }
    set alignment(value) {
        this.helper.setProperty(this.obj, this.property.property, value);
        //TODO ???
        this.model.form.pages.forEach((page) => {
            let firstElement;
            page.elements.forEach((element) => {
                if (element.x == 0 && element.y == 0) {
                    firstElement = element;
                }
            });
            this.render.insertElement(firstElement);
        });
        this.model.needToRefresh.next(true);
    }
    get isTopAlignment() {
        return this.alignment && this.alignment == StiLabelAlignment.Top ? true : false;
    }
    ngOnInit() { }
}
StiLabelAlignmentEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLabelAlignmentEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: StiRectangleGeometryLayout }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiLabelAlignmentEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiLabelAlignmentEditorComponent, selector: "sti-label-alignment-editor", inputs: { property: "property" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.labelAlignment"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>
    <table
      [style.margin-top.px]="2"
      *ngIf="!isTopAlignment && hasVerticalAlignment"
      class="sti-clear"
      [style]="{ width: '100%' }"
    >
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.verticalAlignment"
            [(value)]="verticalAlignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      input {\n        font-size: 13px;\n        font-weight: 600;\n        padding: 2px 4px;\n      }\n      .valid {\n        border-color: rgb(0, 128, 0);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i7.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLabelAlignmentEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-label-alignment-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.labelAlignment"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>
    <table
      [style.margin-top.px]="2"
      *ngIf="!isTopAlignment && hasVerticalAlignment"
      class="sti-clear"
      [style]="{ width: '100%' }"
    >
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.verticalAlignment"
            [(value)]="verticalAlignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: StiRectangleGeometryLayout }, { type: i4.StiLocalizationService }]; }, propDecorators: { property: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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