import { Component, Input } from "@angular/core";
import { UsedFont } from "../../../../services/objects";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "../../../../services/sti-color-dialog.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-dropdown-editor/sti-dropdown-editor.component";
import * as i8 from "../../../sti-tooltip/sti-tooltip.directive";
import * as i9 from "../../../sti-select-button/sti-select-button.component";
export class StiFontEditorComponent {
    constructor(model, helper, theme, loc, colorService) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.colorService = colorService;
    }
    ngOnInit() { }
    showColorPicker(element, object) {
        this.colorService.openDialog(element, object);
    }
    isSettings() {
        return !this.model.selectedComponent && !this.model.selectedPage;
    }
    get content() {
        return this.helper.getProperty(this.object ?? this.model.form.settings, this.property.property);
    }
    changeEvent() {
        if (this.content.eFont) {
            let currentChangableFont = new UsedFont(this.content.eFont.family, this.model.arrayOfStylesToString(this.content.eFont.style), this.content.eFont.size);
            this.model.form.formEvents.next({ name: "UpdateFonts", value: currentChangableFont });
        }
        else {
            let currentChangableFont = new UsedFont(this.content.family ? this.content.family : this.content.font.family, this.model.arrayOfStylesToString(this.content.style ? this.content.style : this.content.font.style), this.content.size ? this.content.size : this.content.font.size);
            this.model.form.formEvents.next({ name: "UpdateFonts", value: currentChangableFont });
        }
    }
}
StiFontEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFontEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }, { token: i5.StiColorDialogService }], target: i0.ɵɵFactoryTarget.Component });
StiFontEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFontEditorComponent, selector: "sti-font-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `<table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.font.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontFamilyTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.font.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontSizeTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.font.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.get2('HelpDesigner', 'FontName')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.getP('FontSize')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr *ngIf="property.property == 'innerText' && (content.eValue?.length > 0 || isSettings())">
        <td colspan="7">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, content.color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="content.color.toHtmlColor()"></span>
              <span class="color-value">{{ content.color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>`, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      .custom-color-picker {\n        width: 100%;\n        background-color: var(--input-color);\n        height: 24px;\n        border: 1px solid var(--inputBorder-color);\n        position: relative;\n        border-radius: 3px;\n      }\n      .custom-color-picker:hover {\n        background-color: var(--hover-color);\n      }\n      .custom-color-picker:focus {\n        background-color: var(--input-color);\n      }\n      .preview {\n        display: flex;\n        position: relative;\n        width: 100%;\n        height: 100%;\n      }\n      .pick {\n        position: absolute;\n        top: 0;\n        left: 0;\n        width: 100%;\n        height: 22px;\n      }\n      .color-value {\n        font-weight: 500;\n        font-size: 12px;\n        align-self: center;\n        color: var(--text-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .custom-color-preview {\n        width: 24px;\n        height: 14px;\n        margin: 4px;\n        background-color: black;\n        border: 1px solid var(--inputBorder-color);\n      }\n      .select-button {\n        float: right;\n        margin-left: auto;\n        margin-right: 5px;\n        color: rgb(186, 185, 184);\n        display: flex;\n        align-items: center;\n      }\n      .i {\n        height: 12px;\n        width: 12px;\n        right: 3px;\n      }\n    "], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: ["value", "options", "optionLabel", "optionValue", "editable"], outputs: ["valueChange"] }, { kind: "directive", type: i8.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i9.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFontEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-font-editor",
                    template: `<table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.font.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontFamilyTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.font.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="fontSizeTooltip"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr *ngIf="property.property === 'this' || content.eValue?.length > 0 || isSettings()">
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.font.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="5">
          <sti-dropdown-editor
            [options]="model.fontFamilies"
            [(value)]="content.family"
            optionLabel="name"
            optionValue="name"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.get2('HelpDesigner', 'FontName')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="helper.fontSizes"
            [(value)]="content.size"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
            [stiTooltip]="loc.getP('FontSize')"
            tooltipPosition="bottom"
            showDelay="500"
            (valueChange)="changeEvent()"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property === 'font' ||
          property.property === 'descriptionFont' ||
          property.property === 'insertedText.font'
        "
      >
        <td colspan="2" style="padding-top: 5px;">
          <sti-selectButton
            [options]="helper.styleOptions"
            [(value)]="content.style"
            [multiple]="true"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
            (onChange)="changeEvent()"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.value)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
      <tr *ngIf="property.property == 'innerText' && (content.eValue?.length > 0 || isSettings())">
        <td colspan="7">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, content.color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="content.color.toHtmlColor()"></span>
              <span class="color-value">{{ content.color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>`,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }, { type: i5.StiColorDialogService }]; }, propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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