import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../../sti-tooltip/sti-tooltip.directive";
export class StiExceedMarginsEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
    }
    get margins() {
        return this.helper.getProperty(this.object, this.property.property);
    }
    setAll() {
        this.margins.drawTop = true;
        this.margins.drawLeft = true;
        this.margins.drawBottom = true;
        this.margins.drawRight = true;
    }
    setNone() {
        this.margins.drawTop = false;
        this.margins.drawLeft = false;
        this.margins.drawBottom = false;
        this.margins.drawRight = false;
    }
    changeState(value) {
        this.margins[value] = !this.margins[value];
    }
    ngOnInit() { }
}
StiExceedMarginsEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExceedMarginsEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiExceedMarginsEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiExceedMarginsEditorComponent, selector: "sti-exceed-margins-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7" *ngIf="property.property != 'gridLines'">
          <div class="button-group">
            <div
              class="button {{
                margins.drawTop && margins.drawLeft && margins.drawBottom && margins.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('All')" alt="" />
            </div>
            <div
              class="button {{
                !margins.drawTop && !margins.drawLeft && !margins.drawBottom && !margins.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('None')" alt="" />
            </div>
            <div
              class="button {{ margins.drawTop ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Top')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawTop')"
            >
              <img [src]="theme.getIcon('Top')" alt="" />
            </div>
            <div
              class="button {{ margins.drawLeft ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Left')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawLeft')"
            >
              <img [src]="theme.getIcon('Left')" alt="" />
            </div>
            <div
              class="button {{ margins.drawBottom ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Bottom')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawBottom')"
            >
              <img [src]="theme.getIcon('Bottom')" alt="" />
            </div>
            <div
              class="button {{ margins.drawRight ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Right')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawRight')"
            >
              <img [src]="theme.getIcon('Right')" alt="" />
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        text-align: end;
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      .active {
        background-color: var(--active-color) !important;
      }
      .active:hover {
        background-color: var(--active-color) !important;
      }
      .button-group {
        display: flex;
        width: 100%;
        flex-direction: row;
        justify-content: start;
      }
      .button {
        height: 22px;
        width: 28px;
        background-color: var(--back-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .button img {
        height: 16px;
        width: 16px;
      }
      .button:hover {
        background-color: var(--hover-color);
      }
      .button:active {
        background-color: var(--active-color);
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        text-align: end;\n      }\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .active {\n        background-color: var(--active-color) !important;\n      }\n      .active:hover {\n        background-color: var(--active-color) !important;\n      }\n      .button-group {\n        display: flex;\n        width: 100%;\n        flex-direction: row;\n        justify-content: start;\n      }\n      .button {\n        height: 22px;\n        width: 28px;\n        background-color: var(--back-color);\n        display: flex;\n        align-items: center;\n        justify-content: center;\n      }\n      .button img {\n        height: 16px;\n        width: 16px;\n      }\n      .button:hover {\n        background-color: var(--hover-color);\n      }\n      .button:active {\n        background-color: var(--active-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExceedMarginsEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-exceed-margins-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7" *ngIf="property.property != 'gridLines'">
          <div class="button-group">
            <div
              class="button {{
                margins.drawTop && margins.drawLeft && margins.drawBottom && margins.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'ChartGridLinesAll')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setAll()"
            >
              <img [src]="theme.getIcon('All')" alt="" />
            </div>
            <div
              class="button {{
                !margins.drawTop && !margins.drawLeft && !margins.drawBottom && !margins.drawRight ? 'active' : ''
              }}"
              [stiTooltip]="loc.get2('PropertyEnum', 'BorderStyleNone')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="setNone()"
            >
              <img [src]="theme.getIcon('None')" alt="" />
            </div>
            <div
              class="button {{ margins.drawTop ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Top')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawTop')"
            >
              <img [src]="theme.getIcon('Top')" alt="" />
            </div>
            <div
              class="button {{ margins.drawLeft ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Left')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawLeft')"
            >
              <img [src]="theme.getIcon('Left')" alt="" />
            </div>
            <div
              class="button {{ margins.drawBottom ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Bottom')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawBottom')"
            >
              <img [src]="theme.getIcon('Bottom')" alt="" />
            </div>
            <div
              class="button {{ margins.drawRight ? 'active' : '' }}"
              [stiTooltip]="loc.getP('Right')"
              tooltipPosition="bottom"
              showDelay="500"
              (click)="changeState('drawRight')"
            >
              <img [src]="theme.getIcon('Right')" alt="" />
            </div>
          </div>
        </td>
      </tr>
    </table>
    <style>
      td {
        text-align: end;
      }
      tr {
        padding: 3px 0px 3px 0px;
      }
      .active {
        background-color: var(--active-color) !important;
      }
      .active:hover {
        background-color: var(--active-color) !important;
      }
      .button-group {
        display: flex;
        width: 100%;
        flex-direction: row;
        justify-content: start;
      }
      .button {
        height: 22px;
        width: 28px;
        background-color: var(--back-color);
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .button img {
        height: 16px;
        width: 16px;
      }
      .button:hover {
        background-color: var(--hover-color);
      }
      .button:active {
        background-color: var(--active-color);
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }]; }, propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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