import { Component, Input } from "@angular/core";
import { StiTableElement } from "../../../../elements/StiTableElement";
import { StiCheckBoxCellItem } from "../../../../elements/table/cells/StiCheckBoxCellItem";
import { StiComboBoxCellItem } from "../../../../elements/table/cells/StiComboBoxCellItem";
import { StiNumberBoxCellItem } from "../../../../elements/table/cells/StiNumberBoxCellItem";
import { StiRadioButtonCellItem } from "../../../../elements/table/cells/StiRadioButtonCellItem";
import { StiTextBoxCellItem } from "../../../../elements/table/cells/StiTextBoxCellItem";
import { StiCheckBoxColumnItem } from "../../../../elements/table/columns/StiCheckBoxColumnItem";
import { StiComboBoxColumnItem } from "../../../../elements/table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "../../../../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../../../../elements/table/columns/StiNumberBoxColumnItem";
import { StiRadioButtonColumnItem } from "../../../../elements/table/columns/StiRadioButtonColumnItem";
import { StiTextBoxColumnItem } from "../../../../elements/table/columns/StiTextBoxColumnItem";
import { StiColumnItem } from "../../../../elements/table/StiColumnItem";
import { StiTotalsFieldItem } from "../../../../elements/table/StiTotalsFieldItem";
import { StiLocalizationService } from "../../../../services/sti-localization.service";
import { Enum } from "../../../../system/Enum";
import { HatchStyle, StiAlgorithmExpression, StiBarcodeType, StiButtonSendType, StiButtonType, StiDateTimeBoxType, StiDateTimeBoxValueChoise, StiLineWeight, StiNumberType, StiNumberRangeFormat, StiPenStyle, StiSignatureType, StiThousandSeparator, StiUnitAlignment, } from "../../../../system/enums";
import { StiDateTimeBoxElement } from "../../../../elements/StiDateTimeBoxElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "@angular/common";
import * as i4 from "../sti-dropdown-editor/sti-dropdown-editor.component";
export class StiEnumEditorComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
        this.items = [];
    }
    get columns() {
        let items = [];
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            this.model.selectedComponent.element.columns.forEach((column, index) => {
                items.push({ name: column.label, value: index + 1 });
            });
        }
        if (this.items.length != items.length || !this.items.every((val, index) => val.name === items[index].name)) {
            this.items = items;
        }
        return this.items;
    }
    get today() {
        return new Date();
    }
    mouseOver(target) {
        if (this.property.property == "dateFormat" ||
            this.property.property == "timeFormat" ||
            this.property.property == "dateTimeFormat") {
            target.style.backgroundColor = "var(--input-color)";
            target.parentElement.style.backgroundColor = "var(--input-color)";
        }
    }
    get columnIndex() {
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            return this.object.calculationAlgorithm.columntIndex;
        }
        return 0;
    }
    set columnIndex(value) {
        this.object.calculationAlgorithm.columntIndex = value;
    }
    get type() {
        if (this.property.property === "valueType") {
            return StiDateTimeBoxType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "signatureType") {
            return StiSignatureType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "initialState") {
            return StiDateTimeBoxValueChoise[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "rangeFormat") {
            return StiNumberRangeFormat[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "numberType") {
            return StiNumberType[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "buttonType") {
            return StiButtonType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "buttonSendType") {
            return StiButtonSendType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "thousandSeparator") {
            return StiThousandSeparator[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "barcodeType") {
            return StiBarcodeType[this.model.selectedComponent.element[this.property.property]];
        }
        else if (this.property.property === "style") {
            return StiPenStyle[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "type") {
            return this.object.type.split("").reverse().slice(6, this.object.type.length).reverse().join("");
        }
        else if (this.property.property === "currency") {
            return (this.helper.getProperty(this.object, this.property.property) ??
                this.helper.getProperty(this.model.form.settings, this.property.property));
        }
        else if (this.property.property === "currentSignatureMode" || this.property.property === "specialFont") {
            return this.helper.getProperty(this.object, this.property.property);
        }
        else if (this.property.property === "calculationAlgorithm.expression") {
            return StiAlgorithmExpression[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property === "dateFormat" || this.property.property === "timeFormat") {
            return this.helper.getProperty(this.object ?? this.model.form.settings, this.property.property);
        }
        else if (this.property.property === "dateTimeFormat") {
            return this.helper.getProperty(this.object, this.property.property);
        }
        else if (this.property.property === "innerText.borderWeight") {
            return StiLineWeight[this.model.form.settings.innerText.borderWeight];
        }
        else if (this.property.property === "unitAlignment") {
            return this.helper.getProperty(this.object, this.property.property) ?? this.model.form.settings.unitAlignment;
        }
        else if (this.property.property.includes("BrushHatchStyle")) {
            return this.helper.getProperty(this.object, this.property.property);
        }
        else {
            return StiLineWeight[this.model.selectedComponent.element[this.property.property]];
        }
    }
    set type(value) {
        if (this.property.property === "valueType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiDateTimeBoxType, value);
        }
        else if (this.property.property === "signatureType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiSignatureType, value);
        }
        else if (this.property.property === "initialState") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiDateTimeBoxValueChoise, value);
            if (!this.model?.selectedComponent?.element?.readOnly &&
                value == "Current" &&
                this.model?.selectedComponent?.element instanceof StiDateTimeBoxElement) {
                this.model.selectedComponent.element.customDate = new Date();
            }
        }
        else if (this.property.property === "rangeFormat") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiNumberRangeFormat, value));
        }
        else if (this.property.property === "numberType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiNumberType, value));
            if (this.object instanceof StiColumnItem) {
                this.model.needToRefreshInnerProperties.next(true);
            }
            else {
                this.model.needToRefresh.next(true);
            }
        }
        else if (this.property.property === "buttonType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiButtonType, value);
        }
        else if (this.property.property === "buttonSendType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiButtonSendType, value);
        }
        else if (this.property.property === "thousandSeparator") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiThousandSeparator, value));
        }
        else if (this.property.property === "barcodeType") {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiBarcodeType, value);
        }
        else if (this.property.property.includes("BrushHatchStyle")) {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(HatchStyle, value));
            this.model.needToRefreshInnerProperties.next(true);
        }
        else if (this.property.property === "style") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiPenStyle, value));
        }
        else if (this.property.property === "calculationAlgorithm.expression") {
            if (this.type != value && this.model.selectedComponent.element instanceof StiTableElement) {
                let slicedField = this.model.selectedComponent.element.totalsFields.splice(this.index, 1);
                this.model.selectedComponent.element.totalsFields.splice(this.index, 0, new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "New Field")));
                this.setProperties(this.model.selectedComponent.element.totalsFields[this.index], slicedField[0], value);
            }
        }
        else if (this.property.property === "currency") {
            if (this.model.selectedComponent) {
                this.helper.setProperty(this.object, this.property.property, value);
            }
            else {
                this.model.form.settings.currency = value;
            }
        }
        else if (this.property.property === "currentSignatureMode" || this.property.property === "specialFont") {
            this.helper.setProperty(this.object, this.property.property, value);
        }
        else if (this.property.property === "type") {
            if (this.type != value && this.model.selectedComponent.element instanceof StiTableElement) {
                let slicedColumn = this.model.selectedComponent.element.columns.splice(this.index, 1);
                if (value == "CheckBox") {
                    this.model.selectedComponent.element.columns.splice(this.index, 0, new StiCheckBoxColumnItem(StiLocalizationService.get("PropertyMain", "New Column")));
                    this.setProperties(this.model.selectedComponent.element.columns[this.index], slicedColumn[0]);
                    for (let row of this.model.selectedComponent.element.rowLabels) {
                        this.model.selectedComponent.element.columns[this.index]["cells"].push(new StiCheckBoxCellItem("", false));
                    }
                }
                else if (value == "ComboBox") {
                    this.model.selectedComponent.element.columns.splice(this.index, 0, new StiComboBoxColumnItem(StiLocalizationService.get("PropertyMain", "New Column")));
                    this.model.selectedComponent.element.columns[this.index]["comboBoxOptions"].push("yes");
                    this.model.selectedComponent.element.columns[this.index]["comboBoxOptions"].push("no");
                    this.setProperties(this.model.selectedComponent.element.columns[this.index], slicedColumn[0]);
                    for (let row of this.model.selectedComponent.element.rowLabels) {
                        this.model.selectedComponent.element.columns[this.index]["cells"].push(new StiComboBoxCellItem("", 0));
                    }
                }
                else if (value == "Label") {
                    this.model.selectedComponent.element.columns.splice(this.index, 0, new StiLabelColumnItem(StiLocalizationService.get("PropertyMain", "New Column")));
                    this.setProperties(this.model.selectedComponent.element.columns[this.index], slicedColumn[0]);
                    for (let row of this.model.selectedComponent.element.rowLabels) {
                        this.model.selectedComponent.element.columns[this.index]["cells"].push("");
                    }
                }
                else if (value == "RadioButton") {
                    this.model.selectedComponent.element.columns.splice(this.index, 0, new StiRadioButtonColumnItem(StiLocalizationService.get("PropertyMain", "New Column")));
                    this.setProperties(this.model.selectedComponent.element.columns[this.index], slicedColumn[0]);
                    for (let row of this.model.selectedComponent.element.rowLabels) {
                        this.model.selectedComponent.element.columns[this.index]["cells"].push(new StiRadioButtonCellItem("", false));
                    }
                }
                else if (value == "TextBox") {
                    this.model.selectedComponent.element.columns.splice(this.index, 0, new StiTextBoxColumnItem(StiLocalizationService.get("PropertyMain", "New Column")));
                    this.setProperties(this.model.selectedComponent.element.columns[this.index], slicedColumn[0]);
                    for (let row of this.model.selectedComponent.element.rowLabels) {
                        this.model.selectedComponent.element.columns[this.index]["cells"].push(new StiTextBoxCellItem("", ""));
                    }
                }
                else if (value == "NumberBox") {
                    this.model.selectedComponent.element.columns.splice(this.index, 0, new StiNumberBoxColumnItem(StiLocalizationService.get("PropertyMain", "New Column")));
                    this.setProperties(this.model.selectedComponent.element.columns[this.index], slicedColumn[0]);
                    for (let row of this.model.selectedComponent.element.rowLabels) {
                        this.model.selectedComponent.element.columns[this.index]["cells"].push(new StiNumberBoxCellItem("", 0));
                    }
                }
            }
        }
        else if (this.property.property === "dateFormat" || this.property.property === "timeFormat") {
            this.helper.setProperty(this.object ?? this.model.form.settings, this.property.property, value);
        }
        else if (this.property.property === "dateTimeFormat") {
            this.helper.setProperty(this.object, this.property.property, value);
        }
        else if (this.property.property === "innerText.borderWeight") {
            this.model.form.settings.innerText.borderWeight = Enum.parse(StiLineWeight, value);
        }
        else if (this.property.property === "unitAlignment") {
            if (this.object) {
                this.helper.setProperty(this.object, this.property.property, Enum.parse(StiUnitAlignment, value));
            }
            else {
                this.model.form.settings.unitAlignment = Enum.parse(StiUnitAlignment, value);
            }
            if (!(this.object instanceof StiColumnItem)) {
                this.model.needToRefresh.next(true);
            }
        }
        else {
            this.model.selectedComponent.element[this.property.property] = Enum.parse(StiLineWeight, value);
        }
        if (this.property.property != "type" &&
            this.property.property != "calculationAlgorithm.expression" &&
            this.property.property != "dateTimeFormat" &&
            this.property.property != "dateFormat" &&
            this.property.property != "timeFormat" &&
            this.property.property != "thousandSeparator" &&
            this.property.property != "numberType" &&
            this.property.property != "unitAlignment" &&
            this.property.property != "currency") {
            this.model.needToRefresh.next(true);
            this.model.needToRefreshInnerProperties.next(true);
        }
    }
    get enum() {
        if (this.property.property === "valueType") {
            return this.helper.dateTimeTypes;
        }
        else if (this.property.property === "signatureType") {
            return this.helper.signatureTypes;
        }
        else if (this.property.property === "initialState") {
            return this.helper.dateTimeValues;
        }
        else if (this.property.property === "numberType") {
            return this.helper.numberTypes;
        }
        else if (this.property.property === "rangeFormat") {
            return this.helper.rangeFormats;
        }
        else if (this.property.property === "buttonType") {
            return this.helper.buttonTypes;
        }
        else if (this.property.property === "buttonSendType") {
            return this.helper.buttonSendTypes;
        }
        else if (this.property.property === "thousandSeparator") {
            return this.helper.thousandSeparators;
        }
        else if (this.property.property === "barcodeType") {
            return this.helper.barcodeTypes;
        }
        else if (this.property.property === "style") {
            return this.helper.penStyles;
        }
        else if (this.property.property === "type") {
            return this.helper.columnTypes;
        }
        else if (this.property.property === "calculationAlgorithm.expression") {
            return this.helper.algorithmExpressions;
        }
        else if (this.property.property === "currency") {
            return this.helper.currencyInfo;
        }
        else if (this.property.property === "currentSignatureMode") {
            return this.helper.signatureEditorModes;
        }
        else if (this.property.property === "specialFont") {
            return this.helper.signatureSpecialFonts;
        }
        else if (this.property.property.includes("BrushHatchStyle")) {
            return this.helper.hatchStyle;
        }
        else if (this.property.property === "dateTimeFormat") {
            return this.helper.dateTimeFormats;
        }
        else if (this.property.property === "dateFormat") {
            return this.helper.dateFormats;
        }
        else if (this.property.property === "timeFormat") {
            return this.helper.timeFormats;
        }
        else if (this.property.property === "unitAlignment") {
            return this.helper.unitAlignment;
        }
        else {
            return this.helper.borderWeights;
        }
    }
    setProperties(newColumn, changedColumn, expression) {
        if ((newColumn && changedColumn) instanceof StiColumnItem) {
            newColumn.label = changedColumn.label;
            newColumn.headerAlignment = changedColumn.headerAlignment;
            newColumn.cellAlignment = changedColumn.cellAlignment;
            newColumn.backgroundColor = changedColumn.backgroundColor;
            newColumn.cellBackColor = changedColumn.cellBackColor;
            newColumn.cellForeColor = changedColumn.cellForeColor;
            newColumn.cellBorderColor = changedColumn.cellBorderColor;
            newColumn.width = changedColumn.width;
        }
        else if ((newColumn && changedColumn) instanceof StiTotalsFieldItem) {
            newColumn.header = changedColumn.header;
            newColumn.headerAlignment = changedColumn.headerAlignment;
            newColumn.headerColor = changedColumn.headerColor;
            newColumn.expression = "0";
        }
    }
    ngOnInit() { }
}
StiEnumEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEnumEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component });
StiEnumEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiEnumEditorComponent, selector: "sti-enum-editor", inputs: { property: "property", object: "object", index: "index" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" *ngIf="property.property != 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            optionLabel="{{ property.property == 'currency' ? 'englishName' : 'name' }}"
            optionValue="{{ property.property == 'currency' ? 'code' : 'value' }}"
            [editable]="
              property.property == 'dateFormat' ||
              property.property == 'timeFormat' ||
              property.property == 'dateTimeFormat'
            "
            (mouseover)="mouseOver($event.target)"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2" *ngIf="property.property == 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="columns"
            [(value)]="columnIndex"
            optionLabel="name"
            optionValue="value"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property == 'dateFormat' ||
          property.property == 'timeFormat' ||
          property.property == 'dateTimeFormat'
        "
      >
        <span>{{ today | date : model.formattingDate(type) }}</span>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      span {\n        margin-left: 2px;\n        color: var(--text-color);\n        font-weight: normal;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n    "], dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: ["value", "options", "optionLabel", "optionValue", "editable"], outputs: ["valueChange"] }, { kind: "pipe", type: i3.DatePipe, name: "date" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEnumEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-enum-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" *ngIf="property.property != 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            optionLabel="{{ property.property == 'currency' ? 'englishName' : 'name' }}"
            optionValue="{{ property.property == 'currency' ? 'code' : 'value' }}"
            [editable]="
              property.property == 'dateFormat' ||
              property.property == 'timeFormat' ||
              property.property == 'dateTimeFormat'
            "
            (mouseover)="mouseOver($event.target)"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
        <td colspan="2" *ngIf="property.property == 'calculationAlgorithm.columntIndex'">
          <sti-dropdown-editor
            [options]="columns"
            [(value)]="columnIndex"
            optionLabel="name"
            optionValue="value"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
      <tr
        *ngIf="
          property.property == 'dateFormat' ||
          property.property == 'timeFormat' ||
          property.property == 'dateTimeFormat'
        "
      >
        <span>{{ today | date : model.formattingDate(type) }}</span>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }]; }, propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }], index: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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