import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "@angular/common";
export class StiDropdownEditorComponent {
    constructor(model, cdr) {
        this.model = model;
        this.cdr = cdr;
        this.valueChange = new EventEmitter();
        this.isInitialized = false;
        this.showDropdownList = false;
    }
    ngOnDestroy() {
        this.hideDropdownSubscription.unsubscribe();
    }
    get currentPreviewIndex() {
        return this.options.findIndex((option) => option instanceof Object ? option[this.valueName] == this.value : option == this.value);
    }
    get label() {
        return this.optionLabel ? this.optionLabel : "name";
    }
    get valueName() {
        return this.optionValue ? this.optionValue : "value";
    }
    blur() {
        this.cdr.reattach();
        this.cdr.detectChanges();
    }
    setContent(innerText) {
        this.cdr.detach();
        this.value = innerText;
        this.valueChange.emit(this.value);
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    getLabel() {
        if (this.isInitialized) {
            return this.options[this.currentPreviewIndex] instanceof Object
                ? this.options[this.currentPreviewIndex][this.label]
                : this.currentPreviewIndex != -1
                    ? this.options[this.currentPreviewIndex]
                    : this.value;
        }
        else {
            return "";
        }
    }
    selectItem(index) {
        this.value = this.options[index] instanceof Object ? this.options[index][this.valueName] : this.options[index];
        this.valueChange.emit(this.value);
        setTimeout(() => {
            this.showDropdownList = false;
        });
    }
    ngOnInit() {
        this.isInitialized = true;
        this.hideDropdownSubscription = this.model.hideActiveDropdown.subscribe((event) => {
            if (this.showDropdownList) {
                this.showDropdownList = false;
            }
        });
    }
}
StiDropdownEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownEditorComponent, deps: [{ token: i1.StiModelService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
StiDropdownEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: { value: "value", options: "options", optionLabel: "optionLabel", optionValue: "optionValue", editable: "editable" }, outputs: { valueChange: "valueChange" }, ngImport: i0, template: `
    <div
      #editor
      class="sti-dropdown-editor"
      (click)="model.currentEditor = editor; editable ? '' : (showDropdownList = !showDropdownList)"
    >
      <span
        class="label"
        [attr.contenteditable]="editable ? 'plaintext-only' : false"
        (input)="setContent($event.target.textContent)"
        (blur)="blur()"
        [style.cursor]="editable ? 'text' : 'pointer'"
        [spellcheck]="false"
        >{{ getLabel() }}</span
      >
      <div
        class="button"
        [style.cursor]="'pointer'"
        (click)="model.currentEditor = editor; editable ? (showDropdownList = !showDropdownList) : ''"
      >
        <span><i class="pi pi-chevron-down"></i></span>
      </div>
      <div class="sti-dropdown-items" *ngIf="showDropdownList && model.currentEditor == editor">
        <div
          class="item {{ currentPreviewIndex == idx ? 'selected' : '' }}"
          *ngFor="let item of options; index as idx"
          (click)="selectItem(idx)"
        >
          <span class="item-label" [spellcheck]="false">{{ item[label] ? item[label] : item }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".item{cursor:pointer;font-weight:400;overflow:hidden;position:relative;white-space:nowrap;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0}.item:hover{background-color:#dadada}.selected{background-color:#efefef}.sti-dropdown-editor{min-width:100%;display:flex;align-items:center;position:relative;height:24px;-webkit-user-select:none;user-select:none;background:var(--input-color);border:1px solid var(--inputBorder-color);border-radius:3px;font-size:12px;font-weight:500;color:var(--text-color)}.sti-dropdown-editor:hover{background-color:var(--hover-color)}.label{width:100%;height:100%;padding:3px 5px;min-width:22.4px}.label:focus{outline:none}.button{width:20px;height:100%;color:#bab9b8;display:flex;align-items:center;justify-content:center}.sti-dropdown-items{position:absolute;max-height:400px;overflow-y:auto;overflow-x:hidden;left:0;top:24px;background:var(--input-color);min-width:100%;z-index:1003;border:1px solid #c8c8c8;border-radius:3px;font-size:13px;box-shadow:0 3px 6px #00000029}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-dropdown-editor", template: `
    <div
      #editor
      class="sti-dropdown-editor"
      (click)="model.currentEditor = editor; editable ? '' : (showDropdownList = !showDropdownList)"
    >
      <span
        class="label"
        [attr.contenteditable]="editable ? 'plaintext-only' : false"
        (input)="setContent($event.target.textContent)"
        (blur)="blur()"
        [style.cursor]="editable ? 'text' : 'pointer'"
        [spellcheck]="false"
        >{{ getLabel() }}</span
      >
      <div
        class="button"
        [style.cursor]="'pointer'"
        (click)="model.currentEditor = editor; editable ? (showDropdownList = !showDropdownList) : ''"
      >
        <span><i class="pi pi-chevron-down"></i></span>
      </div>
      <div class="sti-dropdown-items" *ngIf="showDropdownList && model.currentEditor == editor">
        <div
          class="item {{ currentPreviewIndex == idx ? 'selected' : '' }}"
          *ngFor="let item of options; index as idx"
          (click)="selectItem(idx)"
        >
          <span class="item-label" [spellcheck]="false">{{ item[label] ? item[label] : item }}</span>
        </div>
      </div>
    </div>
  `, styles: [".item{cursor:pointer;font-weight:400;overflow:hidden;position:relative;white-space:nowrap;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0}.item:hover{background-color:#dadada}.selected{background-color:#efefef}.sti-dropdown-editor{min-width:100%;display:flex;align-items:center;position:relative;height:24px;-webkit-user-select:none;user-select:none;background:var(--input-color);border:1px solid var(--inputBorder-color);border-radius:3px;font-size:12px;font-weight:500;color:var(--text-color)}.sti-dropdown-editor:hover{background-color:var(--hover-color)}.label{width:100%;height:100%;padding:3px 5px;min-width:22.4px}.label:focus{outline:none}.button{width:20px;height:100%;color:#bab9b8;display:flex;align-items:center;justify-content:center}.sti-dropdown-items{position:absolute;max-height:400px;overflow-y:auto;overflow-x:hidden;left:0;top:24px;background:var(--input-color);min-width:100%;z-index:1003;border:1px solid #c8c8c8;border-radius:3px;font-size:13px;box-shadow:0 3px 6px #00000029}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { value: [{
                type: Input
            }], options: [{
                type: Input
            }], optionLabel: [{
                type: Input
            }], optionValue: [{
                type: Input
            }], editable: [{
                type: Input
            }], valueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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