import { Component, Input } from "@angular/core";
import StiRectangleGeometryLayout from "../../../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/mouse.service";
import * as i4 from "@angular/common";
export class StiComponentHeightEditorComponent {
    constructor(model, helper, render, mouseService) {
        this.model = model;
        this.helper = helper;
        this.render = render;
        this.mouseService = mouseService;
        this.buttonDown = 0;
        this.mouseOver = false;
        this.focused = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
    }
    get value() {
        return this.helper.getProperty(this.element, this.property.property);
    }
    set value(val) {
        this.helper.setProperty(this.element, this.property.property, this.checkValue(val));
        let container = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
        this.render.insertElement(this.element, container.contentAreaWidth);
    }
    onLostFocus(object) {
        if (this.checkValue(Number(object.currentTarget.value)) != this.value) {
            this.value = Number(object.currentTarget.value);
        }
        else {
            this.model.needToRefresh.next(true);
            this.clear();
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    checkValue(value) {
        let container = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
        let otherElements = Array.from(container.elements);
        otherElements.splice(otherElements.indexOf(this.element), 1);
        let freeAreaHeight = this.render.getFreeToBottomResizeArea(this.element, otherElements);
        let oldValue = this.helper.getProperty(this.element, this.property.property);
        let roundValue = Math.round(value / this.model.form.settings.gridVerticalStep) * this.model.form.settings.gridVerticalStep;
        if (roundValue <= this.element.geometry.minHeight) {
            return this.element.geometry.minHeight;
        }
        else if (roundValue >= oldValue + freeAreaHeight) {
            return oldValue + freeAreaHeight;
        }
        else {
            return roundValue;
        }
    }
    clear() {
        setTimeout(() => {
            this.buttonDown = 0;
        }, 0);
    }
    setIncDec(value) {
        if (this.incTimeout) {
            clearTimeout(this.incTimeout);
            this.incTimeout = null;
        }
        setTimeout(() => {
            this.value += value;
            this.buttonDown = value;
            this.incDecTimer();
            this.model.formEvents.next({ name: "ValueChanged" });
        }, 0);
    }
    incDecTimer(first = true) {
        let this_ = this;
        this.incTimeout = setTimeout(() => {
            if (this_.buttonDown != 0) {
                this_.value += this_.buttonDown;
                this_.incDecTimer(false);
                this.model.formEvents.next({ name: "ValueChanged" });
            }
        }, first ? 400 : 50);
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.buttonDown = 0;
        });
    }
}
StiComponentHeightEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentHeightEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: StiRectangleGeometryLayout }, { token: i3.StiMouseService }], target: i0.ɵɵFactoryTarget.Component });
StiComponentHeightEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiComponentHeightEditorComponent, selector: "sti-component-height-editor", inputs: { property: "property", element: "element" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'componentHeight'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                (blur)="onLostFocus($event)"
                (keyup.enter)="onLostFocus($event)"
                [value]="value"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncDec(model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setIncDec(-model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>
    </table>
  `, isInline: true, styles: [".value:hover{cursor:text}.image-upload>input{display:none}.number-box{width:100%;height:24px;border:1px solid var(--inputBorder-color);border-radius:3px;background-color:var(--input-color);position:relative;display:flex}.value{outline:none;width:100%;height:100%}.value input{outline:none;background-color:var(--input-color);-moz-appearance:textfield;color:var(--text-color);border:0px}.value input[type=number]::-webkit-inner-spin-button,.value input[type=number]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0;opacity:0}.value:after{content:\"\";position:absolute;right:22px;z-index:100;top:2px;width:1px;height:18px;background-color:var(--inputBorder-color)}.buttons{width:22px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:22px;position:relative;height:11px;border-bottom:1px solid var(--inputBorder-color);text-align:center}.button-up:hover{background-color:#d1d0cf}.button-up:active{background-color:#c3c3c3}.button-down{width:22px;position:relative;height:11px;text-align:center}.button-down:hover{background-color:#d1d0cf}.button-down:active{background-color:#c3c3c3}i{position:absolute;left:5px;height:8px;width:8px}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentHeightEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-component-height-editor", template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'componentHeight'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                (blur)="onLostFocus($event)"
                (keyup.enter)="onLostFocus($event)"
                [value]="value"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncDec(model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setIncDec(-model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>
    </table>
  `, styles: [".value:hover{cursor:text}.image-upload>input{display:none}.number-box{width:100%;height:24px;border:1px solid var(--inputBorder-color);border-radius:3px;background-color:var(--input-color);position:relative;display:flex}.value{outline:none;width:100%;height:100%}.value input{outline:none;background-color:var(--input-color);-moz-appearance:textfield;color:var(--text-color);border:0px}.value input[type=number]::-webkit-inner-spin-button,.value input[type=number]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0;opacity:0}.value:after{content:\"\";position:absolute;right:22px;z-index:100;top:2px;width:1px;height:18px;background-color:var(--inputBorder-color)}.buttons{width:22px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:22px;position:relative;height:11px;border-bottom:1px solid var(--inputBorder-color);text-align:center}.button-up:hover{background-color:#d1d0cf}.button-up:active{background-color:#c3c3c3}.button-down{width:22px;position:relative;height:11px;text-align:center}.button-down:hover{background-color:#d1d0cf}.button-down:active{background-color:#c3c3c3}i{position:absolute;left:5px;height:8px;width:8px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: StiRectangleGeometryLayout }, { type: i3.StiMouseService }]; }, propDecorators: { property: [{
                type: Input
            }], element: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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