import { Component, Input } from "@angular/core";
import { StiFormElement } from "../../../../elements/base/StiFormElement";
import { StiFormSettings } from "../../../../elements/settings/StiFormSettings";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/sti-localization.service";
import * as i4 from "../../../../services/sti-color-dialog.service";
import * as i5 from "../../../sti-tooltip/sti-tooltip.directive";
//import Color from "../../../system/Color";
export class StiColorEditorComponent {
    constructor(model, helper, loc, colorService) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.colorService = colorService;
    }
    showColorPicker(element, object) {
        this.colorService.openDialog(element, object);
    }
    ngOnInit() { }
    get color() {
        if (this.obj instanceof StiFormElement || this.obj instanceof StiFormSettings) {
            return this.helper.getProperty(this.obj, this.property.property);
        }
        else {
            return this.obj[this.property.property];
        }
    }
}
StiColorEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }, { token: i4.StiColorDialogService }], target: i0.ɵɵFactoryTarget.Component });
StiColorEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiColorEditorComponent, selector: "sti-color-editor", inputs: { property: "property", textColor: "textColor", obj: "obj" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="color.toHtmlColor()"> </span>
              <span class="color-value">{{ color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      .custom-color-picker {\n        width: 100%;\n        background-color: var(--input-color);\n        height: 24px;\n        border: 1px solid var(--inputBorder-color);\n        position: relative;\n        border-radius: 3px;\n      }\n      .custom-color-picker:hover {\n        background-color: var(--hover-color);\n      }\n      .custom-color-picker:focus {\n        background-color: var(--input-color);\n      }\n      .preview {\n        display: flex;\n        position: relative;\n        width: 100%;\n        height: 100%;\n      }\n      .pick {\n        position: absolute;\n        top: 0;\n        left: 0;\n        width: 100%;\n        height: 22px;\n      }\n      .color-value {\n        font-weight: 500;\n        font-size: 12px;\n        align-self: center;\n        color: var(--text-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .custom-color-preview {\n        width: 24px;\n        height: 14px;\n        margin: 4px;\n        background-color: black;\n        border: 1px solid var(--inputBorder-color);\n      }\n      .select-button {\n        float: right;\n        margin-left: auto;\n        margin-right: 5px;\n        color: rgb(186, 185, 184);\n        display: flex;\n        align-items: center;\n      }\n      .i {\n        height: 12px;\n        width: 12px;\n        right: 3px;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-color-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <div
            class="custom-color-picker"
            [stiTooltip]="loc.getP('Color')"
            tooltipPosition="bottom"
            (click)="showColorPicker(colorEditor, color)"
            showDelay="500"
            #colorEditor
          >
            <div class="preview">
              <span class="custom-color-preview" [style.background-color]="color.toHtmlColor()"> </span>
              <span class="color-value">{{ color.getStringName() }}</span>
              <span class="select-button"><i class="pi pi-chevron-down"></i></span>
            </div>
          </div>
        </td>
      </tr>

      <tr></tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      .custom-color-picker {
        width: 100%;
        background-color: var(--input-color);
        height: 24px;
        border: 1px solid var(--inputBorder-color);
        position: relative;
        border-radius: 3px;
      }
      .custom-color-picker:hover {
        background-color: var(--hover-color);
      }
      .custom-color-picker:focus {
        background-color: var(--input-color);
      }
      .preview {
        display: flex;
        position: relative;
        width: 100%;
        height: 100%;
      }
      .pick {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 22px;
      }
      .color-value {
        font-weight: 500;
        font-size: 12px;
        align-self: center;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .custom-color-preview {
        width: 24px;
        height: 14px;
        margin: 4px;
        background-color: black;
        border: 1px solid var(--inputBorder-color);
      }
      .select-button {
        float: right;
        margin-left: auto;
        margin-right: 5px;
        color: rgb(186, 185, 184);
        display: flex;
        align-items: center;
      }
      .i {
        height: 12px;
        width: 12px;
        right: 3px;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }, { type: i4.StiColorDialogService }]; }, propDecorators: { property: [{
                type: Input
            }], textColor: [{
                type: Input
            }], obj: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWNvbG9yLWVkaXRvci5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvY29tcG9uZW50cy9wcm9wZXJ0eUdyaWQvZWRpdG9ycy9zdGktY29sb3ItZWRpdG9yL3N0aS1jb2xvci1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQWMsS0FBSyxFQUFxQixNQUFNLGVBQWUsQ0FBQztBQUNoRixPQUFPLEVBQUUsY0FBYyxFQUFFLE1BQU0sMENBQTBDLENBQUM7QUFDMUUsT0FBTyxFQUFFLGVBQWUsRUFBRSxNQUFNLCtDQUErQyxDQUFDOzs7Ozs7O0FBT2hGLDRDQUE0QztBQTBGNUMsTUFBTSxPQUFPLHVCQUF1QjtJQVFsQyxZQUNTLEtBQXNCLEVBQ3RCLE1BQXdCLEVBQ3hCLEdBQTJCLEVBQzNCLFlBQW1DO1FBSG5DLFVBQUssR0FBTCxLQUFLLENBQWlCO1FBQ3RCLFdBQU0sR0FBTixNQUFNLENBQWtCO1FBQ3hCLFFBQUcsR0FBSCxHQUFHLENBQXdCO1FBQzNCLGlCQUFZLEdBQVosWUFBWSxDQUF1QjtJQUN6QyxDQUFDO0lBUkosZUFBZSxDQUFDLE9BQU8sRUFBRSxNQUFNO1FBQzdCLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBT0QsUUFBUSxLQUFVLENBQUM7SUFDbkIsSUFBVyxLQUFLO1FBQ2QsSUFBSSxJQUFJLENBQUMsR0FBRyxZQUFZLGNBQWMsSUFBSSxJQUFJLENBQUMsR0FBRyxZQUFZLGVBQWUsRUFBRTtZQUM3RSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUNsRTthQUFNO1lBQ0wsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDekM7SUFDSCxDQUFDOztvSEFyQlUsdUJBQXVCO3dHQUF2Qix1QkFBdUIsOEhBdEZ4Qjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBb0ZUOzJGQUVVLHVCQUF1QjtrQkF4Rm5DLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLGtCQUFrQjtvQkFDNUIsUUFBUSxFQUFFOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FvRlQ7aUJBQ0Y7OE1BRVUsUUFBUTtzQkFBaEIsS0FBSztnQkFDRyxTQUFTO3NCQUFqQixLQUFLO2dCQUNHLEdBQUc7c0JBQVgsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgRWxlbWVudFJlZiwgSW5wdXQsIE9uSW5pdCwgVmlld0NoaWxkIH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpRm9ybUVsZW1lbnQgfSBmcm9tIFwiLi4vLi4vLi4vLi4vZWxlbWVudHMvYmFzZS9TdGlGb3JtRWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlGb3JtU2V0dGluZ3MgfSBmcm9tIFwiLi4vLi4vLi4vLi4vZWxlbWVudHMvc2V0dGluZ3MvU3RpRm9ybVNldHRpbmdzXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUVkaXRvclByb3BlcnR5IH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL29iamVjdHNcIjtcclxuaW1wb3J0IHsgU3RpQ29sb3JEaWFsb2dTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3N0aS1jb2xvci1kaWFsb2cuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlIZWxwZXJTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3N0aS1oZWxwZXIuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgQ29sb3IgZnJvbSBcIi4uLy4uLy4uLy4uL3N5c3RlbS9Db2xvclwiO1xyXG4vL2ltcG9ydCBDb2xvciBmcm9tIFwiLi4vLi4vLi4vc3lzdGVtL0NvbG9yXCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJzdGktY29sb3ItZWRpdG9yXCIsXHJcbiAgdGVtcGxhdGU6IGBcclxuICAgIDx0YWJsZSBjbGFzcz1cInN0aS1jbGVhclwiIFtzdHlsZV09XCJ7IHdpZHRoOiAnMTAwJScgfVwiPlxyXG4gICAgICA8dHI+XHJcbiAgICAgICAgPHRkIGNvbHNwYW49XCIyXCI+XHJcbiAgICAgICAgICA8ZGl2XHJcbiAgICAgICAgICAgIGNsYXNzPVwiY3VzdG9tLWNvbG9yLXBpY2tlclwiXHJcbiAgICAgICAgICAgIFtzdGlUb29sdGlwXT1cImxvYy5nZXRQKCdDb2xvcicpXCJcclxuICAgICAgICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgICAgICAgKGNsaWNrKT1cInNob3dDb2xvclBpY2tlcihjb2xvckVkaXRvciwgY29sb3IpXCJcclxuICAgICAgICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgICAgICAgICAgI2NvbG9yRWRpdG9yXHJcbiAgICAgICAgICA+XHJcbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJwcmV2aWV3XCI+XHJcbiAgICAgICAgICAgICAgPHNwYW4gY2xhc3M9XCJjdXN0b20tY29sb3ItcHJldmlld1wiIFtzdHlsZS5iYWNrZ3JvdW5kLWNvbG9yXT1cImNvbG9yLnRvSHRtbENvbG9yKClcIj4gPC9zcGFuPlxyXG4gICAgICAgICAgICAgIDxzcGFuIGNsYXNzPVwiY29sb3ItdmFsdWVcIj57eyBjb2xvci5nZXRTdHJpbmdOYW1lKCkgfX08L3NwYW4+XHJcbiAgICAgICAgICAgICAgPHNwYW4gY2xhc3M9XCJzZWxlY3QtYnV0dG9uXCI+PGkgY2xhc3M9XCJwaSBwaS1jaGV2cm9uLWRvd25cIj48L2k+PC9zcGFuPlxyXG4gICAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgIDwvZGl2PlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgIDwvdHI+XHJcblxyXG4gICAgICA8dHI+PC90cj5cclxuICAgIDwvdGFibGU+XHJcblxyXG4gICAgPHN0eWxlPlxyXG4gICAgICB0ZCB7XHJcbiAgICAgICAgcGFkZGluZzogMDtcclxuICAgICAgfVxyXG4gICAgICAuY3VzdG9tLWNvbG9yLXBpY2tlciB7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0taW5wdXQtY29sb3IpO1xyXG4gICAgICAgIGhlaWdodDogMjRweDtcclxuICAgICAgICBib3JkZXI6IDFweCBzb2xpZCB2YXIoLS1pbnB1dEJvcmRlci1jb2xvcik7XHJcbiAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xyXG4gICAgICAgIGJvcmRlci1yYWRpdXM6IDNweDtcclxuICAgICAgfVxyXG4gICAgICAuY3VzdG9tLWNvbG9yLXBpY2tlcjpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0taG92ZXItY29sb3IpO1xyXG4gICAgICB9XHJcbiAgICAgIC5jdXN0b20tY29sb3ItcGlja2VyOmZvY3VzIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1pbnB1dC1jb2xvcik7XHJcbiAgICAgIH1cclxuICAgICAgLnByZXZpZXcge1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIGhlaWdodDogMTAwJTtcclxuICAgICAgfVxyXG4gICAgICAucGljayB7XHJcbiAgICAgICAgcG9zaXRpb246IGFic29sdXRlO1xyXG4gICAgICAgIHRvcDogMDtcclxuICAgICAgICBsZWZ0OiAwO1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIGhlaWdodDogMjJweDtcclxuICAgICAgfVxyXG4gICAgICAuY29sb3ItdmFsdWUge1xyXG4gICAgICAgIGZvbnQtd2VpZ2h0OiA1MDA7XHJcbiAgICAgICAgZm9udC1zaXplOiAxMnB4O1xyXG4gICAgICAgIGFsaWduLXNlbGY6IGNlbnRlcjtcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgLXdlYmtpdC10b3VjaC1jYWxsb3V0OiBub25lO1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgIH1cclxuICAgICAgLmN1c3RvbS1jb2xvci1wcmV2aWV3IHtcclxuICAgICAgICB3aWR0aDogMjRweDtcclxuICAgICAgICBoZWlnaHQ6IDE0cHg7XHJcbiAgICAgICAgbWFyZ2luOiA0cHg7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogYmxhY2s7XHJcbiAgICAgICAgYm9yZGVyOiAxcHggc29saWQgdmFyKC0taW5wdXRCb3JkZXItY29sb3IpO1xyXG4gICAgICB9XHJcbiAgICAgIC5zZWxlY3QtYnV0dG9uIHtcclxuICAgICAgICBmbG9hdDogcmlnaHQ7XHJcbiAgICAgICAgbWFyZ2luLWxlZnQ6IGF1dG87XHJcbiAgICAgICAgbWFyZ2luLXJpZ2h0OiA1cHg7XHJcbiAgICAgICAgY29sb3I6IHJnYigxODYsIDE4NSwgMTg0KTtcclxuICAgICAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgICAgIH1cclxuICAgICAgLmkge1xyXG4gICAgICAgIGhlaWdodDogMTJweDtcclxuICAgICAgICB3aWR0aDogMTJweDtcclxuICAgICAgICByaWdodDogM3B4O1xyXG4gICAgICB9XHJcbiAgICA8L3N0eWxlPlxyXG4gIGAsXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBTdGlDb2xvckVkaXRvckNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcbiAgQElucHV0KCkgcHJvcGVydHk6IFN0aUVkaXRvclByb3BlcnR5O1xyXG4gIEBJbnB1dCgpIHRleHRDb2xvcjogQ29sb3I7XHJcbiAgQElucHV0KCkgb2JqPzogYW55O1xyXG5cclxuICBzaG93Q29sb3JQaWNrZXIoZWxlbWVudCwgb2JqZWN0KSB7XHJcbiAgICB0aGlzLmNvbG9yU2VydmljZS5vcGVuRGlhbG9nKGVsZW1lbnQsIG9iamVjdCk7XHJcbiAgfVxyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UsXHJcbiAgICBwdWJsaWMgaGVscGVyOiBTdGlIZWxwZXJTZXJ2aWNlLFxyXG4gICAgcHVibGljIGxvYzogU3RpTG9jYWxpemF0aW9uU2VydmljZSxcclxuICAgIHB1YmxpYyBjb2xvclNlcnZpY2U6IFN0aUNvbG9yRGlhbG9nU2VydmljZVxyXG4gICkge31cclxuICBuZ09uSW5pdCgpOiB2b2lkIHt9XHJcbiAgcHVibGljIGdldCBjb2xvcigpOiBDb2xvciB7XHJcbiAgICBpZiAodGhpcy5vYmogaW5zdGFuY2VvZiBTdGlGb3JtRWxlbWVudCB8fCB0aGlzLm9iaiBpbnN0YW5jZW9mIFN0aUZvcm1TZXR0aW5ncykge1xyXG4gICAgICByZXR1cm4gdGhpcy5oZWxwZXIuZ2V0UHJvcGVydHkodGhpcy5vYmosIHRoaXMucHJvcGVydHkucHJvcGVydHkpO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIHRoaXMub2JqW3RoaXMucHJvcGVydHkucHJvcGVydHldO1xyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXX0=