import { Component } from "@angular/core";
import { StiBarcodeElement } from "../../../../elements/StiBarcodeElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/sti-barcode.service";
import * as i2 from "../../../../services/model.service";
import * as i3 from "@angular/common";
import * as i4 from "./sti-svg-image.component";
export class StiBarcodeStylesPreviewComponent {
    constructor(barcodeService, model) {
        this.barcodeService = barcodeService;
        this.model = model;
        this.itemWidth = 57;
    }
    get items() {
        return this.barcodeService.barcodeStyles;
    }
    get itemsInRows() {
        let items = new Array(Math.floor((this.barcodeService.previewWidth - 10) / this.itemWidth)).fill(1);
        return items.length >= 1 ? items : new Array(1).fill(1);
    }
    get rows() {
        return new Array(Math.ceil(this.items.length / this.itemsInRows.length)).fill(2);
    }
    get currentItem() {
        return this.model.selectedComponent?.element && this.model.selectedComponent?.element instanceof StiBarcodeElement
            ? this.model.selectedComponent?.element
            : null;
    }
    selectStyle(index) {
        this.currentItem.style = index;
        this.barcodeService.showBarcodePreview = false;
    }
    ngOnInit() { }
}
StiBarcodeStylesPreviewComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeStylesPreviewComponent, deps: [{ token: i1.StiBarcodeService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiBarcodeStylesPreviewComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiBarcodeStylesPreviewComponent, selector: "sti-barcode-styles-preview", ngImport: i0, template: `
    <div
      #element
      class="container"
      [style.visibility]="barcodeService.showBarcodePreview ? 'visible' : 'hidden'"
      [style.left.px]="barcodeService.previewX"
      [style.top.px]="barcodeService.previewY"
      [style.width.px]="barcodeService.previewWidth ? barcodeService.previewWidth : 192"
    >
      <table class="sti-clear" [style.width]="'100%'">
        <tr *ngFor="let row of rows; index as i" class="row-container">
          <td
            *ngFor="let item of itemsInRows; index as ind"
            class="{{ items[i * itemsInRows.length + ind] ? '' : 'disabled' }} {{
              currentItem && i * itemsInRows.length + ind + 1 == currentItem.style ? 'active' : ''
            }}"
            (click)="selectStyle(i * itemsInRows.length + ind + 1)"
          >
            <sti-svg-image
              *ngIf="items[i * itemsInRows.length + ind]"
              [svg]="items[i * itemsInRows.length + ind].innerHtml"
            ></sti-svg-image>
          </td>
        </tr>
      </table>
    </div>
    <style>
      .container {
        position: absolute;
        z-index: 999;
        background-color: var(--back-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        width: 192px;
        height: 233px;
        border: 1px solid lightgray;
        border-radius: 3px;
        overflow-y: scroll;
        overflow-x: hidden;
        box-shadow: 0 3px 6px 0 rgb(0 0 0 / 16%);
      }
      .row-container {
        display: flex;
        width: 100%;
      }

      td {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 3px 3px 0 3px;
      }
      td:hover {
        background-color: var(--hover-color);
      }
      td:active {
        background-color: var(--active-color);
      }
      .active {
        background-color: rgb(190, 230, 253);
      }
      .disabled {
        pointer-events: none;
      }
    </style>
  `, isInline: true, styles: ["\n      .container {\n        position: absolute;\n        z-index: 999;\n        background-color: var(--back-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n        width: 192px;\n        height: 233px;\n        border: 1px solid lightgray;\n        border-radius: 3px;\n        overflow-y: scroll;\n        overflow-x: hidden;\n        box-shadow: 0 3px 6px 0 rgb(0 0 0 / 16%);\n      }\n      .row-container {\n        display: flex;\n        width: 100%;\n      }\n\n      td {\n        flex: 1;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        padding: 3px 3px 0 3px;\n      }\n      td:hover {\n        background-color: var(--hover-color);\n      }\n      td:active {\n        background-color: var(--active-color);\n      }\n      .active {\n        background-color: rgb(190, 230, 253);\n      }\n      .disabled {\n        pointer-events: none;\n      }\n    "], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiSvgImageComponent, selector: "sti-svg-image", inputs: ["svg"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeStylesPreviewComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-barcode-styles-preview",
                    template: `
    <div
      #element
      class="container"
      [style.visibility]="barcodeService.showBarcodePreview ? 'visible' : 'hidden'"
      [style.left.px]="barcodeService.previewX"
      [style.top.px]="barcodeService.previewY"
      [style.width.px]="barcodeService.previewWidth ? barcodeService.previewWidth : 192"
    >
      <table class="sti-clear" [style.width]="'100%'">
        <tr *ngFor="let row of rows; index as i" class="row-container">
          <td
            *ngFor="let item of itemsInRows; index as ind"
            class="{{ items[i * itemsInRows.length + ind] ? '' : 'disabled' }} {{
              currentItem && i * itemsInRows.length + ind + 1 == currentItem.style ? 'active' : ''
            }}"
            (click)="selectStyle(i * itemsInRows.length + ind + 1)"
          >
            <sti-svg-image
              *ngIf="items[i * itemsInRows.length + ind]"
              [svg]="items[i * itemsInRows.length + ind].innerHtml"
            ></sti-svg-image>
          </td>
        </tr>
      </table>
    </div>
    <style>
      .container {
        position: absolute;
        z-index: 999;
        background-color: var(--back-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        width: 192px;
        height: 233px;
        border: 1px solid lightgray;
        border-radius: 3px;
        overflow-y: scroll;
        overflow-x: hidden;
        box-shadow: 0 3px 6px 0 rgb(0 0 0 / 16%);
      }
      .row-container {
        display: flex;
        width: 100%;
      }

      td {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 3px 3px 0 3px;
      }
      td:hover {
        background-color: var(--hover-color);
      }
      td:active {
        background-color: var(--active-color);
      }
      .active {
        background-color: rgb(190, 230, 253);
      }
      .disabled {
        pointer-events: none;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiBarcodeService }, { type: i2.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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