import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-barcode.service";
import * as i3 from "./sti-svg-image.component";
export class StiBarcodeStyleEditorComponent {
    constructor(model, barcodeService) {
        this.model = model;
        this.barcodeService = barcodeService;
    }
    get currentBarcode() {
        return this.barcodeService.barcodeStyles.find((element) => element.value == this.element?.style).innerHtml;
    }
    showPreview(event) {
        let element = document.querySelector(".current-barcode");
        let elementRect = this.model.getPositionRelativeToForm(element);
        let propertyGrid = document.querySelector(".properties");
        let propertyGridRect = this.model.getPositionRelativeToForm(propertyGrid);
        this.barcodeService.previewWidth = propertyGridRect.width - (elementRect.left - propertyGridRect.left);
        this.barcodeService.previewY = elementRect.bottom;
        this.barcodeService.previewX = elementRect.left;
        this.barcodeService.showBarcodePreview = true;
    }
    ngOnInit() { }
}
StiBarcodeStyleEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeStyleEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiBarcodeService }], target: i0.ɵɵFactoryTarget.Component });
StiBarcodeStyleEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiBarcodeStyleEditorComponent, selector: "sti-barcode-style-editor", inputs: { property: "property", element: "element" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <div class="current-barcode" (click)="showPreview($event)">
        <sti-svg-image [svg]="currentBarcode"></sti-svg-image>
      </div>
    </table>
    <style>
      .current-barcode {
        height: min-content;
        width: min-content;
        padding: 3px 3px 0 3px;
      }
      .current-barcode:hover {
        background-color: var(--hover-color);
      }
      .current-barcode:active {
        background-color: var(--active-color);
      }
    </style>
  `, isInline: true, styles: ["\n      .current-barcode {\n        height: min-content;\n        width: min-content;\n        padding: 3px 3px 0 3px;\n      }\n      .current-barcode:hover {\n        background-color: var(--hover-color);\n      }\n      .current-barcode:active {\n        background-color: var(--active-color);\n      }\n    "], dependencies: [{ kind: "component", type: i3.StiSvgImageComponent, selector: "sti-svg-image", inputs: ["svg"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeStyleEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-barcode-style-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <div class="current-barcode" (click)="showPreview($event)">
        <sti-svg-image [svg]="currentBarcode"></sti-svg-image>
      </div>
    </table>
    <style>
      .current-barcode {
        height: min-content;
        width: min-content;
        padding: 3px 3px 0 3px;
      }
      .current-barcode:hover {
        background-color: var(--hover-color);
      }
      .current-barcode:active {
        background-color: var(--active-color);
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiBarcodeService }]; }, propDecorators: { property: [{
                type: Input
            }], element: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWJhcmNvZGUtc3R5bGUtZWRpdG9yLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3Byb3BlcnR5R3JpZC9lZGl0b3JzL3N0aS1iYXJjb2RlLXN0eWxlLWVkaXRvci9zdGktYmFyY29kZS1zdHlsZS1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBaUIsU0FBUyxFQUFjLEtBQUssRUFBcUIsTUFBTSxlQUFlLENBQUM7Ozs7O0FBNkIvRixNQUFNLE9BQU8sOEJBQThCO0lBT3pDLFlBQW1CLEtBQXNCLEVBQVMsY0FBaUM7UUFBaEUsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFBUyxtQkFBYyxHQUFkLGNBQWMsQ0FBbUI7SUFBRyxDQUFDO0lBSHZGLElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUM3RyxDQUFDO0lBRUQsV0FBVyxDQUFDLEtBQUs7UUFDZixJQUFJLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDekQsSUFBSSxXQUFXLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNoRSxJQUFJLFlBQVksR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3pELElBQUksZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUMxRSxJQUFJLENBQUMsY0FBYyxDQUFDLFlBQVksR0FBRyxnQkFBZ0IsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxXQUFXLENBQUMsSUFBSSxHQUFHLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3ZHLElBQUksQ0FBQyxjQUFjLENBQUMsUUFBUSxHQUFHLFdBQVcsQ0FBQyxNQUFNLENBQUM7UUFDbEQsSUFBSSxDQUFDLGNBQWMsQ0FBQyxRQUFRLEdBQUcsV0FBVyxDQUFDLElBQUksQ0FBQztRQUNoRCxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztJQUNoRCxDQUFDO0lBQ0QsUUFBUSxLQUFVLENBQUM7OzJIQWxCUiw4QkFBOEI7K0dBQTlCLDhCQUE4QixzSEFyQi9COzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBbUJUOzJGQUVVLDhCQUE4QjtrQkF2QjFDLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLDBCQUEwQjtvQkFDcEMsUUFBUSxFQUFFOzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBbUJUO2lCQUNGO3NJQUVVLFFBQVE7c0JBQWhCLEtBQUs7Z0JBQ0csT0FBTztzQkFBZixLQUFLIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWZ0ZXJWaWV3SW5pdCwgQ29tcG9uZW50LCBFbGVtZW50UmVmLCBJbnB1dCwgT25Jbml0LCBWaWV3Q2hpbGQgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlCYXJjb2RlRWxlbWVudCB9IGZyb20gXCIuLi8uLi8uLi8uLi9lbGVtZW50cy9TdGlCYXJjb2RlRWxlbWVudFwiO1xyXG5pbXBvcnQgeyBTdGlNb2RlbFNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vLi4vc2VydmljZXMvbW9kZWwuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlFZGl0b3JQcm9wZXJ0eSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9vYmplY3RzXCI7XHJcbmltcG9ydCB7IFN0aUJhcmNvZGVTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3N0aS1iYXJjb2RlLnNlcnZpY2VcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1iYXJjb2RlLXN0eWxlLWVkaXRvclwiLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8dGFibGUgY2xhc3M9XCJzdGktY2xlYXJcIiBbc3R5bGVdPVwieyB3aWR0aDogJzEwMCUnIH1cIj5cclxuICAgICAgPGRpdiBjbGFzcz1cImN1cnJlbnQtYmFyY29kZVwiIChjbGljayk9XCJzaG93UHJldmlldygkZXZlbnQpXCI+XHJcbiAgICAgICAgPHN0aS1zdmctaW1hZ2UgW3N2Z109XCJjdXJyZW50QmFyY29kZVwiPjwvc3RpLXN2Zy1pbWFnZT5cclxuICAgICAgPC9kaXY+XHJcbiAgICA8L3RhYmxlPlxyXG4gICAgPHN0eWxlPlxyXG4gICAgICAuY3VycmVudC1iYXJjb2RlIHtcclxuICAgICAgICBoZWlnaHQ6IG1pbi1jb250ZW50O1xyXG4gICAgICAgIHdpZHRoOiBtaW4tY29udGVudDtcclxuICAgICAgICBwYWRkaW5nOiAzcHggM3B4IDAgM3B4O1xyXG4gICAgICB9XHJcbiAgICAgIC5jdXJyZW50LWJhcmNvZGU6aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHZhcigtLWhvdmVyLWNvbG9yKTtcclxuICAgICAgfVxyXG4gICAgICAuY3VycmVudC1iYXJjb2RlOmFjdGl2ZSB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tYWN0aXZlLWNvbG9yKTtcclxuICAgICAgfVxyXG4gICAgPC9zdHlsZT5cclxuICBgLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpQmFyY29kZVN0eWxlRWRpdG9yQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcclxuICBASW5wdXQoKSBwcm9wZXJ0eTogU3RpRWRpdG9yUHJvcGVydHk7XHJcbiAgQElucHV0KCkgZWxlbWVudDogU3RpQmFyY29kZUVsZW1lbnQ7XHJcblxyXG4gIHB1YmxpYyBnZXQgY3VycmVudEJhcmNvZGUoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5iYXJjb2RlU2VydmljZS5iYXJjb2RlU3R5bGVzLmZpbmQoKGVsZW1lbnQpID0+IGVsZW1lbnQudmFsdWUgPT0gdGhpcy5lbGVtZW50Py5zdHlsZSkuaW5uZXJIdG1sO1xyXG4gIH1cclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgbW9kZWw6IFN0aU1vZGVsU2VydmljZSwgcHVibGljIGJhcmNvZGVTZXJ2aWNlOiBTdGlCYXJjb2RlU2VydmljZSkge31cclxuICBzaG93UHJldmlldyhldmVudCkge1xyXG4gICAgbGV0IGVsZW1lbnQgPSBkb2N1bWVudC5xdWVyeVNlbGVjdG9yKFwiLmN1cnJlbnQtYmFyY29kZVwiKTtcclxuICAgIGxldCBlbGVtZW50UmVjdCA9IHRoaXMubW9kZWwuZ2V0UG9zaXRpb25SZWxhdGl2ZVRvRm9ybShlbGVtZW50KTtcclxuICAgIGxldCBwcm9wZXJ0eUdyaWQgPSBkb2N1bWVudC5xdWVyeVNlbGVjdG9yKFwiLnByb3BlcnRpZXNcIik7XHJcbiAgICBsZXQgcHJvcGVydHlHcmlkUmVjdCA9IHRoaXMubW9kZWwuZ2V0UG9zaXRpb25SZWxhdGl2ZVRvRm9ybShwcm9wZXJ0eUdyaWQpO1xyXG4gICAgdGhpcy5iYXJjb2RlU2VydmljZS5wcmV2aWV3V2lkdGggPSBwcm9wZXJ0eUdyaWRSZWN0LndpZHRoIC0gKGVsZW1lbnRSZWN0LmxlZnQgLSBwcm9wZXJ0eUdyaWRSZWN0LmxlZnQpO1xyXG4gICAgdGhpcy5iYXJjb2RlU2VydmljZS5wcmV2aWV3WSA9IGVsZW1lbnRSZWN0LmJvdHRvbTtcclxuICAgIHRoaXMuYmFyY29kZVNlcnZpY2UucHJldmlld1ggPSBlbGVtZW50UmVjdC5sZWZ0O1xyXG4gICAgdGhpcy5iYXJjb2RlU2VydmljZS5zaG93QmFyY29kZVByZXZpZXcgPSB0cnVlO1xyXG4gIH1cclxuICBuZ09uSW5pdCgpOiB2b2lkIHt9XHJcbn1cclxuIl19