import { Component, Input } from "@angular/core";
import { StiBodyBrush } from "../../../../system/enums";
import { SlideInOutAnimation } from "../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../sti-bool-editor/sti-bool-editor.component";
import * as i7 from "../sti-color-editor/sti-color-editor.component";
import * as i8 from "../sti-enum-editor/sti-enum-editor.component";
import * as i9 from "../sti-number-editor/sti-number-editor.component";
import * as i10 from "../sti-simple-enum-editor/sti-simple-enum-editor.component";
export class StiBarcodeShapeEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.properties = [];
    }
    ngOnInit() {
        this.updateProperties();
        this.model.needToRefreshInnerProperties.subscribe(() => this.updateProperties());
        //
    }
    updateProperties() {
        this.properties = [];
        this.properties.push({
            type: "simpleEnum",
            property: `${this.getStartType(this.property.property)}BrushType`,
            label: this.loc.getP(`${this.getMiddleType(this.property.property)}Brush`),
        });
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Solid ||
            this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glass) {
            this.properties.push({
                type: "color",
                property: `${this.getStartType(this.property.property)}BrushColor`,
                label: this.loc.getP("Color"),
            });
        }
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Hatch) {
            this.properties.push({
                type: "color",
                property: `${this.getStartType(this.property.property)}BrushForeColor`,
                label: this.loc.getP("ForeColor"),
            });
            this.properties.push({
                type: "color",
                property: `${this.getStartType(this.property.property)}BrushBackColor`,
                label: this.loc.getP("BackColor"),
            });
            this.properties.push({
                type: "enum",
                property: `${this.getStartType(this.property.property)}BrushHatchStyle`,
                label: this.loc.getP("Style"),
            });
        }
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Gradient ||
            this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glare) {
            this.properties.push({
                type: "Number",
                property: `${this.getStartType(this.property.property)}BrushAngle`,
                label: this.loc.getP("Angle"),
            });
            this.properties.push({
                type: "color",
                property: `start${this.getMiddleType(this.property.property)}BrushColor`,
                label: this.loc.getP("StartColor"),
            });
            this.properties.push({
                type: "color",
                property: `end${this.getMiddleType(this.property.property)}BrushColor`,
                label: this.loc.getP("EndColor"),
            });
        }
        this.properties.push({
            type: "simpleEnum",
            property: `${this.getStartType(this.property.property)}ShapeType`,
            label: this.loc.getP(`${this.getMiddleType(this.property.property)}Shape`),
        });
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glare) {
            this.properties.push({
                type: "Number",
                property: `${this.getStartType(this.property.property)}BrushFocus`,
                label: this.loc.getP("Focus"),
            });
        }
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glass) {
            this.properties.push({
                type: "Number",
                property: `${this.getStartType(this.property.property)}BrushBlend`,
                label: this.loc.getP("Blend"),
            });
            this.properties.push({
                type: "checkbox",
                property: `${this.getStartType(this.property.property)}BrushDrawHatch`,
                label: this.loc.getP("DrawHatch"),
            });
        }
    }
    getMiddleType(property) {
        if (property == "showBodyBrushEditor") {
            return "Body";
        }
        else if (property == "showEyeBallBrushEditor") {
            return "EyeBall";
        }
        else {
            return "EyeFrame";
        }
    }
    getStartType(property) {
        if (property == "showBodyBrushEditor") {
            return "body";
        }
        else if (property == "showEyeBallBrushEditor") {
            return "eyeBall";
        }
        else {
            return "eyeFrame";
        }
    }
    get content() {
        return this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
    }
    set content(value) {
        this.helper.setProperty(this.model.selectedComponent.element, this.property.property, value);
    }
}
StiBarcodeShapeEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeShapeEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiBarcodeShapeEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiBarcodeShapeEditorComponent, selector: "sti-barcode-shape-editor", inputs: { property: "property", state: "state", object: "object" }, ngImport: i0, template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="barcode-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td [style.width]="'100%'">
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object"
            ></sti-color-editor>
            <sti-simple-enum-editor
              *ngIf="prop.type === 'simpleEnum'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '100%' }"
            ></sti-simple-enum-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="prop"
              *ngIf="prop.type === 'checkbox'"
              [style]="{ width: '95%' }"
            ></sti-bool-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 120px;
        white-space: nowrap;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .barcode-editor {
        overflow: hidden;
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .label {\n        font-size: 13px;\n        font-weight: normal;\n        min-width: 120px;\n        white-space: nowrap;\n        color: var(--text-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .barcode-editor {\n        overflow: hidden;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiBoolEditorComponent, selector: "sti-bool-editor", inputs: ["property", "object"] }, { kind: "component", type: i7.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i8.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i9.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i10.StiSimpleEnumEditorComponent, selector: "sti-simple-enum-editor", inputs: ["property", "object"] }], animations: [SlideInOutAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeShapeEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-barcode-shape-editor",
                    template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="barcode-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td [style.width]="'100%'">
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object"
            ></sti-color-editor>
            <sti-simple-enum-editor
              *ngIf="prop.type === 'simpleEnum'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '100%' }"
            ></sti-simple-enum-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="prop"
              *ngIf="prop.type === 'checkbox'"
              [style]="{ width: '95%' }"
            ></sti-bool-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 120px;
        white-space: nowrap;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .barcode-editor {
        overflow: hidden;
      }
    </style>
  `,
                    animations: [SlideInOutAnimation],
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }]; }, propDecorators: { property: [{
                type: Input
            }], state: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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