import { Component, Input } from "@angular/core";
import { RotateAnimation, SlideInOutAnimation } from "../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../table/table-border-editor/table-border-editor.component";
import * as i7 from "../sti-barcode-shape-editor/sti-barcode-shape-editor.component";
export class StiBooleanWithArrowEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
    }
    ngOnInit() {
        this._state = this.model.selectedComponent.element[this.property.property] == true ? "rotated" : "default";
    }
    get isBarcodeShape() {
        return this.property.property == "showBodyBrushEditor" ||
            this.property.property == "showEyeBallBrushEditor" ||
            this.property.property == "showEyeFrameBrushEditor"
            ? true
            : false;
    }
    get content() {
        if (!this.isBarcodeShape) {
            return this.property.property == "showGridLinesEditor"
                ? this.loc.get2("Chart", "GridLines")
                : this.loc.getP("Border");
        }
        else {
            if (this.property.property == "showBodyBrushEditor") {
                return this.loc.getP("BodyBrush");
            }
            else if (this.property.property == "showEyeBallBrushEditor") {
                return this.loc.getP("EyeBallBrush");
            }
            else {
                return this.loc.getP("EyeFrameBrush");
            }
        }
    }
    getObject() {
        if (this.property.property == "showGridLinesEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "gridLines");
        }
        else if (this.property.property == "showBorderEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "border");
        }
        else if (this.property.property == "showColumnsBorderEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "columnHeadersBorder");
        }
        else if (this.property.property == "showRowsBorderEditor") {
            return this.helper.getProperty(this.model.selectedComponent.element, "rowHeadersBorder");
        }
        else {
            return this.model.selectedComponent?.element;
        }
    }
    get state() {
        return this._state;
    }
    set state(value) {
        this._state = value;
    }
    changeState() {
        this.model.selectedComponent.element[this.property.property] =
            !this.model.selectedComponent.element[this.property.property];
        this.state = this.state == "default" ? "rotated" : "default";
    }
}
StiBooleanWithArrowEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBooleanWithArrowEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiBooleanWithArrowEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiBooleanWithArrowEditorComponent, selector: "boolean-with-arrow-editor", inputs: { property: "property" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7">
          <div class="boolean-button" (click)="changeState()">
            <div class="arrow" [@rotatedState]="state">
              <span class="select-button"><i class="pi pi-chevron-right"></i></span>
            </div>
            <div class="content">{{ content }}</div>
          </div>
          <sti-table-border-editor
            *ngIf="!isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-table-border-editor>
          <sti-barcode-shape-editor
            *ngIf="isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-barcode-shape-editor>
        </td>
      </tr>
    </table>
    <style>
      i {
        width: 10px;
        height: 10px;
      }
      .arrow {
        width: 20px;
        text-align: center;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }

      .content {
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .boolean-button {
        width: 100%;
        height: 22px;
        display: flex;
        flex-direction: row;
        color: var(--text-color);
        background-color: var(--hover-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
      }
    </style>
  `, isInline: true, styles: ["\n      i {\n        width: 10px;\n        height: 10px;\n      }\n      .arrow {\n        width: 20px;\n        text-align: center;\n        cursor: default;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n\n      .content {\n        cursor: default;\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .boolean-button {\n        width: 100%;\n        height: 22px;\n        display: flex;\n        flex-direction: row;\n        color: var(--text-color);\n        background-color: var(--hover-color);\n        border-top: 2px solid var(--toolbarResizerBorder-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiTableBorderEditorComponent, selector: "sti-table-border-editor", inputs: ["property", "state", "object"] }, { kind: "component", type: i7.StiBarcodeShapeEditorComponent, selector: "sti-barcode-shape-editor", inputs: ["property", "state", "object"] }], animations: [RotateAnimation, SlideInOutAnimation] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBooleanWithArrowEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "boolean-with-arrow-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="7">
          <div class="boolean-button" (click)="changeState()">
            <div class="arrow" [@rotatedState]="state">
              <span class="select-button"><i class="pi pi-chevron-right"></i></span>
            </div>
            <div class="content">{{ content }}</div>
          </div>
          <sti-table-border-editor
            *ngIf="!isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-table-border-editor>
          <sti-barcode-shape-editor
            *ngIf="isBarcodeShape"
            [property]="property"
            [state]="state == 'default' ? false : true"
            [object]="getObject()"
          ></sti-barcode-shape-editor>
        </td>
      </tr>
    </table>
    <style>
      i {
        width: 10px;
        height: 10px;
      }
      .arrow {
        width: 20px;
        text-align: center;
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }

      .content {
        cursor: default;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .boolean-button {
        width: 100%;
        height: 22px;
        display: flex;
        flex-direction: row;
        color: var(--text-color);
        background-color: var(--hover-color);
        border-top: 2px solid var(--toolbarResizerBorder-color);
      }
    </style>
  `,
                    animations: [RotateAnimation, SlideInOutAnimation],
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }]; }, propDecorators: { property: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYm9vbGVhbi13aXRoLWFycm93LWVkaXRvci5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvY29tcG9uZW50cy9wcm9wZXJ0eUdyaWQvZWRpdG9ycy9ib29sZWFuLXdpdGgtYXJyb3ctZWRpdG9yL2Jvb2xlYW4td2l0aC1hcnJvdy1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBTXpELE9BQU8sRUFBRSxlQUFlLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSxnQ0FBZ0MsQ0FBQzs7Ozs7Ozs7O0FBNER0RixNQUFNLE9BQU8sa0NBQWtDO0lBSTdDLFlBQ1MsS0FBc0IsRUFDdEIsTUFBd0IsRUFDeEIsS0FBc0IsRUFDdEIsR0FBMkI7UUFIM0IsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsV0FBTSxHQUFOLE1BQU0sQ0FBa0I7UUFDeEIsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsUUFBRyxHQUFILEdBQUcsQ0FBd0I7SUFDakMsQ0FBQztJQUVKLFFBQVE7UUFDTixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUM3RyxDQUFDO0lBQ0QsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLElBQUkscUJBQXFCO1lBQ3BELElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLHdCQUF3QjtZQUNsRCxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSx5QkFBeUI7WUFDbkQsQ0FBQyxDQUFDLElBQUk7WUFDTixDQUFDLENBQUMsS0FBSyxDQUFDO0lBQ1osQ0FBQztJQUVELElBQVcsT0FBTztRQUNoQixJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRTtZQUN4QixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLHFCQUFxQjtnQkFDcEQsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxXQUFXLENBQUM7Z0JBQ3JDLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUM3QjthQUFNO1lBQ0wsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSxxQkFBcUIsRUFBRTtnQkFDbkQsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQzthQUNuQztpQkFBTSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLHdCQUF3QixFQUFFO2dCQUM3RCxPQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO2FBQ3RDO2lCQUFNO2dCQUNMLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7YUFDdkM7U0FDRjtJQUNILENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSxxQkFBcUIsRUFBRTtZQUNuRCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLFdBQVcsQ0FBQyxDQUFDO1NBQ25GO2FBQU0sSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSxrQkFBa0IsRUFBRTtZQUN2RCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQ2hGO2FBQU0sSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSx5QkFBeUIsRUFBRTtZQUM5RCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLHFCQUFxQixDQUFDLENBQUM7U0FDN0Y7YUFBTSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxJQUFJLHNCQUFzQixFQUFFO1lBQzNELE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztTQUMxRjthQUFNO1lBQ0wsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLE9BQU8sQ0FBQztTQUM5QztJQUNILENBQUM7SUFDRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQWE7UUFDNUIsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7SUFDdEIsQ0FBQztJQUNELFdBQVc7UUFDVCxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQztZQUMxRCxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDaEUsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxJQUFJLFNBQVMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDL0QsQ0FBQzs7K0hBNURVLGtDQUFrQzttSEFBbEMsa0NBQWtDLG1HQXhEbkM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBcURULDZrQ0FDVyxDQUFDLGVBQWUsRUFBRSxtQkFBbUIsQ0FBQzsyRkFFdkMsa0NBQWtDO2tCQTFEOUMsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsMkJBQTJCO29CQUNyQyxRQUFRLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBcURUO29CQUNELFVBQVUsRUFBRSxDQUFDLGVBQWUsRUFBRSxtQkFBbUIsQ0FBQztpQkFDbkQ7d01BRVUsUUFBUTtzQkFBaEIsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUVkaXRvclByb3BlcnR5IH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL29iamVjdHNcIjtcclxuaW1wb3J0IHsgU3RpSGVscGVyU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9zdGktaGVscGVyLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9zdGktbG9jYWxpemF0aW9uLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpVGhlbWVTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3RoZW1lLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgUm90YXRlQW5pbWF0aW9uLCBTbGlkZUluT3V0QW5pbWF0aW9uIH0gZnJvbSBcIi4uLy4uLy4uL2FuaW1hdGlvbnMvYW5pbWF0aW9uc1wiO1xyXG5cclxuQENvbXBvbmVudCh7XHJcbiAgc2VsZWN0b3I6IFwiYm9vbGVhbi13aXRoLWFycm93LWVkaXRvclwiLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8dGFibGUgY2xhc3M9XCJzdGktY2xlYXJcIiBbc3R5bGVdPVwieyB3aWR0aDogJzEwMCUnIH1cIj5cclxuICAgICAgPHRyPlxyXG4gICAgICAgIDx0ZCBjb2xzcGFuPVwiN1wiPlxyXG4gICAgICAgICAgPGRpdiBjbGFzcz1cImJvb2xlYW4tYnV0dG9uXCIgKGNsaWNrKT1cImNoYW5nZVN0YXRlKClcIj5cclxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImFycm93XCIgW0Byb3RhdGVkU3RhdGVdPVwic3RhdGVcIj5cclxuICAgICAgICAgICAgICA8c3BhbiBjbGFzcz1cInNlbGVjdC1idXR0b25cIj48aSBjbGFzcz1cInBpIHBpLWNoZXZyb24tcmlnaHRcIj48L2k+PC9zcGFuPlxyXG4gICAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImNvbnRlbnRcIj57eyBjb250ZW50IH19PC9kaXY+XHJcbiAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgIDxzdGktdGFibGUtYm9yZGVyLWVkaXRvclxyXG4gICAgICAgICAgICAqbmdJZj1cIiFpc0JhcmNvZGVTaGFwZVwiXHJcbiAgICAgICAgICAgIFtwcm9wZXJ0eV09XCJwcm9wZXJ0eVwiXHJcbiAgICAgICAgICAgIFtzdGF0ZV09XCJzdGF0ZSA9PSAnZGVmYXVsdCcgPyBmYWxzZSA6IHRydWVcIlxyXG4gICAgICAgICAgICBbb2JqZWN0XT1cImdldE9iamVjdCgpXCJcclxuICAgICAgICAgID48L3N0aS10YWJsZS1ib3JkZXItZWRpdG9yPlxyXG4gICAgICAgICAgPHN0aS1iYXJjb2RlLXNoYXBlLWVkaXRvclxyXG4gICAgICAgICAgICAqbmdJZj1cImlzQmFyY29kZVNoYXBlXCJcclxuICAgICAgICAgICAgW3Byb3BlcnR5XT1cInByb3BlcnR5XCJcclxuICAgICAgICAgICAgW3N0YXRlXT1cInN0YXRlID09ICdkZWZhdWx0JyA/IGZhbHNlIDogdHJ1ZVwiXHJcbiAgICAgICAgICAgIFtvYmplY3RdPVwiZ2V0T2JqZWN0KClcIlxyXG4gICAgICAgICAgPjwvc3RpLWJhcmNvZGUtc2hhcGUtZWRpdG9yPlxyXG4gICAgICAgIDwvdGQ+XHJcbiAgICAgIDwvdHI+XHJcbiAgICA8L3RhYmxlPlxyXG4gICAgPHN0eWxlPlxyXG4gICAgICBpIHtcclxuICAgICAgICB3aWR0aDogMTBweDtcclxuICAgICAgICBoZWlnaHQ6IDEwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmFycm93IHtcclxuICAgICAgICB3aWR0aDogMjBweDtcclxuICAgICAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XHJcbiAgICAgICAgY3Vyc29yOiBkZWZhdWx0O1xyXG4gICAgICAgIC13ZWJraXQtdG91Y2gtY2FsbG91dDogbm9uZTtcclxuICAgICAgICAtd2Via2l0LXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICB9XHJcblxyXG4gICAgICAuY29udGVudCB7XHJcbiAgICAgICAgY3Vyc29yOiBkZWZhdWx0O1xyXG4gICAgICAgIC13ZWJraXQtdG91Y2gtY2FsbG91dDogbm9uZTtcclxuICAgICAgICAtd2Via2l0LXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICB9XHJcbiAgICAgIC5ib29sZWFuLWJ1dHRvbiB7XHJcbiAgICAgICAgd2lkdGg6IDEwMCU7XHJcbiAgICAgICAgaGVpZ2h0OiAyMnB4O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcclxuICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1jb2xvcik7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0taG92ZXItY29sb3IpO1xyXG4gICAgICAgIGJvcmRlci10b3A6IDJweCBzb2xpZCB2YXIoLS10b29sYmFyUmVzaXplckJvcmRlci1jb2xvcik7XHJcbiAgICAgIH1cclxuICAgIDwvc3R5bGU+XHJcbiAgYCxcclxuICBhbmltYXRpb25zOiBbUm90YXRlQW5pbWF0aW9uLCBTbGlkZUluT3V0QW5pbWF0aW9uXSxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aUJvb2xlYW5XaXRoQXJyb3dFZGl0b3JDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIEBJbnB1dCgpIHByb3BlcnR5OiBTdGlFZGl0b3JQcm9wZXJ0eTtcclxuICBwcml2YXRlIF9zdGF0ZTogc3RyaW5nO1xyXG5cclxuICBjb25zdHJ1Y3RvcihcclxuICAgIHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlLFxyXG4gICAgcHVibGljIGhlbHBlcjogU3RpSGVscGVyU2VydmljZSxcclxuICAgIHB1YmxpYyB0aGVtZTogU3RpVGhlbWVTZXJ2aWNlLFxyXG4gICAgcHVibGljIGxvYzogU3RpTG9jYWxpemF0aW9uU2VydmljZVxyXG4gICkge31cclxuXHJcbiAgbmdPbkluaXQoKTogdm9pZCB7XHJcbiAgICB0aGlzLl9zdGF0ZSA9IHRoaXMubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQuZWxlbWVudFt0aGlzLnByb3BlcnR5LnByb3BlcnR5XSA9PSB0cnVlID8gXCJyb3RhdGVkXCIgOiBcImRlZmF1bHRcIjtcclxuICB9XHJcbiAgcHVibGljIGdldCBpc0JhcmNvZGVTaGFwZSgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwic2hvd0JvZHlCcnVzaEVkaXRvclwiIHx8XHJcbiAgICAgIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJzaG93RXllQmFsbEJydXNoRWRpdG9yXCIgfHxcclxuICAgICAgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcInNob3dFeWVGcmFtZUJydXNoRWRpdG9yXCJcclxuICAgICAgPyB0cnVlXHJcbiAgICAgIDogZmFsc2U7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGNvbnRlbnQoKSB7XHJcbiAgICBpZiAoIXRoaXMuaXNCYXJjb2RlU2hhcGUpIHtcclxuICAgICAgcmV0dXJuIHRoaXMucHJvcGVydHkucHJvcGVydHkgPT0gXCJzaG93R3JpZExpbmVzRWRpdG9yXCJcclxuICAgICAgICA/IHRoaXMubG9jLmdldDIoXCJDaGFydFwiLCBcIkdyaWRMaW5lc1wiKVxyXG4gICAgICAgIDogdGhpcy5sb2MuZ2V0UChcIkJvcmRlclwiKTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIGlmICh0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwic2hvd0JvZHlCcnVzaEVkaXRvclwiKSB7XHJcbiAgICAgICAgcmV0dXJuIHRoaXMubG9jLmdldFAoXCJCb2R5QnJ1c2hcIik7XHJcbiAgICAgIH0gZWxzZSBpZiAodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcInNob3dFeWVCYWxsQnJ1c2hFZGl0b3JcIikge1xyXG4gICAgICAgIHJldHVybiB0aGlzLmxvYy5nZXRQKFwiRXllQmFsbEJydXNoXCIpO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHJldHVybiB0aGlzLmxvYy5nZXRQKFwiRXllRnJhbWVCcnVzaFwiKTtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgZ2V0T2JqZWN0KCk6IGFueSB7XHJcbiAgICBpZiAodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcInNob3dHcmlkTGluZXNFZGl0b3JcIikge1xyXG4gICAgICByZXR1cm4gdGhpcy5oZWxwZXIuZ2V0UHJvcGVydHkodGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudC5lbGVtZW50LCBcImdyaWRMaW5lc1wiKTtcclxuICAgIH0gZWxzZSBpZiAodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcInNob3dCb3JkZXJFZGl0b3JcIikge1xyXG4gICAgICByZXR1cm4gdGhpcy5oZWxwZXIuZ2V0UHJvcGVydHkodGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudC5lbGVtZW50LCBcImJvcmRlclwiKTtcclxuICAgIH0gZWxzZSBpZiAodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSA9PSBcInNob3dDb2x1bW5zQm9yZGVyRWRpdG9yXCIpIHtcclxuICAgICAgcmV0dXJuIHRoaXMuaGVscGVyLmdldFByb3BlcnR5KHRoaXMubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQuZWxlbWVudCwgXCJjb2x1bW5IZWFkZXJzQm9yZGVyXCIpO1xyXG4gICAgfSBlbHNlIGlmICh0aGlzLnByb3BlcnR5LnByb3BlcnR5ID09IFwic2hvd1Jvd3NCb3JkZXJFZGl0b3JcIikge1xyXG4gICAgICByZXR1cm4gdGhpcy5oZWxwZXIuZ2V0UHJvcGVydHkodGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudC5lbGVtZW50LCBcInJvd0hlYWRlcnNCb3JkZXJcIik7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gdGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudD8uZWxlbWVudDtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldCBzdGF0ZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMuX3N0YXRlO1xyXG4gIH1cclxuICBwdWJsaWMgc2V0IHN0YXRlKHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIHRoaXMuX3N0YXRlID0gdmFsdWU7XHJcbiAgfVxyXG4gIGNoYW5nZVN0YXRlKCkge1xyXG4gICAgdGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudC5lbGVtZW50W3RoaXMucHJvcGVydHkucHJvcGVydHldID1cclxuICAgICAgIXRoaXMubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQuZWxlbWVudFt0aGlzLnByb3BlcnR5LnByb3BlcnR5XTtcclxuICAgIHRoaXMuc3RhdGUgPSB0aGlzLnN0YXRlID09IFwiZGVmYXVsdFwiID8gXCJyb3RhdGVkXCIgOiBcImRlZmF1bHRcIjtcclxuICB9XHJcbn1cclxuIl19