import { Component, Input, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../sti-autocomplete/sti-autocomplete.component";
export class AutoCompleteEditorComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    get items() {
        return this.model.enteredUrls;
    }
    get value() {
        return this.helper.getProperty(this.obj, this.property.property);
    }
    set value(val) {
        let endValue;
        if (val.indexOf(",") != -1) {
            endValue = val.replace(/[\s,]/g, "");
        }
        this.helper.setProperty(this.obj, this.property.property, endValue ?? val);
    }
    ngOnInit() {
        if (this.value && !this.items.find((item) => item == this.value)) {
            this.model.enteredUrls.push(this.value);
        }
    }
}
AutoCompleteEditorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AutoCompleteEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component });
AutoCompleteEditorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: AutoCompleteEditorComponent, selector: "auto-complete-editor", inputs: { property: "property", obj: "obj" }, viewQueries: [{ propertyName: "autoComplete", first: true, predicate: ["autoComplete"], descendants: true }], ngImport: i0, template: `<table class="sti-clear" [style]="{ width: '100%' }">
    <tr>
      <td colspan="2">
        <sti-autoComplete [(value)]="value" [items]="items"></sti-autoComplete>
      </td>
    </tr>

    <tr></tr>
  </table>`, isInline: true, styles: ["td{padding:0}\n"], dependencies: [{ kind: "component", type: i3.StiAutoCompleteComponent, selector: "sti-autoComplete", inputs: ["value", "items"], outputs: ["valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AutoCompleteEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "auto-complete-editor", template: `<table class="sti-clear" [style]="{ width: '100%' }">
    <tr>
      <td colspan="2">
        <sti-autoComplete [(value)]="value" [items]="items"></sti-autoComplete>
      </td>
    </tr>

    <tr></tr>
  </table>`, styles: ["td{padding:0}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }]; }, propDecorators: { autoComplete: [{
                type: ViewChild,
                args: ["autoComplete"]
            }], property: [{
                type: Input
            }], obj: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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