import { Component } from "@angular/core";
import { StiAddressElement } from "../../../elements/StiAddressElement";
import { StiBarcodeElement } from "../../../elements/StiBarcodeElement";
import { StiButtonElement } from "../../../elements/StiButtonElement";
import { StiCheckBoxElement } from "../../../elements/StiCheckBoxElement";
import { StiComboBoxElement } from "../../../elements/StiComboBoxElement";
import { StiDateTimeBoxElement } from "../../../elements/StiDateTimeBoxElement";
import { StiFormPageElement } from "../../../elements/StiFormPageElement";
import { StiImageElement } from "../../../elements/StiImageElement";
import { StiLabelElement } from "../../../elements/StiLabelElement";
import StiLineElement from "../../../elements/StiLineElement";
import { StiListBoxElement } from "../../../elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "../../../elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "../../../elements/StiNumberBoxElement";
import { StiPDFSignatureElement } from "../../../elements/StiPDFSignatureElement";
import { StiPanelElement } from "../../../elements/StiPanelElement";
import { StiSignatureElement } from "../../../elements/StiSignatureElement";
import { StiSingleSelectionElement } from "../../../elements/StiSingleSelectionElement";
import { StiTableElement } from "../../../elements/StiTableElement";
import { StiTextBoxElement } from "../../../elements/StiTextBoxElement";
import { StiTextElement } from "../../../elements/StiTextElement";
import { StiLocalizationService } from "../../../services/sti-localization.service";
import StiAddressCreator from "../creators/StiAddressCreator";
import StiBarcodeCreator from "../creators/StiBarcodeCreator";
import StiButtonCreator from "../creators/StiButtonCreator";
import StiCheckBoxCreator from "../creators/StiCheckBoxCreator";
import StiComboBoxCreator from "../creators/StiComboBoxCreator";
import StiDateTimeBoxCreator from "../creators/StiDateTimeBoxCreator";
import StiFormPageCreator from "../creators/StiFormPageCreator";
import StiImageCreator from "../creators/StiImageCreator";
import StiLabelCreator from "../creators/StiLabelCreator";
import StiLineCreator from "../creators/StiLineCreator";
import StiListBoxCreator from "../creators/StiListBoxCreator";
import StiMultipleSelectionCreator from "../creators/StiMultipleSelectionCreator";
import StiNumberBoxCreator from "../creators/StiNumberBoxEditor";
import StiPDFSignatureCreator from "../creators/StiPDFSignatureCreator";
import StiPanelCreator from "../creators/StiPanelCreator";
import StiSettingsCreator from "../creators/StiSettingsCreator";
import StiSignatureCreator from "../creators/StiSignatureCreator";
import StiSingleSelectionCreator from "../creators/StiSingleSelectionCreator";
import StiTableCreator from "../creators/StiTableCreator";
import StiTextBoxCreator from "../creators/StiTextBoxCreator";
import StiTextCreator from "../creators/StiTextCreator";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-helper.service";
import * as i3 from "../../../services/sti-localization.service";
import * as i4 from "@angular/common";
import * as i5 from "../../propertyGrid/editors/sti-bool-editor/sti-bool-editor.component";
import * as i6 from "../../propertyGrid/editors/sti-color-editor/sti-color-editor.component";
import * as i7 from "../../propertyGrid/editors/sti-enum-editor/sti-enum-editor.component";
import * as i8 from "../../propertyGrid/editors/sti-font-editor/sti-font-editor.component";
import * as i9 from "../../propertyGrid/editors/sti-image-editor/sti-image-editor.component";
import * as i10 from "../../propertyGrid/editors/sti-padding-editor/sti-padding-editor.component";
import * as i11 from "../../propertyGrid/editors/sti-multiline-string-editor/sti-multiline-string-editor.component";
import * as i12 from "../../propertyGrid/editors/sti-number-editor/sti-number-editor.component";
import * as i13 from "../../propertyGrid/editors/sti-paper-kind-editor/sti-paper-kind-editor.component";
import * as i14 from "../../propertyGrid/editors/sti-vertical-alignment-editor/sti-vertical-alignment-editor";
import * as i15 from "../../propertyGrid/editors/sti-text-editor/sti-text-editor.component";
import * as i16 from "../../propertyGrid/editors/sti-name-editor/sti-name-editor";
import * as i17 from "../../propertyGrid/editors/sti-horizontal-alignment-editor/sti-horizontal-alignment-editor";
import * as i18 from "../../propertyGrid/editors/sti-label-alignment-editor/sti-label-alignment-editor";
import * as i19 from "../../propertyGrid/editors/boolean-with-arrow-editor/boolean-with-arrow-editor.component";
import * as i20 from "../../propertyGrid/editors/table/table-item-editor/table-item-editor.component";
import * as i21 from "../../propertyGrid/editors/table/table-border-editor/table-border-editor.component";
import * as i22 from "../../propertyGrid/editors/table/table-columns-editor/table-columns-editor.component";
import * as i23 from "../../propertyGrid/editors/sti-exceed-margins/sti-exceed-margins.component";
import * as i24 from "../../propertyGrid/editors/sti-select-button-editor.component";
import * as i25 from "../../propertyGrid/editors/sti-barcode-style-editor/sti-barcode-style-editor.component";
import * as i26 from "../../propertyGrid/editors/sti-simple-enum-editor/sti-simple-enum-editor.component";
import * as i27 from "../../propertyGrid/editors/table/table-navigation/table-navigation.component";
import * as i28 from "../../propertyGrid/editors/sti-component-height-editor/sti-component-height-editor.component";
import * as i29 from "../../propertyGrid/editors/auto-complete-editor/auto-complete-editor.component";
import * as i30 from "../../sti-divider/sti-divider.component";
import * as i31 from "../sti-forms-elements-dropdown/sti-forms-elements-dropdown.component";
export class StiPropertyGridComponent {
    constructor(model, helper, loc) {
        this.model = model;
        this.helper = helper;
        this.loc = loc;
        this.isDrag = false;
        this.properties = [];
    }
    get isTable() {
        return this.model?.selectedComponent?.element instanceof StiTableElement ? true : false;
    }
    get object() {
        if (this.model.selectedComponent) {
            return this.model.selectedComponent.element;
        }
        else if (this.model.selectedPage) {
            return this.model.selectedPage;
        }
        else {
            return this.model.form.settings;
        }
    }
    hasValue(property) {
        if ((property?.includes("label") || property?.includes("description")) &&
            !property?.includes("value") &&
            this.object != this.model.form.settings) {
            if (property.includes("label")) {
                let value = this.helper.getProperty(this.object, "label.value");
                if (value) {
                    return true;
                }
                else
                    return false;
            }
            else {
                if (this.object instanceof StiAddressElement) {
                    return true;
                }
                let value = this.helper.getProperty(this.object, "description.value");
                if (value) {
                    return true;
                }
                else
                    return false;
            }
        }
        else {
            return true;
        }
    }
    ngOnDestroy() {
        this.refreshSubscription?.unsubscribe();
        this.refreshFromLocalizationSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.refreshSubscription = this.model.needToRefresh.subscribe(() => this.updateProperties());
        this.refreshFromLocalizationSubscription = StiLocalizationService.needToRefresh.subscribe(() => {
            this.updateProperties();
        });
    }
    needToDisable(property) {
        if (this.object instanceof StiSingleSelectionElement || this.object instanceof StiMultipleSelectionElement) {
            if (this.object.prefix.length > 0 && property.property == "suffix") {
                return true;
            }
            else if (this.object.suffix.length > 0 && property.property == "prefix") {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    back() {
        if (this.model.selectedComponent.element instanceof StiTableElement) {
            this.model.selectedComponent.element.showHeaderEditor = false;
            this.model.selectedComponent.element.showColumnsEditor = false;
            this.model.selectedComponent.element.showRowsEditor = false;
            this.model.selectedComponent.element.showTotalsEditor = false;
            this.model.needToRefresh.next(true);
        }
    }
    checkTableProperties() {
        if (this.model.selectedComponent?.element instanceof StiTableElement) {
            let tableJson = (this.model.selectedComponent?.element).saveToJsonObject({}).serialize();
            if (tableJson != this.savedTableJson) {
                this.savedTableJson = tableJson;
                this.model.form.formEvents.next({ name: "ValueChanged" });
            }
            setTimeout(() => {
                this.checkTableProperties();
            }, 500);
        }
        else {
            this.savedTableJson = null;
        }
    }
    updateProperties() {
        this.properties = [];
        this.checkTableProperties();
        if (this.model.selectedComponent?.element instanceof StiCheckBoxElement) {
            StiCheckBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiTextBoxElement) {
            StiTextBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiNumberBoxElement) {
            StiNumberBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiComboBoxElement) {
            StiComboBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiListBoxElement) {
            StiListBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiSingleSelectionElement) {
            StiSingleSelectionCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiMultipleSelectionElement) {
            StiMultipleSelectionCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiLineElement) {
            StiLineCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiSignatureElement) {
            StiSignatureCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiPDFSignatureElement) {
            StiPDFSignatureCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiPanelElement) {
            StiPanelCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiDateTimeBoxElement) {
            StiDateTimeBoxCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiTableElement) {
            StiTableCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element, this.model);
        }
        else if (this.model.selectedComponent?.element instanceof StiImageElement) {
            StiImageCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiButtonElement) {
            StiButtonCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiBarcodeElement) {
            StiBarcodeCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiTextElement) {
            StiTextCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiLabelElement) {
            StiLabelCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedComponent?.element instanceof StiAddressElement) {
            StiAddressCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedPage instanceof StiFormPageElement) {
            StiFormPageCreator.createPropertyEditors(this.properties, this.model.selectedComponent?.element);
        }
        else if (this.model.selectedPage == null && this.model.selectedComponent == null && this.model.form) {
            StiSettingsCreator.createPropertyEditors(this.properties, this.model.form.settings);
        }
    }
}
StiPropertyGridComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPropertyGridComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiPropertyGridComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiPropertyGridComponent, selector: "property-grid", ngImport: i0, template: ` <div style="width: 100%;">
    <!--   <span *ngIf="this.model.selectedComponent">{{
      loc.get2(
        helper.getLocalizationCategory(model.selectedComponent?.element.type),
        helper.getLocalizationKey(model.selectedComponent?.element.type)
      )
    }}</span>
    <span *ngIf="this.model.selectedPage">{{
      loc.get2("Components", helper.getLocalizationKey(model.selectedPage?.type))
    }}</span>
    <span *ngIf="model.selectedComponent == null && model.selectedPage == null">{{ loc.getP("FormSettings") }}</span> -->
    <sti-form-elements-dropdown></sti-form-elements-dropdown>
    <table class="sti-clear p-component property-grid">
      <tr *ngFor="let property of properties">
        <td
          *ngIf="
            property.type != 'BooleanWithArrowEditor' &&
            property.type != 'TableColumnsEditor' &&
            property.type != 'tableNavigations' &&
            hasValue(property.property)
          "
          [colSpan]="property.type != 'divider' && property.type != 'defaultLabel' ? 1 : 2"
          [style]="{
            padding: property.type != 'divider' && property.type != 'defaultLabel' ? '5px 0px 0px 5px' : '0px',
            verticalAlign: 'top'
          }"
        >
          <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          <span *ngIf="property.type === 'defaultLabel'">{{ loc.getP("DefaultSettings") }}</span>
          <div class="label" *ngIf="property.label">
            {{ property.label.replace(":", "") }}
          </div>
        </td>
        <td
          *ngIf="property.type != 'divider' && hasValue(property.property)"
          [colSpan]="
            property.type == 'BooleanWithArrowEditor' ||
            property.type == 'TableColumnsEditor' ||
            property.type == 'tableNavigations'
              ? 8
              : ''
          "
          [style]="{ width: '100%', padding: '0px 2px 0 px 2 px' }"
        >
          <table-navigation *ngIf="property.type === 'tableNavigations'" [style]="{ width: '100%' }"></table-navigation>
          <auto-complete-editor
            [property]="property"
            [obj]="object"
            *ngIf="property.type === 'autoCompleteEditor'"
            [style]="{ width: '95%' }"
          ></auto-complete-editor>
          <sti-bool-editor
            [property]="property"
            *ngIf="property.type === 'checkbox'"
            [style]="{ width: '95%' }"
            [object]="object"
          ></sti-bool-editor>
          <sti-name-editor
            *ngIf="property.type === 'nameEditor'"
            [property]="property"
            [style]="{ width: '95%' }"
          ></sti-name-editor>
          <sti-color-editor
            *ngIf="property.type === 'color'"
            [property]="property"
            [obj]="object"
            [style]="{ width: '95%' }"
          ></sti-color-editor>
          <sti-horizontal-alignment-editor
            [property]="property"
            *ngIf="property.type === 'horizontalAlignment'"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-horizontal-alignment-editor>
          <sti-vertical-alignment-editor
            [property]="property"
            *ngIf="property.type === 'verticalAlignment'"
            [style]="{ width: '95%' }"
          ></sti-vertical-alignment-editor>
          <sti-component-height-editor
            [property]="property"
            *ngIf="property.type === 'componentHeight'"
            [style]="{ width: '95%' }"
            [element]="object"
          >
          </sti-component-height-editor>
          <sti-label-alignment-editor
            [property]="property"
            *ngIf="property.type === 'labelAlignment'"
            [style]="{ width: '95%' }"
          >
          </sti-label-alignment-editor>
          <sti-enum-editor
            *ngIf="property.type === 'enum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-enum-editor>
          <sti-simple-enum-editor
            *ngIf="property.type === 'simpleEnum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-simple-enum-editor>
          <sti-font-editor
            *ngIf="property.type === 'FontEditor'"
            [object]="object"
            [property]="property"
          ></sti-font-editor>
          <sti-image-editor
            *ngIf="property.type === 'image'"
            [object]="object"
            [property]="property"
          ></sti-image-editor>
          <sti-initial-value-datetime-box-editor
            *ngIf="property.type === 'customDate'"
            [property]="property"
            [object]="object"
          ></sti-initial-value-datetime-box-editor>
          <sti-barcode-style-editor
            *ngIf="property.type === 'barcodeStyles'"
            [property]="property"
            [element]="object"
          ></sti-barcode-style-editor>
          <sti-padding-editor *ngIf="property.type === 'PaddingEditor'" [property]="property"></sti-padding-editor>
          <sti-multiline-string-editor
            *ngIf="property.type === 'MultilineEditor'"
            [property]="property"
          ></sti-multiline-string-editor>
          <sti-number-editor
            *ngIf="
              property.type === 'NumberEditor' || property.type === 'pageNumberEditor' || property.type === 'Number'
            "
            [property]="property"
            [obj]="object"
          ></sti-number-editor>
          <sti-paper-kind-editor
            *ngIf="property.type === 'paperKind' && this.model.selectedPage"
            [property]="property"
          ></sti-paper-kind-editor>
          <sti-text-editor
            *ngIf="property.type === 'TextEditor'"
            [object]="object"
            [property]="property"
            [disabled]="needToDisable(property)"
          ></sti-text-editor>
          <sti-table-item-editor
            *ngIf="property.type === 'TableItemEditor'"
            [property]="property"
          ></sti-table-item-editor>
          <sti-table-border-editor
            *ngIf="property.type === 'TableBorderEditor'"
            [property]="property"
          ></sti-table-border-editor>
          <boolean-with-arrow-editor
            *ngIf="property.type === 'BooleanWithArrowEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></boolean-with-arrow-editor>
          <sti-table-columns-editor
            *ngIf="property.type === 'TableColumnsEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></sti-table-columns-editor>
          <sti-exceed-margins-editor
            *ngIf="property.type === 'ExceedMarginsEditor'"
            [property]="property"
            [object]="object"
            [style]="{ width: '100%' }"
          ></sti-exceed-margins-editor>
          <sti-select-button-editor
            *ngIf="property.type === 'labelFormat' || property.type === 'currencyFormat'"
            [propertyType]="property.type"
            [property]="property.property"
            [object]="object"
            [style.height.px]="24"
            [style.display]="'flex'"
          >
          </sti-select-button-editor>
        </td>
      </tr>
    </table>
  </div>`, isInline: true, styles: [".table-property-header{width:100%;display:flex;margin-bottom:-3px}.table-property-header span{flex:1;display:flex;font-size:13px;justify-content:center;align-items:center;margin:0;font-weight:400;border-bottom:3px solid transparent}.table-property-header span:hover{background-color:var(--hover-color);color:#5579ae}.table-property-header .current{color:#767676;font-weight:600;border-color:var(--text-color);z-index:1}.table-property-header .other{color:var(--text-color)}.property-grid{position:relative}.property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}table{width:100%;font-size:13px;font-weight:600;-webkit-user-select:none}span{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:15px;-webkit-touch-callout:none;-webkit-user-select:none}.label{font-size:13px;font-weight:400;min-width:120px;color:var(--property-label-color);white-space:nowrap;-webkit-touch-callout:none;-webkit-user-select:none}\n"], dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.StiBoolEditorComponent, selector: "sti-bool-editor", inputs: ["property", "object"] }, { kind: "component", type: i6.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i7.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i8.StiFontEditorComponent, selector: "sti-font-editor", inputs: ["property", "object"] }, { kind: "component", type: i9.StiImageEditorComponent, selector: "sti-image-editor", inputs: ["property", "object"] }, { kind: "component", type: i10.StiPaddingEditorComponent, selector: "sti-padding-editor", inputs: ["property"] }, { kind: "component", type: i11.StiMultilineStringEditorComponent, selector: "sti-multiline-string-editor", inputs: ["property", "object"] }, { kind: "component", type: i12.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i13.StiPaperKindEditorComponent, selector: "sti-paper-kind-editor", inputs: ["property"] }, { kind: "component", type: i14.StiVerticalAlignmentEditorComponent, selector: "sti-vertical-alignment-editor", inputs: ["property"] }, { kind: "component", type: i15.StiTextEditorComponent, selector: "sti-text-editor", inputs: ["property", "object", "disabled"] }, { kind: "component", type: i16.StiNameEditorComponent, selector: "sti-name-editor", inputs: ["property"] }, { kind: "component", type: i17.StiHorizontalAlignmentEditorComponent, selector: "sti-horizontal-alignment-editor", inputs: ["property", "object"] }, { kind: "component", type: i18.StiLabelAlignmentEditorComponent, selector: "sti-label-alignment-editor", inputs: ["property"] }, { kind: "component", type: i19.StiBooleanWithArrowEditorComponent, selector: "boolean-with-arrow-editor", inputs: ["property"] }, { kind: "component", type: i20.StiTableItemEditorComponent, selector: "sti-table-item-editor", inputs: ["property"] }, { kind: "component", type: i21.StiTableBorderEditorComponent, selector: "sti-table-border-editor", inputs: ["property", "state", "object"] }, { kind: "component", type: i22.StiTableColumnsEditorComponent, selector: "sti-table-columns-editor", inputs: ["property"] }, { kind: "component", type: i23.StiExceedMarginsEditorComponent, selector: "sti-exceed-margins-editor", inputs: ["property", "object"] }, { kind: "component", type: i24.StiSelectButtonEditorComponent, selector: "sti-select-button-editor", inputs: ["propertyType", "property", "object"] }, { kind: "component", type: i25.StiBarcodeStyleEditorComponent, selector: "sti-barcode-style-editor", inputs: ["property", "element"] }, { kind: "component", type: i26.StiSimpleEnumEditorComponent, selector: "sti-simple-enum-editor", inputs: ["property", "object"] }, { kind: "component", type: i27.TableNavigationComponent, selector: "table-navigation" }, { kind: "component", type: i28.StiComponentHeightEditorComponent, selector: "sti-component-height-editor", inputs: ["property", "element"] }, { kind: "component", type: i29.AutoCompleteEditorComponent, selector: "auto-complete-editor", inputs: ["property", "obj"] }, { kind: "component", type: i30.StiDividerComponent, selector: "sti-divider" }, { kind: "component", type: i31.StiFormElementsDropdownComponent, selector: "sti-form-elements-dropdown" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPropertyGridComponent, decorators: [{
            type: Component,
            args: [{ selector: "property-grid", template: ` <div style="width: 100%;">
    <!--   <span *ngIf="this.model.selectedComponent">{{
      loc.get2(
        helper.getLocalizationCategory(model.selectedComponent?.element.type),
        helper.getLocalizationKey(model.selectedComponent?.element.type)
      )
    }}</span>
    <span *ngIf="this.model.selectedPage">{{
      loc.get2("Components", helper.getLocalizationKey(model.selectedPage?.type))
    }}</span>
    <span *ngIf="model.selectedComponent == null && model.selectedPage == null">{{ loc.getP("FormSettings") }}</span> -->
    <sti-form-elements-dropdown></sti-form-elements-dropdown>
    <table class="sti-clear p-component property-grid">
      <tr *ngFor="let property of properties">
        <td
          *ngIf="
            property.type != 'BooleanWithArrowEditor' &&
            property.type != 'TableColumnsEditor' &&
            property.type != 'tableNavigations' &&
            hasValue(property.property)
          "
          [colSpan]="property.type != 'divider' && property.type != 'defaultLabel' ? 1 : 2"
          [style]="{
            padding: property.type != 'divider' && property.type != 'defaultLabel' ? '5px 0px 0px 5px' : '0px',
            verticalAlign: 'top'
          }"
        >
          <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          <span *ngIf="property.type === 'defaultLabel'">{{ loc.getP("DefaultSettings") }}</span>
          <div class="label" *ngIf="property.label">
            {{ property.label.replace(":", "") }}
          </div>
        </td>
        <td
          *ngIf="property.type != 'divider' && hasValue(property.property)"
          [colSpan]="
            property.type == 'BooleanWithArrowEditor' ||
            property.type == 'TableColumnsEditor' ||
            property.type == 'tableNavigations'
              ? 8
              : ''
          "
          [style]="{ width: '100%', padding: '0px 2px 0 px 2 px' }"
        >
          <table-navigation *ngIf="property.type === 'tableNavigations'" [style]="{ width: '100%' }"></table-navigation>
          <auto-complete-editor
            [property]="property"
            [obj]="object"
            *ngIf="property.type === 'autoCompleteEditor'"
            [style]="{ width: '95%' }"
          ></auto-complete-editor>
          <sti-bool-editor
            [property]="property"
            *ngIf="property.type === 'checkbox'"
            [style]="{ width: '95%' }"
            [object]="object"
          ></sti-bool-editor>
          <sti-name-editor
            *ngIf="property.type === 'nameEditor'"
            [property]="property"
            [style]="{ width: '95%' }"
          ></sti-name-editor>
          <sti-color-editor
            *ngIf="property.type === 'color'"
            [property]="property"
            [obj]="object"
            [style]="{ width: '95%' }"
          ></sti-color-editor>
          <sti-horizontal-alignment-editor
            [property]="property"
            *ngIf="property.type === 'horizontalAlignment'"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-horizontal-alignment-editor>
          <sti-vertical-alignment-editor
            [property]="property"
            *ngIf="property.type === 'verticalAlignment'"
            [style]="{ width: '95%' }"
          ></sti-vertical-alignment-editor>
          <sti-component-height-editor
            [property]="property"
            *ngIf="property.type === 'componentHeight'"
            [style]="{ width: '95%' }"
            [element]="object"
          >
          </sti-component-height-editor>
          <sti-label-alignment-editor
            [property]="property"
            *ngIf="property.type === 'labelAlignment'"
            [style]="{ width: '95%' }"
          >
          </sti-label-alignment-editor>
          <sti-enum-editor
            *ngIf="property.type === 'enum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-enum-editor>
          <sti-simple-enum-editor
            *ngIf="property.type === 'simpleEnum'"
            [property]="property"
            [object]="object"
            [style]="{ width: '95%' }"
          ></sti-simple-enum-editor>
          <sti-font-editor
            *ngIf="property.type === 'FontEditor'"
            [object]="object"
            [property]="property"
          ></sti-font-editor>
          <sti-image-editor
            *ngIf="property.type === 'image'"
            [object]="object"
            [property]="property"
          ></sti-image-editor>
          <sti-initial-value-datetime-box-editor
            *ngIf="property.type === 'customDate'"
            [property]="property"
            [object]="object"
          ></sti-initial-value-datetime-box-editor>
          <sti-barcode-style-editor
            *ngIf="property.type === 'barcodeStyles'"
            [property]="property"
            [element]="object"
          ></sti-barcode-style-editor>
          <sti-padding-editor *ngIf="property.type === 'PaddingEditor'" [property]="property"></sti-padding-editor>
          <sti-multiline-string-editor
            *ngIf="property.type === 'MultilineEditor'"
            [property]="property"
          ></sti-multiline-string-editor>
          <sti-number-editor
            *ngIf="
              property.type === 'NumberEditor' || property.type === 'pageNumberEditor' || property.type === 'Number'
            "
            [property]="property"
            [obj]="object"
          ></sti-number-editor>
          <sti-paper-kind-editor
            *ngIf="property.type === 'paperKind' && this.model.selectedPage"
            [property]="property"
          ></sti-paper-kind-editor>
          <sti-text-editor
            *ngIf="property.type === 'TextEditor'"
            [object]="object"
            [property]="property"
            [disabled]="needToDisable(property)"
          ></sti-text-editor>
          <sti-table-item-editor
            *ngIf="property.type === 'TableItemEditor'"
            [property]="property"
          ></sti-table-item-editor>
          <sti-table-border-editor
            *ngIf="property.type === 'TableBorderEditor'"
            [property]="property"
          ></sti-table-border-editor>
          <boolean-with-arrow-editor
            *ngIf="property.type === 'BooleanWithArrowEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></boolean-with-arrow-editor>
          <sti-table-columns-editor
            *ngIf="property.type === 'TableColumnsEditor'"
            [property]="property"
            [style]="{ width: '100%' }"
          ></sti-table-columns-editor>
          <sti-exceed-margins-editor
            *ngIf="property.type === 'ExceedMarginsEditor'"
            [property]="property"
            [object]="object"
            [style]="{ width: '100%' }"
          ></sti-exceed-margins-editor>
          <sti-select-button-editor
            *ngIf="property.type === 'labelFormat' || property.type === 'currencyFormat'"
            [propertyType]="property.type"
            [property]="property.property"
            [object]="object"
            [style.height.px]="24"
            [style.display]="'flex'"
          >
          </sti-select-button-editor>
        </td>
      </tr>
    </table>
  </div>`, styles: [".table-property-header{width:100%;display:flex;margin-bottom:-3px}.table-property-header span{flex:1;display:flex;font-size:13px;justify-content:center;align-items:center;margin:0;font-weight:400;border-bottom:3px solid transparent}.table-property-header span:hover{background-color:var(--hover-color);color:#5579ae}.table-property-header .current{color:#767676;font-weight:600;border-color:var(--text-color);z-index:1}.table-property-header .other{color:var(--text-color)}.property-grid{position:relative}.property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}table{width:100%;font-size:13px;font-weight:600;-webkit-user-select:none}span{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:15px;-webkit-touch-callout:none;-webkit-user-select:none}.label{font-size:13px;font-weight:400;min-width:120px;color:var(--property-label-color);white-space:nowrap;-webkit-touch-callout:none;-webkit-user-select:none}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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