import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/sti-localization.service";
import * as i2 from "../../../services/model.service";
export class StiPropertyGridNavigationComponent {
    constructor(loc, model) {
        this.loc = loc;
        this.model = model;
    }
    selectMode(mode) {
        if (this.model.currentPropertyGridMode != mode) {
            this.model.currentPropertyGridMode = mode;
            if (mode == "Properties") {
                setTimeout(() => {
                    this.model.needToRefresh.next(true);
                });
            }
        }
    }
    ngOnInit() { }
}
StiPropertyGridNavigationComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPropertyGridNavigationComponent, deps: [{ token: i1.StiLocalizationService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiPropertyGridNavigationComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiPropertyGridNavigationComponent, selector: "property-grid-navigation", ngImport: i0, template: `<div class="navigation-container">
    <div
      class="button {{ model.currentPropertyGridMode == 'Properties' ? 'selected' : '' }}"
      (click)="selectMode('Properties')"
    >
      <img [src]="model.getImage('images.Other.Properties.png')" />
      <div class="label">
        <span>{{ "Properties" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
    <div class="button {{ model.currentPropertyGridMode == 'Tree' ? 'selected' : '' }}" (click)="selectMode('Tree')">
      <img [src]="model.getImage('images.Other.ReportTree.png')" />
      <div class="label">
        <span>{{ "Form Tree" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
  </div>`, isInline: true, styles: [".navigation-container{display:flex;height:34px;-webkit-user-select:none;align-items:center}.label{display:flex;flex-direction:column}.selected .current-indicator{height:3px;width:100%;background-color:#19478a}.button{font-family:Arial;font-size:12px;min-width:80px;height:26px;border-radius:3px;background-color:transparent;display:flex;align-items:center;margin-right:3px;padding-right:10px}.button:hover{background-color:#dadada;cursor:pointer}.selected{background-color:#e5e5e5}img{height:16px;width:16px;margin:0 6px}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPropertyGridNavigationComponent, decorators: [{
            type: Component,
            args: [{ selector: "property-grid-navigation", template: `<div class="navigation-container">
    <div
      class="button {{ model.currentPropertyGridMode == 'Properties' ? 'selected' : '' }}"
      (click)="selectMode('Properties')"
    >
      <img [src]="model.getImage('images.Other.Properties.png')" />
      <div class="label">
        <span>{{ "Properties" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
    <div class="button {{ model.currentPropertyGridMode == 'Tree' ? 'selected' : '' }}" (click)="selectMode('Tree')">
      <img [src]="model.getImage('images.Other.ReportTree.png')" />
      <div class="label">
        <span>{{ "Form Tree" }}</span>
        <div class="current-indicator"></div>
      </div>
    </div>
  </div>`, styles: [".navigation-container{display:flex;height:34px;-webkit-user-select:none;align-items:center}.label{display:flex;flex-direction:column}.selected .current-indicator{height:3px;width:100%;background-color:#19478a}.button{font-family:Arial;font-size:12px;min-width:80px;height:26px;border-radius:3px;background-color:transparent;display:flex;align-items:center;margin-right:3px;padding-right:10px}.button:hover{background-color:#dadada;cursor:pointer}.selected{background-color:#e5e5e5}img{height:16px;width:16px;margin:0 6px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiLocalizationService }, { type: i2.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXByb3BlcnR5LWdyaWQtbmF2aWdhdGlvbi5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvY29tcG9uZW50cy9wcm9wZXJ0aWVzLmNvbXBvbmVudC9zdGktcHJvcGVydHktZ3JpZC1uYXZpZ2F0aW9uL3N0aS1wcm9wZXJ0eS1ncmlkLW5hdmlnYXRpb24uY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQVUsTUFBTSxlQUFlLENBQUM7Ozs7QUFxRWxELE1BQU0sT0FBTyxrQ0FBa0M7SUFDN0MsWUFBbUIsR0FBMkIsRUFBUyxLQUFzQjtRQUExRCxRQUFHLEdBQUgsR0FBRyxDQUF3QjtRQUFTLFVBQUssR0FBTCxLQUFLLENBQWlCO0lBQUcsQ0FBQztJQUVqRixVQUFVLENBQUMsSUFBWTtRQUNyQixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsdUJBQXVCLElBQUksSUFBSSxFQUFFO1lBQzlDLElBQUksQ0FBQyxLQUFLLENBQUMsdUJBQXVCLEdBQUcsSUFBSSxDQUFDO1lBQzFDLElBQUksSUFBSSxJQUFJLFlBQVksRUFBRTtnQkFDeEIsVUFBVSxDQUFDLEdBQUcsRUFBRTtvQkFDZCxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7Z0JBQ3RDLENBQUMsQ0FBQyxDQUFDO2FBQ0o7U0FDRjtJQUNILENBQUM7SUFFRCxRQUFRLEtBQUksQ0FBQzs7K0hBZEYsa0NBQWtDO21IQUFsQyxrQ0FBa0MsZ0VBL0RuQzs7Ozs7Ozs7Ozs7Ozs7Ozs7O1NBa0JIOzJGQTZDSSxrQ0FBa0M7a0JBakU5QyxTQUFTOytCQUNFLDBCQUEwQixZQUMxQjs7Ozs7Ozs7Ozs7Ozs7Ozs7O1NBa0JIIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBPbkluaXQgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uL3NlcnZpY2VzL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlNb2RlbFNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vc2VydmljZXMvbW9kZWwuc2VydmljZVwiO1xyXG5cclxuQENvbXBvbmVudCh7XHJcbiAgc2VsZWN0b3I6IFwicHJvcGVydHktZ3JpZC1uYXZpZ2F0aW9uXCIsXHJcbiAgdGVtcGxhdGU6IGA8ZGl2IGNsYXNzPVwibmF2aWdhdGlvbi1jb250YWluZXJcIj5cclxuICAgIDxkaXZcclxuICAgICAgY2xhc3M9XCJidXR0b24ge3sgbW9kZWwuY3VycmVudFByb3BlcnR5R3JpZE1vZGUgPT0gJ1Byb3BlcnRpZXMnID8gJ3NlbGVjdGVkJyA6ICcnIH19XCJcclxuICAgICAgKGNsaWNrKT1cInNlbGVjdE1vZGUoJ1Byb3BlcnRpZXMnKVwiXHJcbiAgICA+XHJcbiAgICAgIDxpbWcgW3NyY109XCJtb2RlbC5nZXRJbWFnZSgnaW1hZ2VzLk90aGVyLlByb3BlcnRpZXMucG5nJylcIiAvPlxyXG4gICAgICA8ZGl2IGNsYXNzPVwibGFiZWxcIj5cclxuICAgICAgICA8c3Bhbj57eyBcIlByb3BlcnRpZXNcIiB9fTwvc3Bhbj5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwiY3VycmVudC1pbmRpY2F0b3JcIj48L2Rpdj5cclxuICAgICAgPC9kaXY+XHJcbiAgICA8L2Rpdj5cclxuICAgIDxkaXYgY2xhc3M9XCJidXR0b24ge3sgbW9kZWwuY3VycmVudFByb3BlcnR5R3JpZE1vZGUgPT0gJ1RyZWUnID8gJ3NlbGVjdGVkJyA6ICcnIH19XCIgKGNsaWNrKT1cInNlbGVjdE1vZGUoJ1RyZWUnKVwiPlxyXG4gICAgICA8aW1nIFtzcmNdPVwibW9kZWwuZ2V0SW1hZ2UoJ2ltYWdlcy5PdGhlci5SZXBvcnRUcmVlLnBuZycpXCIgLz5cclxuICAgICAgPGRpdiBjbGFzcz1cImxhYmVsXCI+XHJcbiAgICAgICAgPHNwYW4+e3sgXCJGb3JtIFRyZWVcIiB9fTwvc3Bhbj5cclxuICAgICAgICA8ZGl2IGNsYXNzPVwiY3VycmVudC1pbmRpY2F0b3JcIj48L2Rpdj5cclxuICAgICAgPC9kaXY+XHJcbiAgICA8L2Rpdj5cclxuICA8L2Rpdj5gLFxyXG4gIHN0eWxlczogW1xyXG4gICAgYFxyXG4gICAgICAubmF2aWdhdGlvbi1jb250YWluZXIge1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgaGVpZ2h0OiAzNHB4O1xyXG4gICAgICAgIC13ZWJraXQtdXNlci1zZWxlY3Q6IG5vbmU7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAubGFiZWwge1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcclxuICAgICAgfVxyXG4gICAgICAuc2VsZWN0ZWQgLmN1cnJlbnQtaW5kaWNhdG9yIHtcclxuICAgICAgICBoZWlnaHQ6IDNweDtcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiByZ2IoMjUsIDcxLCAxMzgpO1xyXG4gICAgICB9XHJcbiAgICAgIC5idXR0b24ge1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiBBcmlhbDtcclxuICAgICAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICAgICAgbWluLXdpZHRoOiA4MHB4O1xyXG4gICAgICAgIGhlaWdodDogMjZweDtcclxuICAgICAgICBib3JkZXItcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdHJhbnNwYXJlbnQ7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIG1hcmdpbi1yaWdodDogM3B4O1xyXG4gICAgICAgIHBhZGRpbmctcmlnaHQ6IDEwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmJ1dHRvbjpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiKDIxOCwgMjE4LCAyMTgpO1xyXG4gICAgICAgIGN1cnNvcjogcG9pbnRlcjtcclxuICAgICAgfVxyXG4gICAgICAuc2VsZWN0ZWQge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYigyMjksIDIyOSwgMjI5KTtcclxuICAgICAgfVxyXG4gICAgICBpbWcge1xyXG4gICAgICAgIGhlaWdodDogMTZweDtcclxuICAgICAgICB3aWR0aDogMTZweDtcclxuICAgICAgICBtYXJnaW46IDBweCA2cHg7XHJcbiAgICAgIH1cclxuICAgIGAsXHJcbiAgXSxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aVByb3BlcnR5R3JpZE5hdmlnYXRpb25Db21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBsb2M6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UsIHB1YmxpYyBtb2RlbDogU3RpTW9kZWxTZXJ2aWNlKSB7fVxyXG5cclxuICBzZWxlY3RNb2RlKG1vZGU6IHN0cmluZykge1xyXG4gICAgaWYgKHRoaXMubW9kZWwuY3VycmVudFByb3BlcnR5R3JpZE1vZGUgIT0gbW9kZSkge1xyXG4gICAgICB0aGlzLm1vZGVsLmN1cnJlbnRQcm9wZXJ0eUdyaWRNb2RlID0gbW9kZTtcclxuICAgICAgaWYgKG1vZGUgPT0gXCJQcm9wZXJ0aWVzXCIpIHtcclxuICAgICAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgICAgIHRoaXMubW9kZWwubmVlZFRvUmVmcmVzaC5uZXh0KHRydWUpO1xyXG4gICAgICAgIH0pO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBuZ09uSW5pdCgpIHt9XHJcbn1cclxuIl19