import { Component } from "@angular/core";
import { StiFormPageElement } from "../../../elements/StiFormPageElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-localization.service";
import * as i3 from "./sti-forms-tree-item.component";
export class StiFormsTreeComponent {
    constructor(model, loc) {
        this.model = model;
        this.loc = loc;
        this.value = "";
    }
    inputEvent(value) {
        this.value = value;
    }
    findElement() {
        let names = this.getAllNames();
        let resultNames = [];
        names.forEach((item) => {
            if (item.name.toLowerCase().indexOf(this.value.toLowerCase()) == 0) {
                resultNames.push(item);
            }
        });
        if (resultNames) {
            if (resultNames.findIndex((item) => item.name == this.lastFindedItem?.name) != -1) {
                let index = resultNames.findIndex((item) => item.name == this.lastFindedItem?.name);
                if (index + 1 < resultNames.length) {
                    this.selectItem(resultNames[index + 1]);
                    this.lastFindedItem = resultNames[index + 1];
                }
                else {
                    this.selectItem(resultNames[0]);
                    this.lastFindedItem = resultNames[0];
                }
            }
            else {
                this.selectItem(resultNames[0]);
                this.lastFindedItem = resultNames[0];
            }
        }
    }
    selectItem(item) {
        if (item.name == "Form") {
            this.model.selectedPage = null;
            this.model.selectedComponent = null;
        }
        else if (item.element instanceof StiFormPageElement) {
            this.model.selectedPage = item.element;
        }
        else {
            this.model.needToSelectedComponent.next(item.element);
        }
    }
    getAllNames() {
        let names = [];
        names.push({ name: "Form" });
        this.model.form?.pages?.forEach((page, index) => {
            names.push({ name: "Page" + (index == 0 ? "" : index + 1), element: page });
            page.allElements.forEach((elem) => {
                names.push({ name: elem.name, element: elem });
            });
        });
        return names;
    }
    ngOnInit() { }
}
StiFormsTreeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormsTreeComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiFormsTreeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFormsTreeComponent, selector: "forms-tree", ngImport: i0, template: `
    <div class="form-tree-container">
      <div class="search-container">
        <div class="search-component">
          <span class="input"
            ><input
              type="text"
              [placeholder]="loc.get2('Editor', 'Search')"
              [value]="value"
              (input)="inputEvent($event.target.value)"
              (keyup.enter)="findElement()"
            />
          </span>
          <div class="search-button" (click)="findElement()">
            <img [src]="model.getImage('images.Other.Search.png')" />
          </div>
        </div>
        <div
          class="show-components-button {{ model.showComponentsTab ? 'selected' : '' }}"
          (click)="model.showComponentsTab = !model.showComponentsTab"
        >
          <img [src]="model.getImage('images.Other.ComponentsTab.png')" />
        </div>
      </div>
      <div class="tree-items-container">
        <sti-forms-tree-item [item]="model?.form"></sti-forms-tree-item>
      </div>
    </div>
  `, isInline: true, styles: [".input{z-index:99999}input{height:22px;font-size:12px;width:100%;outline:none;border:0}.search-button{border-radius:3px;display:flex;align-items:center;justify-content:center;height:100%}.search-button:hover{cursor:pointer;background-color:var(--hover-color)}.disabled{pointer-events:none;opacity:.5}.selected{background-color:var(--hover-color)}.tree-items-container{position:relative;width:-moz-fit-content;width:fit-content}.container-label{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:4.5px;-webkit-touch-callout:none;-webkit-user-select:none}.search-component{border:1px solid var(--inputBorder-color);border-radius:3px;display:flex;width:100%;align-items:center;margin-left:5px;min-width:300px;position:relative}.search-component span{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:12px;padding-left:5px;font-weight:500;color:var(--text-color);flex:1}.search-container{display:flex;height:24px;width:100%;margin:5px 0}.form-tree-container{min-width:100%;display:flex;flex-direction:column}.show-components-button{height:100%;margin:0 5px;border-radius:3px}.show-components-button:hover{background-color:var(--hover-color);cursor:pointer}img{height:16px;width:16px;margin:0 4px}\n"], dependencies: [{ kind: "component", type: i3.StiFormsTreeItemComponent, selector: "sti-forms-tree-item", inputs: ["item", "index"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormsTreeComponent, decorators: [{
            type: Component,
            args: [{ selector: "forms-tree", template: `
    <div class="form-tree-container">
      <div class="search-container">
        <div class="search-component">
          <span class="input"
            ><input
              type="text"
              [placeholder]="loc.get2('Editor', 'Search')"
              [value]="value"
              (input)="inputEvent($event.target.value)"
              (keyup.enter)="findElement()"
            />
          </span>
          <div class="search-button" (click)="findElement()">
            <img [src]="model.getImage('images.Other.Search.png')" />
          </div>
        </div>
        <div
          class="show-components-button {{ model.showComponentsTab ? 'selected' : '' }}"
          (click)="model.showComponentsTab = !model.showComponentsTab"
        >
          <img [src]="model.getImage('images.Other.ComponentsTab.png')" />
        </div>
      </div>
      <div class="tree-items-container">
        <sti-forms-tree-item [item]="model?.form"></sti-forms-tree-item>
      </div>
    </div>
  `, styles: [".input{z-index:99999}input{height:22px;font-size:12px;width:100%;outline:none;border:0}.search-button{border-radius:3px;display:flex;align-items:center;justify-content:center;height:100%}.search-button:hover{cursor:pointer;background-color:var(--hover-color)}.disabled{pointer-events:none;opacity:.5}.selected{background-color:var(--hover-color)}.tree-items-container{position:relative;width:-moz-fit-content;width:fit-content}.container-label{color:#767676;font-size:13px;font-weight:700;margin-left:5px;margin-top:4.5px;-webkit-touch-callout:none;-webkit-user-select:none}.search-component{border:1px solid var(--inputBorder-color);border-radius:3px;display:flex;width:100%;align-items:center;margin-left:5px;min-width:300px;position:relative}.search-component span{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:12px;padding-left:5px;font-weight:500;color:var(--text-color);flex:1}.search-container{display:flex;height:24px;width:100%;margin:5px 0}.form-tree-container{min-width:100%;display:flex;flex-direction:column}.show-components-button{height:100%;margin:0 5px;border-radius:3px}.show-components-button:hover{background-color:var(--hover-color);cursor:pointer}img{height:16px;width:16px;margin:0 4px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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