import { Component, Input } from "@angular/core";
import { StiForm } from "../../../elements/StiForm";
import { StiFormPageElement } from "../../../elements/StiFormPageElement";
import { StiFormElement } from "../../../elements/base/StiFormElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-toolbox.service";
import * as i3 from "@angular/common";
export class StiFormsTreeItemComponent {
    constructor(model, toolboxService) {
        this.model = model;
        this.toolboxService = toolboxService;
        this.showInnerTree = false;
    }
    get innerItems() {
        return this.item?.pages ?? this.item?.elements;
    }
    get isFormElement() {
        return this.item instanceof StiForm;
    }
    get isPageElement() {
        return this.item instanceof StiFormPageElement;
    }
    get isLastIndex() {
        if (this.item instanceof StiFormElement) {
            let parentElement = this.model.getElementPage(this.item) ?? this.model.getElementPanel(this.item);
            return parentElement?.elements?.indexOf(this.item) == parentElement?.elements?.length - 1;
        }
        else {
            return true;
        }
    }
    showInnerComponents() {
        return this.item?.pages ? true : this.model.showComponentsTab;
    }
    selectItem() {
        if (this.item instanceof StiForm) {
            this.model.selectedPage = null;
            this.model.selectedComponent = null;
        }
        else if (this.item instanceof StiFormPageElement) {
            this.model.selectedPage = this.item;
        }
        else {
            this.model.needToSelectedComponent.next(this.item);
        }
        this.scrollToElement();
    }
    scrollToElement() {
        if (this.item instanceof StiForm) {
            return;
        }
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let page = this.item instanceof StiFormPageElement ? this.item : this.model.getElementPageForScroll(this.item);
        let pageElement = document.getElementById(page.guid);
        let pageElementRect = pageElement.getBoundingClientRect();
        let index = this.model.form.pages.indexOf(page);
        workspace.scrollTop = pageElementRect.height * index + (index != 0 ? 20 * this.model.zoom : 0);
    }
    isCurrentSelectedItem() {
        if (this.item instanceof StiFormPageElement) {
            return this.model.selectedPage == this.item;
        }
        else if (this.item instanceof StiForm) {
            return !this.model.selectedPage && !this.model.selectedComponent;
        }
        else {
            return this.model?.selectedComponent?.element == this.item;
        }
    }
    getItemLabel() {
        if (this.item && this.item instanceof StiForm) {
            return "Form";
        }
        else {
            return this.item instanceof StiFormPageElement ? `Page${this.index != 0 ? this.index + 1 : ""}` : this.item?.name;
        }
    }
    getIconSrc() {
        let path;
        if (this.item && this.item instanceof StiForm) {
            path = "images.Other.StiForm.png";
        }
        else if (this.item instanceof StiFormPageElement) {
            path = "images.Page.StiPage.png";
        }
        else {
            let toolboxElement = this.toolboxService?.elements?.find((elem) => elem.id == this.toolboxService?.getToolboxId(this.item?.type));
            path = toolboxElement?.image;
        }
        return this.model.getImage(path);
    }
    ngOnInit() {
        if (this.item instanceof StiForm) {
            this.showInnerTree = true;
        }
    }
}
StiFormsTreeItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormsTreeItemComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiToolboxService }], target: i0.ɵɵFactoryTarget.Component });
StiFormsTreeItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFormsTreeItemComponent, selector: "sti-forms-tree-item", inputs: { item: "item", index: "index" }, ngImport: i0, template: `<div class="item-container" [style.left.px]="isFormElement ? 5 : !isPageElement && innerItems ? 21 : 15">
    <div class="tree-item">
      <div class="tree-lines" [style.width.px]="innerItems ? 15 : 23">
        <div
          class="inner-elements-button"
          *ngIf="innerItems && showInnerComponents()"
          (click)="this.showInnerTree = !this.showInnerTree"
        >
          <img
            [src]="
              showInnerTree
                ? model.getImage('images.Other.IconCloseItem.png')
                : model.getImage('images.Other.IconOpenItem.png')
            "
          />
        </div>
        <div class="vertical-line" [style.height.px]="isLastIndex ? 11 : 23" *ngIf="!innerItems"></div>
        <div class="horizontal-line" *ngIf="!innerItems"></div>
      </div>
      <div class="item-content {{ isCurrentSelectedItem() ? 'current' : '' }}" (click)="selectItem()">
        <div class="item-icon"><img [src]="getIconSrc()" /></div>
        <div class="item-label">{{ getItemLabel() }}</div>
      </div>
    </div>
    <div class="inner-items" *ngIf="innerItems && showInnerTree && showInnerComponents()">
      <sti-forms-tree-item
        *ngFor="let innerItem of innerItems; let i = index"
        [item]="innerItem"
        [index]="i"
      ></sti-forms-tree-item>
    </div>
  </div>`, isInline: true, styles: [".item-icon{height:17px}.item-content{border-radius:3px;display:flex;align-items:center;height:23px;padding:3px}.current{background-color:#d3d3d3}.horizontal-line{position:absolute;height:1px;width:11px;left:11px;top:11px;background-color:#d3d3d3}.vertical-line{position:absolute;height:11px;width:1px;left:11px;top:0;background-color:#d3d3d3}.tree-lines{height:100%;position:relative;width:23px;display:flex;align-items:center}.item-label{margin-left:3px}.item-container{position:relative;top:0;font-size:11px;color:#444;font-family:Arial;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;display:flex;flex-direction:column}.tree-item{display:flex;align-items:center;height:23px}img{height:16px;width:16px}.inner-elements-button{display:flex;justify-content:flex-end}.inner-elements-button img{height:12px;width:12px;margin-top:1px;margin-right:3px}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: StiFormsTreeItemComponent, selector: "sti-forms-tree-item", inputs: ["item", "index"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormsTreeItemComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-forms-tree-item", template: `<div class="item-container" [style.left.px]="isFormElement ? 5 : !isPageElement && innerItems ? 21 : 15">
    <div class="tree-item">
      <div class="tree-lines" [style.width.px]="innerItems ? 15 : 23">
        <div
          class="inner-elements-button"
          *ngIf="innerItems && showInnerComponents()"
          (click)="this.showInnerTree = !this.showInnerTree"
        >
          <img
            [src]="
              showInnerTree
                ? model.getImage('images.Other.IconCloseItem.png')
                : model.getImage('images.Other.IconOpenItem.png')
            "
          />
        </div>
        <div class="vertical-line" [style.height.px]="isLastIndex ? 11 : 23" *ngIf="!innerItems"></div>
        <div class="horizontal-line" *ngIf="!innerItems"></div>
      </div>
      <div class="item-content {{ isCurrentSelectedItem() ? 'current' : '' }}" (click)="selectItem()">
        <div class="item-icon"><img [src]="getIconSrc()" /></div>
        <div class="item-label">{{ getItemLabel() }}</div>
      </div>
    </div>
    <div class="inner-items" *ngIf="innerItems && showInnerTree && showInnerComponents()">
      <sti-forms-tree-item
        *ngFor="let innerItem of innerItems; let i = index"
        [item]="innerItem"
        [index]="i"
      ></sti-forms-tree-item>
    </div>
  </div>`, styles: [".item-icon{height:17px}.item-content{border-radius:3px;display:flex;align-items:center;height:23px;padding:3px}.current{background-color:#d3d3d3}.horizontal-line{position:absolute;height:1px;width:11px;left:11px;top:11px;background-color:#d3d3d3}.vertical-line{position:absolute;height:11px;width:1px;left:11px;top:0;background-color:#d3d3d3}.tree-lines{height:100%;position:relative;width:23px;display:flex;align-items:center}.item-label{margin-left:3px}.item-container{position:relative;top:0;font-size:11px;color:#444;font-family:Arial;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;display:flex;flex-direction:column}.tree-item{display:flex;align-items:center;height:23px}img{height:16px;width:16px}.inner-elements-button{display:flex;justify-content:flex-end}.inner-elements-button img{height:12px;width:12px;margin-top:1px;margin-right:3px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiToolboxService }]; }, propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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