import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/mouse.service";
import * as i3 from "../../services/sti-helper.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-property-grid-navigation/sti-property-grid-navigation.component";
import * as i7 from "./sti-forms-tree/sti-forms-tree.component";
import * as i8 from "./sti-property-grid/sti-property-grid.component";
export class PropertiesComponent {
    constructor(model, mouseService, helper, loc) {
        this.model = model;
        this.mouseService = mouseService;
        this.helper = helper;
        this.loc = loc;
        this.isDrag = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.drag(event);
        });
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endDrag(event);
        });
    }
    onMouseDown(event) {
        event.preventDefault();
        this.startWidth = this.model.propertyGridWidth;
        this.startX = event.clientX;
        this.isDrag = true;
    }
    drag(event) {
        if (this.isDrag) {
            let delta = event.clientX - this.startX;
            if (this.startWidth - delta >= 500) {
                this.model.propertyGridWidth = 500;
            }
            else if (this.startWidth - delta <= 220) {
                this.model.propertyGridWidth = 220;
            }
            else {
                this.model.propertyGridWidth = this.startWidth - delta;
            }
        }
    }
    endDrag(event) {
        this.isDrag = false;
    }
}
PropertiesComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PropertiesComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiHelperService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
PropertiesComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: PropertiesComponent, selector: "app-properties", ngImport: i0, template: `
    <div class="property-grid-resizer" (mousedown)="onMouseDown($event)"></div>
    <div class="property-grid-container">
      <div class="property-grid-components">
        <forms-tree *ngIf="model.currentPropertyGridMode == 'Tree'"></forms-tree>
        <property-grid *ngIf="model.currentPropertyGridMode == 'Properties'"></property-grid>
      </div>
      <div class="property-grid-navigation">
        <property-grid-navigation></property-grid-navigation>
      </div>
    </div>
  `, isInline: true, styles: [".property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}.property-grid-container{display:flex;flex-direction:column;width:100%}.property-grid-components{flex:1;overflow-y:scroll;scroll-behavior:smooth}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}\n"], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiPropertyGridNavigationComponent, selector: "property-grid-navigation" }, { kind: "component", type: i7.StiFormsTreeComponent, selector: "forms-tree" }, { kind: "component", type: i8.StiPropertyGridComponent, selector: "property-grid" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PropertiesComponent, decorators: [{
            type: Component,
            args: [{ selector: "app-properties", template: `
    <div class="property-grid-resizer" (mousedown)="onMouseDown($event)"></div>
    <div class="property-grid-container">
      <div class="property-grid-components">
        <forms-tree *ngIf="model.currentPropertyGridMode == 'Tree'"></forms-tree>
        <property-grid *ngIf="model.currentPropertyGridMode == 'Properties'"></property-grid>
      </div>
      <div class="property-grid-navigation">
        <property-grid-navigation></property-grid-navigation>
      </div>
    </div>
  `, styles: [".property-grid-resizer{height:100%;min-width:8px}.property-grid-resizer:hover{cursor:ew-resize}.property-grid-container{display:flex;flex-direction:column;width:100%}.property-grid-components{flex:1;overflow-y:scroll;scroll-behavior:smooth}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiHelperService }, { type: i4.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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