import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiLabelAlignment } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiTextBoxCreator extends StiElementCreator {
    static createPropertyEditors(properties, element) {
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "value",
            label: StiLocalizationService.get("Dashboard", "InitialValue"),
        });
        properties.push({ type: "horizontalAlignment", property: "contentAlignment", label: "" });
        properties.push({
            type: "FontEditor",
            property: "font",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "textColor",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({
            type: "color",
            property: "backgroundColor",
            label: StiLocalizationService.get("PropertyMain", "BackColor"),
        });
        properties.push({
            type: "color",
            property: "borderColor",
            label: StiLocalizationService.get("PropertyMain", "BorderColor"),
        });
        properties.push({
            type: "enum",
            property: "borderWeight",
            label: StiLocalizationService.get("PropertyMain", "BorderWidth"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "nameEditor",
            property: "name",
            label: StiLocalizationService.get("PropertyMain", "Name"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "componentHeight",
            property: "height",
            label: StiLocalizationService.get("PropertyMain", "Height"),
        });
        properties.push({
            type: "PaddingEditor",
            property: "padding",
            label: StiLocalizationService.get("PropertyMain", "Padding"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "tooltip",
            label: StiLocalizationService.get("PropertyMain", "ToolTip"),
        });
        properties.push({
            type: "checkbox",
            property: "readOnly",
            checkbox: StiLocalizationService.get("PropertyMain", "ReadOnly"),
        });
        properties.push({
            type: "checkbox",
            property: "required",
            checkbox: StiLocalizationService.get("PropertyMain", "Required"),
        });
        properties.push({
            type: "checkbox",
            property: "isPassword",
            checkbox: StiLocalizationService.get("Password", "StiSavePasswordForm"),
        });
        properties.push({
            type: "checkbox",
            property: "useRange",
            checkbox: StiLocalizationService.get("Chart", "Range"),
        });
        if (element.useRange) {
            properties.push({
                type: "Number",
                property: "maximum",
                label: StiLocalizationService.get("PropertyMain", "Maximum"),
            });
        }
        properties.push({
            type: "checkbox",
            property: "isMultiline",
            checkbox: StiLocalizationService.get("PropertyMain", "Multiline"),
        });
        if (element.isMultiline) {
            properties.push({
                type: "Number",
                property: "linesCount",
                label: StiLocalizationService.get("Shapes", "Lines"),
            });
        }
        properties.push({
            type: "checkbox",
            property: "visible",
            checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "label.value",
            label: StiLocalizationService.get("PropertyMain", "Label"),
        });
        properties.push({ type: "labelAlignment", property: "label.alignment", label: "" });
        if (element.label.alignment != StiLabelAlignment.Top) {
            properties.push({
                type: "Number",
                property: "label.width",
                label: StiLocalizationService.get("PropertyMain", "Width"),
            });
        }
        properties.push({
            type: "FontEditor",
            property: "label",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "label.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "description.value",
            label: StiLocalizationService.get("PropertyMain", "Description"),
        });
        properties.push({
            type: "FontEditor",
            property: "description",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "description.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,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