import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiLabelAlignment } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiTableCreator extends StiElementCreator {
    static createPropertyEditors(properties, element, model) {
        properties.push({ type: "divider" });
        properties.push({ type: "tableNavigations" });
        properties.push({ type: "divider" });
        if (element.showHeaderEditor) {
            model?.currentTablePropertyHeader.next("Main");
            properties.push({
                type: "TextEditor",
                property: "tableHeaderText",
                label: StiLocalizationService.get("PropertyMain", "Header"),
            });
            properties.push({
                type: "horizontalAlignment",
                property: "tableHeaderAlignment",
                label: "",
            });
            properties.push({
                type: "checkbox",
                property: "useWordWrap",
                checkbox: StiLocalizationService.get("PropertyEnum", "StiTextSizeModeWordWrap"),
            });
            properties.push({
                type: "color",
                property: "tableHeaderBackgroundColor",
                label: StiLocalizationService.get("PropertyMain", "BackColor"),
            });
            properties.push({
                type: "color",
                property: "tableHeaderColor",
                label: StiLocalizationService.get("PropertyMain", "ForeColor"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "FontEditor",
                property: "font",
                label: StiLocalizationService.get("PropertyMain", "Font"),
            });
            properties.push({
                type: "color",
                property: "backgroundColor",
                label: StiLocalizationService.get("PropertyMain", "BackColor"),
            });
            properties.push({ type: "BooleanWithArrowEditor", property: "showBorderEditor", label: "" });
            properties.push({ type: "BooleanWithArrowEditor", property: "showGridLinesEditor", label: "" });
            properties.push({ type: "divider" });
            properties.push({
                type: "nameEditor",
                property: "name",
                label: StiLocalizationService.get("PropertyMain", "Name"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "componentHeight",
                property: "height",
                label: StiLocalizationService.get("PropertyMain", "Height"),
            });
            properties.push({
                type: "PaddingEditor",
                property: "padding",
                label: StiLocalizationService.get("PropertyMain", "Padding"),
            });
            properties.push({
                type: "checkbox",
                property: "readOnly",
                checkbox: StiLocalizationService.get("PropertyMain", "ReadOnly"),
            });
            /* if (!element.readOnly) {
              properties.push({
                type: "checkbox",
                property: "dynamicRows",
                checkbox: StiLocalizationService.get("PropertyMain", "DynamicRows"),
              });
            } */
            properties.push({
                type: "checkbox",
                property: "visible",
                checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "TextEditor",
                property: "label.value",
                label: StiLocalizationService.get("PropertyMain", "Label"),
            });
            properties.push({ type: "labelAlignment", property: "label.alignment", label: "" });
            if (element.label.alignment != StiLabelAlignment.Top) {
                properties.push({
                    type: "Number",
                    property: "label.width",
                    label: StiLocalizationService.get("PropertyMain", "Width"),
                });
            }
            properties.push({
                type: "FontEditor",
                property: "label",
                label: StiLocalizationService.get("PropertyMain", "Font"),
            });
            properties.push({
                type: "color",
                property: "label.color",
                label: StiLocalizationService.get("PropertyMain", "ForeColor"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "TextEditor",
                property: "description.value",
                label: StiLocalizationService.get("PropertyMain", "Description"),
            });
            properties.push({
                type: "FontEditor",
                property: "description",
                label: StiLocalizationService.get("PropertyMain", "Font"),
            });
            properties.push({
                type: "color",
                property: "description.color",
                label: StiLocalizationService.get("PropertyMain", "ForeColor"),
            });
        }
        else if (element.showColumnsEditor) {
            model?.currentTablePropertyHeader.next("Columns");
            properties.push({ type: "BooleanWithArrowEditor", property: "showColumnsBorderEditor", label: "" });
            properties.push({ type: "divider" });
            properties.push({ type: "TableColumnsEditor", property: "columns", label: "" });
        }
        else if (element.showRowsEditor) {
            model?.currentTablePropertyHeader.next("Rows");
            properties.push({
                type: "checkbox",
                property: "showRowLabels",
                checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "MultilineEditor",
                property: "rowLabels",
                label: StiLocalizationService.get("PropertyMain", "Labels"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "horizontalAlignment",
                property: "rowLabelsHorizontalAlignment",
                label: StiLocalizationService.get("PropertyMain", "Alignment"),
            });
            properties.push({
                type: "checkbox",
                property: "alternateRowColors",
                checkbox: StiLocalizationService.get("PropertyMain", "AlternateRowColors"),
            });
            if (!element.alternateRowColors) {
                properties.push({
                    type: "color",
                    property: "rowHeadersBackground",
                    label: StiLocalizationService.get("PropertyMain", "BackColor"),
                });
                properties.push({
                    type: "color",
                    property: "rowHeadersColor",
                    label: StiLocalizationService.get("PropertyMain", "ForeColor"),
                });
            }
            else {
                properties.push({
                    type: "color",
                    property: "evenRowsStyle",
                    label: StiLocalizationService.get("PropertyMain", "EvenRowsStyle"),
                });
                properties.push({ type: "color", property: "evenRowsTextColor", label: "" });
                properties.push({
                    type: "color",
                    property: "oddRowsStyle",
                    label: StiLocalizationService.get("PropertyMain", "OddRowsStyle"),
                });
                properties.push({ type: "color", property: "oddRowsTextColor", label: "" });
            }
            properties.push({ type: "BooleanWithArrowEditor", property: "showRowsBorderEditor", label: "" });
        }
        else if (element.showTotalsEditor) {
            model?.currentTablePropertyHeader.next("Totals");
            properties.push({
                type: "checkbox",
                property: "useTotals",
                checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
            });
            properties.push({ type: "divider" });
            properties.push({
                type: "TextEditor",
                property: "totalsRowHeader",
                label: StiLocalizationService.get("PropertyMain", "Header"),
            });
            properties.push({ type: "horizontalAlignment", property: "totalsRowHeaderHorizontalAlignment", label: "" });
            properties.push({ type: "verticalAlignment", property: "totalsRowHeaderVerticalAlignment", label: "" });
            properties.push({ type: "color", property: "totalsRowHeaderColor", label: "" });
            properties.push({ type: "divider" });
            properties.push({ type: "TableColumnsEditor", property: "totalsFields", label: "" });
        }
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,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