import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiLabelAlignment } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiSingleSelectionCreator extends StiElementCreator {
    static createPropertyEditors(properties, element) {
        properties.push({ type: "divider" });
        properties.push({
            type: "MultilineEditor",
            property: "options",
            label: StiLocalizationService.get("PropertyMain", "Options"),
        });
        properties.push({
            type: "FontEditor",
            property: "font",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "backgroundColor",
            label: StiLocalizationService.get("PropertyMain", "BackColor"),
        });
        properties.push({
            type: "color",
            property: "textColor",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({
            type: "color",
            property: "checkColor",
            label: StiLocalizationService.get("PropertyMain", "CheckColor"),
        });
        properties.push({
            type: "color",
            property: "borderColor",
            label: StiLocalizationService.get("PropertyMain", "BorderColor"),
        });
        properties.push({
            type: "Number",
            property: "columns",
            label: StiLocalizationService.get("PropertyMain", "Columns"),
        });
        properties.push({
            type: "checkbox",
            property: "useCustomOption",
            checkbox: StiLocalizationService.get("FormDictionaryDesigner", "CsvSeparatorOther"),
        });
        if (element.useCustomOption) {
            properties.push({
                type: "TextEditor",
                property: "customOptionText",
                label: StiLocalizationService.get("Components", "StiText"),
            });
            properties.push({
                type: "TextEditor",
                property: "prefix",
                label: StiLocalizationService.get("PropertyMain", "Prefix"),
            });
            properties.push({
                type: "TextEditor",
                property: "suffix",
                label: StiLocalizationService.get("PropertyMain", "Suffix"),
            });
        }
        properties.push({ type: "divider" });
        properties.push({
            type: "nameEditor",
            property: "name",
            label: StiLocalizationService.get("PropertyMain", "Name"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "componentHeight",
            property: "height",
            label: StiLocalizationService.get("PropertyMain", "Height"),
        });
        properties.push({
            type: "PaddingEditor",
            property: "padding",
            label: StiLocalizationService.get("PropertyMain", "Padding"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "tooltip",
            label: StiLocalizationService.get("PropertyMain", "ToolTip"),
        });
        properties.push({
            type: "checkbox",
            property: "required",
            checkbox: StiLocalizationService.get("PropertyMain", "Required"),
        });
        properties.push({
            type: "checkbox",
            property: "readOnly",
            checkbox: StiLocalizationService.get("PropertyMain", "ReadOnly"),
        });
        properties.push({
            type: "checkbox",
            property: "visible",
            checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "label.value",
            label: StiLocalizationService.get("PropertyMain", "Label"),
        });
        properties.push({ type: "labelAlignment", property: "label.alignment", label: "" });
        if (element.label.alignment != StiLabelAlignment.Top) {
            properties.push({
                type: "Number",
                property: "label.width",
                label: StiLocalizationService.get("PropertyMain", "Width"),
            });
        }
        properties.push({
            type: "FontEditor",
            property: "label",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "label.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "description.value",
            label: StiLocalizationService.get("PropertyMain", "Description"),
        });
        properties.push({
            type: "FontEditor",
            property: "description",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "description.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpU2luZ2xlU2VsZWN0aW9uQ3JlYXRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3Byb3BlcnRpZXMuY29tcG9uZW50L2NyZWF0b3JzL1N0aVNpbmdsZVNlbGVjdGlvbkNyZWF0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sNENBQTRDLENBQUM7QUFDcEYsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFDMUQsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0scUJBQXFCLENBQUM7QUFFeEQsTUFBTSxDQUFDLE9BQU8sT0FBTyx5QkFBMEIsU0FBUSxpQkFBaUI7SUFDdEUsTUFBTSxDQUFDLHFCQUFxQixDQUFDLFVBQWlCLEVBQUUsT0FBTztRQUNyRCxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDckMsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxpQkFBaUI7WUFDdkIsUUFBUSxFQUFFLFNBQVM7WUFDbkIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsU0FBUyxDQUFDO1NBQzdELENBQUMsQ0FBQztRQUNILFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsWUFBWTtZQUNsQixRQUFRLEVBQUUsTUFBTTtZQUNoQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUM7U0FDMUQsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxPQUFPO1lBQ2IsUUFBUSxFQUFFLGlCQUFpQjtZQUMzQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxXQUFXLENBQUM7U0FDL0QsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxPQUFPO1lBQ2IsUUFBUSxFQUFFLFdBQVc7WUFDckIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsV0FBVyxDQUFDO1NBQy9ELENBQUMsQ0FBQztRQUNILFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsT0FBTztZQUNiLFFBQVEsRUFBRSxZQUFZO1lBQ3RCLEtBQUssRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLFlBQVksQ0FBQztTQUNoRSxDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsSUFBSSxDQUFDO1lBQ2QsSUFBSSxFQUFFLE9BQU87WUFDYixRQUFRLEVBQUUsYUFBYTtZQUN2QixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxhQUFhLENBQUM7U0FDakUsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxRQUFRO1lBQ2QsUUFBUSxFQUFFLFNBQVM7WUFDbkIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsU0FBUyxDQUFDO1NBQzdELENBQUMsQ0FBQztRQUNILFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsVUFBVTtZQUNoQixRQUFRLEVBQUUsaUJBQWlCO1lBQzNCLFFBQVEsRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsd0JBQXdCLEVBQUUsbUJBQW1CLENBQUM7U0FDcEYsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxPQUFPLENBQUMsZUFBZSxFQUFFO1lBQzNCLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ2QsSUFBSSxFQUFFLFlBQVk7Z0JBQ2xCLFFBQVEsRUFBRSxrQkFBa0I7Z0JBQzVCLEtBQUssRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsWUFBWSxFQUFFLFNBQVMsQ0FBQzthQUMzRCxDQUFDLENBQUM7WUFDSCxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNkLElBQUksRUFBRSxZQUFZO2dCQUNsQixRQUFRLEVBQUUsUUFBUTtnQkFDbEIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsUUFBUSxDQUFDO2FBQzVELENBQUMsQ0FBQztZQUNILFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ2QsSUFBSSxFQUFFLFlBQVk7Z0JBQ2xCLFFBQVEsRUFBRSxRQUFRO2dCQUNsQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxRQUFRLENBQUM7YUFDNUQsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDckMsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxZQUFZO1lBQ2xCLFFBQVEsRUFBRSxNQUFNO1lBQ2hCLEtBQUssRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQztTQUMxRCxDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDckMsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxpQkFBaUI7WUFDdkIsUUFBUSxFQUFFLFFBQVE7WUFDbEIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsUUFBUSxDQUFDO1NBQzVELENBQUMsQ0FBQztRQUNILFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsZUFBZTtZQUNyQixRQUFRLEVBQUUsU0FBUztZQUNuQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxTQUFTLENBQUM7U0FDN0QsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBQ3JDLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsWUFBWTtZQUNsQixRQUFRLEVBQUUsU0FBUztZQUNuQixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxTQUFTLENBQUM7U0FDN0QsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxVQUFVO1lBQ2hCLFFBQVEsRUFBRSxVQUFVO1lBQ3BCLFFBQVEsRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLFVBQVUsQ0FBQztTQUNqRSxDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsSUFBSSxDQUFDO1lBQ2QsSUFBSSxFQUFFLFVBQVU7WUFDaEIsUUFBUSxFQUFFLFVBQVU7WUFDcEIsUUFBUSxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsVUFBVSxDQUFDO1NBQ2pFLENBQUMsQ0FBQztRQUNILFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsVUFBVTtZQUNoQixRQUFRLEVBQUUsU0FBUztZQUNuQixRQUFRLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxTQUFTLENBQUM7U0FDaEUsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBQ3JDLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsWUFBWTtZQUNsQixRQUFRLEVBQUUsYUFBYTtZQUN2QixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxPQUFPLENBQUM7U0FDM0QsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxnQkFBZ0IsRUFBRSxRQUFRLEVBQUUsaUJBQWlCLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDcEYsSUFBSSxPQUFPLENBQUMsS0FBSyxDQUFDLFNBQVMsSUFBSSxpQkFBaUIsQ0FBQyxHQUFHLEVBQUU7WUFDcEQsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxRQUFRLEVBQUUsYUFBYTtnQkFDdkIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsT0FBTyxDQUFDO2FBQzNELENBQUMsQ0FBQztTQUNKO1FBQ0QsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNkLElBQUksRUFBRSxZQUFZO1lBQ2xCLFFBQVEsRUFBRSxPQUFPO1lBQ2pCLEtBQUssRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLE1BQU0sQ0FBQztTQUMxRCxDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsSUFBSSxDQUFDO1lBQ2QsSUFBSSxFQUFFLE9BQU87WUFDYixRQUFRLEVBQUUsYUFBYTtZQUN2QixLQUFLLEVBQUUsc0JBQXNCLENBQUMsR0FBRyxDQUFDLGNBQWMsRUFBRSxXQUFXLENBQUM7U0FDL0QsQ0FBQyxDQUFDO1FBQ0gsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBQ3JDLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsWUFBWTtZQUNsQixRQUFRLEVBQUUsbUJBQW1CO1lBQzdCLEtBQUssRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLGFBQWEsQ0FBQztTQUNqRSxDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsSUFBSSxDQUFDO1lBQ2QsSUFBSSxFQUFFLFlBQVk7WUFDbEIsUUFBUSxFQUFFLGFBQWE7WUFDdkIsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDO1NBQzFELENBQUMsQ0FBQztRQUNILFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDZCxJQUFJLEVBQUUsT0FBTztZQUNiLFFBQVEsRUFBRSxtQkFBbUI7WUFDN0IsS0FBSyxFQUFFLHNCQUFzQixDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsV0FBVyxDQUFDO1NBQy9ELENBQUMsQ0FBQztRQUNILE9BQU8sVUFBVSxDQUFDO0lBQ3BCLENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0aUxvY2FsaXphdGlvblNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vc2VydmljZXMvc3RpLWxvY2FsaXphdGlvbi5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUxhYmVsQWxpZ25tZW50IH0gZnJvbSBcIi4uLy4uLy4uL3N5c3RlbS9lbnVtc1wiO1xyXG5pbXBvcnQgeyBTdGlFbGVtZW50Q3JlYXRvciB9IGZyb20gXCIuL1N0aUVsZW1lbnRDcmVhdG9yXCI7XHJcblxyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBTdGlTaW5nbGVTZWxlY3Rpb25DcmVhdG9yIGV4dGVuZHMgU3RpRWxlbWVudENyZWF0b3Ige1xyXG4gIHN0YXRpYyBjcmVhdGVQcm9wZXJ0eUVkaXRvcnMocHJvcGVydGllczogYW55W10sIGVsZW1lbnQpIHtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7IHR5cGU6IFwiZGl2aWRlclwiIH0pO1xyXG4gICAgcHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgdHlwZTogXCJNdWx0aWxpbmVFZGl0b3JcIixcclxuICAgICAgcHJvcGVydHk6IFwib3B0aW9uc1wiLFxyXG4gICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJPcHRpb25zXCIpLFxyXG4gICAgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcIkZvbnRFZGl0b3JcIixcclxuICAgICAgcHJvcGVydHk6IFwiZm9udFwiLFxyXG4gICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJGb250XCIpLFxyXG4gICAgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcImNvbG9yXCIsXHJcbiAgICAgIHByb3BlcnR5OiBcImJhY2tncm91bmRDb2xvclwiLFxyXG4gICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJCYWNrQ29sb3JcIiksXHJcbiAgICB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiY29sb3JcIixcclxuICAgICAgcHJvcGVydHk6IFwidGV4dENvbG9yXCIsXHJcbiAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIkZvcmVDb2xvclwiKSxcclxuICAgIH0pO1xyXG4gICAgcHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgdHlwZTogXCJjb2xvclwiLFxyXG4gICAgICBwcm9wZXJ0eTogXCJjaGVja0NvbG9yXCIsXHJcbiAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIkNoZWNrQ29sb3JcIiksXHJcbiAgICB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiY29sb3JcIixcclxuICAgICAgcHJvcGVydHk6IFwiYm9yZGVyQ29sb3JcIixcclxuICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiQm9yZGVyQ29sb3JcIiksXHJcbiAgICB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiTnVtYmVyXCIsXHJcbiAgICAgIHByb3BlcnR5OiBcImNvbHVtbnNcIixcclxuICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiQ29sdW1uc1wiKSxcclxuICAgIH0pO1xyXG4gICAgcHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgdHlwZTogXCJjaGVja2JveFwiLFxyXG4gICAgICBwcm9wZXJ0eTogXCJ1c2VDdXN0b21PcHRpb25cIixcclxuICAgICAgY2hlY2tib3g6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiRm9ybURpY3Rpb25hcnlEZXNpZ25lclwiLCBcIkNzdlNlcGFyYXRvck90aGVyXCIpLFxyXG4gICAgfSk7XHJcbiAgICBpZiAoZWxlbWVudC51c2VDdXN0b21PcHRpb24pIHtcclxuICAgICAgcHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcIlRleHRFZGl0b3JcIixcclxuICAgICAgICBwcm9wZXJ0eTogXCJjdXN0b21PcHRpb25UZXh0XCIsXHJcbiAgICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiQ29tcG9uZW50c1wiLCBcIlN0aVRleHRcIiksXHJcbiAgICAgIH0pO1xyXG4gICAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgIHR5cGU6IFwiVGV4dEVkaXRvclwiLFxyXG4gICAgICAgIHByb3BlcnR5OiBcInByZWZpeFwiLFxyXG4gICAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIlByZWZpeFwiKSxcclxuICAgICAgfSk7XHJcbiAgICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgdHlwZTogXCJUZXh0RWRpdG9yXCIsXHJcbiAgICAgICAgcHJvcGVydHk6IFwic3VmZml4XCIsXHJcbiAgICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiU3VmZml4XCIpLFxyXG4gICAgICB9KTtcclxuICAgIH1cclxuICAgIHByb3BlcnRpZXMucHVzaCh7IHR5cGU6IFwiZGl2aWRlclwiIH0pO1xyXG4gICAgcHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgdHlwZTogXCJuYW1lRWRpdG9yXCIsXHJcbiAgICAgIHByb3BlcnR5OiBcIm5hbWVcIixcclxuICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiTmFtZVwiKSxcclxuICAgIH0pO1xyXG4gICAgcHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJkaXZpZGVyXCIgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcImNvbXBvbmVudEhlaWdodFwiLFxyXG4gICAgICBwcm9wZXJ0eTogXCJoZWlnaHRcIixcclxuICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiSGVpZ2h0XCIpLFxyXG4gICAgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcIlBhZGRpbmdFZGl0b3JcIixcclxuICAgICAgcHJvcGVydHk6IFwicGFkZGluZ1wiLFxyXG4gICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJQYWRkaW5nXCIpLFxyXG4gICAgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goeyB0eXBlOiBcImRpdmlkZXJcIiB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiVGV4dEVkaXRvclwiLFxyXG4gICAgICBwcm9wZXJ0eTogXCJ0b29sdGlwXCIsXHJcbiAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIlRvb2xUaXBcIiksXHJcbiAgICB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiY2hlY2tib3hcIixcclxuICAgICAgcHJvcGVydHk6IFwicmVxdWlyZWRcIixcclxuICAgICAgY2hlY2tib3g6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiUmVxdWlyZWRcIiksXHJcbiAgICB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiY2hlY2tib3hcIixcclxuICAgICAgcHJvcGVydHk6IFwicmVhZE9ubHlcIixcclxuICAgICAgY2hlY2tib3g6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiUmVhZE9ubHlcIiksXHJcbiAgICB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiY2hlY2tib3hcIixcclxuICAgICAgcHJvcGVydHk6IFwidmlzaWJsZVwiLFxyXG4gICAgICBjaGVja2JveDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJWaXNpYmxlXCIpLFxyXG4gICAgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goeyB0eXBlOiBcImRpdmlkZXJcIiB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiVGV4dEVkaXRvclwiLFxyXG4gICAgICBwcm9wZXJ0eTogXCJsYWJlbC52YWx1ZVwiLFxyXG4gICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJMYWJlbFwiKSxcclxuICAgIH0pO1xyXG4gICAgcHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJsYWJlbEFsaWdubWVudFwiLCBwcm9wZXJ0eTogXCJsYWJlbC5hbGlnbm1lbnRcIiwgbGFiZWw6IFwiXCIgfSk7XHJcbiAgICBpZiAoZWxlbWVudC5sYWJlbC5hbGlnbm1lbnQgIT0gU3RpTGFiZWxBbGlnbm1lbnQuVG9wKSB7XHJcbiAgICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgdHlwZTogXCJOdW1iZXJcIixcclxuICAgICAgICBwcm9wZXJ0eTogXCJsYWJlbC53aWR0aFwiLFxyXG4gICAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIldpZHRoXCIpLFxyXG4gICAgICB9KTtcclxuICAgIH1cclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiRm9udEVkaXRvclwiLFxyXG4gICAgICBwcm9wZXJ0eTogXCJsYWJlbFwiLFxyXG4gICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJGb250XCIpLFxyXG4gICAgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcImNvbG9yXCIsXHJcbiAgICAgIHByb3BlcnR5OiBcImxhYmVsLmNvbG9yXCIsXHJcbiAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIkZvcmVDb2xvclwiKSxcclxuICAgIH0pO1xyXG4gICAgcHJvcGVydGllcy5wdXNoKHsgdHlwZTogXCJkaXZpZGVyXCIgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcIlRleHRFZGl0b3JcIixcclxuICAgICAgcHJvcGVydHk6IFwiZGVzY3JpcHRpb24udmFsdWVcIixcclxuICAgICAgbGFiZWw6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiUHJvcGVydHlNYWluXCIsIFwiRGVzY3JpcHRpb25cIiksXHJcbiAgICB9KTtcclxuICAgIHByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgIHR5cGU6IFwiRm9udEVkaXRvclwiLFxyXG4gICAgICBwcm9wZXJ0eTogXCJkZXNjcmlwdGlvblwiLFxyXG4gICAgICBsYWJlbDogU3RpTG9jYWxpemF0aW9uU2VydmljZS5nZXQoXCJQcm9wZXJ0eU1haW5cIiwgXCJGb250XCIpLFxyXG4gICAgfSk7XHJcbiAgICBwcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcImNvbG9yXCIsXHJcbiAgICAgIHByb3BlcnR5OiBcImRlc2NyaXB0aW9uLmNvbG9yXCIsXHJcbiAgICAgIGxhYmVsOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlLmdldChcIlByb3BlcnR5TWFpblwiLCBcIkZvcmVDb2xvclwiKSxcclxuICAgIH0pO1xyXG4gICAgcmV0dXJuIHByb3BlcnRpZXM7XHJcbiAgfVxyXG59XHJcbiJdfQ==