import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiLabelAlignment } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiSettingsCreator extends StiElementCreator {
    static createPropertyEditors(properties, element) {
        properties.push({ type: "divider" });
        properties.push({
            type: "image",
            property: "reportImage",
            label: StiLocalizationService.get("Cloud", "LabelPicture"),
        });
        properties.push({
            type: "TextEditor",
            property: "formName",
            label: StiLocalizationService.get("PropertyMain", "FormName"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "Number",
            property: "gridColumns",
            label: StiLocalizationService.get("PropertyMain", "GridColumns"),
        });
        properties.push({
            type: "Number",
            property: "gridVerticalStep",
            label: StiLocalizationService.get("PropertyMain", "GridVerticalStep"),
        });
        properties.push({ type: "divider" });
        properties.push({ type: "defaultLabel" });
        properties.push({ type: "divider" });
        properties.push({
            type: "FontEditor",
            property: "label",
            label: StiLocalizationService.get("PropertyMain", "Label"),
        });
        properties.push({ type: "color", property: "label.color", label: "" });
        properties.push({ type: "labelAlignment", property: "label.alignment", label: "" });
        if (element.label.alignment != StiLabelAlignment.Top) {
            properties.push({
                type: "Number",
                property: "label.width",
                label: StiLocalizationService.get("PropertyMain", "Width"),
            });
        }
        properties.push({ type: "divider" });
        properties.push({
            type: "FontEditor",
            property: "innerText",
            label: StiLocalizationService.get("PropertyMain", "InnerText"),
        });
        properties.push({ type: "horizontalAlignment", property: "innerText.contentAlignment", label: "" });
        properties.push({
            type: "color",
            property: "innerText.backgroundColor",
            label: StiLocalizationService.get("PropertyMain", "BackColor"),
        });
        properties.push({
            type: "color",
            property: "innerText.borderColor",
            label: StiLocalizationService.get("PropertyMain", "BorderColor"),
        });
        properties.push({
            type: "color",
            property: "innerText.checkColor",
            label: StiLocalizationService.get("PropertyMain", "CheckColor"),
        });
        properties.push({
            type: "enum",
            property: "innerText.borderWeight",
            label: StiLocalizationService.get("PropertyMain", "BorderWidth"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "FontEditor",
            property: "description",
            label: StiLocalizationService.get("PropertyMain", "Description"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "PaddingEditor",
            property: "padding",
            label: StiLocalizationService.get("PropertyMain", "Padding"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "enum",
            property: "dateTimeFormat",
            label: StiLocalizationService.get("FormFormatEditor", "DateTimeFormat"),
        });
        properties.push({
            type: "enum",
            property: "dateFormat",
            label: StiLocalizationService.get("FormFormatEditor", "Date") +
                " " +
                StiLocalizationService.get("PropertyMain", "Format"),
        });
        properties.push({
            type: "enum",
            property: "timeFormat",
            label: StiLocalizationService.get("FormFormatEditor", "Time") +
                " " +
                StiLocalizationService.get("PropertyMain", "Format"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "enum",
            property: "currency",
            label: StiLocalizationService.get("FormFormatEditor", "Currency"),
        });
        properties.push({
            type: "currencyFormat",
            property: "currencyFormat",
            label: StiLocalizationService.get("FormFormatEditor", "CurrencySymbol"),
        });
        properties.push({
            type: "enum",
            property: "unitAlignment",
            label: StiLocalizationService.get("PropertyMain", "UnitAlignment"),
        });
        properties.push({
            type: "enum",
            property: "thousandSeparator",
            label: StiLocalizationService.get("Export", "Separator").replace(":", ""),
        });
        properties.push({
            type: "Number",
            property: "decimalDigits",
            label: StiLocalizationService.get("FormFormatEditor", "DecimalDigits"),
        });
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,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