import { StiLocalizationService } from "../../../services/sti-localization.service";
import { StiLabelAlignment } from "../../../system/enums";
import { StiElementCreator } from "./StiElementCreator";
export default class StiMultipleSelectionCreator extends StiElementCreator {
    static createPropertyEditors(properties, element) {
        properties.push({ type: "divider" });
        properties.push({
            type: "MultilineEditor",
            property: "options",
            label: StiLocalizationService.get("PropertyMain", "Options"),
        });
        properties.push({
            type: "FontEditor",
            property: "font",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "backgroundColor",
            label: StiLocalizationService.get("PropertyMain", "BackColor"),
        });
        properties.push({
            type: "color",
            property: "textColor",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({
            type: "color",
            property: "checkColor",
            label: StiLocalizationService.get("PropertyMain", "CheckColor"),
        });
        properties.push({
            type: "color",
            property: "borderColor",
            label: StiLocalizationService.get("PropertyMain", "BorderColor"),
        });
        properties.push({
            type: "Number",
            property: "columns",
            label: StiLocalizationService.get("PropertyMain", "Columns"),
        });
        properties.push({
            type: "checkbox",
            property: "useCustomOption",
            checkbox: StiLocalizationService.get("FormDictionaryDesigner", "CsvSeparatorOther"),
        });
        if (element.useCustomOption) {
            properties.push({
                type: "TextEditor",
                property: "customOptionText",
                label: StiLocalizationService.get("Components", "StiText"),
            });
            properties.push({
                type: "TextEditor",
                property: "prefix",
                label: StiLocalizationService.get("PropertyMain", "Prefix"),
            });
            properties.push({
                type: "TextEditor",
                property: "suffix",
                label: StiLocalizationService.get("PropertyMain", "Suffix"),
            });
        }
        properties.push({ type: "divider" });
        properties.push({
            type: "nameEditor",
            property: "name",
            label: StiLocalizationService.get("PropertyMain", "Name"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "componentHeight",
            property: "height",
            label: StiLocalizationService.get("PropertyMain", "Height"),
        });
        properties.push({
            type: "PaddingEditor",
            property: "padding",
            label: StiLocalizationService.get("PropertyMain", "Padding"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "tooltip",
            label: StiLocalizationService.get("PropertyMain", "ToolTip"),
        });
        properties.push({
            type: "checkbox",
            property: "required",
            checkbox: StiLocalizationService.get("PropertyMain", "Required"),
        });
        properties.push({
            type: "checkbox",
            property: "readOnly",
            checkbox: StiLocalizationService.get("PropertyMain", "ReadOnly"),
        });
        properties.push({
            type: "checkbox",
            property: "visible",
            checkbox: StiLocalizationService.get("PropertyMain", "Visible"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "label.value",
            label: StiLocalizationService.get("PropertyMain", "Label"),
        });
        properties.push({ type: "labelAlignment", property: "label.alignment", label: "" });
        if (element.label.alignment != StiLabelAlignment.Top) {
            properties.push({
                type: "Number",
                property: "label.width",
                label: StiLocalizationService.get("PropertyMain", "Width"),
            });
        }
        properties.push({
            type: "FontEditor",
            property: "label",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "label.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        properties.push({ type: "divider" });
        properties.push({
            type: "TextEditor",
            property: "description.value",
            label: StiLocalizationService.get("PropertyMain", "Description"),
        });
        properties.push({
            type: "FontEditor",
            property: "description",
            label: StiLocalizationService.get("PropertyMain", "Font"),
        });
        properties.push({
            type: "color",
            property: "description.color",
            label: StiLocalizationService.get("PropertyMain", "ForeColor"),
        });
        return properties;
    }
}
//# sourceMappingURL=data:application/json;base64,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