import { Component, Input, ViewChild } from "@angular/core";
import { StiModelService } from "../../services/model.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "../../services/sti-editable-content.service";
import * as i5 from "@angular/common";
import * as i6 from "../sti-page-grid-overlay.component";
import * as i7 from "../sti-pages-navigation.component";
import * as i8 from "../sti-components-holder.component";
export class PageComponent {
    constructor(model, loc, componentResizerService, editableContent) {
        this.model = model;
        this.loc = loc;
        this.componentResizerService = componentResizerService;
        this.editableContent = editableContent;
        this.BORDER_WIDTH = 2;
        this.isInitialized = false;
        this.PANEL_NAVIGATION_WIDTH = 40;
        this.INNER_MARGIN = 10;
        this.previewModeIsInitialized = false;
    }
    get width() {
        return this.page.width + this.BORDER_WIDTH;
    }
    get height() {
        return this.page.height + this.BORDER_WIDTH;
    }
    get id() {
        return this.page.guid;
    }
    get elements() {
        return this.page.elements;
    }
    get className() {
        return ("page " +
            (this.model.selectedPage == this.page && !this.model.isPreviewMode ? "active" : "") +
            " " +
            StiModelService.PAGE_CLASS +
            (this.componentResizerService.isResizing ? " disable-text-selection" : ""));
    }
    get backgroundImage() {
        return this.page.backgroundImage ? "url(" + this.page.backgroundImage + ")" : null;
    }
    onContainerMouseDown(event) {
        if (event.target === this.pageContainerEl.nativeElement) {
            this.model.selectedComponent = null;
        }
    }
    onMouseDown(event) {
        this.model.selectedPage = this.page;
        this.editableContent.editableContent = null;
    }
    getPageIndex() {
        return this.model.form.pages.indexOf(this.page);
    }
    get zoom() {
        return this.model.zoom;
    }
    getLeftMargin() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        if (!this.isInitialized) {
            return 0;
        }
        if (!this.previewModeIsInitialized && this.model.isPreviewMode) {
            return 0;
        }
        let pageContainerWidth = this.page.width + (this.model.isPreviewMode ? 0 : this.PANEL_NAVIGATION_WIDTH + this.INNER_MARGIN);
        let freeHorizontalSpace = workspace.clientWidth -
            (workspace.clientHeight < workspace.scrollHeight || this.model.isPreviewMode
                ? 0
                : this.model.zoom < 0.5 && this.model.zoom > 0.3
                    ? window.devicePixelRatio == 1.25
                        ? 8
                        : 10
                    : 10) -
            40 -
            pageContainerWidth * this.zoom;
        let leftMargin = Math.round(freeHorizontalSpace / 2);
        return freeHorizontalSpace > 0 ? Number((leftMargin / this.zoom).toFixed(2)) : 0;
    }
    ngOnDestroy() {
        this.previewModeChangesObserver?.unsubscribe();
    }
    ngDoCheck() {
        if (this.pageEl && this.page.element != this.pageEl) {
            this.page.element = this.pageEl;
        }
    }
    ngAfterViewInit() {
        this.page.element = this.pageEl;
        setTimeout(() => {
            this.isInitialized = true;
        });
    }
    ngOnInit() {
        if (this.model.isPreviewMode && !this.previewModeIsInitialized) {
            this.previewModeIsInitialized = true;
        }
        this.previewModeChangesObserver = this.model.interfaceEvent.subscribe((event) => {
            if (event.name == "SetPreviewMode") {
                setTimeout(() => {
                    this.previewModeIsInitialized = true;
                });
            }
            else if (event.name == "UnsetPreviewMode") {
                this.previewModeIsInitialized = false;
            }
        });
    }
}
PageComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiComponentResizerService }, { token: i4.StiEditableContentService }], target: i0.ɵɵFactoryTarget.Component });
PageComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: PageComponent, selector: "app-page", inputs: { page: "page" }, viewQueries: [{ propertyName: "pageEl", first: true, predicate: ["element"], descendants: true }, { propertyName: "pageContainerEl", first: true, predicate: ["pageContainerEl"], descendants: true }], ngImport: i0, template: "<div\r\n  #pageContainerEl\r\n  class=\"page-container\"\r\n  *ngIf=\"((!page.visible || page.visible) && !model.isPreviewMode) || (page.visible && model.isPreviewMode)\"\r\n  [style.width.px]=\"width + (model.viewerMode || model.isPreviewMode ? 0 : 51)\"\r\n  [style.margin-left.px]=\"getLeftMargin()\"\r\n  (mousedown)=\"onContainerMouseDown($event)\"\r\n  [style.opacity]=\"isInitialized ? 1 : 0\"\r\n>\r\n  <div\r\n    #element\r\n    class=\"page\"\r\n    id=\"Page\"\r\n    [id]=\"id\"\r\n    [style.padding-left.px]=\"page?.padding.left\"\r\n    [style.padding-right.px]=\"page?.padding.right\"\r\n    [style.padding-top.px]=\"page?.padding.top\"\r\n    [style.padding-bottom.px]=\"page?.padding.bottom\"\r\n    [style.background-color]=\"page.backgroundColor.toHtmlColor()\"\r\n    [style.overflow]=\"'hidden'\"\r\n    [style.width.px]=\"width\"\r\n    [style.height.px]=\"height\"\r\n    [class]=\"className\"\r\n    [style.background-image]=\"backgroundImage\"\r\n    [style.background-position]=\"'center'\"\r\n    [style.background-size]=\"'cover'\"\r\n    [style.background-repeat]=\"'no-repeat'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n    (mousedown)=\"onMouseDown($event)\"\r\n  >\r\n    <div *ngFor=\"let element of elements\">\r\n      <sti-component-holder [element]=\"element\"></sti-component-holder>\r\n    </div>\r\n    <sti-page-grid-overlay\r\n      *ngIf=\"model.pageWithGrid == page || (model.lastUsedPage == page && componentResizerService.isResizing)\"\r\n    ></sti-page-grid-overlay>\r\n    <div class=\"trial-title\" [style.zIndex]=\"model.isPreviewMode ? 99999 : 0\" *ngIf=\"model.showTrialTitle\">\r\n      <span>{{ loc.getP(\"Trial\") }}</span>\r\n    </div>\r\n    <div\r\n      class=\"inline-border\"\r\n      *ngIf=\"!model.viewerMode && !model.isPreviewMode\"\r\n      [style.left.px]=\"page.padding.left\"\r\n      [style.top.px]=\"page.padding.top\"\r\n      [style.width.px]=\"page.contentAreaWidth\"\r\n      [style.height.px]=\"page.contentAreaHeight\"\r\n    ></div>\r\n    <i *ngIf=\"!page?.visible\" class=\"pi pi-eye-slash\" style=\"opacity: 0.3\"></i>\r\n  </div>\r\n  <sti-page-navigation\r\n    *ngIf=\"page === model.selectedPage && !model.isPreviewMode\"\r\n    [currentPage]=\"page\"\r\n    [style.visibility]=\"model.isPreviewMode ? 'hidden' : ''\"\r\n    [style.height]=\"'100%'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n  ></sti-page-navigation>\r\n</div>\r\n<style>\r\n  .page-container {\r\n    position: relative;\r\n    display: flex;\r\n  }\r\n  .page {\r\n    position: relative;\r\n    display: block;\r\n    background: white;\r\n    font-size: 2.5rem;\r\n    color: black;\r\n    border: 1px solid #c6c6c6;\r\n    margin-right: 10px;\r\n    margin-top: 10px;\r\n    margin-bottom: 10px;\r\n  }\r\n  .inline-border {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    border: 1px solid rgb(234, 234, 234);\r\n    opacity: 0.5;\r\n  }\r\n  .trial-title {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    user-select: none;\r\n    opacity: 0.3;\r\n    font-family: \"Segoe UI\";\r\n    font-weight: bold;\r\n    font-size: 100pt;\r\n    left: calc(50% - 135px);\r\n    top: calc(50% - 88px);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .trial-title span {\r\n    transform: rotate(-45deg);\r\n  }\r\n  .hovered {\r\n    border-color: rgb(73, 108, 159);\r\n  }\r\n\r\n  .active {\r\n    border-color: rgb(146, 146, 146);\r\n  }\r\n  i {\r\n    position: absolute;\r\n    right: 5px;\r\n    top: 5px;\r\n  }\r\n\r\n  .disable-text-selection {\r\n    -webkit-touch-callout: none;\r\n    -khtml-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n  }\r\n</style>\r\n", styles: ["\n  .page-container {\n    position: relative;\n    display: flex;\n  }\n  .page {\n    position: relative;\n    display: block;\n    background: white;\n    font-size: 2.5rem;\n    color: black;\n    border: 1px solid #c6c6c6;\n    margin-right: 10px;\n    margin-top: 10px;\n    margin-bottom: 10px;\n  }\n  .inline-border {\n    position: absolute;\n    pointer-events: none;\n    border: 1px solid rgb(234, 234, 234);\n    opacity: 0.5;\n  }\n  .trial-title {\n    position: absolute;\n    pointer-events: none;\n    user-select: none;\n    opacity: 0.3;\n    font-family: \"Segoe UI\";\n    font-weight: bold;\n    font-size: 100pt;\n    left: calc(50% - 135px);\n    top: calc(50% - 88px);\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n  .trial-title span {\n    transform: rotate(-45deg);\n  }\n  .hovered {\n    border-color: rgb(73, 108, 159);\n  }\n\n  .active {\n    border-color: rgb(146, 146, 146);\n  }\n  i {\n    position: absolute;\n    right: 5px;\n    top: 5px;\n  }\n\n  .disable-text-selection {\n    -webkit-touch-callout: none;\n    -khtml-user-select: none;\n    -moz-user-select: none;\n    -ms-user-select: none;\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n  }\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiPageGridOverlayComponent, selector: "sti-page-grid-overlay" }, { kind: "component", type: i7.StiPageNavigationComponent, selector: "sti-page-navigation", inputs: ["currentPage"] }, { kind: "component", type: i8.StiComponentHolderComponent, selector: "sti-component-holder", inputs: ["element", "isClone"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageComponent, decorators: [{
            type: Component,
            args: [{ selector: "app-page", template: "<div\r\n  #pageContainerEl\r\n  class=\"page-container\"\r\n  *ngIf=\"((!page.visible || page.visible) && !model.isPreviewMode) || (page.visible && model.isPreviewMode)\"\r\n  [style.width.px]=\"width + (model.viewerMode || model.isPreviewMode ? 0 : 51)\"\r\n  [style.margin-left.px]=\"getLeftMargin()\"\r\n  (mousedown)=\"onContainerMouseDown($event)\"\r\n  [style.opacity]=\"isInitialized ? 1 : 0\"\r\n>\r\n  <div\r\n    #element\r\n    class=\"page\"\r\n    id=\"Page\"\r\n    [id]=\"id\"\r\n    [style.padding-left.px]=\"page?.padding.left\"\r\n    [style.padding-right.px]=\"page?.padding.right\"\r\n    [style.padding-top.px]=\"page?.padding.top\"\r\n    [style.padding-bottom.px]=\"page?.padding.bottom\"\r\n    [style.background-color]=\"page.backgroundColor.toHtmlColor()\"\r\n    [style.overflow]=\"'hidden'\"\r\n    [style.width.px]=\"width\"\r\n    [style.height.px]=\"height\"\r\n    [class]=\"className\"\r\n    [style.background-image]=\"backgroundImage\"\r\n    [style.background-position]=\"'center'\"\r\n    [style.background-size]=\"'cover'\"\r\n    [style.background-repeat]=\"'no-repeat'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n    (mousedown)=\"onMouseDown($event)\"\r\n  >\r\n    <div *ngFor=\"let element of elements\">\r\n      <sti-component-holder [element]=\"element\"></sti-component-holder>\r\n    </div>\r\n    <sti-page-grid-overlay\r\n      *ngIf=\"model.pageWithGrid == page || (model.lastUsedPage == page && componentResizerService.isResizing)\"\r\n    ></sti-page-grid-overlay>\r\n    <div class=\"trial-title\" [style.zIndex]=\"model.isPreviewMode ? 99999 : 0\" *ngIf=\"model.showTrialTitle\">\r\n      <span>{{ loc.getP(\"Trial\") }}</span>\r\n    </div>\r\n    <div\r\n      class=\"inline-border\"\r\n      *ngIf=\"!model.viewerMode && !model.isPreviewMode\"\r\n      [style.left.px]=\"page.padding.left\"\r\n      [style.top.px]=\"page.padding.top\"\r\n      [style.width.px]=\"page.contentAreaWidth\"\r\n      [style.height.px]=\"page.contentAreaHeight\"\r\n    ></div>\r\n    <i *ngIf=\"!page?.visible\" class=\"pi pi-eye-slash\" style=\"opacity: 0.3\"></i>\r\n  </div>\r\n  <sti-page-navigation\r\n    *ngIf=\"page === model.selectedPage && !model.isPreviewMode\"\r\n    [currentPage]=\"page\"\r\n    [style.visibility]=\"model.isPreviewMode ? 'hidden' : ''\"\r\n    [style.height]=\"'100%'\"\r\n    [style.margin-top.px]=\"getPageIndex() == 0 ? 0 : 10\"\r\n  ></sti-page-navigation>\r\n</div>\r\n<style>\r\n  .page-container {\r\n    position: relative;\r\n    display: flex;\r\n  }\r\n  .page {\r\n    position: relative;\r\n    display: block;\r\n    background: white;\r\n    font-size: 2.5rem;\r\n    color: black;\r\n    border: 1px solid #c6c6c6;\r\n    margin-right: 10px;\r\n    margin-top: 10px;\r\n    margin-bottom: 10px;\r\n  }\r\n  .inline-border {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    border: 1px solid rgb(234, 234, 234);\r\n    opacity: 0.5;\r\n  }\r\n  .trial-title {\r\n    position: absolute;\r\n    pointer-events: none;\r\n    user-select: none;\r\n    opacity: 0.3;\r\n    font-family: \"Segoe UI\";\r\n    font-weight: bold;\r\n    font-size: 100pt;\r\n    left: calc(50% - 135px);\r\n    top: calc(50% - 88px);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .trial-title span {\r\n    transform: rotate(-45deg);\r\n  }\r\n  .hovered {\r\n    border-color: rgb(73, 108, 159);\r\n  }\r\n\r\n  .active {\r\n    border-color: rgb(146, 146, 146);\r\n  }\r\n  i {\r\n    position: absolute;\r\n    right: 5px;\r\n    top: 5px;\r\n  }\r\n\r\n  .disable-text-selection {\r\n    -webkit-touch-callout: none;\r\n    -khtml-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n  }\r\n</style>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiComponentResizerService }, { type: i4.StiEditableContentService }]; }, propDecorators: { pageEl: [{
                type: ViewChild,
                args: ["element"]
            }], pageContainerEl: [{
                type: ViewChild,
                args: ["pageContainerEl"]
            }], page: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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