import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-toolbox.service";
import * as i4 from "../../services/sti-helper.service";
import * as i5 from "@angular/common";
import * as i6 from "../../toolbox/sti-toolbox-element.component";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
export class StiInsertRibbonComponent {
    constructor(model, loc, toolboxService, helper) {
        this.model = model;
        this.loc = loc;
        this.toolboxService = toolboxService;
        this.helper = helper;
    }
    addPage() {
        let newPage = this.helper.clonePage(this.model.form.pages[this.model.form.pages.length - 1]);
        newPage.elements = [];
        this.model.form.pages.splice(this.model.form.pages.indexOf(this.model.form.pages[this.model.form.pages.length - 1]) + 1, 0, newPage);
    }
    ngOnInit() { }
}
StiInsertRibbonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiInsertRibbonComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiToolboxService }, { token: i4.StiHelperService }], target: i0.ɵɵFactoryTarget.Component });
StiInsertRibbonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiInsertRibbonComponent, selector: "sti-insert-ribbon-component", ngImport: i0, template: `<div class="insert">
    <div
      class="container"
      [stiTooltip]="loc.get2('HelpDesigner', 'PageNew')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="addPage()"
    >
      <div class="button">
        <img [src]="model.getImage('images.Page.StiPage.png')" alt="" />
        <span>{{ loc.get2("FormViewer", "PageNew") }}</span>
      </div>
    </div>
    <div class="vertical-line"></div>
    <sti-toolbox-element
      [forRibbon]="true"
      *ngFor="let element of toolboxService.elementsForRibbon"
      [element]="element"
    ></sti-toolbox-element>
    <div
      *ngIf="toolboxService.isInsertOutlineElementsDividerEnabled() && model.getBooleanSetting('showSetupToolbox')"
      class="vertical-line"
    ></div>
    <div
      class="container"
      *ngIf="model.getBooleanSetting('showSetupToolbox')"
      (click)="model.showToolboxSetup = true"
      [stiTooltip]="loc.get2('FormDesigner', 'SetupToolbox')"
      tooltipPosition="bottom"
      showDelay="500"
    >
      <div class="button">
        <img [src]="model.getImage('images.Other.SetupToolbox.png')" alt="" />
        <span>{{ loc.get2("FormDesigner", "SetupToolbox") }}</span>
      </div>
    </div>
  </div>`, isInline: true, styles: [".container{width:max-content;display:flex;align-items:center;justify-content:center;-webkit-touch-callout:none;-webkit-user-select:none}.button{height:50px;padding-left:5px;padding-right:5px;width:max-content;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--hover-color)!important}.button:active{background-color:var(--columnDeleteHover-color)!important}img{max-width:18px}.insert{height:55px;color:var(--text-color);width:100%;display:flex;border-bottom:1px solid var(--formBorder-color);vertical-align:-webkit-baseline-middle;background-color:var(--back-color);font-family:Segoe UI;overflow-x:auto;overflow-y:hidden}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.vertical-line{margin-top:10px;width:0px;height:32px;border-right:1px solid rgb(195,195,195);margin-right:5px;margin-left:5px}span{font-size:13px;margin-left:3px}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiToolboxElementComponent, selector: "sti-toolbox-element", inputs: ["element", "forRibbon", "forGroup"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiInsertRibbonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-insert-ribbon-component", template: `<div class="insert">
    <div
      class="container"
      [stiTooltip]="loc.get2('HelpDesigner', 'PageNew')"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="addPage()"
    >
      <div class="button">
        <img [src]="model.getImage('images.Page.StiPage.png')" alt="" />
        <span>{{ loc.get2("FormViewer", "PageNew") }}</span>
      </div>
    </div>
    <div class="vertical-line"></div>
    <sti-toolbox-element
      [forRibbon]="true"
      *ngFor="let element of toolboxService.elementsForRibbon"
      [element]="element"
    ></sti-toolbox-element>
    <div
      *ngIf="toolboxService.isInsertOutlineElementsDividerEnabled() && model.getBooleanSetting('showSetupToolbox')"
      class="vertical-line"
    ></div>
    <div
      class="container"
      *ngIf="model.getBooleanSetting('showSetupToolbox')"
      (click)="model.showToolboxSetup = true"
      [stiTooltip]="loc.get2('FormDesigner', 'SetupToolbox')"
      tooltipPosition="bottom"
      showDelay="500"
    >
      <div class="button">
        <img [src]="model.getImage('images.Other.SetupToolbox.png')" alt="" />
        <span>{{ loc.get2("FormDesigner", "SetupToolbox") }}</span>
      </div>
    </div>
  </div>`, styles: [".container{width:max-content;display:flex;align-items:center;justify-content:center;-webkit-touch-callout:none;-webkit-user-select:none}.button{height:50px;padding-left:5px;padding-right:5px;width:max-content;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;justify-content:center}.button:hover{background-color:var(--hover-color)!important}.button:active{background-color:var(--columnDeleteHover-color)!important}img{max-width:18px}.insert{height:55px;color:var(--text-color);width:100%;display:flex;border-bottom:1px solid var(--formBorder-color);vertical-align:-webkit-baseline-middle;background-color:var(--back-color);font-family:Segoe UI;overflow-x:auto;overflow-y:hidden}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.vertical-line{margin-top:10px;width:0px;height:32px;border-right:1px solid rgb(195,195,195);margin-right:5px;margin-left:5px}span{font-size:13px;margin-left:3px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiToolboxService }, { type: i4.StiHelperService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmF2YmFyLmluc2VydC1yaWJib24uY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvbmF2YmFyLmNvbXBvbmVudC9uYXZiYXIuaW5zZXJ0LXJpYmJvbi5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBVSxNQUFNLGVBQWUsQ0FBQzs7Ozs7Ozs7O0FBa0psRCxNQUFNLE9BQU8sd0JBQXdCO0lBQ25DLFlBQ1MsS0FBc0IsRUFDdEIsR0FBMkIsRUFDM0IsY0FBaUMsRUFDakMsTUFBd0I7UUFIeEIsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsUUFBRyxHQUFILEdBQUcsQ0FBd0I7UUFDM0IsbUJBQWMsR0FBZCxjQUFjLENBQW1CO1FBQ2pDLFdBQU0sR0FBTixNQUFNLENBQWtCO0lBQzlCLENBQUM7SUFDSixPQUFPO1FBQ0wsSUFBSSxPQUFPLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUM3RixPQUFPLENBQUMsUUFBUSxHQUFHLEVBQUUsQ0FBQztRQUN0QixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUMxQixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxFQUMxRixDQUFDLEVBQ0QsT0FBTyxDQUNSLENBQUM7SUFDSixDQUFDO0lBQ0QsUUFBUSxLQUFJLENBQUM7O3FIQWhCRix3QkFBd0I7eUdBQXhCLHdCQUF3QixtRUExSXpCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7U0FvQ0g7MkZBc0dJLHdCQUF3QjtrQkE1SXBDLFNBQVM7K0JBQ0UsNkJBQTZCLFlBQzdCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7U0FvQ0giLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUhlbHBlclNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vc2VydmljZXMvc3RpLWhlbHBlci5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUxvY2FsaXphdGlvblNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vc2VydmljZXMvc3RpLWxvY2FsaXphdGlvbi5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aVRvb2xib3hTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uL3NlcnZpY2VzL3N0aS10b29sYm94LnNlcnZpY2VcIjtcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiBcInN0aS1pbnNlcnQtcmliYm9uLWNvbXBvbmVudFwiLFxyXG4gIHRlbXBsYXRlOiBgPGRpdiBjbGFzcz1cImluc2VydFwiPlxyXG4gICAgPGRpdlxyXG4gICAgICBjbGFzcz1cImNvbnRhaW5lclwiXHJcbiAgICAgIFtzdGlUb29sdGlwXT1cImxvYy5nZXQyKCdIZWxwRGVzaWduZXInLCAnUGFnZU5ldycpXCJcclxuICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgICAgKG1vdXNlZG93bik9XCJhZGRQYWdlKClcIlxyXG4gICAgPlxyXG4gICAgICA8ZGl2IGNsYXNzPVwiYnV0dG9uXCI+XHJcbiAgICAgICAgPGltZyBbc3JjXT1cIm1vZGVsLmdldEltYWdlKCdpbWFnZXMuUGFnZS5TdGlQYWdlLnBuZycpXCIgYWx0PVwiXCIgLz5cclxuICAgICAgICA8c3Bhbj57eyBsb2MuZ2V0MihcIkZvcm1WaWV3ZXJcIiwgXCJQYWdlTmV3XCIpIH19PC9zcGFuPlxyXG4gICAgICA8L2Rpdj5cclxuICAgIDwvZGl2PlxyXG4gICAgPGRpdiBjbGFzcz1cInZlcnRpY2FsLWxpbmVcIj48L2Rpdj5cclxuICAgIDxzdGktdG9vbGJveC1lbGVtZW50XHJcbiAgICAgIFtmb3JSaWJib25dPVwidHJ1ZVwiXHJcbiAgICAgICpuZ0Zvcj1cImxldCBlbGVtZW50IG9mIHRvb2xib3hTZXJ2aWNlLmVsZW1lbnRzRm9yUmliYm9uXCJcclxuICAgICAgW2VsZW1lbnRdPVwiZWxlbWVudFwiXHJcbiAgICA+PC9zdGktdG9vbGJveC1lbGVtZW50PlxyXG4gICAgPGRpdlxyXG4gICAgICAqbmdJZj1cInRvb2xib3hTZXJ2aWNlLmlzSW5zZXJ0T3V0bGluZUVsZW1lbnRzRGl2aWRlckVuYWJsZWQoKSAmJiBtb2RlbC5nZXRCb29sZWFuU2V0dGluZygnc2hvd1NldHVwVG9vbGJveCcpXCJcclxuICAgICAgY2xhc3M9XCJ2ZXJ0aWNhbC1saW5lXCJcclxuICAgID48L2Rpdj5cclxuICAgIDxkaXZcclxuICAgICAgY2xhc3M9XCJjb250YWluZXJcIlxyXG4gICAgICAqbmdJZj1cIm1vZGVsLmdldEJvb2xlYW5TZXR0aW5nKCdzaG93U2V0dXBUb29sYm94JylcIlxyXG4gICAgICAoY2xpY2spPVwibW9kZWwuc2hvd1Rvb2xib3hTZXR1cCA9IHRydWVcIlxyXG4gICAgICBbc3RpVG9vbHRpcF09XCJsb2MuZ2V0MignRm9ybURlc2lnbmVyJywgJ1NldHVwVG9vbGJveCcpXCJcclxuICAgICAgdG9vbHRpcFBvc2l0aW9uPVwiYm90dG9tXCJcclxuICAgICAgc2hvd0RlbGF5PVwiNTAwXCJcclxuICAgID5cclxuICAgICAgPGRpdiBjbGFzcz1cImJ1dHRvblwiPlxyXG4gICAgICAgIDxpbWcgW3NyY109XCJtb2RlbC5nZXRJbWFnZSgnaW1hZ2VzLk90aGVyLlNldHVwVG9vbGJveC5wbmcnKVwiIGFsdD1cIlwiIC8+XHJcbiAgICAgICAgPHNwYW4+e3sgbG9jLmdldDIoXCJGb3JtRGVzaWduZXJcIiwgXCJTZXR1cFRvb2xib3hcIikgfX08L3NwYW4+XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgPC9kaXY+XHJcbiAgPC9kaXY+YCxcclxuICBzdHlsZXM6IFtcclxuICAgIGBcclxuICAgICAgLmNvbnRhaW5lciB7XHJcbiAgICAgICAgd2lkdGg6IG1heC1jb250ZW50O1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcclxuICAgICAgICAtd2Via2l0LXRvdWNoLWNhbGxvdXQ6IG5vbmU7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgICAtd2Via2l0LXRvdWNoLWNhbGxvdXQ6IG5vbmU7XHJcbiAgICAgICAgLXdlYmtpdC11c2VyLXNlbGVjdDogbm9uZTtcclxuICAgICAgfVxyXG4gICAgICAuYnV0dG9uIHtcclxuICAgICAgICBoZWlnaHQ6IDUwcHg7XHJcbiAgICAgICAgcGFkZGluZy1sZWZ0OiA1cHg7XHJcbiAgICAgICAgcGFkZGluZy1yaWdodDogNXB4O1xyXG4gICAgICAgIHdpZHRoOiBtYXgtY29udGVudDtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1iYWNrLWNvbG9yKTtcclxuICAgICAgICBib3JkZXItcmFkaXVzOiAzcHg7XHJcbiAgICAgICAgZGlzcGxheTogZmxleDtcclxuICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG4gICAgICB9XHJcbiAgICAgIC5idXR0b246aG92ZXIge1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHZhcigtLWhvdmVyLWNvbG9yKSAhaW1wb3J0YW50O1xyXG4gICAgICB9XHJcbiAgICAgIC5idXR0b246YWN0aXZlIHtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1jb2x1bW5EZWxldGVIb3Zlci1jb2xvcikgIWltcG9ydGFudDtcclxuICAgICAgfVxyXG4gICAgICBpbWcge1xyXG4gICAgICAgIG1heC13aWR0aDogMThweDtcclxuICAgICAgfVxyXG4gICAgICAuaW5zZXJ0IHtcclxuICAgICAgICBoZWlnaHQ6IDU1cHg7XHJcbiAgICAgICAgY29sb3I6IHZhcigtLXRleHQtY29sb3IpO1xyXG4gICAgICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XHJcbiAgICAgICAgYm9yZGVyLWJvdHRvbTogMXB4IHNvbGlkIHZhcigtLWZvcm1Cb3JkZXItY29sb3IpO1xyXG4gICAgICAgIHZlcnRpY2FsLWFsaWduOiAtd2Via2l0LWJhc2VsaW5lLW1pZGRsZTtcclxuICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1iYWNrLWNvbG9yKTtcclxuICAgICAgICBmb250LWZhbWlseTogXCJTZWdvZSBVSVwiO1xyXG4gICAgICAgIG92ZXJmbG93LXg6IGF1dG87XHJcbiAgICAgICAgb3ZlcmZsb3cteTogaGlkZGVuO1xyXG4gICAgICB9XHJcbiAgICAgICoge1xyXG4gICAgICAgIHNjcm9sbGJhci13aWR0aDogdGhpbjtcclxuICAgICAgICBzY3JvbGxiYXItY29sb3I6IHZhcigtLXRodW1iLWNvbG9yKSwgdmFyKC0tYmFjay1jb2xvcik7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgICo6Oi13ZWJraXQtc2Nyb2xsYmFyIHtcclxuICAgICAgICAtd2Via2l0LWFwcGVhcmFuY2U6IG5vbmU7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tYmFjay1jb2xvcik7XHJcbiAgICAgICAgaGVpZ2h0OiAxMHB4O1xyXG4gICAgICAgIHdpZHRoOiAxMHB4O1xyXG4gICAgICAgIG91dGxpbmU6IG5vbmU7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgICo6Oi13ZWJraXQtc2Nyb2xsYmFyLWJ1dHRvbiB7XHJcbiAgICAgICAgLXdlYmtpdC1hcHBlYXJhbmNlOiBub25lO1xyXG4gICAgICAgIGhlaWdodDogM3B4O1xyXG4gICAgICAgIHdpZHRoOiAzcHg7XHJcbiAgICAgIH1cclxuXHJcbiAgICAgICo6Oi13ZWJraXQtc2Nyb2xsYmFyLXRodW1iIHtcclxuICAgICAgICAtd2Via2l0LWFwcGVhcmFuY2U6IG5vbmU7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tdGh1bWItY29sb3IpO1xyXG4gICAgICAgIGhlaWdodDogMTBweDtcclxuICAgICAgICBtaW4td2lkdGg6IDI1cHg7XHJcbiAgICAgICAgbWF4LXdpZHRoOiA4MCU7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogNHB4O1xyXG4gICAgICAgIGJvcmRlcjogMnB4IHNvbGlkIHZhcigtLWJhY2stY29sb3IpO1xyXG4gICAgICB9XHJcblxyXG4gICAgICAqOjotd2Via2l0LXNjcm9sbGJhci10aHVtYjpob3ZlciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tdHJhY2tIb3Zlci1jb2xvcik7XHJcbiAgICAgICAgaGVpZ2h0OiAxMHB4O1xyXG4gICAgICB9XHJcblxyXG4gICAgICAqOjotd2Via2l0LXNjcm9sbGJhci10cmFjayB7XHJcbiAgICAgICAgLXdlYmtpdC1hcHBlYXJhbmNlOiBub25lO1xyXG4gICAgICAgIGJhY2tncm91bmQtY29sb3I6IHZhcigtLWJhY2stY29sb3IpO1xyXG4gICAgICAgIGJvcmRlcjogMXB4IHNvbGlkIHZhcigtLWJhY2stY29sb3IpO1xyXG4gICAgICB9XHJcbiAgICAgICo6Oi13ZWJraXQtc2Nyb2xsYmFyLWNvcm5lciB7XHJcbiAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tYmFjay1jb2xvcik7XHJcbiAgICAgIH1cclxuICAgICAgLnZlcnRpY2FsLWxpbmUge1xyXG4gICAgICAgIG1hcmdpbi10b3A6IDEwcHg7XHJcbiAgICAgICAgd2lkdGg6IDBweDtcclxuICAgICAgICBoZWlnaHQ6IDMycHg7XHJcbiAgICAgICAgYm9yZGVyLXJpZ2h0OiAxcHggc29saWQgcmdiKDE5NSwgMTk1LCAxOTUpO1xyXG4gICAgICAgIG1hcmdpbi1yaWdodDogNXB4O1xyXG4gICAgICAgIG1hcmdpbi1sZWZ0OiA1cHg7XHJcbiAgICAgIH1cclxuICAgICAgc3BhbiB7XHJcbiAgICAgICAgZm9udC1zaXplOiAxM3B4O1xyXG4gICAgICAgIG1hcmdpbi1sZWZ0OiAzcHg7XHJcbiAgICAgIH1cclxuICAgIGAsXHJcbiAgXSxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aUluc2VydFJpYmJvbkNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwdWJsaWMgbW9kZWw6IFN0aU1vZGVsU2VydmljZSxcclxuICAgIHB1YmxpYyBsb2M6IFN0aUxvY2FsaXphdGlvblNlcnZpY2UsXHJcbiAgICBwdWJsaWMgdG9vbGJveFNlcnZpY2U6IFN0aVRvb2xib3hTZXJ2aWNlLFxyXG4gICAgcHVibGljIGhlbHBlcjogU3RpSGVscGVyU2VydmljZVxyXG4gICkge31cclxuICBhZGRQYWdlKCkge1xyXG4gICAgbGV0IG5ld1BhZ2UgPSB0aGlzLmhlbHBlci5jbG9uZVBhZ2UodGhpcy5tb2RlbC5mb3JtLnBhZ2VzW3RoaXMubW9kZWwuZm9ybS5wYWdlcy5sZW5ndGggLSAxXSk7XHJcbiAgICBuZXdQYWdlLmVsZW1lbnRzID0gW107XHJcbiAgICB0aGlzLm1vZGVsLmZvcm0ucGFnZXMuc3BsaWNlKFxyXG4gICAgICB0aGlzLm1vZGVsLmZvcm0ucGFnZXMuaW5kZXhPZih0aGlzLm1vZGVsLmZvcm0ucGFnZXNbdGhpcy5tb2RlbC5mb3JtLnBhZ2VzLmxlbmd0aCAtIDFdKSArIDEsXHJcbiAgICAgIDAsXHJcbiAgICAgIG5ld1BhZ2VcclxuICAgICk7XHJcbiAgfVxyXG4gIG5nT25Jbml0KCkge31cclxufVxyXG4iXX0=