import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/sti-toolbox.service";
import * as i2 from "../../services/model.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "@angular/common";
import * as i5 from "../../toolbox/sti-toolbox-element.component";
export class NavbarGroupPreviewComponent {
    constructor(toolboxService, model, loc) {
        this.toolboxService = toolboxService;
        this.model = model;
        this.loc = loc;
    }
    ngOnInit() { }
}
NavbarGroupPreviewComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavbarGroupPreviewComponent, deps: [{ token: i1.StiToolboxService }, { token: i2.StiModelService }, { token: i3.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
NavbarGroupPreviewComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: NavbarGroupPreviewComponent, selector: "sti-navbar-group-preview-component", ngImport: i0, template: `<div
    class="parent-group-container"
    [style.visibility]="model.showGroupPreview ? 'visible' : 'hidden'"
    [style.left.px]="toolboxService.previewX"
    [style.top.px]="toolboxService.previewY"
    [style.width]="'max-content'"
  >
    <div class="toolbox-content" *ngIf="toolboxService.currentGroup == 'Others'">
      <sti-toolbox-element
        [forGroup]="true"
        *ngFor="let element of toolboxService.otherGroup"
        [element]="element"
      ></sti-toolbox-element>
    </div>
    <div class="toolbox-content" *ngIf="toolboxService.currentGroup == 'Input'">
      <sti-toolbox-element
        [forGroup]="true"
        *ngFor="let element of toolboxService.inputGroup"
        [element]="element"
      ></sti-toolbox-element>
    </div>
    <div class="toolbox-content" *ngIf="toolboxService.currentGroup == 'Selection'">
      <sti-toolbox-element
        [forGroup]="true"
        *ngFor="let element of toolboxService.selectionGroup"
        [element]="element"
      ></sti-toolbox-element>
    </div>
  </div>`, isInline: true, styles: [".parent-group-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px 2px;border:1px solid lightgray;border-radius:3px;overflow:hidden;box-shadow:0 3px 6px #00000029}.toolbox-content{height:max-content;width:max-content}\n"], dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.StiToolboxElementComponent, selector: "sti-toolbox-element", inputs: ["element", "forRibbon", "forGroup"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavbarGroupPreviewComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-navbar-group-preview-component", template: `<div
    class="parent-group-container"
    [style.visibility]="model.showGroupPreview ? 'visible' : 'hidden'"
    [style.left.px]="toolboxService.previewX"
    [style.top.px]="toolboxService.previewY"
    [style.width]="'max-content'"
  >
    <div class="toolbox-content" *ngIf="toolboxService.currentGroup == 'Others'">
      <sti-toolbox-element
        [forGroup]="true"
        *ngFor="let element of toolboxService.otherGroup"
        [element]="element"
      ></sti-toolbox-element>
    </div>
    <div class="toolbox-content" *ngIf="toolboxService.currentGroup == 'Input'">
      <sti-toolbox-element
        [forGroup]="true"
        *ngFor="let element of toolboxService.inputGroup"
        [element]="element"
      ></sti-toolbox-element>
    </div>
    <div class="toolbox-content" *ngIf="toolboxService.currentGroup == 'Selection'">
      <sti-toolbox-element
        [forGroup]="true"
        *ngFor="let element of toolboxService.selectionGroup"
        [element]="element"
      ></sti-toolbox-element>
    </div>
  </div>`, styles: [".parent-group-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px 2px;border:1px solid lightgray;border-radius:3px;overflow:hidden;box-shadow:0 3px 6px #00000029}.toolbox-content{height:max-content;width:max-content}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiToolboxService }, { type: i2.StiModelService }, { type: i3.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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