import { Component, ViewChild } from "@angular/core";
import StiRectangleGeometryLayout from "../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-draggable.service";
import * as i4 from "../../services/sti-export.service";
import * as i5 from "../../services/theme.service";
import * as i6 from "../../services/sti-localization.service";
import * as i7 from "../../services/sti-toolbox.service";
import * as i8 from "../../services/http-client.service";
import * as i9 from "../../services/sti-user-service";
import * as i10 from "../../services/sti-form-checker.service";
import * as i11 from "@angular/common";
import * as i12 from "./navbar.home-ribbon.component";
import * as i13 from "./navbar.file-ribbon.component";
import * as i14 from "./navbar.insert-ribbon.component";
import * as i15 from "../sti-tooltip/sti-tooltip.directive";
export class NavbarComponent {
    constructor(model, helper, draggableService, exportService, render, theme, loc, toolboxService, httpService, userService, formCheckerService) {
        this.model = model;
        this.helper = helper;
        this.draggableService = draggableService;
        this.exportService = exportService;
        this.render = render;
        this.theme = theme;
        this.loc = loc;
        this.toolboxService = toolboxService;
        this.httpService = httpService;
        this.userService = userService;
        this.formCheckerService = formCheckerService;
        this.disabled = true;
        this._currentRibbon = "Home";
    }
    get editButtonRight() {
        return (this.saveButton?.nativeElement.offsetWidth ?? 0) + 20;
    }
    get currentRibbon() {
        if (this._currentRibbon == "Insert" && !this.toolboxService.showInsertTab) {
            this.currentRibbon = "Home";
        }
        else if (this.model.viewerMode && this._currentRibbon != "Preview") {
            this.model.isPreviewMode = true;
            this.currentRibbon = "Preview";
        }
        else {
            return this._currentRibbon;
        }
    }
    set currentRibbon(value) {
        this._currentRibbon = value;
        this.model.currentRibbonValue = value;
    }
    get componentHeight() {
        if (this.model.viewerMode) {
            return 0;
        }
        else if (this.model.pdfPreviewMode || this.model.isPreviewMode) {
            return 38;
        }
        else
            return 93;
    }
    getClass(ribbon) {
        return this.currentRibbon == ribbon ? "current" : "other";
    }
    setEvent(event) {
        if (event == "Share") {
            this.httpService.post("", { action: "InterfaceEvent", event: "ShareButtonClick" }).subscribe(() => { });
        }
        else if (event == "Publish") {
            this.httpService.post("", { action: "InterfaceEvent", event: "PublishButtonClick" }).subscribe(() => { });
        }
        else if (event == "Login") {
            this.httpService.post("", { action: "InterfaceEvent", event: "LoginButtonClick" }).subscribe(() => { });
        }
        else if (event == "Signup") {
            this.httpService.post("", { action: "InterfaceEvent", event: "SignUpButtonClick" }).subscribe(() => { });
        }
    }
    setRibbon(ribbon, forcedSetting = false) {
        if ((this.model.isWebView || this.model.embeddedMode) && ribbon == "File") {
            this.httpService.post("", { action: "InterfaceEvent", event: "RibbonFileClick" }).subscribe(() => { });
        }
        else {
            if (this.selectedComponent) {
                this.model.selectedComponent = this.selectedComponent;
            }
            else if (this.selectedPage) {
                this.model.selectedPage = this.selectedPage;
            }
            if (ribbon != "File") {
                if (forcedSetting || this.formCheckerService.check(ribbon)) {
                    this.currentRibbon = ribbon;
                    if (ribbon == "PDFPreview") {
                        this.model.currentFormState = this.model.form.saveToReportJsonObject().serialize();
                    }
                    this.model.isPreviewMode = ribbon == "Preview";
                    this.model.pdfPreviewMode = ribbon == "PDFPreview";
                }
            }
            else if (ribbon == "File") {
                this.model.showFileMenu = true;
                this.model.showFileMenuNavigation = true;
                this.model.currentFormState = this.model.form.saveToReportJsonObject().serialize();
                this.model.currentSelectedFileOption = "Open";
            }
        }
        this.model.showTrialLog();
    }
    save() {
        if (this.model.isWebView || this.model.embeddedMode || this.model.isCloudMode) {
            let form = this.model.form.saveToJsonObject().serialize();
            this.httpService.post("", { action: "InterfaceEvent", event: "SaveButtonClick", form: form }).subscribe(() => { });
        }
        else {
            this.setRibbon("File");
            this.model.currentSelectedFileOption = "SaveAs";
        }
    }
    showInfo(event, type) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        let element = elements.find((element) => element?.classList.contains("localization")) ||
            elements.find((element) => element?.classList.contains("user-info"));
        let elementRect = this.model.getPositionRelativeToForm(element);
        this.userService.previewY = elementRect.bottom;
        if (type == "Localization") {
            this.userService.showLocalizationPreview = true;
            this.userService.previewX = elementRect.right - (this.loc.localizationList?.length > 0 ? 465 : 155);
        }
        else {
            this.userService.showUserInfo = true;
            this.userService.previewX = elementRect.right - 351;
        }
    }
    sendExportEvent() {
        if (this.model.isWebView) {
            this.httpService.post("", { action: "InterfaceEvent", event: "ExportButtonClick" }).subscribe(() => { });
        }
        else if (this.model.isCloudMode && !this.model.viewerMode) {
            this.model.showSaveDialogFromCloud = true;
        }
        else {
            this.showPdfOption();
        }
    }
    ngOnDestroy() {
        this.startPdfEventSubscription?.unsubscribe();
        this.setFormEventSubscription?.unsubscribe();
    }
    editForm() {
        let cloudParams = {
            demomode: true,
            localizationName: "en",
            themeName: "Office2022WhiteBlue",
            isForm: true,
            reportName: this.helper.base64Encode(this.model.form.formName),
        };
        let win_ = window.open("about:blank");
        let doc = win_ ? win_.document : document;
        this.httpService.postForm("https://designer.stimulsoft.com/", {
            designerParams: this.helper.base64Encode(JSON.stringify(cloudParams)),
        }, doc, true);
    }
    showPdfOption() {
        this.exportService.showModalWindow = !this.exportService.showModalWindow;
    }
    ngOnInit() {
        this.model.form?.pages.length == 1 ? (this.disabled = true) : (this.disabled = false);
        this.setFormEventSubscription = this.model.formEvents.subscribe((e) => {
            if (e.name == "SetForm") {
                this.getDefaultTab();
            }
            else if (e.name == "Preview" || e.name == "PDFPreview") {
                this.setRibbon(e.name, true);
            }
            else if (e.name == "ShowFileMenu") {
                this.setRibbon("File");
            }
            else if (e.name == "ShowSaveMenu") {
                this.setRibbon("File");
                this.model.currentSelectedFileOption = "SaveAs";
            }
            else if (e.name == "ShowTab") {
                this.setRibbon(e.value);
            }
        });
        this.startPdfEventSubscription = this.model.startPdfExportEvent.subscribe(() => {
            this.setRibbon("Preview");
            this.showPdfOption();
        });
    }
    getDefaultTab() {
        let value = this.model.settings ? this.model.settings["defaultTab"] : "Home";
        if (value?.length > 0 && typeof value == "string") {
            switch (value.toLowerCase()) {
                case "home":
                    this.setRibbon("Home");
                    break;
                case "insert":
                    this.setRibbon("Insert");
                    break;
                case "preview":
                    this.setRibbon("Preview");
                    break;
                case "pdfpreview":
                    this.setRibbon("PDFPreview");
                    break;
                default:
                    this.setRibbon("Home");
                    break;
            }
        }
        else {
            this.setRibbon("Home");
        }
    }
}
NavbarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavbarComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiDraggableService }, { token: i4.StiExportService }, { token: StiRectangleGeometryLayout }, { token: i5.StiThemeService }, { token: i6.StiLocalizationService }, { token: i7.StiToolboxService }, { token: i8.StiHttpClientService }, { token: i9.StiUserService }, { token: i10.StiFormCheckerService }], target: i0.ɵɵFactoryTarget.Component });
NavbarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: NavbarComponent, selector: "sti-navbar", viewQueries: [{ propertyName: "saveButton", first: true, predicate: ["saveButton"], descendants: true }], ngImport: i0, template: "<div class=\"navbar\" [style.visibility]=\"model.viewerMode ? 'hidden' : 'visible'\" [style.height.px]=\"componentHeight\">\r\n  <div\r\n    class=\"navigation\"\r\n    [style.border-bottom]=\"\r\n      model.isPreviewMode && !model.viewerMode ? '1px solid rgb(224,224,224)' : '1px solid transparent'\r\n    \"\r\n  >\r\n    <div\r\n      class=\"image-container\"\r\n      *ngIf=\"model.isPreviewMode && model.showEditButton\"\r\n      [style.right.px]=\"editButtonRight\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      (click)=\"editForm()\"\r\n    >\r\n      <img [style.margin]=\"model.isMobile() ? '0px' : '0px 5px 0px 0px'\" [src]=\"model.getImage('images.Edit.png')\" />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"MainMenu\", \"menuEditEdit\") }}</span>\r\n    </div>\r\n    <div\r\n      #saveButton\r\n      class=\"image-container\"\r\n      *ngIf=\"(model.viewerMode || model.isPreviewMode) && model.showSaveToPdfButton\"\r\n      [style.right.px]=\"15\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      [stiTooltip]=\"loc.get2('A_WebViewer', 'SaveReport')\"\r\n      tooltipPosition=\"bottom\"\r\n      (click)=\"showPdfOption()\"\r\n    >\r\n      <img\r\n        [style.margin]=\"model.isMobile() ? '0px' : '1px 5px 0px 0px'\"\r\n        [src]=\"\r\n          model.isMobile() ? model.getImage('images.ReportSave.png') : model.getImage('images.Other.DownloadPDF.png')\r\n        \"\r\n      />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"Buttons\", \"Save\") }}</span>\r\n    </div>\r\n    <div class=\"save-button\" *ngIf=\"model.getBooleanSetting('showSaveButton')\" (click)=\"save()\">\r\n      <img [src]=\"model.getImage('images.Other.Save.png')\" />\r\n    </div>\r\n    <div class=\"file-menu-button\" *ngIf=\"model.getBooleanSetting('showFileButton')\" (click)=\"setRibbon('File')\">\r\n      <span>{{ loc.getP(\"File\") }}</span>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showHomeTab')\" (click)=\"setRibbon('Home')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"Toolbars\", \"TabHome\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Home') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"toolboxService.showInsertTab && model.getBooleanSetting('showInsertTab')\"\r\n      (click)=\"setRibbon('Insert')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"Insert\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Insert') }}\"></div>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showPreviewTab')\" (click)=\"setRibbon('Preview')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"FormDesigner\", \"Preview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Preview') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"model.getBooleanSetting('showPDFPreviewTab')\"\r\n      (click)=\"setRibbon('PDFPreview')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"PDFPreview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('PDFPreview') }}\"></div>\r\n    </div>\r\n    <div *ngIf=\"(userService.currentUser || model.embeddedMode) && model.userWasChecked\" class=\"user-interface\">\r\n      <div class=\"share button\" (click)=\"setEvent('Share')\">\r\n        <img [src]=\"model.getImage('images.Share.png')\" alt=\"\" />\r\n      </div>\r\n      <div class=\"publish button\" (click)=\"setEvent('Publish')\">\r\n        <span>{{ loc.get2(\"Buttons\", \"Publish\") }}</span>\r\n      </div>\r\n      <div class=\"localization button\" (click)=\"showInfo($event, 'Localization')\" [style.padding]=\"'3px 10px'\">\r\n        <span>{{ loc.currentLocalization ? loc.currentLocalization.cultureName.toUpperCase() : \"EN\" }}</span>\r\n      </div>\r\n      <div\r\n        *ngIf=\"!model.userIsAuthorized && !model.isWebView\"\r\n        class=\"login button\"\r\n        [style.padding]=\"'3px 10px'\"\r\n        (click)=\"setEvent('Login')\"\r\n      >\r\n        <span>{{ loc.get2(\"Cloud\", \"Login\") }}</span>\r\n      </div>\r\n      <div *ngIf=\"!model.userIsAuthorized && !model.isWebView\" class=\"signup button\" (click)=\"setEvent('Signup')\">\r\n        <span>{{ loc.get2(\"Cloud\", \"ButtonSignUp\") }}</span>\r\n      </div>\r\n      <div\r\n        class=\"user-info button\"\r\n        *ngIf=\"model.userIsAuthorized || model.isWebView\"\r\n        (click)=\"showInfo($event, 'User')\"\r\n      >\r\n        <span>{{\r\n          userService.currentUser\r\n            ? (userService.currentUser.firstName ? userService.currentUser.firstName : \"\") +\r\n              \" \" +\r\n              (userService.currentUser.lastName ? userService.currentUser.lastName : \"\")\r\n            : \"My1 Company\"\r\n        }}</span\r\n        ><img\r\n          *ngIf=\"userService?.currentUser?.picture\"\r\n          src=\"data:image/jpeg;base64,{{ userService?.currentUser?.picture }}\"\r\n          alt=\"\"\r\n        />\r\n        <div\r\n          *ngIf=\"!userService?.currentUser?.picture\"\r\n          class=\"custom-image\"\r\n          [style.background-color]=\"userService.getBackground(userService.currentUser)\"\r\n        >\r\n          <span [style.margin-top.px]=\"4\">{{\r\n            userService.currentUser\r\n              ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : \"\") +\r\n                (userService.currentUser.lastName ? userService.currentUser.lastName[0] : \"\")\r\n              : \"MC\"\r\n          }}</span>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <sti-file-ribbon-component *ngIf=\"this.currentRibbon == 'File'\"></sti-file-ribbon-component>\r\n  <sti-home-ribbon-component *ngIf=\"this.currentRibbon == 'Home'\"></sti-home-ribbon-component>\r\n  <sti-insert-ribbon-component\r\n    *ngIf=\"this.currentRibbon == 'Insert' && toolboxService.showInsertTab\"\r\n  ></sti-insert-ribbon-component>\r\n</div>\r\n\r\n<style>\r\n  .save-button img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .save-button {\r\n    height: 30px;\r\n    width: 30px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n    border-radius: 3px;\r\n  }\r\n  .save-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .label-container {\r\n    padding: 0px 12px;\r\n  }\r\n  .file-menu-button {\r\n    height: 30px;\r\n    margin-left: 3px;\r\n    min-width: 70px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    color: white;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    padding: 0px 10px;\r\n  }\r\n  .file-menu-button:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navigation-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .navigation-button {\r\n    height: 30px;\r\n    min-width: 60px;\r\n    margin-left: 3px;\r\n    display: flex;\r\n    flex-direction: column;\r\n    color: rgb(68, 68, 68);\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n  }\r\n  .navigation-label {\r\n    height: 27px;\r\n    width: 100%;\r\n    padding-top: 2px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    white-space: nowrap;\r\n  }\r\n  .current-indicator {\r\n    height: 3px;\r\n    margin: 0px 10px;\r\n  }\r\n  .navigation-button:hover .current-indicator {\r\n    margin: 0px;\r\n  }\r\n  .image-container {\r\n    position: absolute;\r\n    top: 43px;\r\n    height: 23px;\r\n    min-width: 83px;\r\n    border: 1px solid rgb(218, 218, 218);\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    justify-content: center;\r\n    background-color: white;\r\n    z-index: 99999999;\r\n  }\r\n  .image-container img {\r\n    height: 16px;\r\n    width: 16px;\r\n    margin: 5px 0px 0px 5px;\r\n  }\r\n  .image-container span {\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n  }\r\n  .image-container:hover {\r\n    background-color: rgb(226, 226, 226);\r\n  }\r\n  .image-container:active {\r\n    background-color: rgb(187, 187, 187);\r\n  }\r\n  .custom-image {\r\n    margin: 0px 5px;\r\n    height: 22px;\r\n    width: 22px;\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n    overflow: hidden;\r\n    border-radius: 40px;\r\n    color: White;\r\n    display: flex;\r\n    justify-content: center;\r\n  }\r\n  .user-info img {\r\n    width: 22px;\r\n    height: 22px;\r\n    margin: 0px 5px;\r\n    border-radius: 40px;\r\n  }\r\n  .button {\r\n    height: 30px;\r\n    min-width: 30px;\r\n    padding: 3px 5px;\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .share img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .user-interface {\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    align-items: center;\r\n    height: 30px;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    color: #444444;\r\n    flex: 1;\r\n  }\r\n  .signup {\r\n    background-color: #19478a;\r\n    color: #ffffff;\r\n    padding: 0px 17px;\r\n    margin-right: 3px;\r\n  }\r\n  .signup:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navbar {\r\n    height: 93px;\r\n    width: 100%;\r\n    display: flex;\r\n    flex-direction: column;\r\n    background-color: var(--back-color);\r\n    color: var(--text-color);\r\n  }\r\n  a span {\r\n    height: 100%;\r\n    padding: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-items: center;\r\n  }\r\n  .navigation {\r\n    position: relative;\r\n    display: flex;\r\n    justify-content: flex-start;\r\n    height: 38px;\r\n    align-items: center;\r\n    background-color: var(--back-color);\r\n    width: 100%;\r\n    padding-top: 1px;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    font-family: \"Segoe UI\";\r\n  }\r\n\r\n  .navigation a {\r\n    padding: 0px 10px;\r\n    height: 100%;\r\n    text-decoration: none;\r\n    text-align: center;\r\n    font-size: 13px;\r\n    cursor: default;\r\n    margin-right: 5px;\r\n    margin-left: 5px;\r\n  }\r\n  .navigation a:hover {\r\n    padding: 0;\r\n    background-color: var(--hover-color);\r\n  }\r\n  a:hover span {\r\n    padding-left: 13px;\r\n    padding-right: 13px;\r\n    width: 100%;\r\n  }\r\n  .current {\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .other {\r\n    background-color: transparent;\r\n  }\r\n</style>\r\n", styles: ["\n  .save-button img {\n    height: 16px;\n    width: 16px;\n  }\n  .save-button {\n    height: 30px;\n    width: 30px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    margin-left: 3px;\n    border-radius: 3px;\n  }\n  .save-button:hover {\n    background-color: rgb(218, 218, 218);\n  }\n  .label-container {\n    padding: 0px 12px;\n  }\n  .file-menu-button {\n    height: 30px;\n    margin-left: 3px;\n    min-width: 70px;\n    background-color: rgb(25, 71, 138);\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    color: white;\n    font-size: 12px;\n    font-family: Arial;\n    padding: 0px 10px;\n  }\n  .file-menu-button:hover {\n    background-color: rgb(61, 98, 152);\n  }\n  .navigation-button:hover {\n    background-color: rgb(218, 218, 218);\n  }\n  .navigation-button {\n    height: 30px;\n    min-width: 60px;\n    margin-left: 3px;\n    display: flex;\n    flex-direction: column;\n    color: rgb(68, 68, 68);\n    font-size: 12px;\n    font-family: Arial;\n  }\n  .navigation-label {\n    height: 27px;\n    width: 100%;\n    padding-top: 2px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    white-space: nowrap;\n  }\n  .current-indicator {\n    height: 3px;\n    margin: 0px 10px;\n  }\n  .navigation-button:hover .current-indicator {\n    margin: 0px;\n  }\n  .image-container {\n    position: absolute;\n    top: 43px;\n    height: 23px;\n    min-width: 83px;\n    border: 1px solid rgb(218, 218, 218);\n    border-radius: 3px;\n    display: flex;\n    align-items: center;\n    padding: 0px 10px;\n    justify-content: center;\n    background-color: white;\n    z-index: 99999999;\n  }\n  .image-container img {\n    height: 16px;\n    width: 16px;\n    margin: 5px 0px 0px 5px;\n  }\n  .image-container span {\n    font-family: Arial;\n    font-size: 12px;\n  }\n  .image-container:hover {\n    background-color: rgb(226, 226, 226);\n  }\n  .image-container:active {\n    background-color: rgb(187, 187, 187);\n  }\n  .custom-image {\n    margin: 0px 5px;\n    height: 22px;\n    width: 22px;\n    font-family: Arial;\n    font-size: 12px;\n    overflow: hidden;\n    border-radius: 40px;\n    color: White;\n    display: flex;\n    justify-content: center;\n  }\n  .user-info img {\n    width: 22px;\n    height: 22px;\n    margin: 0px 5px;\n    border-radius: 40px;\n  }\n  .button {\n    height: 30px;\n    min-width: 30px;\n    padding: 3px 5px;\n    border-radius: 3px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    margin-left: 3px;\n  }\n  .button:hover {\n    background-color: rgb(218, 218, 218);\n  }\n  .share img {\n    height: 16px;\n    width: 16px;\n  }\n  .user-interface {\n    display: flex;\n    justify-content: flex-end;\n    align-items: center;\n    height: 30px;\n    font-size: 12px;\n    font-family: Arial;\n    color: #444444;\n    flex: 1;\n  }\n  .signup {\n    background-color: #19478a;\n    color: #ffffff;\n    padding: 0px 17px;\n    margin-right: 3px;\n  }\n  .signup:hover {\n    background-color: rgb(61, 98, 152);\n  }\n  .navbar {\n    height: 93px;\n    width: 100%;\n    display: flex;\n    flex-direction: column;\n    background-color: var(--back-color);\n    color: var(--text-color);\n  }\n  a span {\n    height: 100%;\n    padding: 3px;\n    display: flex;\n    align-items: center;\n    justify-items: center;\n  }\n  .navigation {\n    position: relative;\n    display: flex;\n    justify-content: flex-start;\n    height: 38px;\n    align-items: center;\n    background-color: var(--back-color);\n    width: 100%;\n    padding-top: 1px;\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n    font-family: \"Segoe UI\";\n  }\n\n  .navigation a {\n    padding: 0px 10px;\n    height: 100%;\n    text-decoration: none;\n    text-align: center;\n    font-size: 13px;\n    cursor: default;\n    margin-right: 5px;\n    margin-left: 5px;\n  }\n  .navigation a:hover {\n    padding: 0;\n    background-color: var(--hover-color);\n  }\n  a:hover span {\n    padding-left: 13px;\n    padding-right: 13px;\n    width: 100%;\n  }\n  .current {\n    background-color: rgb(25, 71, 138);\n  }\n\n  .other {\n    background-color: transparent;\n  }\n"], dependencies: [{ kind: "directive", type: i11.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i12.StiHomeRibbonComponent, selector: "sti-home-ribbon-component" }, { kind: "component", type: i13.StiFileRibbonComponent, selector: "sti-file-ribbon-component" }, { kind: "component", type: i14.StiInsertRibbonComponent, selector: "sti-insert-ribbon-component" }, { kind: "directive", type: i15.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavbarComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-navbar", template: "<div class=\"navbar\" [style.visibility]=\"model.viewerMode ? 'hidden' : 'visible'\" [style.height.px]=\"componentHeight\">\r\n  <div\r\n    class=\"navigation\"\r\n    [style.border-bottom]=\"\r\n      model.isPreviewMode && !model.viewerMode ? '1px solid rgb(224,224,224)' : '1px solid transparent'\r\n    \"\r\n  >\r\n    <div\r\n      class=\"image-container\"\r\n      *ngIf=\"model.isPreviewMode && model.showEditButton\"\r\n      [style.right.px]=\"editButtonRight\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      (click)=\"editForm()\"\r\n    >\r\n      <img [style.margin]=\"model.isMobile() ? '0px' : '0px 5px 0px 0px'\" [src]=\"model.getImage('images.Edit.png')\" />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"MainMenu\", \"menuEditEdit\") }}</span>\r\n    </div>\r\n    <div\r\n      #saveButton\r\n      class=\"image-container\"\r\n      *ngIf=\"(model.viewerMode || model.isPreviewMode) && model.showSaveToPdfButton\"\r\n      [style.right.px]=\"15\"\r\n      [style.visibility]=\"'visible'\"\r\n      [style.top.px]=\"model.viewerMode ? 5 : 43\"\r\n      [style.min-width.px]=\"model.isMobile() ? 33 : 83\"\r\n      [stiTooltip]=\"loc.get2('A_WebViewer', 'SaveReport')\"\r\n      tooltipPosition=\"bottom\"\r\n      (click)=\"showPdfOption()\"\r\n    >\r\n      <img\r\n        [style.margin]=\"model.isMobile() ? '0px' : '1px 5px 0px 0px'\"\r\n        [src]=\"\r\n          model.isMobile() ? model.getImage('images.ReportSave.png') : model.getImage('images.Other.DownloadPDF.png')\r\n        \"\r\n      />\r\n      <span *ngIf=\"!model.isMobile()\">{{ loc.get2(\"Buttons\", \"Save\") }}</span>\r\n    </div>\r\n    <div class=\"save-button\" *ngIf=\"model.getBooleanSetting('showSaveButton')\" (click)=\"save()\">\r\n      <img [src]=\"model.getImage('images.Other.Save.png')\" />\r\n    </div>\r\n    <div class=\"file-menu-button\" *ngIf=\"model.getBooleanSetting('showFileButton')\" (click)=\"setRibbon('File')\">\r\n      <span>{{ loc.getP(\"File\") }}</span>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showHomeTab')\" (click)=\"setRibbon('Home')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"Toolbars\", \"TabHome\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Home') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"toolboxService.showInsertTab && model.getBooleanSetting('showInsertTab')\"\r\n      (click)=\"setRibbon('Insert')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"Insert\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Insert') }}\"></div>\r\n    </div>\r\n    <div class=\"navigation-button\" *ngIf=\"model.getBooleanSetting('showPreviewTab')\" (click)=\"setRibbon('Preview')\">\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.get2(\"FormDesigner\", \"Preview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('Preview') }}\"></div>\r\n    </div>\r\n    <div\r\n      class=\"navigation-button\"\r\n      *ngIf=\"model.getBooleanSetting('showPDFPreviewTab')\"\r\n      (click)=\"setRibbon('PDFPreview')\"\r\n    >\r\n      <div class=\"label-container\">\r\n        <div class=\"navigation-label\">\r\n          <span>{{ loc.getP(\"PDFPreview\") }}</span>\r\n        </div>\r\n      </div>\r\n      <div class=\"current-indicator {{ getClass('PDFPreview') }}\"></div>\r\n    </div>\r\n    <div *ngIf=\"(userService.currentUser || model.embeddedMode) && model.userWasChecked\" class=\"user-interface\">\r\n      <div class=\"share button\" (click)=\"setEvent('Share')\">\r\n        <img [src]=\"model.getImage('images.Share.png')\" alt=\"\" />\r\n      </div>\r\n      <div class=\"publish button\" (click)=\"setEvent('Publish')\">\r\n        <span>{{ loc.get2(\"Buttons\", \"Publish\") }}</span>\r\n      </div>\r\n      <div class=\"localization button\" (click)=\"showInfo($event, 'Localization')\" [style.padding]=\"'3px 10px'\">\r\n        <span>{{ loc.currentLocalization ? loc.currentLocalization.cultureName.toUpperCase() : \"EN\" }}</span>\r\n      </div>\r\n      <div\r\n        *ngIf=\"!model.userIsAuthorized && !model.isWebView\"\r\n        class=\"login button\"\r\n        [style.padding]=\"'3px 10px'\"\r\n        (click)=\"setEvent('Login')\"\r\n      >\r\n        <span>{{ loc.get2(\"Cloud\", \"Login\") }}</span>\r\n      </div>\r\n      <div *ngIf=\"!model.userIsAuthorized && !model.isWebView\" class=\"signup button\" (click)=\"setEvent('Signup')\">\r\n        <span>{{ loc.get2(\"Cloud\", \"ButtonSignUp\") }}</span>\r\n      </div>\r\n      <div\r\n        class=\"user-info button\"\r\n        *ngIf=\"model.userIsAuthorized || model.isWebView\"\r\n        (click)=\"showInfo($event, 'User')\"\r\n      >\r\n        <span>{{\r\n          userService.currentUser\r\n            ? (userService.currentUser.firstName ? userService.currentUser.firstName : \"\") +\r\n              \" \" +\r\n              (userService.currentUser.lastName ? userService.currentUser.lastName : \"\")\r\n            : \"My1 Company\"\r\n        }}</span\r\n        ><img\r\n          *ngIf=\"userService?.currentUser?.picture\"\r\n          src=\"data:image/jpeg;base64,{{ userService?.currentUser?.picture }}\"\r\n          alt=\"\"\r\n        />\r\n        <div\r\n          *ngIf=\"!userService?.currentUser?.picture\"\r\n          class=\"custom-image\"\r\n          [style.background-color]=\"userService.getBackground(userService.currentUser)\"\r\n        >\r\n          <span [style.margin-top.px]=\"4\">{{\r\n            userService.currentUser\r\n              ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : \"\") +\r\n                (userService.currentUser.lastName ? userService.currentUser.lastName[0] : \"\")\r\n              : \"MC\"\r\n          }}</span>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <sti-file-ribbon-component *ngIf=\"this.currentRibbon == 'File'\"></sti-file-ribbon-component>\r\n  <sti-home-ribbon-component *ngIf=\"this.currentRibbon == 'Home'\"></sti-home-ribbon-component>\r\n  <sti-insert-ribbon-component\r\n    *ngIf=\"this.currentRibbon == 'Insert' && toolboxService.showInsertTab\"\r\n  ></sti-insert-ribbon-component>\r\n</div>\r\n\r\n<style>\r\n  .save-button img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .save-button {\r\n    height: 30px;\r\n    width: 30px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n    border-radius: 3px;\r\n  }\r\n  .save-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .label-container {\r\n    padding: 0px 12px;\r\n  }\r\n  .file-menu-button {\r\n    height: 30px;\r\n    margin-left: 3px;\r\n    min-width: 70px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    color: white;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    padding: 0px 10px;\r\n  }\r\n  .file-menu-button:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navigation-button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .navigation-button {\r\n    height: 30px;\r\n    min-width: 60px;\r\n    margin-left: 3px;\r\n    display: flex;\r\n    flex-direction: column;\r\n    color: rgb(68, 68, 68);\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n  }\r\n  .navigation-label {\r\n    height: 27px;\r\n    width: 100%;\r\n    padding-top: 2px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    white-space: nowrap;\r\n  }\r\n  .current-indicator {\r\n    height: 3px;\r\n    margin: 0px 10px;\r\n  }\r\n  .navigation-button:hover .current-indicator {\r\n    margin: 0px;\r\n  }\r\n  .image-container {\r\n    position: absolute;\r\n    top: 43px;\r\n    height: 23px;\r\n    min-width: 83px;\r\n    border: 1px solid rgb(218, 218, 218);\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    justify-content: center;\r\n    background-color: white;\r\n    z-index: 99999999;\r\n  }\r\n  .image-container img {\r\n    height: 16px;\r\n    width: 16px;\r\n    margin: 5px 0px 0px 5px;\r\n  }\r\n  .image-container span {\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n  }\r\n  .image-container:hover {\r\n    background-color: rgb(226, 226, 226);\r\n  }\r\n  .image-container:active {\r\n    background-color: rgb(187, 187, 187);\r\n  }\r\n  .custom-image {\r\n    margin: 0px 5px;\r\n    height: 22px;\r\n    width: 22px;\r\n    font-family: Arial;\r\n    font-size: 12px;\r\n    overflow: hidden;\r\n    border-radius: 40px;\r\n    color: White;\r\n    display: flex;\r\n    justify-content: center;\r\n  }\r\n  .user-info img {\r\n    width: 22px;\r\n    height: 22px;\r\n    margin: 0px 5px;\r\n    border-radius: 40px;\r\n  }\r\n  .button {\r\n    height: 30px;\r\n    min-width: 30px;\r\n    padding: 3px 5px;\r\n    border-radius: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    margin-left: 3px;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(218, 218, 218);\r\n  }\r\n  .share img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .user-interface {\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    align-items: center;\r\n    height: 30px;\r\n    font-size: 12px;\r\n    font-family: Arial;\r\n    color: #444444;\r\n    flex: 1;\r\n  }\r\n  .signup {\r\n    background-color: #19478a;\r\n    color: #ffffff;\r\n    padding: 0px 17px;\r\n    margin-right: 3px;\r\n  }\r\n  .signup:hover {\r\n    background-color: rgb(61, 98, 152);\r\n  }\r\n  .navbar {\r\n    height: 93px;\r\n    width: 100%;\r\n    display: flex;\r\n    flex-direction: column;\r\n    background-color: var(--back-color);\r\n    color: var(--text-color);\r\n  }\r\n  a span {\r\n    height: 100%;\r\n    padding: 3px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-items: center;\r\n  }\r\n  .navigation {\r\n    position: relative;\r\n    display: flex;\r\n    justify-content: flex-start;\r\n    height: 38px;\r\n    align-items: center;\r\n    background-color: var(--back-color);\r\n    width: 100%;\r\n    padding-top: 1px;\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    font-family: \"Segoe UI\";\r\n  }\r\n\r\n  .navigation a {\r\n    padding: 0px 10px;\r\n    height: 100%;\r\n    text-decoration: none;\r\n    text-align: center;\r\n    font-size: 13px;\r\n    cursor: default;\r\n    margin-right: 5px;\r\n    margin-left: 5px;\r\n  }\r\n  .navigation a:hover {\r\n    padding: 0;\r\n    background-color: var(--hover-color);\r\n  }\r\n  a:hover span {\r\n    padding-left: 13px;\r\n    padding-right: 13px;\r\n    width: 100%;\r\n  }\r\n  .current {\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .other {\r\n    background-color: transparent;\r\n  }\r\n</style>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiDraggableService }, { type: i4.StiExportService }, { type: StiRectangleGeometryLayout }, { type: i5.StiThemeService }, { type: i6.StiLocalizationService }, { type: i7.StiToolboxService }, { type: i8.StiHttpClientService }, { type: i9.StiUserService }, { type: i10.StiFormCheckerService }]; }, propDecorators: { saveButton: [{
                type: ViewChild,
                args: ["saveButton"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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