import { Component } from "@angular/core";
import { StiModelService } from "../../services/model.service";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/theme.service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-form-checker.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
export class StiFooterComponent {
    constructor(model, helper, theme, loc, formCheckerService) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.formCheckerService = formCheckerService;
        this.isIncrement = false;
        this.isDecrement = false;
        this.model.isMobileViewer.subscribe(() => {
            setTimeout(() => {
                this.zoomByWidth();
            });
        });
        this.model.formEvents.subscribe((e) => {
            if (e.name == "SetZoomByPageWidth") {
                this.zoomByWidth();
            }
            else if (e.name == "SetZoomByOnePage") {
                this.zoomByOnePage();
            }
            else if (e.name == "SetDefaultZoom") {
                this.setDefaultZoom();
            }
        });
    }
    get themes() {
        return StiModelService.THEMES;
    }
    get cloud() {
        return this.loc.getP("StimulsoftCloud");
    }
    get size() {
        return this.model.zoom <= 1
            ? (this.model.zoom * 100).toFixed(0)
            : (100 + ((this.model.zoom - 1) / 3) * 100).toFixed(0);
    }
    get calculatedSize() {
        return (this.model.zoom * 100).toFixed(0);
    }
    get isMobileViewer() {
        return this.model.isMobile() && this.model.viewerMode;
    }
    get step() {
        return this.model.zoom <= 1 ? 10 : 1;
    }
    setSize(value) {
        if (value <= 100) {
            (this.model.zoom = value / 100).toFixed(1);
        }
        else {
            setTimeout(() => {
                this.model.zoom = Number((1 + ((value - 100) / 100) * 3).toFixed(1));
            });
        }
    }
    zoomByWidth() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let width = workspace["offsetWidth"];
        let pageElem = document.querySelectorAll(".page-container")[0];
        let pagetWithMaxWidth = this.model.form.pages.reduce((acc, curr) => (acc.width > curr.width ? acc : curr));
        this.model.zoom = width / (pagetWithMaxWidth.width + 30);
        setTimeout(() => {
            let rect = this.model.getPositionRelativeToForm(pageElem);
            if (this.isMobileViewer) {
                if (workspace.scrollLeft != workspace.scrollWidth - rect.width - 6) {
                    workspace.scrollLeft = workspace.scrollWidth - rect.width - 6;
                }
            }
            else {
                if (workspace.scrollLeft != (workspace.scrollWidth - rect.width) / 2) {
                    workspace.scrollLeft = (workspace.scrollWidth - rect.width) / 2;
                }
            }
        }, 0);
    }
    setDefaultZoom() {
        this.model.zoom = 1;
    }
    zoomByOnePage() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let height = workspace["offsetHeight"];
        let elementWithMaxHeight = this.model.form.pages.reduce((acc, curr) => (acc.height > curr.height ? acc : curr));
        let width = workspace["offsetWidth"];
        let elementWithMaxWidth = this.model.form.pages.reduce((acc, curr) => (acc.width > curr.width ? acc : curr));
        let currentCoef = height / (elementWithMaxHeight.height + 25) >
            width / (elementWithMaxWidth.width + (this.model.isPreviewMode ? 0 : 60))
            ? width / (elementWithMaxWidth.width + (this.model.isPreviewMode ? 0 : 60))
            : height / (elementWithMaxHeight.height + 25);
        this.model.zoom = currentCoef;
    }
    changeTheme() {
        this.theme.currentTheme = this.currentTheme;
    }
    clearTimers() {
        this.isIncrement = false;
        this.isDecrement = false;
        clearTimeout(this.timeout);
        clearInterval(this.interval);
    }
    iterate() {
        if (this.isIncrement) {
            this.model.zoom += 0.1;
        }
        else if (this.isDecrement) {
            this.model.zoom -= 0.1;
        }
    }
    setIncrementInterval() {
        this.isIncrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    setDecrementInterval() {
        this.isDecrement = true;
        this.iterate();
        let this_ = this;
        this.timeout = setTimeout(function () {
            this_.interval = setInterval(function () {
                this_.iterate();
            }, 50);
        }, 300);
    }
    ngOnInit() { }
}
StiFooterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFooterComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }, { token: i5.StiFormCheckerService }], target: i0.ɵɵFactoryTarget.Component });
StiFooterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiFooterComponent, selector: "sti-footer", ngImport: i0, template: "<div class=\"sti-footer\">\r\n  <div class=\"cloud-content\">\r\n    <div\r\n      class=\"warnings-container\"\r\n      *ngIf=\"formCheckerService.hasIssue\"\r\n      (click)=\"formCheckerService.displayFormsChecker()\"\r\n    >\r\n      <div class=\"vertical-line\"></div>\r\n      <div class=\"warning-panel\">\r\n        <img [src]=\"model.getImage('images.Form_Checker.Warning.png')\" />\r\n        <span class=\"warnings-count\">{{ formCheckerService.issuesCount }}</span>\r\n      </div>\r\n    </div>\r\n    <a\r\n      *ngIf=\"model.isCloudMode && model.viewerMode && model.basePlanIsTrial\"\r\n      href=\"https://cloud.stimulsoft.com/\"\r\n      target=\"_blank\"\r\n      >{{ cloud }}</a\r\n    >\r\n  </div>\r\n  <div class=\"zoom-buttons\" *ngIf=\"model.getBooleanSetting('showZoomButtons')\">\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'PageWidth')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByWidth()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomWidth.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'OnePage')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByOnePage()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomSize.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'ZoomTo100')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"setDefaultZoom()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.Zoom100.png')\" alt=\"\" />\r\n    </div>\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <label *ngIf=\"!isMobileViewer\"> {{ calculatedSize }}%</label>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' -'\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setDecrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomMinus.png')\" alt=\"\" />\r\n    </div>\r\n    <input\r\n      *ngIf=\"!isMobileViewer\"\r\n      type=\"range\"\r\n      min=\"10\"\r\n      max=\"200\"\r\n      [step]=\"step\"\r\n      [value]=\"size\"\r\n      (input)=\"setSize($event.target.value)\"\r\n    />\r\n    <div *ngIf=\"!isMobileViewer\" class=\"slider-vertical-line\"></div>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' +'\"\r\n      tooltipPosition=\"left\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setIncrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomPlus.png')\" alt=\"\" />\r\n    </div>\r\n  </div>\r\n\r\n  <!-- <p-dropdown\r\n        [options]=\"helper.themes\"\r\n        [(ngModel)]=\"currentTheme\"\r\n        optionLabel=\"name\"\r\n        optionValue=\"name\"\r\n        [style]=\"{ width: '100px',marginTop:'3px',marginRight:'5px' }\"\r\n        (onChange)=\"changeTheme()\"\r\n      ></p-dropdown> -->\r\n</div>\r\n<style>\r\n  .zoom-buttons {\r\n    width: fit-content;\r\n    display: flex;\r\n    position: relative;\r\n  }\r\n  .warnings-count {\r\n    margin-left: 5px;\r\n    font-size: 12px;\r\n  }\r\n  .warning-panel {\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    border-radius: 3px;\r\n    height: 100%;\r\n  }\r\n  .warnings-container {\r\n    display: flex;\r\n    position: absolute;\r\n    align-items: center;\r\n    top: 0;\r\n    right: 0;\r\n    height: 100%;\r\n  }\r\n  .warning-panel:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .cloud-content {\r\n    flex: 1;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    position: relative;\r\n  }\r\n  .vertical-line {\r\n    height: 32px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    border-right: 1px solid rgb(149, 171, 205);\r\n  }\r\n  .slider-vertical-line {\r\n    position: absolute;\r\n    height: 11px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    top: 11px;\r\n    right: 84px;\r\n    background-color: white;\r\n    pointer-events: none;\r\n  }\r\n  a {\r\n    font-size: 16px;\r\n    font-family: Arial;\r\n    cursor: pointer;\r\n    color: white;\r\n    text-decoration: none;\r\n  }\r\n  span {\r\n    font-size: 18px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n  .button {\r\n    height: 31px;\r\n    width: 32px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  .button:active {\r\n    background-color: rgb(0, 32, 80);\r\n  }\r\n  .sti-footer {\r\n    width: 100%;\r\n    height: 32px;\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    border-top: 1px solid var(--formBorder-color);\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    background-color: rgb(25, 71, 138);\r\n    font-family: \"Segoe UI\";\r\n    position: relative;\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"] {\r\n    margin-top: 3px;\r\n    margin-right: 3px;\r\n    margin-left: 3px;\r\n    width: 100px;\r\n    -webkit-appearance: none;\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"]:focus {\r\n    outline: none;\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-runnable-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n  input[type=\"range\"]::-moz-range-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    z-index: 11;\r\n  }\r\n  input[type=\"range\"]::-moz-range-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    border: 0;\r\n    background-color: transparent;\r\n  }\r\n\r\n  input[type=\"range\"]:focus::-webkit-slider-runnable-track {\r\n  }\r\n\r\n  input[type=\"range\"]:-webkit-slider-thumb:focus {\r\n  }\r\n\r\n  .sti-footer label {\r\n    margin-top: 7px;\r\n    margin-left: 5px;\r\n    width: 35px;\r\n    vertical-align: sub;\r\n    font-size: 12px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n</style>\r\n", styles: ["\n  .zoom-buttons {\n    width: fit-content;\n    display: flex;\n    position: relative;\n  }\n  .warnings-count {\n    margin-left: 5px;\n    font-size: 12px;\n  }\n  .warning-panel {\n    display: flex;\n    align-items: center;\n    padding: 0px 10px;\n    border-radius: 3px;\n    height: 100%;\n  }\n  .warnings-container {\n    display: flex;\n    position: absolute;\n    align-items: center;\n    top: 0;\n    right: 0;\n    height: 100%;\n  }\n  .warning-panel:hover {\n    background-color: rgb(18, 64, 120);\n  }\n  img {\n    height: 16px;\n    width: 16px;\n  }\n  .cloud-content {\n    flex: 1;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    position: relative;\n  }\n  .vertical-line {\n    height: 32px;\n    width: 1px;\n    margin-left: 3px;\n    margin-right: 3px;\n    border-right: 1px solid rgb(149, 171, 205);\n  }\n  .slider-vertical-line {\n    position: absolute;\n    height: 11px;\n    width: 1px;\n    margin-left: 3px;\n    margin-right: 3px;\n    top: 11px;\n    right: 84px;\n    background-color: white;\n    pointer-events: none;\n  }\n  a {\n    font-size: 16px;\n    font-family: Arial;\n    cursor: pointer;\n    color: white;\n    text-decoration: none;\n  }\n  span {\n    font-size: 18px;\n    font-weight: bold;\n    color: rgb(255, 255, 255);\n  }\n  .button {\n    height: 31px;\n    width: 32px;\n    background-color: rgb(25, 71, 138);\n    display: flex;\n    align-items: center;\n    justify-content: center;\n  }\n  .button:hover {\n    background-color: rgb(18, 64, 120);\n  }\n  .button:active {\n    background-color: rgb(0, 32, 80);\n  }\n  .sti-footer {\n    width: 100%;\n    height: 32px;\n    display: flex;\n    justify-content: flex-end;\n    border-top: 1px solid var(--formBorder-color);\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n    background-color: rgb(25, 71, 138);\n    font-family: \"Segoe UI\";\n    position: relative;\n  }\n\n  .sti-footer input[type=\"range\"] {\n    margin-top: 3px;\n    margin-right: 3px;\n    margin-left: 3px;\n    width: 100px;\n    -webkit-appearance: none;\n    background-color: rgb(25, 71, 138);\n  }\n\n  .sti-footer input[type=\"range\"]:focus {\n    outline: none;\n  }\n\n  input[type=\"range\"]::-webkit-slider-runnable-track {\n    width: 100%;\n    height: 2px;\n    cursor: default;\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\n    border-radius: 0px;\n    border: 0px solid rgb(255, 255, 255);\n  }\n  input[type=\"range\"]::-moz-range-track {\n    width: 100%;\n    height: 2px;\n    cursor: default;\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\n    border-radius: 0px;\n    border: 0px solid rgb(255, 255, 255);\n  }\n\n  input[type=\"range\"]::-webkit-slider-thumb {\n    height: 15px;\n    width: 15px;\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\n    background-repeat: no-repeat;\n    background-position: center;\n    cursor: default;\n    -webkit-appearance: none;\n    margin-top: -6px;\n    z-index: 11;\n  }\n  input[type=\"range\"]::-moz-range-thumb {\n    height: 15px;\n    width: 15px;\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\n    background-repeat: no-repeat;\n    background-position: center;\n    cursor: default;\n    -webkit-appearance: none;\n    margin-top: -6px;\n    border: 0;\n    background-color: transparent;\n  }\n\n  input[type=\"range\"]:focus::-webkit-slider-runnable-track {\n  }\n\n  input[type=\"range\"]:-webkit-slider-thumb:focus {\n  }\n\n  .sti-footer label {\n    margin-top: 7px;\n    margin-left: 5px;\n    width: 35px;\n    vertical-align: sub;\n    font-size: 12px;\n    font-weight: bold;\n    color: rgb(255, 255, 255);\n  }\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFooterComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-footer", template: "<div class=\"sti-footer\">\r\n  <div class=\"cloud-content\">\r\n    <div\r\n      class=\"warnings-container\"\r\n      *ngIf=\"formCheckerService.hasIssue\"\r\n      (click)=\"formCheckerService.displayFormsChecker()\"\r\n    >\r\n      <div class=\"vertical-line\"></div>\r\n      <div class=\"warning-panel\">\r\n        <img [src]=\"model.getImage('images.Form_Checker.Warning.png')\" />\r\n        <span class=\"warnings-count\">{{ formCheckerService.issuesCount }}</span>\r\n      </div>\r\n    </div>\r\n    <a\r\n      *ngIf=\"model.isCloudMode && model.viewerMode && model.basePlanIsTrial\"\r\n      href=\"https://cloud.stimulsoft.com/\"\r\n      target=\"_blank\"\r\n      >{{ cloud }}</a\r\n    >\r\n  </div>\r\n  <div class=\"zoom-buttons\" *ngIf=\"model.getBooleanSetting('showZoomButtons')\">\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'PageWidth')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByWidth()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomWidth.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'OnePage')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"zoomByOnePage()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomSize.png')\" alt=\"\" />\r\n    </div>\r\n    <div\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('Zoom', 'ZoomTo100')\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (click)=\"setDefaultZoom()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.Zoom100.png')\" alt=\"\" />\r\n    </div>\r\n    <div *ngIf=\"!isMobileViewer\" class=\"vertical-line\"></div>\r\n    <label *ngIf=\"!isMobileViewer\"> {{ calculatedSize }}%</label>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' -'\"\r\n      tooltipPosition=\"top\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setDecrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomMinus.png')\" alt=\"\" />\r\n    </div>\r\n    <input\r\n      *ngIf=\"!isMobileViewer\"\r\n      type=\"range\"\r\n      min=\"10\"\r\n      max=\"200\"\r\n      [step]=\"step\"\r\n      [value]=\"size\"\r\n      (input)=\"setSize($event.target.value)\"\r\n    />\r\n    <div *ngIf=\"!isMobileViewer\" class=\"slider-vertical-line\"></div>\r\n    <div\r\n      *ngIf=\"!isMobileViewer\"\r\n      class=\"button\"\r\n      [stiTooltip]=\"loc.get2('FormViewer', 'Zoom') + ' +'\"\r\n      tooltipPosition=\"left\"\r\n      showDelay=\"500\"\r\n      (mousedown)=\"setIncrementInterval()\"\r\n      (mouseup)=\"clearTimers()\"\r\n      (mouseleave)=\"clearTimers()\"\r\n    >\r\n      <img [src]=\"model.getImage('images.Other.ZoomPlus.png')\" alt=\"\" />\r\n    </div>\r\n  </div>\r\n\r\n  <!-- <p-dropdown\r\n        [options]=\"helper.themes\"\r\n        [(ngModel)]=\"currentTheme\"\r\n        optionLabel=\"name\"\r\n        optionValue=\"name\"\r\n        [style]=\"{ width: '100px',marginTop:'3px',marginRight:'5px' }\"\r\n        (onChange)=\"changeTheme()\"\r\n      ></p-dropdown> -->\r\n</div>\r\n<style>\r\n  .zoom-buttons {\r\n    width: fit-content;\r\n    display: flex;\r\n    position: relative;\r\n  }\r\n  .warnings-count {\r\n    margin-left: 5px;\r\n    font-size: 12px;\r\n  }\r\n  .warning-panel {\r\n    display: flex;\r\n    align-items: center;\r\n    padding: 0px 10px;\r\n    border-radius: 3px;\r\n    height: 100%;\r\n  }\r\n  .warnings-container {\r\n    display: flex;\r\n    position: absolute;\r\n    align-items: center;\r\n    top: 0;\r\n    right: 0;\r\n    height: 100%;\r\n  }\r\n  .warning-panel:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  img {\r\n    height: 16px;\r\n    width: 16px;\r\n  }\r\n  .cloud-content {\r\n    flex: 1;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    position: relative;\r\n  }\r\n  .vertical-line {\r\n    height: 32px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    border-right: 1px solid rgb(149, 171, 205);\r\n  }\r\n  .slider-vertical-line {\r\n    position: absolute;\r\n    height: 11px;\r\n    width: 1px;\r\n    margin-left: 3px;\r\n    margin-right: 3px;\r\n    top: 11px;\r\n    right: 84px;\r\n    background-color: white;\r\n    pointer-events: none;\r\n  }\r\n  a {\r\n    font-size: 16px;\r\n    font-family: Arial;\r\n    cursor: pointer;\r\n    color: white;\r\n    text-decoration: none;\r\n  }\r\n  span {\r\n    font-size: 18px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n  .button {\r\n    height: 31px;\r\n    width: 32px;\r\n    background-color: rgb(25, 71, 138);\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n  }\r\n  .button:hover {\r\n    background-color: rgb(18, 64, 120);\r\n  }\r\n  .button:active {\r\n    background-color: rgb(0, 32, 80);\r\n  }\r\n  .sti-footer {\r\n    width: 100%;\r\n    height: 32px;\r\n    display: flex;\r\n    justify-content: flex-end;\r\n    border-top: 1px solid var(--formBorder-color);\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    background-color: rgb(25, 71, 138);\r\n    font-family: \"Segoe UI\";\r\n    position: relative;\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"] {\r\n    margin-top: 3px;\r\n    margin-right: 3px;\r\n    margin-left: 3px;\r\n    width: 100px;\r\n    -webkit-appearance: none;\r\n    background-color: rgb(25, 71, 138);\r\n  }\r\n\r\n  .sti-footer input[type=\"range\"]:focus {\r\n    outline: none;\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-runnable-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n  input[type=\"range\"]::-moz-range-track {\r\n    width: 100%;\r\n    height: 2px;\r\n    cursor: default;\r\n    box-shadow: 0px 0px 0px rgb(255, 255, 255);\r\n    background: linear-gradient(to bottom, rgb(38, 87, 170) 0%, rgb(98, 135, 199) 50%);\r\n    border-radius: 0px;\r\n    border: 0px solid rgb(255, 255, 255);\r\n  }\r\n\r\n  input[type=\"range\"]::-webkit-slider-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    z-index: 11;\r\n  }\r\n  input[type=\"range\"]::-moz-range-thumb {\r\n    height: 15px;\r\n    width: 15px;\r\n    background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAYAAAB4zEQNAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAABESURBVHgBxY/dCQAgCIStCRyhUdukNmmERrKTfsAHe/WD4/BOBJMAcsj0IaqsTrdzfNPF0t4KBobmKdTZ3EBQoKF+swXwnjPbHIqL4gAAAABJRU5ErkJggg==\");\r\n    background-repeat: no-repeat;\r\n    background-position: center;\r\n    cursor: default;\r\n    -webkit-appearance: none;\r\n    margin-top: -6px;\r\n    border: 0;\r\n    background-color: transparent;\r\n  }\r\n\r\n  input[type=\"range\"]:focus::-webkit-slider-runnable-track {\r\n  }\r\n\r\n  input[type=\"range\"]:-webkit-slider-thumb:focus {\r\n  }\r\n\r\n  .sti-footer label {\r\n    margin-top: 7px;\r\n    margin-left: 5px;\r\n    width: 35px;\r\n    vertical-align: sub;\r\n    font-size: 12px;\r\n    font-weight: bold;\r\n    color: rgb(255, 255, 255);\r\n  }\r\n</style>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }, { type: i5.StiFormCheckerService }]; } });
//# sourceMappingURL=data:application/json;base64,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