import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-form-events-service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-undo-service";
import * as i6 from "@angular/common";
export class ContextMenuWindowComponent {
    constructor(model, helper, formEvents, loc, undoService) {
        this.model = model;
        this.helper = helper;
        this.formEvents = formEvents;
        this.loc = loc;
        this.undoService = undoService;
    }
    ngOnInit() { }
}
ContextMenuWindowComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ContextMenuWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.FormEventsService }, { token: i4.StiLocalizationService }, { token: i5.StiUndoService }], target: i0.ɵɵFactoryTarget.Component });
ContextMenuWindowComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ContextMenuWindowComponent, selector: "sti-context-menu-window", ngImport: i0, template: `
    <div [style.left.px]="model.contextMenuX" [style.top.px]="model.contextMenuY" class="context-menu">
      <div
        *ngIf="(model.selectedComponent || formEvents.copiedComponent) && !model.selectedPage"
        class="context-menu-container"
      >
        <div
          class="context-menu-item {{ undoService.undos.length < 2 ? 'disabled' : '' }}"
          (click)="undoService.undo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Undo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditUndo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ undoService.redos.length < 1 ? 'disabled' : '' }}"
          (click)="undoService.redo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Redo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditRedo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ !formEvents.hasCopy ? 'disabled' : '' }}"
          (click)="formEvents.pasteComponent($event)"
        >
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ formEvents.canCopy ? 'disabled' : '' }}" (click)="formEvents.copyComponent()">
          <img [src]="model.getImage('images.Ribbon.Copy.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCopy").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ formEvents.canCopy ? 'disabled' : '' }}" (click)="formEvents.cutComponent()">
          <img [src]="model.getImage('images.Ribbon.Cut.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCut").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.deleteComponent()">
          <img [src]="model.getImage('images.Ribbon.Delete.png')" /><span>{{ loc.get2("Buttons", "Delete") }}</span>
        </div>
      </div>

      <!-- //////////////////////////////////////////////////////////////////// -->

      <div *ngIf="model.selectedPage" class="context-menu-container">
        <div *ngIf="formEvents.hasCopy" class="context-menu-item" (click)="formEvents.pasteComponent($event)">
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveUp ? 'disabled' : '' }}" (click)="formEvents.moveUp()">
          <img [src]="model.getImage('images.Page.MovePageUp.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveUp")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveDown ? 'disabled' : '' }}" (click)="formEvents.moveDown()">
          <img [src]="model.getImage('images.Page.MovePageDown.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveDown")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertBefore()">
          <img [src]="model.getImage('images.Page.InsertPageBefore.png')" /><span>{{
            loc.get2("TableRibbon", "InsertAbove")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertAfter()">
          <img [src]="model.getImage('images.Page.InsertPageAfter.png')" /><span>{{
            loc.get2("TableRibbon", "InsertBelow")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canClear ? 'disabled' : '' }}" (click)="formEvents.clear()">
          <img [src]="model.getImage('images.Page.ClearContent.png')" /><span>{{
            loc.get2("MainMenu", "menuEditClearContents")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canDelete ? 'disabled' : '' }}" (click)="formEvents.delete()">
          <img [src]="model.getImage('images.Page.DeletePage.png')" /><span>{{
            loc.get2("FormViewer", "PageDelete")
          }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".context-menu{position:absolute;z-index:999999999999999;background-color:var(--back-color);min-height:20px;max-height:380px;min-width:200px;display:flex;border:1px solid #c6c6c6;color:#444;box-shadow:0 0 7px #0000004d;cursor:default;font-family:Arial;font-size:12px;padding:1px}.context-menu-container{height:100%;width:100%;display:flex;flex-direction:column;-webkit-user-select:none}.context-menu-item{display:flex;width:100%;height:26px;align-items:center;border-radius:3px}.context-menu-item:hover{background-color:#dadada}.context-menu-item img{height:16px;width:16px;margin-left:10px;margin-right:10px}.context-menu-item span{margin-right:10px}.disabled{opacity:.5;pointer-events:none}\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ContextMenuWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-context-menu-window", template: `
    <div [style.left.px]="model.contextMenuX" [style.top.px]="model.contextMenuY" class="context-menu">
      <div
        *ngIf="(model.selectedComponent || formEvents.copiedComponent) && !model.selectedPage"
        class="context-menu-container"
      >
        <div
          class="context-menu-item {{ undoService.undos.length < 2 ? 'disabled' : '' }}"
          (click)="undoService.undo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Undo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditUndo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ undoService.redos.length < 1 ? 'disabled' : '' }}"
          (click)="undoService.redo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Redo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditRedo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ !formEvents.hasCopy ? 'disabled' : '' }}"
          (click)="formEvents.pasteComponent($event)"
        >
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ formEvents.canCopy ? 'disabled' : '' }}" (click)="formEvents.copyComponent()">
          <img [src]="model.getImage('images.Ribbon.Copy.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCopy").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ formEvents.canCopy ? 'disabled' : '' }}" (click)="formEvents.cutComponent()">
          <img [src]="model.getImage('images.Ribbon.Cut.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCut").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.deleteComponent()">
          <img [src]="model.getImage('images.Ribbon.Delete.png')" /><span>{{ loc.get2("Buttons", "Delete") }}</span>
        </div>
      </div>

      <!-- //////////////////////////////////////////////////////////////////// -->

      <div *ngIf="model.selectedPage" class="context-menu-container">
        <div *ngIf="formEvents.hasCopy" class="context-menu-item" (click)="formEvents.pasteComponent($event)">
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveUp ? 'disabled' : '' }}" (click)="formEvents.moveUp()">
          <img [src]="model.getImage('images.Page.MovePageUp.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveUp")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveDown ? 'disabled' : '' }}" (click)="formEvents.moveDown()">
          <img [src]="model.getImage('images.Page.MovePageDown.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveDown")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertBefore()">
          <img [src]="model.getImage('images.Page.InsertPageBefore.png')" /><span>{{
            loc.get2("TableRibbon", "InsertAbove")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertAfter()">
          <img [src]="model.getImage('images.Page.InsertPageAfter.png')" /><span>{{
            loc.get2("TableRibbon", "InsertBelow")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canClear ? 'disabled' : '' }}" (click)="formEvents.clear()">
          <img [src]="model.getImage('images.Page.ClearContent.png')" /><span>{{
            loc.get2("MainMenu", "menuEditClearContents")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canDelete ? 'disabled' : '' }}" (click)="formEvents.delete()">
          <img [src]="model.getImage('images.Page.DeletePage.png')" /><span>{{
            loc.get2("FormViewer", "PageDelete")
          }}</span>
        </div>
      </div>
    </div>
  `, styles: [".context-menu{position:absolute;z-index:999999999999999;background-color:var(--back-color);min-height:20px;max-height:380px;min-width:200px;display:flex;border:1px solid #c6c6c6;color:#444;box-shadow:0 0 7px #0000004d;cursor:default;font-family:Arial;font-size:12px;padding:1px}.context-menu-container{height:100%;width:100%;display:flex;flex-direction:column;-webkit-user-select:none}.context-menu-item{display:flex;width:100%;height:26px;align-items:center;border-radius:3px}.context-menu-item:hover{background-color:#dadada}.context-menu-item img{height:16px;width:16px;margin-left:10px;margin-right:10px}.context-menu-item span{margin-right:10px}.disabled{opacity:.5;pointer-events:none}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.FormEventsService }, { type: i4.StiLocalizationService }, { type: i5.StiUndoService }]; } });
//# sourceMappingURL=data:application/json;base64,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