import * as i0 from '@angular/core';
import { EventEmitter, Component, ViewChild, Output, Input, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';

class StimulsoftDesignerComponent {
    constructor() {
        /**
         * Occurs when designer loaded
         */
        this.designerLoaded = new EventEmitter();
        this.id = 'aDesigner' + (Math.random() * 10000000).toString();
        this.loaded = false;
    }
    ngOnDestroy() {
        var _a, _b, _c;
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        let options = (_c = (_b = (_a = this.designerEl.nativeElement) === null || _a === void 0 ? void 0 : _a.firstChild) === null || _b === void 0 ? void 0 : _b.jsObject) === null || _c === void 0 ? void 0 : _c.options;
        try {
            clearTimeout(options.timerAjax);
        }
        catch (_d) { }
        try {
            clearTimeout(options.timerUpdateCache);
        }
        catch (_e) { }
        try {
            clearTimeout(options.timerAutoSave);
        }
        catch (_f) { }
    }
    ngOnInit() {
        this.addScript();
    }
    ngOnChanges(changes) {
        this.addScript();
    }
    addScript() {
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        this.chartScripts = document.createElement('Script');
        this.chartScripts.setAttribute('type', 'text/javascript');
        this.chartScripts.src = this.requestUrl;
        this.chartScripts.addEventListener('load', () => {
            if (!this.loaded) {
                try {
                    const options = new Stimulsoft.Designer.StiDesignerOptions();
                    this.loaded = true;
                    setTimeout(() => {
                        this.designerLoaded.next(null);
                    });
                    this.showDesigner();
                }
                catch (_a) { }
            }
        });
        this.head.appendChild(this.chartScripts);
    }
    showDesigner() {
        const options = new Stimulsoft.Designer.StiDesignerOptions();
        if (this.width) {
            options.width = this.width;
        }
        if (this.height) {
            options.height = this.height;
        }
        this.designer = new Stimulsoft.Designer.StiDesigner(options, 'StiDesigner', false);
        this.designer.renderHtml(this.designerEl.nativeElement);
    }
    get head() {
        return document.getElementsByTagName('head')[0];
    }
}
StimulsoftDesignerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
StimulsoftDesignerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StimulsoftDesignerComponent, selector: "stimulsoft-designer-angular", inputs: { requestUrl: "requestUrl", width: "width", height: "height" }, outputs: { designerLoaded: "designerLoaded" }, viewQueries: [{ propertyName: "designerEl", first: true, predicate: ["designer"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <div #designer [attr.id]="id">
      <ng-content></ng-content>
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerComponent, decorators: [{
            type: Component,
            args: [{ selector: 'stimulsoft-designer-angular', template: `
    <div #designer [attr.id]="id">
      <ng-content></ng-content>
    </div>
  ` }]
        }], ctorParameters: function () { return []; }, propDecorators: { designerEl: [{
                type: ViewChild,
                args: ['designer']
            }], designerLoaded: [{
                type: Output
            }], requestUrl: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }] } });

class StimulsoftDesignerModule {
}
StimulsoftDesignerModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
StimulsoftDesignerModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerModule, declarations: [StimulsoftDesignerComponent], imports: [CommonModule], exports: [StimulsoftDesignerComponent] });
StimulsoftDesignerModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerModule, imports: [CommonModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [StimulsoftDesignerComponent],
                    imports: [
                        CommonModule
                    ],
                    exports: [StimulsoftDesignerComponent]
                }]
        }] });

/*
 * Public API Surface of stimulsoft-designer-angular
 */

/**
 * Generated bundle index. Do not edit.
 */

export { StimulsoftDesignerComponent, StimulsoftDesignerModule };
//# sourceMappingURL=stimulsoft-designer-angular.mjs.map
