import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
export class StimulsoftDesignerComponent {
    constructor() {
        /**
         * Occurs when designer loaded
         */
        this.designerLoaded = new EventEmitter();
        this.id = 'aDesigner' + (Math.random() * 10000000).toString();
        this.loaded = false;
    }
    ngOnDestroy() {
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        let options = this.designerEl.nativeElement?.firstChild?.jsObject?.options;
        try {
            clearTimeout(options.timerAjax);
        }
        catch { }
        try {
            clearTimeout(options.timerUpdateCache);
        }
        catch { }
        try {
            clearTimeout(options.timerAutoSave);
        }
        catch { }
    }
    ngOnInit() {
        this.addScript();
    }
    ngOnChanges(changes) {
        this.addScript();
    }
    addScript() {
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        this.chartScripts = document.createElement('Script');
        this.chartScripts.setAttribute('type', 'text/javascript');
        this.chartScripts.src = this.requestUrl;
        this.chartScripts.addEventListener('load', () => {
            if (!this.loaded) {
                try {
                    const options = new Stimulsoft.Designer.StiDesignerOptions();
                    this.loaded = true;
                    setTimeout(() => {
                        this.designerLoaded.next(null);
                    });
                    this.showDesigner();
                }
                catch { }
            }
        });
        this.head.appendChild(this.chartScripts);
    }
    showDesigner() {
        const options = new Stimulsoft.Designer.StiDesignerOptions();
        if (this.width) {
            options.width = this.width;
        }
        if (this.height) {
            options.height = this.height;
        }
        this.designer = new Stimulsoft.Designer.StiDesigner(options, 'StiDesigner', false);
        this.designer.renderHtml(this.designerEl.nativeElement);
    }
    get head() {
        return document.getElementsByTagName('head')[0];
    }
}
StimulsoftDesignerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
StimulsoftDesignerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StimulsoftDesignerComponent, selector: "stimulsoft-designer-angular", inputs: { requestUrl: "requestUrl", width: "width", height: "height" }, outputs: { designerLoaded: "designerLoaded" }, viewQueries: [{ propertyName: "designerEl", first: true, predicate: ["designer"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <div #designer [attr.id]="id">
      <ng-content></ng-content>
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftDesignerComponent, decorators: [{
            type: Component,
            args: [{ selector: 'stimulsoft-designer-angular', template: `
    <div #designer [attr.id]="id">
      <ng-content></ng-content>
    </div>
  ` }]
        }], ctorParameters: function () { return []; }, propDecorators: { designerEl: [{
                type: ViewChild,
                args: ['designer']
            }], designerLoaded: [{
                type: Output
            }], requestUrl: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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