/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.utils;

import com.stimulsoft.web.utils.StiConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StiURLUtil {
    private static final Logger LOG = Logger.getLogger(StiURLUtil.class.getName());

    private StiURLUtil() {
    }

    public static String encode(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str, StiConstants.ENCODING.value);
            result = result.replaceAll("[+]", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "\u043d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c encode \u0441\u0442\u0440\u043e\u043a\u0438 " + str, e);
        }
        return result;
    }

    public static List<String> encode(String[] values) {
        ArrayList<String> result = new ArrayList<String>(values.length);
        for (String str : values) {
            result.add(StiURLUtil.encode(str));
        }
        return result;
    }

    public static String decode(String str) {
        String result = str;
        try {
            result = URLDecoder.decode(str, StiConstants.ENCODING.value);
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "\u043d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c decode \u0441\u0442\u0440\u043e\u043a\u0438 " + str, e);
        }
        return result;
    }
}

