/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.utils;

import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.web.utils.StiURLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class StiServletUtil {
    private static final Logger LOG = Logger.getLogger(StiServletUtil.class.getName());
    private static final String PARAMETERS_MSG = "Parameter map '%s'";
    private static final String QUERY_STRING_MSG = "Query string '%s'";
    private static final String PATERN_VALUE = "%s=[%s]";

    public static String getSystemVersion() {
        return "Java: " + System.getProperty("java.runtime.version") + ", OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
    }

    private StiServletUtil() {
    }

    public static InputStream print(HttpServletRequest request) {
        StiServletUtil.printParam(request);
        TreeMap<String, String> entries = new TreeMap<String, String>();
        entries.put("getCharacterEncoding", request.getCharacterEncoding());
        entries.put("getContentLength", "" + request.getContentLength());
        entries.put("getContentType", request.getContentType());
        entries.put("getLocale", request.getLocale() + "");
        entries.put("getProtocol", request.getProtocol());
        entries.put("getRequestURI", request.getRequestURL().toString());
        entries.put("getQueryString", request.getQueryString());
        entries.put("getRemoteAddr", request.getRemoteAddr());
        entries.put("getRemoteHost", request.getRemoteHost());
        entries.put("getScheme", request.getScheme());
        entries.put("getServerName", request.getServerName());
        entries.put("getServerPort", "" + request.getServerPort());
        entries.put("isSecure", "" + request.isSecure());
        entries.put("getAuthType", request.getAuthType());
        entries.put("getContextPath", request.getContextPath());
        entries.put("getMethod", request.getMethod());
        entries.put("getPathInfo", request.getPathInfo());
        entries.put("getPathTranslated", request.getPathTranslated());
        entries.put("getRemoteUser", request.getRemoteUser());
        entries.put("getRequestedSessionId", request.getRequestedSessionId());
        entries.put("getServletPath", request.getServletPath());
        entries.put("isRequestedSessionIdFromCookie", "" + request.isRequestedSessionIdFromCookie());
        entries.put("isRequestedSessionIdFromURL", "" + request.isRequestedSessionIdFromURL());
        entries.put("isRequestedSessionIdValid", "" + request.isRequestedSessionIdValid());
        StiServletUtil.print(entries);
        return StiServletUtil.printStream(request);
    }

    private static InputStream printStream(HttpServletRequest request) {
        InputStream print = null;
        try {
            print = StiIOUtil.print((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "", e);
        }
        return print;
    }

    public static void printParam(HttpServletRequest request) {
        LOG.severe(String.format(QUERY_STRING_MSG, request.getQueryString()));
        Map map = request.getParameterMap();
        Iterator it = map.entrySet().iterator();
        ArrayList<String> values = new ArrayList<String>();
        Iterator iterator = it;
        while (iterator.hasNext()) {
            Map.Entry param = iterator.next();
            values.add(String.format(PATERN_VALUE, param.getKey(), StiStringUtil.join(StiURLUtil.encode((String[])param.getValue()), (char)',')));
        }
        LOG.severe(String.format(PARAMETERS_MSG, StiStringUtil.join(values, (char)';')));
    }

    private static void print(Map<String, String> entries) {
        StringBuilder strb = new StringBuilder();
        for (Map.Entry<String, String> pair : entries.entrySet()) {
            strb.append(pair.getKey() + " - " + pair.getValue() + "\n");
        }
        LOG.severe(strb.toString());
    }
}

