/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class StiWebActionResult {
    private String contentType;
    private String fileName = null;
    private byte[] data = null;
    private boolean saveFileDialog = true;
    private boolean enableBrowserCache = false;

    public static StiWebActionResult stringResult(StiRequestParams requestParams, String data) throws UnsupportedEncodingException {
        return new StiWebActionResult(data);
    }

    public static StiWebActionResult jsonResult(StiRequestParams requestParams, HashMap<String, Object> data) throws UnsupportedEncodingException {
        String json = new JSONObject(data).toString();
        return StiWebActionResult.stringResult(requestParams, json);
    }

    public static StiWebActionResult errorResult(StiRequestParams requestParams, String data) throws UnsupportedEncodingException {
        if (requestParams.component == StiComponentType.Designer) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", data);
            return StiWebActionResult.jsonResult(requestParams, result);
        }
        return StiWebActionResult.stringResult(requestParams, "ServerError:" + data);
    }

    public static StiWebActionResult packedResult(String data) throws UnsupportedEncodingException, IOException {
        String base64 = StiGZipHelper.pack((String)data);
        return new StiWebActionResult(base64);
    }

    public static StiWebActionResult emptyReportResult() throws UnsupportedEncodingException {
        return new StiWebActionResult(String.format(StiLocalization.getValue((String)"Notices", (String)"IsNotSpecified").replace("{0}", "%s"), StiLocalization.getValue((String)"Components", (String)"StiReport")));
    }

    public void writeFile(StiHttpServletResponse response) throws IOException {
        response.setContentType(this.contentType);
        if (this.saveFileDialog && this.fileName != null) {
            response.addHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(this.fileName, "UTF-8").replace("+", "%20") + "\"");
        }
        if (this.data != null) {
            response.addHeader("Content-Length", String.valueOf(this.data.length));
            StiIOUtil.writeInputStream((OutputStream)response.getOutputStream(), (InputStream)new ByteArrayInputStream(this.data));
        }
    }

    public StiWebActionResult() throws UnsupportedEncodingException {
        this("");
    }

    public StiWebActionResult(String data) throws UnsupportedEncodingException {
        this(data, "text/plain");
    }

    public StiWebActionResult(String data, String contentType) throws UnsupportedEncodingException {
        this(data, contentType, null);
    }

    public StiWebActionResult(String data, String contentType, String fileName) throws UnsupportedEncodingException {
        this(data.getBytes("UTF-8"), fileName, contentType);
    }

    public StiWebActionResult(ByteArrayOutputStream stream, String fileName, String contentType) throws IOException {
        this(stream.toByteArray(), fileName, contentType, true);
        stream.close();
    }

    public StiWebActionResult(ByteArrayOutputStream stream, String fileName, String contentType, boolean saveFileDialog) throws IOException {
        this(stream.toByteArray(), fileName, contentType, saveFileDialog);
        stream.close();
    }

    public StiWebActionResult(byte[] binaryData, String fileName, String contentType) {
        this(binaryData, fileName, contentType, true);
    }

    public StiWebActionResult(byte[] binaryData, String contentType) {
        this(binaryData, "", contentType, false);
    }

    public StiWebActionResult(byte[] binaryData, String fileName, String contentType, boolean saveFileDialog) {
        this(binaryData, fileName, contentType, saveFileDialog, false);
    }

    public StiWebActionResult(byte[] binaryData, String fileName, String contentType, boolean saveFileDialog, boolean enableBrowserCache) {
        this.contentType = contentType;
        this.data = binaryData;
        this.fileName = fileName;
        this.saveFileDialog = saveFileDialog;
        this.enableBrowserCache = enableBrowserCache;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] binaryData) {
        this.data = binaryData;
    }

    public boolean isSaveFileDialog() {
        return this.saveFileDialog;
    }

    public void setSaveFileDialog(boolean saveFileDialog) {
        this.saveFileDialog = saveFileDialog;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEnableBrowserCache() {
        return this.enableBrowserCache;
    }

    public void setEnableBrowserCache(boolean enableBrowserCache) {
        this.enableBrowserCache = enableBrowserCache;
    }
}

