/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.range.ByteRange;
import com.stimulsoft.base.range.CharRange;
import com.stimulsoft.base.range.DateTimeRange;
import com.stimulsoft.base.range.DecimalRange;
import com.stimulsoft.base.range.DoubleRange;
import com.stimulsoft.base.range.FloatRange;
import com.stimulsoft.base.range.GuidRange;
import com.stimulsoft.base.range.IntRange;
import com.stimulsoft.base.range.LongRange;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.range.ShortRange;
import com.stimulsoft.base.range.StringRange;
import com.stimulsoft.base.range.TimeSpanRange;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiDialogInfoItem;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.enums.StiItemsInitializationType;
import com.stimulsoft.report.dictionary.enums.StiSelectionMode;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.engine.StiVariableHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StiVariablesHelper {
    protected static final Logger LOG = Logger.getLogger(StiVariablesHelper.class.getName());

    public static void applyReportBindingVariables(StiReport report, HashMap<String, Object> values) {
        if (values != null) {
            for (String key : values.keySet()) {
                for (StiVariable variable : report.getDictionary().getVariables()) {
                    if (variable.getName().equals(key)) {
                        variable.setValue(values.get(key) instanceof List ? "" : Func.Convert.toString((Object)values.get(key)));
                    }
                    if (variable.getDialogInfo().getBindingVariable() == null || !key.equals(variable.getDialogInfo().getBindingVariable().getName())) continue;
                    if (values.get(key) instanceof List) {
                        variable.getDialogInfo().getBindingVariable().getDialogInfo().setValuesBindingList((List[])values.get(key));
                        continue;
                    }
                    variable.getDialogInfo().getBindingVariable().setValue(Func.Convert.toString((Object)values.get(key)));
                }
            }
        }
    }

    public static void fillDialogInfoItems(StiReport report) {
        boolean isColumnsInitializationTypeItems = false;
        if (report != null && report.getDictionary() != null) {
            for (StiVariable variable : report.getDictionary().getVariables()) {
                if (!variable.getRequestFromUser() || variable.getDialogInfo().getItemsInitializationType() != StiItemsInitializationType.Columns || variable.getDialogInfo().getKeys() != null && variable.getDialogInfo().getKeys().size() != 0 && variable.getDialogInfo().getValues() != null && variable.getDialogInfo().getValues().size() != 0) continue;
                isColumnsInitializationTypeItems = true;
                break;
            }
        }
        if (isColumnsInitializationTypeItems) {
            report.getDictionary().connect();
            StiVariableHelper.FillItemsOfVariables((StiReport)report);
            report.getDictionary().Disconnect();
        }
    }

    private static String getVariableAlias(StiVariable variable) {
        if (!StiValidationUtil.isNullOrEmpty((String)variable.getAlias())) {
            return variable.getAlias();
        }
        return variable.getName();
    }

    private static String getBasicType(StiVariable variable) {
        if (variable.isRange()) {
            return "Range";
        }
        if (variable.isList()) {
            return "List";
        }
        if (variable.isNullable()) {
            return "NullableValue";
        }
        return "Value";
    }

    private static String getType(StiVariable variable) {
        if (variable.getType() == StiSystemTypeEnum.SystemString || variable.getType() == StiSystemTypeEnum.SystemString && (variable.isRange() || variable.isList())) {
            return "String";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemChar || variable.getType() == StiSystemTypeEnum.SystemChar && (variable.isNullable() || variable.isRange() || variable.isList())) {
            return "Char";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemBoolean || variable.getType() == StiSystemTypeEnum.SystemBoolean && (variable.isNullable() || variable.isList())) {
            return "Bool";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDateTime || variable.getType() == StiSystemTypeEnum.SystemDateTime && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "DateTime";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemTimeSpan || variable.getType() == StiSystemTypeEnum.SystemTimeSpan && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "TimeSpan";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemGuid || variable.getType() == StiSystemTypeEnum.SystemGuid && (variable.isList() || variable.isNullable() || variable.isRange())) {
            return "Guid";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDrawingImage || variable.getType() == StiSystemTypeEnum.SystemDrawingBitmap) {
            return "Image";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemFloat || variable.getType() == StiSystemTypeEnum.SystemFloat && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "Float";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDouble || variable.getType() == StiSystemTypeEnum.SystemDouble && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "Double";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemDecimal || variable.getType() == StiSystemTypeEnum.SystemDecimal && (variable.isNullable() || variable.isList() && variable.isRange())) {
            return "Decimal";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt32 || variable.getType() == StiSystemTypeEnum.SystemInt32 && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "Int";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt32 || variable.getType() == StiSystemTypeEnum.SystemUInt32 && variable.isNullable()) {
            return "Uint";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt16 || variable.getType() == StiSystemTypeEnum.SystemInt16 && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "Short";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt16 || variable.getType() == StiSystemTypeEnum.SystemUInt16 && variable.isNullable()) {
            return "Ushort";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemInt64 || variable.getType() == StiSystemTypeEnum.SystemInt64 && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "Long";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemUInt64 || variable.getType() == StiSystemTypeEnum.SystemUInt64 && variable.isNullable()) {
            return "Ulong";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemByte || variable.getType() == StiSystemTypeEnum.SystemByte && (variable.isNullable() || variable.isList() || variable.isRange())) {
            return "Byte";
        }
        if (variable.getType() == StiSystemTypeEnum.SystemSByte || variable.getType() == StiSystemTypeEnum.SystemSByte && variable.isNullable()) {
            return "Sbyte";
        }
        return "";
    }

    private static HashMap<String, Integer> getDateTimeObject(Object value) {
        if (value instanceof HashMap) {
            return (HashMap)value;
        }
        StiDateTime dateValue = StiDateTime.currentDate();
        if (value != null && !StiDateTime.ZERO.equals(value)) {
            try {
                dateValue = (StiDateTime)value;
            }
            catch (Exception e) {
                try {
                    if (value instanceof String) {
                        dateValue = StiDateTime.Parse((String)((String)value));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        HashMap<String, Integer> dateTime = new HashMap<String, Integer>();
        dateTime.put("year", dateValue.year());
        dateTime.put("month", dateValue.month());
        dateTime.put("day", dateValue.day());
        dateTime.put("hours", dateValue.hour());
        dateTime.put("minutes", dateValue.minute());
        dateTime.put("seconds", dateValue.second());
        return dateTime;
    }

    public static HashMap<String, HashMap<String, Object>> getVariables(StiReport report, HashMap<String, Object> values) {
        StiVariablesHelper.fillDialogInfoItems(report);
        HashMap<String, HashMap<String, Object>> variables = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Boolean> binding = new HashMap<String, Boolean>();
        Integer index = 0;
        if (report.getDictionary() != null) {
            for (StiVariable variable : report.getDictionary().getVariables()) {
                if (!variable.getRequestFromUser()) continue;
                if (variable.getDialogInfo().getBindingVariable() != null) {
                    binding.put(variable.getDialogInfo().getBindingVariable().getName(), true);
                }
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put("name", variable.getName());
                var.put("alias", StiVariablesHelper.getVariableAlias(variable));
                var.put("category", variable.getCategory());
                var.put("isCategory", variable.getIsCategory());
                var.put("readOnly", variable.getReadOnly());
                var.put("description", variable.getDescription());
                var.put("basicType", StiVariablesHelper.getBasicType(variable));
                var.put("type", StiVariablesHelper.getType(variable));
                var.put("allowUserValues", variable.getDialogInfo().getAllowUserValues());
                var.put("dateTimeType", variable.getDialogInfo() != null ? variable.getDialogInfo().getDateTimeType().name() : "");
                var.put("sortDirection", variable.getDialogInfo().getSortDirection().toString());
                var.put("sortField", variable.getDialogInfo().getSortField().toString());
                var.put("checkedStates", variable.getDialogInfo().checkedStates != null ? variable.getDialogInfo().checkedStates : null);
                ArrayList<HashMap<String, Object>> items = StiVariablesHelper.getItems(variable, values);
                var.put("items", items);
                if (values != null && values.containsKey(variable.getName())) {
                    var.put("value", variable.getDialogInfo().isBindingValue() && variable.getSystemType().isList() ? "" : values.get(variable.getName()));
                } else if (variable.getSelection() == StiSelectionMode.Nothing) {
                    var.put("value", "");
                } else if (variable.getSelection() == StiSelectionMode.First) {
                    var.put("value", items != null && items.size() > 0 ? items.get(0).get("key") : "");
                } else {
                    String value;
                    String string = value = variable.getInitBy() == StiVariableInitBy.Value ? variable.getValue() : report.get(variable.getName());
                    if (variable.isList() && value instanceof List && ((List)((Object)value)).size() == 0) {
                        var.put("value", "");
                    } else {
                        var.put("value", value);
                    }
                }
                var.put("key", variable.getInitBy() == StiVariableInitBy.Value ? variable.getValueObject() : (values != null && values.containsKey(variable.getName()) && variable.getSystemType().isTime() && report.get(variable.getName()) == null ? StiVariablesHelper.getDateTimeObject(values.get(variable.getName())) : report.get(variable.getName())));
                var.put("keyTo", "");
                HashMap<String, Object> selectedItem = null;
                if (items != null && items.size() > 0) {
                    if (variable.getSelection() == StiSelectionMode.First) {
                        selectedItem = items.get(0);
                    } else if (variable.getSelection() == StiSelectionMode.Nothing) {
                        selectedItem = new HashMap();
                        selectedItem.put("value", "");
                        selectedItem.put("key", variable.getType() == StiSystemTypeEnum.SystemDateTime ? StiVariablesHelper.getDateTimeObject(StiDateTime.currentDate()) : null);
                        selectedItem.put("keyTo", variable.getType() == StiSystemTypeEnum.SystemDateTime ? StiVariablesHelper.getDateTimeObject(StiDateTime.currentDate()) : null);
                    }
                    String stringValue = String.valueOf(var.get("value"));
                    for (HashMap<String, Object> item : items) {
                        if (!StiValidationUtil.equals((Object)String.valueOf(item.get("key")), (Object)stringValue)) continue;
                        selectedItem = item;
                        break;
                    }
                    if (selectedItem == null && variable.getDialogInfo().isBindingValue() && variable.getDialogInfo().getBindingVariable() != null && !Func.Convert.toBoolean(binding.get(variable.name))) {
                        selectedItem = items.get(0);
                    }
                }
                if ("Value".equals(var.get("basicType")) || "NullableValue".equals(var.get("basicType"))) {
                    if (selectedItem != null) {
                        var.put("key", selectedItem.get("key"));
                        var.put("value", selectedItem.get("value"));
                        if (variable.getDialogInfo().getAllowUserValues() || var.get("value") == null || var.get("value") instanceof String && "".equals(var.get("value"))) {
                            var.put("value", var.get("key"));
                        }
                        var.put("value", StiVariablesHelper.fixPoint(var.get("value")));
                        for (StiVariable bindingVariable : report.getDictionary().getVariables()) {
                            if (bindingVariable.getDialogInfo().getBindingVariable() == null || !StiValidationUtil.equals((Object)bindingVariable.getDialogInfo().getBindingVariable().getName(), (Object)variable.getName())) continue;
                            bindingVariable.getDialogInfo().getBindingVariable().setValueObject(var.get("key"));
                        }
                    }
                    if ("DateTime".equals(var.get("type"))) {
                        var.put("key", StiVariablesHelper.getDateTimeObject(var.get("key")));
                    }
                }
                if ("Range".equals(var.get("basicType"))) {
                    if ("DateTime".equals(var.get("type"))) {
                        var.put("key", StiVariablesHelper.getDateTimeObject(variable.getInitBy() == StiVariableInitBy.Value ? ((Range)report.getVariable(variable.getName())).getFromObject() : ((Range)report.get(variable.getName())).getFromObject()));
                    } else {
                        var.put("key", variable.getInitBy() == StiVariableInitBy.Value ? ((Range)report.getVariable(variable.getName())).getFromObject().toString() : ((Range)report.get(variable.getName())).getFromObject().toString());
                        var.put("key", StiVariablesHelper.fixPoint(var.get("key")));
                    }
                    if ("DateTime".equals(var.get("type"))) {
                        var.put("keyTo", StiVariablesHelper.getDateTimeObject(variable.getInitBy() == StiVariableInitBy.Value ? ((Range)report.getVariable(variable.getName())).getToObject() : ((Range)report.get(variable.getName())).getToObject()));
                    } else {
                        var.put("keyTo", variable.getInitBy() == StiVariableInitBy.Value ? ((Range)report.getVariable(variable.getName())).getToObject().toString() : ((Range)report.get(variable.getName())).getToObject().toString());
                        var.put("keyTo", StiVariablesHelper.fixPoint(var.get("keyTo")));
                    }
                }
                variables.put(index.toString(), var);
                Integer n = index;
                index = index + 1;
                Integer n2 = index;
            }
        }
        if (variables.size() > 0) {
            for (String name : binding.keySet()) {
                for (HashMap<String, Object> var : variables.values()) {
                    if (!StiValidationUtil.equals((Object)var.get("name"), (Object)name)) continue;
                    var.put("binding", true);
                }
            }
            return variables;
        }
        return variables.size() == 0 ? null : variables;
    }

    private static ArrayList<HashMap<String, Object>> getItems(StiVariable variable, HashMap<String, Object> values) {
        ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>();
        if (values != null && values.containsKey(variable.name) && variable.getSystemType().isList() && variable.getDialogInfo().getAllowUserValues()) {
            List currentItems;
            List list = currentItems = values.get(variable.name) instanceof List ? (List)values.get(variable.name) : null;
            if (currentItems != null) {
                for (Object itemValue : currentItems) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("key", Func.Convert.toString(itemValue));
                    if (variable.getSystemType().isList() && variable.getType() == StiSystemTypeEnum.SystemDateTime) {
                        try {
                            item.put("key", StiVariablesHelper.getDateTimeObject(StiDateTime.Parse((String)Func.Convert.toString(itemValue))));
                        }
                        catch (Exception e) {
                            item.put("key", null);
                        }
                    }
                    items.add(item);
                }
            }
            return items;
        }
        String valueBinding = variable.getDialogInfo().getBindingVariable() != null ? (variable.getDialogInfo().getBindingVariable().isList() && (variable.getDialogInfo().getBindingVariable().getDialogInfo().getValuesBindingList() == null || variable.getDialogInfo().getBindingVariable().getDialogInfo().getValuesBindingList().length == 0) ? null : variable.getDialogInfo().getBindingVariable().getValue()) : null;
        int index = 0;
        if (!(variable.getDialogInfo().getKeys() == null || variable.getDialogInfo().getKeys().size() == 0 || variable.getDialogInfo().getItemsInitializationType() != StiItemsInitializationType.Items && (variable.getDialogInfo().getItemsInitializationType() != StiItemsInitializationType.Columns || StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getKeysColumn()) && StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getValuesColumn())))) {
            List itemsVariable = variable.getDialogInfo().getDialogInfoItems(variable.getType());
            HashMap bindingValues = new HashMap();
            HashSet listKeys = new HashSet();
            for (StiDialogInfoItem itemVariable : itemsVariable) {
                ArrayList<Object> itemsVariableValueBinding = itemVariable.ValueBinding;
                if (itemsVariableValueBinding == null || itemsVariableValueBinding.size() == 0) {
                    if (itemVariable.ValueBinding != null) {
                        itemsVariableValueBinding = new ArrayList(itemVariable.ValueBinding);
                    } else {
                        itemsVariableValueBinding = new ArrayList<Object>();
                        itemsVariableValueBinding.add(null);
                    }
                }
                for (Object e : itemsVariableValueBinding) {
                    if (valueBinding != null && !StiValidationUtil.equals((Object)valueBinding, (Object)Func.Convert.toString(e)) && !StiVariablesHelper.containsBindingVariableValue(variable, Func.Convert.toString(e))) continue;
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("value", itemVariable.getValue());
                    item.put("key", itemVariable.getFrom() != null ? itemVariable.getFrom().toString() : (itemVariable.KeyObject != null ? itemVariable.KeyObject.toString() : null));
                    item.put("keyTo", itemVariable.getTo() != null ? itemVariable.getTo().toString() : null);
                    if (variable.getType() == StiSystemTypeEnum.SystemDateTime || variable.getType() == StiSystemTypeEnum.SystemDateTime && (variable.getSystemType().isRange() || variable.getSystemType().isList())) {
                        if (itemVariable.KeyObject != null) {
                            item.put("key", StiVariablesHelper.getDateTimeObject(itemVariable.KeyObject));
                        }
                        if (itemVariable.KeyObjectTo != null) {
                            item.put("keyTo", StiVariablesHelper.getDateTimeObject(itemVariable.KeyObjectTo));
                        }
                    }
                    if (!(!StiValidationUtil.isNullOrEmpty((String)valueBinding) && item.containsKey("key") && bindingValues.containsKey(item.get("key")) || listKeys.contains(item.get("key")))) {
                        items.add(item);
                        listKeys.add(item.get("key"));
                    }
                    if (StiValidationUtil.isNullOrEmpty((String)valueBinding)) continue;
                    bindingValues.put(item.get("key"), true);
                }
                ++index;
            }
        }
        return index > 0 ? items : null;
    }

    private static boolean containsBindingVariableValue(StiVariable variable, String value) {
        if (variable.getDialogInfo().isBindingValue() && variable.getDialogInfo().getBindingVariable() != null && variable.isList()) {
            String sValue = Func.Convert.toString((Object)value);
            try {
                if (!StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getBindingVariable().getValue())) {
                    JSONArray valuesArray = new JSONArray(variable.getDialogInfo().getBindingVariable().getValue());
                    if (valuesArray != null && value != null) {
                        for (int i = 0; i < valuesArray.length(); ++i) {
                            if (!StiValidationUtil.equals((Object)sValue, (Object)Func.Convert.toString((Object)valuesArray.getString(0)))) continue;
                            return true;
                        }
                    }
                } else if (variable.getDialogInfo().getBindingVariable().getDialogInfo().getValuesBindingList() != null) {
                    for (List bindingValues : variable.getDialogInfo().getBindingVariable().getDialogInfo().getValuesBindingList()) {
                        if (bindingValues == null || value == null) continue;
                        for (Object o : bindingValues) {
                            if (!StiValidationUtil.equals((Object)sValue, (Object)Func.Convert.toString(o))) continue;
                            return true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void applyReportParameters(StiReport report, HashMap<String, HashMap<String, Object>> parameters) {
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                StiVariable variable = report.getDictionary().getVariables().get(key);
                if (variable == null) continue;
                StiVariablesHelper.setVariableValue(report, key, parameters.get(key), variable.getType(), variable.isList(), variable.isRange(), variable.isNullable());
                StiVariablesHelper.setVariableLabel(report, variable, parameters.get(key));
            }
            report.setIsRendered(false);
        }
    }

    private static void setVariableLabel(StiReport report, StiVariable variable, Object value) {
        int labelIndex;
        if (variable != null && variable.getDialogInfo().getKeys() != null && variable.getDialogInfo().getKeys().size() > 0 && variable.getDialogInfo().getValues() != null && variable.getDialogInfo().getValues().size() > 0 && value != null && (labelIndex = variable.getDialogInfo().getKeys().indexOf(value.toString())) >= 0 && labelIndex < variable.getDialogInfo().getValues().size()) {
            String label = (String)variable.getDialogInfo().getValues().get(labelIndex);
            StiVariableHelper.setVariableLabel((StiReport)report, (StiVariable)variable, (String)label);
        }
    }

    private static void setVariableValue(StiReport report, String paramName, Object paramValue, StiSystemTypeEnum type, boolean isList, boolean isRange, boolean isNullable) {
        JSONObject jsonObj = null;
        List jsonArray = null;
        if (paramValue != null) {
            if (paramValue instanceof JSONObject) {
                jsonObj = (JSONObject)paramValue;
            } else if (paramValue instanceof List) {
                jsonArray = (List)paramValue;
            } else if (paramValue instanceof HashMap) {
                jsonObj = new JSONObject((Map)((HashMap)paramValue));
            }
        }
        if (!isRange && !isList) {
            Object value = paramValue;
            try {
                if (type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemSingle) {
                    value = Float.valueOf(0.0f);
                    try {
                        value = Float.valueOf(Float.parseFloat(paramValue.toString().replaceAll(",", ".")));
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemDouble) {
                    value = 0.0;
                    try {
                        value = Double.parseDouble(paramValue.toString().replaceAll(",", "."));
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemDecimal) {
                    value = new BigDecimal(0);
                    try {
                        value = new BigDecimal(paramValue.toString().replaceAll(",", "."));
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32) {
                    value = 0;
                    try {
                        value = Integer.parseInt(paramValue.toString().replaceAll(",", "."));
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16) {
                    value = 0;
                    try {
                        value = Short.parseShort(paramValue.toString().replaceAll(",", "."));
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64) {
                    value = 0;
                    try {
                        value = Long.parseLong(paramValue.toString().replaceAll(",", "."));
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemByte) {
                    value = 0;
                    try {
                        value = Byte.parseByte(paramValue.toString().replaceAll(",", "."));
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemChar) {
                    value = Character.valueOf(' ');
                    try {
                        value = Character.valueOf(paramValue.toString().length() > 0 ? paramValue.toString().charAt(0) : (char)' ');
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemDateTime) {
                    value = StiDateTime.currentDate();
                    value = 0;
                    try {
                        value = StiDateTime.fromString((String)paramValue.toString());
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemTimeSpan) {
                    value = StiTimeSpan.ZERO;
                    value = 0;
                    try {
                        value = StiTimeSpan.valueOf((String)paramValue.toString());
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemGuid) {
                    value = StiGuid.EMPTY;
                    value = 0;
                    try {
                        value = new StiGuid(paramValue.toString());
                    }
                    catch (Exception exception) {}
                } else if (type == StiSystemTypeEnum.SystemBoolean) {
                    value = false;
                    try {
                        value = Boolean.parseBoolean(paramValue.toString().toLowerCase());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                if (report != null) {
                    report.WriteToReportRenderingMessages("Unable to parse value: " + paramValue);
                }
                LOG.log(Level.SEVERE, "Unable to parse value: " + paramValue, e);
            }
            if (isNullable && paramValue == null) {
                value = null;
            }
            report.getDictionary().getVariables().get(paramName).setValue(value);
            report.getVariables().put(paramName, value);
        } else if (isRange) {
            StringRange rangeResult = null;
            String from = (String)jsonObj.opt("from");
            String to = (String)jsonObj.opt("to");
            if (type == StiSystemTypeEnum.SystemString) {
                rangeResult = new StringRange(from, to);
            } else if (type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemSingle) {
                float valueFrom = 0.0f;
                float valueTo = 0.0f;
                try {
                    valueFrom = Float.parseFloat(from.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = Float.parseFloat(to.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new FloatRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemDouble) {
                double valueFrom = 0.0;
                double valueTo = 0.0;
                try {
                    valueFrom = Double.parseDouble(from.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = Double.parseDouble(to.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new DoubleRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemDecimal) {
                BigDecimal valueFrom = new BigDecimal(0);
                BigDecimal valueTo = new BigDecimal(0);
                try {
                    valueFrom = new BigDecimal(from.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = new BigDecimal(to.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new DecimalRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32) {
                int valueFrom = 0;
                int valueTo = 0;
                try {
                    valueFrom = Integer.parseInt(from.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = Integer.parseInt(to.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new IntRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16) {
                short valueFrom = 0;
                short valueTo = 0;
                try {
                    valueFrom = Short.parseShort(from.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = Short.parseShort(to.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new ShortRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64) {
                long valueFrom = 0L;
                long valueTo = 0L;
                try {
                    valueFrom = Long.parseLong(from.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = Long.parseLong(to.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new LongRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemByte) {
                byte valueFrom = 0;
                byte valueTo = 0;
                try {
                    valueFrom = Byte.parseByte(from.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = Byte.parseByte(to.replaceAll(",", "."));
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new ByteRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemChar) {
                char valueFrom = from.length() > 0 ? (char)from.charAt(0) : (char)' ';
                char valueTo = to.length() > 0 ? (char)to.charAt(0) : (char)' ';
                rangeResult = new CharRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemDateTime) {
                StiDateTime valueFrom = StiDateTime.currentDate();
                StiDateTime valueTo = StiDateTime.currentDate();
                try {
                    valueFrom = StiDateTime.fromString((String)from);
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = StiDateTime.fromString((String)to);
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new DateTimeRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemTimeSpan) {
                StiTimeSpan valueFrom = StiTimeSpan.ZERO;
                StiTimeSpan valueTo = StiTimeSpan.ZERO;
                try {
                    valueFrom = StiTimeSpan.valueOf((String)from);
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = StiTimeSpan.valueOf((String)to);
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new TimeSpanRange(valueFrom, valueTo);
            } else if (type == StiSystemTypeEnum.SystemGuid) {
                StiGuid valueFrom = StiGuid.EMPTY;
                StiGuid valueTo = StiGuid.EMPTY;
                try {
                    valueFrom = new StiGuid(from);
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + from);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + from, e);
                }
                try {
                    valueTo = new StiGuid(to);
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages("Unable to parse value: " + to);
                    }
                    LOG.log(Level.SEVERE, "Unable to parse value: " + to, e);
                }
                rangeResult = new GuidRange(valueFrom, valueTo);
            }
            report.getDictionary().getVariables().get(paramName).setValue(rangeResult != null ? rangeResult.serialize() : null);
            if (rangeResult != null) {
                report.getVariables().put(paramName, (Object)rangeResult);
            } else {
                report.getVariables().remove((Object)paramName);
            }
        } else if (isList) {
            ArrayList<String> listResult = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                try {
                    listResult.add(jsonArray.get(i).toString());
                    continue;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "", e);
                }
            }
            StiVariable variable = report.getDictionary().getVariables().get(paramName);
            variable.setInitBy(StiVariableInitBy.Value);
            if (variable.getDialogInfo().getKeys() == null || variable.getDialogInfo().getKeys().size() == 0) {
                report.getDictionary().getVariables().get(paramName).getDialogInfo().setKeys(listResult);
                report.getDictionary().getVariables().get(paramName).getDialogInfo().setValues(listResult);
            }
            report.getVariables().put(paramName, listResult);
        }
    }

    private static Object fixPoint(Object value) {
        if (value instanceof String && value != null && ((String)value).indexOf(".") > 0) {
            try {
                Double dValue = Double.parseDouble((String)value);
                return StiTextUtil.toString((Object)dValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value;
    }
}

