/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.service.StiPdfExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiPdfAutoPrintMode;
import com.stimulsoft.web.helper.StiReportHelper;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class StiReportResponse {
    public static void printAsPdf(StiHttpServletResponse response, StiReport report) throws StiException, IOException {
        StiReportResponse.printAsPdf(response, report, StiPagesRange.All);
    }

    public static void printAsPdf(StiHttpServletResponse response, StiReport report, StiPagesRange pageRange) throws StiException, IOException {
        StiPdfExportSettings settings = new StiPdfExportSettings();
        settings.setPageRange(pageRange);
        StiReportResponse.printAsPdf(response, report, settings);
    }

    public static void printAsPdf(StiHttpServletResponse response, StiReport report, StiPdfExportSettings settings) throws StiException, IOException {
        settings.setAutoPrintMode(StiPdfAutoPrintMode.Dialog);
        StiReportResponse.responseAsPdf(response, report, settings, false);
    }

    public static void printAsHtml(StiHttpServletResponse response, StiReport report) throws UnsupportedEncodingException, IOException, StiException {
        StiReportResponse.printAsHtml(response, report, StiPagesRange.All);
    }

    public static void printAsHtml(StiHttpServletResponse response, StiReport report, StiPagesRange pageRange) throws UnsupportedEncodingException, IOException, StiException {
        StiHtmlExportSettings settings = new StiHtmlExportSettings();
        settings.setPageRange(pageRange);
        StiReportResponse.printAsHtml(response, report, settings);
    }

    public static void printAsHtml(StiHttpServletResponse response, StiReport report, StiHtmlExportSettings settings) throws UnsupportedEncodingException, IOException, StiException {
        if (!report.isRendered) {
            report.Render(false);
        }
        settings.setChartType(StiHtmlChartType.Image);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StiHtmlExportService export = new StiHtmlExportService();
        export.exportHtml(report, (OutputStream)stream, settings);
        String html = stream.toString("UTF-8");
        html = html.replace("<body", "<body onload='window.print()'");
        StiReportResponse.responseBuffer(response, html.getBytes("UTF-8"), "text/html", false, null, false);
    }

    public static void responseAsPdf(StiHttpServletResponse response, StiReport report, StiPdfExportSettings settings, boolean saveFileDialog) throws StiException, IOException {
        if (!report.isRendered) {
            report.Render(false);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StiPdfExportService export = new StiPdfExportService();
        export.exportPdf(report, (OutputStream)stream, settings);
        StiReportResponse.responseStream(response, stream, "application/pdf", false, StiReportHelper.getReportFileName(report) + ".pdf", saveFileDialog);
    }

    public static void responseStream(StiHttpServletResponse response, ByteArrayOutputStream stream, String contentType, boolean browserCache, String fileName, boolean saveFileDialog) throws IOException {
        StiReportResponse.responseBuffer(response, stream.toByteArray(), contentType, browserCache, fileName, saveFileDialog);
    }

    public static void responseBuffer(StiHttpServletResponse response, byte[] buffer, String contentType, boolean browserCache, String fileName, boolean saveFileDialog) throws IOException {
        if (browserCache || !StiValidationUtil.isNullOrEmpty((String)fileName)) {
            response.setHeader("Cache-Control", "public, max-age=31536000");
        } else {
            response.setHeader("Cache-Control", "public, max-age=1");
        }
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Length", String.valueOf(buffer.length));
        if (!StiValidationUtil.isNullOrEmpty((String)fileName)) {
            String value = String.format("%s; filename=\"%s\"; filename*=UTF-8''%s", saveFileDialog ? "attachment" : "inline", fileName, URLEncoder.encode(fileName, "UTF-8"));
            response.addHeader("Content-Disposition", value);
        }
        StiIOUtil.writeInputStream((OutputStream)response.getOutputStream(), (InputStream)new ByteArrayInputStream(buffer));
    }
}

