/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.drawing.StiBytesFromURL;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.web.helper.StiEncodingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StiGalleriesHelper {
    public static String getHtmlStringFromRichTextItem(StiReport report, HashMap<String, Object> itemObject) {
        if (itemObject == null) {
            return "";
        }
        try {
            String type = (String)itemObject.get("type");
            String name = (String)itemObject.get("name");
            if ("StiResource".equals(type)) {
                StiResource resource = StiGalleriesHelper.getResource(report, name);
                if (resource != null && resource.content != null) {
                    String text = new String(resource.content);
                    text = StiRtfHelper.isRtfText((String)text) ? StiRtfHelper.rtfToPlain((String)text) : StiGalleriesHelper.getHtmlTextFromText(text);
                    return StiEncodingHelper.encode(text);
                }
            } else if ("StiVariable".equals(type)) {
                StiVariable variable = StiGalleriesHelper.getVariable(report, name);
                if (variable != null && variable.getValueObject() != null) {
                    String text = (String)variable.getValueObject();
                    text = StiRtfHelper.isRtfText((String)text) ? "" : StiGalleriesHelper.getHtmlTextFromText(text);
                    return StiEncodingHelper.encode(text);
                }
            } else if (itemObject.get("url") != null) {
                return StiEncodingHelper.encode(new String(StiBytesFromURL.load((String)((String)itemObject.get("url"))), "UTF-8"));
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public static String getHtmlTextFromText(String text) {
        return text.replaceAll("\r\n", "<br>").replaceAll("\n", "<br>");
    }

    private static StiResource getResource(StiReport report, String resourceName) {
        if (report == null || StiValidationUtil.isNullOrWhiteSpace((String)resourceName)) {
            return null;
        }
        resourceName = resourceName.toLowerCase().trim();
        for (StiResource res : report.getDictionary().getResources()) {
            if (res.getName() == null || !res.getName().trim().equalsIgnoreCase(resourceName)) continue;
            return res;
        }
        return null;
    }

    private static StiVariable getVariable(StiReport report, String variableName) {
        if (report == null || StiValidationUtil.isNullOrWhiteSpace((String)variableName)) {
            return null;
        }
        variableName = variableName.toLowerCase().trim();
        for (StiVariable var : report.getDictionary().getVariables()) {
            if (var.getName() == null || !var.getName().trim().equalsIgnoreCase(variableName)) continue;
            return var;
        }
        return null;
    }

    public static List<StiDataColumn> getImageColumns(StiReport report) {
        ArrayList<StiDataColumn> result = new ArrayList<StiDataColumn>();
        for (StiDataSource source : report.getDictionary().getDataSources()) {
            for (StiDataColumn column : source.getColumns()) {
                if (column.getType() != StiSystemTypeEnum.SystemDrawingImage && column.getType() != StiSystemTypeEnum.SystemDrawingBitmap && column.getType() != StiSystemTypeEnum.SystemByteArray) continue;
                result.add(column);
            }
        }
        return result;
    }

    public static StiImage getImageFromColumn(StiDataColumn column, StiReport report) {
        String columnPath = column.getColumnPath();
        List datas = StiDataColumn.getDataListFromDataColumn((StiDictionary)report.getDictionary(), (String)columnPath, (Integer)3);
        for (Object data : datas) {
            if (data == null || !StiImageHelper.isImage(data)) continue;
            try {
                StiImage image = StiImageHelper.getImageFromObject(data);
                if (image == null) continue;
                return image;
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static List<StiVariable> getImageVariables(StiReport report) {
        ArrayList<StiVariable> result = new ArrayList<StiVariable>();
        for (StiVariable variable : report.getDictionary().getVariables()) {
            if (variable.getType() != StiSystemTypeEnum.SystemDrawingBitmap && variable.getType() != StiSystemTypeEnum.SystemDrawingImage) continue;
            result.add(variable);
        }
        return result;
    }

    public static List<StiVariable> getRichTextVariables(StiReport report) {
        ArrayList<StiVariable> result = new ArrayList<StiVariable>();
        for (StiVariable variable : report.getDictionary().getVariables()) {
            if (!(variable.getValueObject() instanceof String)) continue;
            result.add(variable);
        }
        return result;
    }

    public static List<StiResource> getRichTextResources(StiReport report) {
        ArrayList<StiResource> result = new ArrayList<StiResource>();
        for (StiResource resource : report.getDictionary().getResources()) {
            if (resource.getType() != StiResourceType.Rtf && resource.getType() != StiResourceType.Txt || resource.getContent() == null) continue;
            result.add(resource);
        }
        return result;
    }

    public static List<StiResource> getImageResources(StiReport report) {
        ArrayList<StiResource> result = new ArrayList<StiResource>();
        for (StiResource resource : report.getDictionary().getResources()) {
            if (resource.getType() != StiResourceType.Image || resource.getContent() == null) continue;
            result.add(resource);
        }
        return result;
    }
}

