/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.utils;

import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.io.StiFileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StiXmlUtil {
    private StiXmlUtil() {
    }

    public static DocumentBuilderFactory getBuilderFactory() {
        try {
            return (DocumentBuilderFactory)Class.forName("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl").newInstance();
        }
        catch (Exception e) {
            return DocumentBuilderFactory.newInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocumentInFile(Document document, String fileName, boolean formatOutput) throws TransformerException, IOException {
        FileWriter out = null;
        try {
            out = new FileWriter(fileName);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            if (formatOutput) {
                serializer.setOutputProperties(StiXmlUtil.formatXml());
            }
            serializer.transform(new DOMSource(document), new StreamResult(out));
            ((Writer)out).flush();
        }
        catch (Throwable throwable) {
            StiCloseUtil.close(out);
            throw throwable;
        }
        StiCloseUtil.close((Closeable)out);
    }

    public static void xmlDocumentToOutputStream(Document document, OutputStream out, boolean formatOutput) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        if (formatOutput) {
            serializer.setOutputProperties(StiXmlUtil.formatXml());
        }
        serializer.transform(new DOMSource(document), new StreamResult(out));
    }

    private static Properties formatXml() {
        Properties props = new Properties();
        props.put("indent", "yes");
        props.put("{http://xml.apache.org/xslt}indent-amount", "2");
        return props;
    }

    public static String convertXMLFileToString(Document doc) {
        try {
            StringWriter stw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.transform(new DOMSource(doc), new StreamResult(stw));
            return stw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseXmlFile(String name) {
        return StiXmlUtil.parseXmlFile(new File(name));
    }

    public static Document parseXmlInputStream(InputStream inputStream) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            return db.parse(inputSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    public static Document parseXmlFile(File file) {
        Document document;
        InputStream inputStream = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            inputStream = StiFileUtil.openInputStream(file);
            inputStream = StiFileUtil.removeUtf8BOM(inputStream);
            InputSource inputSource = new InputSource(inputStream);
            document = db.parse(inputSource);
        }
        catch (Exception e) {
            Document db = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            StiCloseUtil.close((Closeable)inputStream);
            return db;
            {
                catch (ParserConfigurationException e1) {
                    try {
                        e1.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        StiCloseUtil.close(inputStream);
                        throw throwable;
                    }
                }
            }
        }
        StiCloseUtil.close((Closeable)inputStream);
        return document;
    }

    public static Document parseFromString(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document parse = builder.parse(new InputSource(new StringReader(xmlString)));
            return parse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isElementNode(Node node) {
        return node.getNodeType() == 1;
    }

    public static boolean isTextNode(Node node) {
        return node.getNodeType() == 3;
    }

    public static boolean isAttributeNode(Node node) {
        return node.getNodeType() == 2;
    }

    public static void processRelations(Element element, String elementPath, Integer relationId, HashMap<String, Integer> relations) {
        element.setAttribute("relationId", relationId.toString());
        if (!relations.containsKey(elementPath)) {
            relations.put(elementPath, 0);
        }
        Integer id = relations.get(elementPath);
        relations.put(elementPath, id + 1);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            Element node = (Element)childNodes.item(i);
            if (StiXmlUtil.isElementNode(node) && (node.getAttributes().getLength() > 0 || node.getChildNodes().getLength() > 1)) {
                element.setAttribute(node.getNodeName(), id.toString());
                StiXmlUtil.processRelations(node, elementPath + "\\" + node.getNodeName(), id, relations);
                continue;
            }
            node.setAttribute("relationId", id.toString());
        }
    }
}

