/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class StiFontHelper {
    static Logger LOG = Logger.getLogger(StiFontHelper.class.getName());

    public static byte[] getFontData(Font font) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        try {
            File file = StiFontHelper.getFontFile(font);
            FileInputStream fin = new FileInputStream(file);
            byte[] result = new byte[(int)file.length()];
            fin.read(result);
            fin.close();
            return result;
        }
        catch (Exception e) {
            LOG.severe("Your system does not have access to font files, please use export without embedded fonts");
            throw e;
        }
    }

    public static File getFontFile(Font font) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        Object fontManager;
        Object f2d = null;
        Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
        try {
            Class<?> manager = Class.forName("sun.font.FontManagerFactory");
            Method managerInstance = manager.getDeclaredMethod("getInstance", new Class[0]);
            managerInstance.setAccessible(true);
            fontManager = managerInstance.invoke(null, new Object[0]);
            Method findFont2D = fontManager.getClass().getMethod("findFont2D", argTypes);
            findFont2D.setAccessible(true);
            Object font2D = findFont2D.invoke(fontManager, font.getFontName(), font.getStyle(), 2);
            Class<?> font2DClass = Class.forName("sun.font.Font2D");
            Class<?> gont2DHandleClass = Class.forName("sun.font.Font2DHandle");
            Object handle = font2DClass.getField("handle").get(font2D);
            f2d = gont2DHandleClass.getField("font2D").get(handle);
        }
        catch (Exception e) {
            try {
                Class<?> manager = Class.forName("sun.font.FontManager");
                fontManager = manager.newInstance();
                Object font2D = manager.getMethod("findFont2D", String.class, Integer.TYPE, Integer.TYPE).invoke(fontManager, font.getFontName(), font.getStyle(), 2);
                Class<?> font2DClass = Class.forName("sun.font.Font2D");
                Class<?> gont2DHandleClass = Class.forName("sun.font.Font2DHandle");
                Object handle = font2DClass.getField("handle").get(font2D);
                f2d = gont2DHandleClass.getField("font2D").get(handle);
            }
            catch (Exception manager) {
            }
            catch (IncompatibleClassChangeError i1) {
                try {
                    Class<?> manager = Class.forName("sun.font.FontManager");
                    Method findMethod = manager.getMethod("findFont2D", argTypes);
                    Object font2D = findMethod.invoke(null, font.getFontName(), font.getStyle(), 2);
                    Class<?> font2DClass = Class.forName("sun.font.Font2D");
                    Class<?> gont2DHandleClass = Class.forName("sun.font.Font2DHandle");
                    Object handle = font2DClass.getField("handle").get(font2D);
                    f2d = gont2DHandleClass.getField("font2D").get(handle);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        try {
            return new File(StiFontHelper.getPlatName(f2d));
        }
        catch (Exception e) {
            if (f2d.getClass().getName().equalsIgnoreCase("sun.font.CFont")) {
                String platName = StiFontHelper.getPlatName(f2d);
                return new File(platName);
            }
            Class<?> compositeFontClass = Class.forName("sun.font.CompositeFont");
            String platName = StiFontHelper.getPlatName(compositeFontClass.getMethod("getSlotFont", Integer.TYPE).invoke(f2d, (Integer)compositeFontClass.getMethod("getNumSlots", null).invoke(f2d, null) - 1));
            return new File(platName);
        }
    }

    private static String getPlatName(Object f2d) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        Field platName = Class.forName("sun.font.PhysicalFont").getDeclaredField("platName");
        platName.setAccessible(true);
        String fontPath = (String)platName.get(f2d);
        platName.setAccessible(false);
        return fontPath;
    }
}

