/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import java.time.ZonedDateTime;

public class StiTimeSpan
implements Comparable<StiTimeSpan> {
    public static final StiTimeSpan ZERO = new StiTimeSpan();
    private long ticks;

    public StiTimeSpan(long ticks) {
        this.ticks = ticks;
    }

    public StiTimeSpan(int hours, int minutes, int seconds) {
        this.ticks = this.millisecondsInHours(hours) + (long)minutes * 1000L * 60L + (long)seconds * 1000L;
    }

    public StiTimeSpan(int days, int hours, int minutes, int seconds) {
        this.ticks = this.millisecondsInDay(days) + this.millisecondsInHours(hours) + (long)minutes * 1000L * 60L + (long)seconds * 1000L;
    }

    public StiTimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) {
        this.ticks = this.millisecondsInDay(days) + this.millisecondsInHours(hours) + (long)minutes * 1000L * 60L + (long)seconds * 1000L + (long)milliseconds;
    }

    private long millisecondsInDay(long days) {
        return days * 1000L * 60L * 60L * 24L;
    }

    private long millisecondsInHours(long hours) {
        return hours * 1000L * 60L * 60L;
    }

    public StiTimeSpan() {
        this.ticks = 0L;
    }

    public StiTimeSpan(float ticks) {
        this.ticks = (long)ticks;
    }

    public static StiTimeSpan FromSeconds(double seconds) {
        return new StiTimeSpan((float)seconds * 1000.0f);
    }

    public static StiTimeSpan fromDays(double days) {
        return StiTimeSpan.fromHours(days * 24.0);
    }

    public static StiTimeSpan fromHours(double hours) {
        return StiTimeSpan.fromMinutes(hours * 60.0);
    }

    public static StiTimeSpan fromMilliseconds(double milliseconds) {
        return new StiTimeSpan((float)milliseconds);
    }

    public static StiTimeSpan fromMinutes(double minutes) {
        return StiTimeSpan.FromSeconds(minutes * 60.0);
    }

    public static StiTimeSpan fromTicks(double ticks) {
        return new StiTimeSpan((float)ticks / 1000.0f);
    }

    public static StiTimeSpan valueOf(String str) {
        try {
            if (str.contains(":")) {
                String[] time = str.split(":");
                String[] daysHours = time[0].split("\\.");
                String days = daysHours.length == 2 ? daysHours[0] : String.valueOf(0);
                String hours = time.length == 3 ? daysHours[daysHours.length - 1] : String.valueOf(0);
                String minutes = time.length > 1 ? time[time.length - 2] : String.valueOf(0);
                String[] mSeconds = time[time.length - 1].split("\\.");
                String seconds = mSeconds.length == 2 ? mSeconds[0] : time[time.length - 1];
                return new StiTimeSpan(Integer.valueOf(days), Integer.valueOf(hours), Integer.valueOf(minutes), Integer.valueOf(seconds));
            }
            return new StiTimeSpan(Long.valueOf(str));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("For input string: " + str);
        }
    }

    public double getTotalYear() {
        return new Double(this.ticks) / 3.1104E10;
    }

    public double getTotalMonth() {
        return new Double(this.ticks) / 2.592E9;
    }

    public double getTotalDays() {
        return new Double(this.ticks) / 8.64E7;
    }

    public double getTotalHours() {
        return new Double(this.ticks) / 3600000.0;
    }

    public double getTotalMinutes() {
        return new Double(this.ticks) / 60000.0;
    }

    public double getTotalSeconds() {
        return new Double(this.ticks) / 1000.0;
    }

    public double getTotalMilliseconds() {
        return this.ticks;
    }

    public String formatString() {
        int day = this.getDays();
        int hours = this.getHours();
        int minutes = this.getMinutes();
        int seconds = this.getSeconds();
        int mseconds = this.getMilisecond();
        return String.format("%d.%02d:%02d:%02d %dms", day, hours, minutes, seconds, mseconds);
    }

    private int getMilisecond() {
        return (int)(new Double(this.ticks) % 1000.0);
    }

    public int getSeconds() {
        return (int)(new Double(this.ticks) / 1000.0 % 60.0);
    }

    public int getMinutes() {
        return (int)(new Double(this.ticks) / 60000.0 % 60.0);
    }

    public int getHours() {
        return (int)(new Double(this.ticks) / 3600000.0) - this.getDays() * 24;
    }

    public int getDays() {
        return (int)(new Double(this.ticks) / 8.64E7);
    }

    public String toString() {
        return String.format("%02d:%02d:%02d:%02d", this.getDays(), this.getHours(), this.getMinutes(), this.getSeconds());
    }

    public static StiTimeSpan fromInterval(ZonedDateTime dateBegin, ZonedDateTime dateEnd) {
        long ticks = dateEnd.toInstant().toEpochMilli() - dateBegin.toInstant().toEpochMilli();
        return new StiTimeSpan(ticks);
    }

    public void setTicks(long ticks) {
        this.ticks = ticks;
    }

    public long getTicks() {
        return this.ticks;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof StiTimeSpan && ((StiTimeSpan)obj).ticks == this.ticks;
    }

    public String format(String format) {
        int day = this.getDays();
        int hour = this.getHours();
        int min = this.getMinutes();
        int sec = this.getSeconds();
        format = format.replaceAll("dd", String.format("%02d", day)).replaceAll("d", String.valueOf(day));
        format = format.replaceAll("HH", String.format("%02d", hour)).replaceAll("hh", String.format("%02d", hour));
        format = format.replaceAll("mm", String.format("%02d", min)).replaceAll("m", String.valueOf(min));
        format = format.replaceAll("ss", String.format("%02d", sec)).replaceAll("s", String.valueOf(sec));
        format = format.replaceAll("S", String.valueOf(this.getMilisecond()));
        format = format.replaceAll("\\\\", "");
        return format;
    }

    @Override
    public int compareTo(StiTimeSpan o) {
        return new Long(this.ticks).compareTo(o.ticks);
    }
}

