/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.lib.utils.StiValidationUtil;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.Locale;

public class StiConverterDateFormatToJava {
    private StiConverterDateFormatToJava() {
    }

    public static DateTimeFormatter getDateFormat(String stringFormat) {
        return StiConverterDateFormatToJava.getDateFormat(stringFormat, null);
    }

    public static DateTimeFormatter getDateFormat(String stringFormat, Locale locale) {
        if (stringFormat != null && StandartCFormat.exist(stringFormat)) {
            return StandartCFormat.forPattern(stringFormat, locale);
        }
        if (locale != null && !StiValidationUtil.isNullOrEmpty((String)stringFormat)) {
            return DateTimeFormatter.ofPattern(stringFormat, locale);
        }
        if (locale == null && !StiValidationUtil.isNullOrEmpty((String)stringFormat)) {
            return DateTimeFormatter.ofPattern(stringFormat);
        }
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.MEDIUM).withLocale(locale != null ? locale : Locale.getDefault());
    }

    static enum StandartCFormat {
        SHORT("d", DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)),
        FULL("D", DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL)),
        YEAR_MONTH("Y", DateTimeFormatter.ofPattern("MMMM, yyyy", Locale.ENGLISH)),
        DAY_SINGLE("%d", DateTimeFormatter.ofPattern("d", Locale.ENGLISH)),
        DAY("%D", DateTimeFormatter.ofPattern("D", Locale.ENGLISH));

        final DateTimeFormatter format;
        private final String pattern;
        private static HashMap<String, DateTimeFormatter> formats;

        private StandartCFormat(String pattern, DateTimeFormatter format) {
            this.pattern = pattern;
            this.format = format;
            StandartCFormat.getFormats().put(pattern, format);
        }

        private static synchronized HashMap<String, DateTimeFormatter> getFormats() {
            if (formats == null) {
                formats = new HashMap();
            }
            return formats;
        }

        static boolean exist(String pattern) {
            return formats.containsKey(pattern);
        }

        static DateTimeFormatter forPattern(String pattern, Locale locale) {
            if (locale != null) {
                if ("d".equals(pattern)) {
                    return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale);
                }
                if ("D".equals(pattern)) {
                    return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale);
                }
                if ("Y".equals(pattern)) {
                    return DateTimeFormatter.ofPattern("MMMM, yyyy", locale);
                }
                if ("%d".equals(pattern)) {
                    return DateTimeFormatter.ofPattern("d", locale);
                }
                if ("%D".equals(pattern)) {
                    return DateTimeFormatter.ofPattern("D", locale);
                }
            }
            return StandartCFormat.getFormats().get(pattern);
        }
    }
}

