/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import java.text.MessageFormat;

public class FloatRange
extends Range {
    public float From = 0.0f;
    public float To = 0.0f;

    public FloatRange() {
    }

    public FloatRange(float from, float to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public String getRangeName() {
        return "FloatRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemSingle;
    }

    @Override
    public Object getFromObject() {
        return Float.valueOf(this.From);
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof Float) {
            this.From = ((Float)value).floatValue();
        }
    }

    @Override
    public Object getToObject() {
        return Float.valueOf(this.To);
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof Float) {
            this.To = ((Float)value).floatValue();
        }
    }

    public final boolean Contains(float value) {
        return this.From <= value && this.To >= value;
    }

    @Override
    public String serialize() {
        String data = MessageFormat.format(this.getSerializeName() + ",{0},{1}", StiXMLConvert.encodeName(StiSerializTypeConverter.floatToString(Float.valueOf(this.From))), StiXMLConvert.encodeName(StiSerializTypeConverter.floatToString(Float.valueOf(this.To))));
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = StiSerializTypeConverter.stringToFloat(StiXMLConvert.decodeName(values[1]));
        this.To = StiSerializTypeConverter.stringToFloat(StiXMLConvert.decodeName(values[2]));
    }

    @Override
    protected String getSerializeName() {
        return "Float";
    }

    public static FloatRange fromSerializeValue(String str) {
        FloatRange result = new FloatRange();
        result.deserialize(str);
        return result;
    }
}

