/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.exception;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.exception.StiExceptionSaveDialog;
import com.stimulsoft.base.exception.StiPopupTextArea;
import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.base.utils.StiResourceUtil;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class StiExceptionProvider
extends JDialog {
    private static final long serialVersionUID = -3909912161102206452L;
    private static final int PANEL_WIDTH = 600;
    private static final int LEFT_WIDTH = 90;
    private static final int TEXT_PANE_WIDTH = 490;
    private static final int TEXT_HEIGHT = 22;
    private static final Border LABEL_BORDER = BorderFactory.createEmptyBorder(0, 7, 0, 0);
    private static final Border PANEL_BORDER = BorderFactory.createEmptyBorder(7, 0, 0, 0);
    private static final int TEXT_AREA_WIDTH = 573;
    private static final int TEXT_AREA_STRUT = 5;
    private StiPopupTextArea messagePane;
    private StiPopupTextArea applicationPane;
    private StiPopupTextArea versionPane;
    private StiPopupTextArea javaVersionPane;
    private StiPopupTextArea osVersionPane;
    private StiPopupTextArea infoDescriptionPane;
    private StiPopupTextArea messageTabDescriptionPane;
    private StiPopupTextArea causeDescriptionPane;
    private StiPopupTextArea stackDescriptionPane;
    private JScrollPane exceptionScrollPane;
    private JButton saveButton;
    private JButton copyButton;
    private JButton closeButton;

    public StiExceptionProvider(Throwable e, Frame owner) {
        super(owner, "Exception report", true);
        this.buildComponent();
        this.populateData(e);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 433);
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.bindEvents();
    }

    private void buildComponent() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.add(tabbedPane);
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        messagePanel.setAlignmentX(0.0f);
        JLabel imgLabel = new JLabel(StiResourceUtil.loadIcon("/exception.png"));
        imgLabel.setMaximumSize(new Dimension(90, 64));
        this.messagePane = this.createTextPane(490, 64);
        messagePanel.add(imgLabel);
        messagePanel.add(this.messagePane);
        generalPanel.add(messagePanel);
        generalPanel.setBorder(PANEL_BORDER);
        JPanel applicationPanel = new JPanel();
        applicationPanel.setLayout(new BoxLayout(applicationPanel, 0));
        applicationPanel.setAlignmentX(0.0f);
        JLabel applicationLabel = new JLabel("Application");
        applicationLabel.setMaximumSize(new Dimension(90, 22));
        applicationLabel.setBorder(LABEL_BORDER);
        this.applicationPane = this.createTextPane(490, 22);
        this.applicationPane.setText("Stimulsoft Reports.JAVA");
        applicationPanel.setBorder(PANEL_BORDER);
        applicationPanel.add(applicationLabel);
        applicationPanel.add(this.applicationPane);
        generalPanel.add(applicationPanel);
        JPanel versionPanel = new JPanel();
        versionPanel.setLayout(new BoxLayout(versionPanel, 0));
        versionPanel.setAlignmentX(0.0f);
        JLabel versionLabel = new JLabel("Version");
        versionLabel.setMaximumSize(new Dimension(90, 22));
        versionLabel.setBorder(LABEL_BORDER);
        this.versionPane = this.createTextPane(490, 22);
        versionPanel.setBorder(PANEL_BORDER);
        versionPanel.add(versionLabel);
        versionPanel.add(this.versionPane);
        generalPanel.add(versionPanel);
        JPanel javaVersionPanel = new JPanel();
        javaVersionPanel.setLayout(new BoxLayout(javaVersionPanel, 0));
        javaVersionPanel.setAlignmentX(0.0f);
        JLabel javaVersionLabel = new JLabel("Java Version");
        javaVersionLabel.setMaximumSize(new Dimension(90, 22));
        javaVersionLabel.setBorder(LABEL_BORDER);
        this.javaVersionPane = this.createTextPane(490, 22);
        javaVersionPanel.setBorder(PANEL_BORDER);
        javaVersionPanel.add(javaVersionLabel);
        javaVersionPanel.add(this.javaVersionPane);
        generalPanel.add(javaVersionPanel);
        JPanel osVersionPanel = new JPanel();
        osVersionPanel.setLayout(new BoxLayout(osVersionPanel, 0));
        osVersionPanel.setAlignmentX(0.0f);
        JLabel osVersionLabel = new JLabel("OS Version");
        osVersionLabel.setMaximumSize(new Dimension(90, 22));
        osVersionLabel.setBorder(LABEL_BORDER);
        this.osVersionPane = this.createTextPane(490, 22);
        osVersionPanel.setBorder(PANEL_BORDER);
        osVersionPanel.add(osVersionLabel);
        osVersionPanel.add(this.osVersionPane);
        generalPanel.add(osVersionPanel);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        infoPanel.setAlignmentX(0.0f);
        JLabel infoLabel = new JLabel("Please enter detailed information about events which cause this exception. ");
        infoLabel.setMaximumSize(new Dimension(600, 22));
        infoLabel.setBorder(LABEL_BORDER);
        infoPanel.setBorder(PANEL_BORDER);
        infoPanel.add(infoLabel);
        generalPanel.add(infoPanel);
        JPanel infoDescriptionPanel = new JPanel();
        infoDescriptionPanel.setLayout(new BoxLayout(infoDescriptionPanel, 0));
        infoDescriptionPanel.setAlignmentX(0.0f);
        this.infoDescriptionPane = new StiPopupTextArea();
        this.infoDescriptionPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.infoDescriptionPane.setWrapStyleWord(true);
        this.infoDescriptionPane.setLineWrap(true);
        infoDescriptionPanel.add(Box.createHorizontalStrut(5));
        this.exceptionScrollPane = new JScrollPane(this.infoDescriptionPane);
        infoDescriptionPanel.add(this.exceptionScrollPane);
        Dimension infoDescrSize = new Dimension(573, 140);
        this.exceptionScrollPane.setMaximumSize(infoDescrSize);
        this.exceptionScrollPane.setPreferredSize(infoDescrSize);
        generalPanel.add(infoDescriptionPanel);
        generalPanel.add(Box.createVerticalStrut(5));
        tabbedPane.addTab("General", generalPanel);
        JPanel exceptionPanel = new JPanel();
        exceptionPanel.setLayout(new BoxLayout(exceptionPanel, 1));
        JPanel messageTabPanel = new JPanel();
        messageTabPanel.setLayout(new BoxLayout(messageTabPanel, 0));
        messageTabPanel.setAlignmentX(0.0f);
        JLabel messageTabLabel = new JLabel("Message");
        messageTabLabel.setMaximumSize(new Dimension(600, 22));
        messageTabLabel.setBorder(LABEL_BORDER);
        messageTabPanel.setBorder(PANEL_BORDER);
        messageTabPanel.add(messageTabLabel);
        exceptionPanel.add(messageTabPanel);
        JPanel messageTabDescriptionPanel = new JPanel();
        messageTabDescriptionPanel.setLayout(new BoxLayout(messageTabDescriptionPanel, 0));
        messageTabDescriptionPanel.setAlignmentX(0.0f);
        this.messageTabDescriptionPane = this.createTextPane(573, 64);
        Dimension messageDescrSize = new Dimension(573, 64);
        this.messageTabDescriptionPane.setMinimumSize(messageDescrSize);
        this.messageTabDescriptionPane.setPreferredSize(messageDescrSize);
        messageTabDescriptionPanel.add(Box.createHorizontalStrut(5));
        messageTabDescriptionPanel.add(this.messageTabDescriptionPane);
        exceptionPanel.add(messageTabDescriptionPanel);
        JPanel causePanel = new JPanel();
        causePanel.setLayout(new BoxLayout(causePanel, 0));
        causePanel.setAlignmentX(0.0f);
        JLabel causeLabel = new JLabel("Cause");
        causeLabel.setMaximumSize(new Dimension(600, 22));
        causeLabel.setBorder(LABEL_BORDER);
        causePanel.setBorder(PANEL_BORDER);
        causePanel.add(causeLabel);
        exceptionPanel.add(causePanel);
        JPanel causeDescriptionPanel = new JPanel();
        causeDescriptionPanel.setLayout(new BoxLayout(causeDescriptionPanel, 0));
        causeDescriptionPanel.setAlignmentX(0.0f);
        this.causeDescriptionPane = this.createTextPane(573, 22);
        causeDescriptionPanel.add(Box.createHorizontalStrut(5));
        causeDescriptionPanel.add(this.causeDescriptionPane);
        exceptionPanel.add(causeDescriptionPanel);
        JPanel stackPanel = new JPanel();
        stackPanel.setLayout(new BoxLayout(stackPanel, 0));
        stackPanel.setAlignmentX(0.0f);
        JLabel stackLabel = new JLabel("Stack Trace");
        stackLabel.setMaximumSize(new Dimension(600, 22));
        stackLabel.setBorder(LABEL_BORDER);
        stackPanel.setBorder(PANEL_BORDER);
        stackPanel.add(stackLabel);
        exceptionPanel.add(stackPanel);
        JPanel stackDescriptionPanel = new JPanel();
        stackDescriptionPanel.setLayout(new BoxLayout(stackDescriptionPanel, 0));
        stackDescriptionPanel.setAlignmentX(0.0f);
        this.stackDescriptionPane = new StiPopupTextArea();
        this.stackDescriptionPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.stackDescriptionPane.setEditable(false);
        this.stackDescriptionPane.setWrapStyleWord(true);
        this.stackDescriptionPane.setLineWrap(true);
        stackDescriptionPanel.add(Box.createHorizontalStrut(5));
        this.exceptionScrollPane = new JScrollPane(this.stackDescriptionPane);
        stackDescriptionPanel.add(this.exceptionScrollPane);
        Dimension stackDescrSize = new Dimension(573, 320);
        this.exceptionScrollPane.setMaximumSize(stackDescrSize);
        this.exceptionScrollPane.setPreferredSize(stackDescrSize);
        exceptionPanel.add(stackDescriptionPanel);
        exceptionPanel.add(Box.createVerticalStrut(5));
        tabbedPane.addTab("Exception", exceptionPanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.setAlignmentX(0.0f);
        Dimension buttonsPanelSize = new Dimension(600, 36);
        buttonsPanel.setMaximumSize(buttonsPanelSize);
        buttonsPanel.setPreferredSize(buttonsPanelSize);
        this.saveButton = new JButton("Save to File");
        this.copyButton = new JButton("Copy to Clipboard");
        this.closeButton = new JButton("Close");
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(this.saveButton);
        buttonsPanel.add(this.copyButton);
        buttonsPanel.add(this.closeButton);
        buttonsPanel.add(Box.createHorizontalStrut(22));
        this.add(buttonsPanel);
    }

    private void bindEvents() {
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection data = new StringSelection(StiExceptionProvider.this.getTextData());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, data);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiExceptionProvider.this.setVisible(false);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiExceptionSaveDialog saveDialog = new StiExceptionSaveDialog();
                int chooserResult = saveDialog.showSaveDialog(StiExceptionProvider.this.getOwner());
                if (chooserResult == 0) {
                    File file = saveDialog.getFile();
                    try {
                        FileOutputStream fos = new FileOutputStream(file);
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StiCharsetHelper.UTF8);
                        osw.write(StiExceptionProvider.this.getTextData());
                        osw.close();
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                        StiExceptionProvider.show(e1, null);
                    }
                }
            }
        });
        int c = 2;
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.closeButton.getInputMap(c).put(ks, "hotPress");
        this.closeButton.getActionMap().put("hotPress", new AbstractAction(){
            private static final long serialVersionUID = 8935120531469858422L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StiExceptionProvider.this.dispose();
            }
        });
    }

    private String getTextData() {
        StringBuilder result = new StringBuilder();
        result.append("----------------------------\r\n");
        result.append("[Customer Explanation]\r\n\r\n");
        result.append(this.infoDescriptionPane.getText() + "\r\n");
        result.append("----------------------------\r\n");
        result.append("[General Info]\r\n\r\n");
        result.append("Application:  " + this.applicationPane.getText() + "\r\n");
        result.append("Version:      " + this.versionPane.getText() + "\r\n");
        result.append("JAVA Version: " + this.javaVersionPane.getText() + "\r\n");
        result.append("OSVersion:    " + this.osVersionPane.getText() + "\r\n");
        result.append("UserName:     " + System.getProperty("user.name") + "\r\n");
        result.append("\r\n");
        result.append("----------------------------\r\n");
        result.append("[Exception Info]\r\n");
        result.append("Message:      " + this.messagePane.getText() + "\r\n");
        result.append("\r\n");
        result.append("Cause:       " + this.causeDescriptionPane.getText() + "\r\n");
        result.append("\r\n");
        result.append("StackTrace:   \r\n");
        result.append(this.stackDescriptionPane.getText() + "\r\n");
        result.append("\r\n");
        result.append("----------------------------\r\n");
        return result.toString();
    }

    private void populateData(Throwable e) {
        this.messagePane.setText(e.getMessage());
        this.javaVersionPane.setText(System.getProperty("java.runtime.version"));
        this.versionPane.setText(StiAttribute.getVersion());
        this.osVersionPane.setText(System.getProperty("os.name") + " " + System.getProperty("sun.os.patch.level") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        this.messageTabDescriptionPane.setText(e.getLocalizedMessage());
        this.causeDescriptionPane.setText(e.getCause() != null ? e.getCause().toString() : "");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bos);
            e.printStackTrace(pw);
            bos.close();
            pw.close();
            this.stackDescriptionPane.setText(bos.toString().replaceAll(Character.toString('\t'), ""));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StiExceptionProvider.this.exceptionScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
        }
        catch (IOException e1) {
            System.err.println("Error in parse exception " + e);
            e1.printStackTrace();
        }
    }

    private StiPopupTextArea createTextPane(int width, int height) {
        StiPopupTextArea pane = new StiPopupTextArea();
        pane.setMaximumSize(new Dimension(width, height));
        pane.setEditable(false);
        pane.setBorder(BorderFactory.createEtchedBorder());
        pane.setWrapStyleWord(true);
        pane.setLineWrap(true);
        return pane;
    }

    public static void show(Throwable e, Frame owner) {
        e.printStackTrace();
        StiExceptionProvider exceptionProvider = new StiExceptionProvider(e, owner);
        exceptionProvider.setVisible(true);
    }
}

