/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing.path;

import com.stimulsoft.base.drawing.path.StiPathCommandEnum;
import com.stimulsoft.base.drawing.path.StiPathCurveTo;
import com.stimulsoft.base.drawing.path.StiPathLineTo;
import com.stimulsoft.base.drawing.path.StiPathMoveTo;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.util.List;

public class StiPathCommand {
    public static final double KAPPA = 0.5522847498;
    private double x = 0.0;
    private double y = 0.0;

    public StiPathCommand(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public StiPathCommandEnum getCommand() {
        return StiPathCommandEnum.NoOperation;
    }

    public static StiPathMoveTo moveTo(Double x, Double y) {
        return new StiPathMoveTo(x, y);
    }

    public static StiPathLineTo lineTo(Double x, Double y) {
        return new StiPathLineTo(x, y);
    }

    public static StiPathCurveTo curveTo(Double x, Double y, Double ax, Double ay) {
        return new StiPathCurveTo(x, y, ax, ay);
    }

    public static List<StiPathCommand> createCircle(StiRectangle rect, List<StiPathCommand> path) {
        Double x = rect.getX() + rect.getWidth() / 2.0;
        Double y = rect.getY() + rect.getHeight() / 2.0;
        Double r = rect.getWidth() / 2.0;
        path.add(new StiPathMoveTo(x, (Double)(y - r)));
        path.add(new StiPathCurveTo(x + r * 0.5522847498, y - r, x + r, y - r * 0.5522847498, x + r, y));
        path.add(new StiPathCurveTo(x + r, y + r * 0.5522847498, x + r * 0.5522847498, y + r, x, y + r));
        path.add(new StiPathCurveTo(x - r * 0.5522847498, y + r, x - r, y + r * 0.5522847498, x - r, y));
        path.add(new StiPathCurveTo(x - r, y - r * 0.5522847498, x - r * 0.5522847498, y - r, x, y - r));
        return path;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

