/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGlyph;
import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiHtmlTag2;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.TagPair;
import com.stimulsoft.base.drawing.enums.StiHtmlTag;
import com.stimulsoft.base.drawing.enums.StiHtmlTag2State;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StiTextRendererParseHtml {
    private static final double defaultParagraphLineHeight = 0.7;
    private static HashMap<String, Character> htmlEscapeSequence = null;
    private static Object lockHtmlNameToColor = new Object();
    private static HashMap<String, StiColor> htmlNameToColor = null;
    private static String bulletBlack = new String("\u2022");
    private static String bulletWhite = new String("\u25e6");

    private static HashMap<String, Character> getHtmlEscapeSequence() {
        if (htmlEscapeSequence == null) {
            htmlEscapeSequence = new HashMap();
            htmlEscapeSequence.put("&quot;", Character.valueOf('\"'));
            htmlEscapeSequence.put("&amp;", Character.valueOf('&'));
            htmlEscapeSequence.put("&apos;", Character.valueOf('\''));
            htmlEscapeSequence.put("&lt;", Character.valueOf('<'));
            htmlEscapeSequence.put("&gt;", Character.valueOf('>'));
            htmlEscapeSequence.put("&nbsp;", Character.valueOf('\u00a0'));
            htmlEscapeSequence.put("&iexcl;", Character.valueOf('\u00a1'));
            htmlEscapeSequence.put("&cent;", Character.valueOf('\u00a2'));
            htmlEscapeSequence.put("&pound;", Character.valueOf('\u00a3'));
            htmlEscapeSequence.put("&curren;", Character.valueOf('\u00a4'));
            htmlEscapeSequence.put("&yen;", Character.valueOf('\u00a5'));
            htmlEscapeSequence.put("&brvbar;", Character.valueOf('\u00a6'));
            htmlEscapeSequence.put("&sect;", Character.valueOf('\u00a7'));
            htmlEscapeSequence.put("&uml;", Character.valueOf('\u00a8'));
            htmlEscapeSequence.put("&copy;", Character.valueOf('\u00a9'));
            htmlEscapeSequence.put("&ordf;", Character.valueOf('\u00aa'));
            htmlEscapeSequence.put("&laquo;", Character.valueOf('\u00ab'));
            htmlEscapeSequence.put("&not;", Character.valueOf('\u00ac'));
            htmlEscapeSequence.put("&shy;", Character.valueOf('\u00ad'));
            htmlEscapeSequence.put("&reg;", Character.valueOf('\u00ae'));
            htmlEscapeSequence.put("&macr;", Character.valueOf('\u00af'));
            htmlEscapeSequence.put("&deg;", Character.valueOf('\u00b0'));
            htmlEscapeSequence.put("&plusmn;", Character.valueOf('\u00b1'));
            htmlEscapeSequence.put("&sup2;", Character.valueOf('\u00b2'));
            htmlEscapeSequence.put("&sup3;", Character.valueOf('\u00b3'));
            htmlEscapeSequence.put("&acute;", Character.valueOf('\u00b4'));
            htmlEscapeSequence.put("&micro;", Character.valueOf('\u00b5'));
            htmlEscapeSequence.put("&para;", Character.valueOf('\u00b6'));
            htmlEscapeSequence.put("&middot;", Character.valueOf('\u00b7'));
            htmlEscapeSequence.put("&cedil;", Character.valueOf('\u00b8'));
            htmlEscapeSequence.put("&sup1;", Character.valueOf('\u00b9'));
            htmlEscapeSequence.put("&ordm;", Character.valueOf('\u00ba'));
            htmlEscapeSequence.put("&raquo;", Character.valueOf('\u00bb'));
            htmlEscapeSequence.put("&frac14;", Character.valueOf('\u00bc'));
            htmlEscapeSequence.put("&frac12;", Character.valueOf('\u00bd'));
            htmlEscapeSequence.put("&frac34;", Character.valueOf('\u00be'));
            htmlEscapeSequence.put("&iquest;", Character.valueOf('\u00bf'));
            htmlEscapeSequence.put("&Agrave;", Character.valueOf('\u00c0'));
            htmlEscapeSequence.put("&Aacute;", Character.valueOf('\u00c1'));
            htmlEscapeSequence.put("&Acirc;", Character.valueOf('\u00c2'));
            htmlEscapeSequence.put("&Atilde;", Character.valueOf('\u00c3'));
            htmlEscapeSequence.put("&Auml;", Character.valueOf('\u00c4'));
            htmlEscapeSequence.put("&Aring;", Character.valueOf('\u00c5'));
            htmlEscapeSequence.put("&AElig;", Character.valueOf('\u00c6'));
            htmlEscapeSequence.put("&Ccedil;", Character.valueOf('\u00c7'));
            htmlEscapeSequence.put("&Egrave;", Character.valueOf('\u00c8'));
            htmlEscapeSequence.put("&Eacute;", Character.valueOf('\u00c9'));
            htmlEscapeSequence.put("&Ecirc;", Character.valueOf('\u00ca'));
            htmlEscapeSequence.put("&Euml;", Character.valueOf('\u00cb'));
            htmlEscapeSequence.put("&Igrave;", Character.valueOf('\u00cc'));
            htmlEscapeSequence.put("&Iacute;", Character.valueOf('\u00cd'));
            htmlEscapeSequence.put("&Icirc;", Character.valueOf('\u00ce'));
            htmlEscapeSequence.put("&Iuml;", Character.valueOf('\u00cf'));
            htmlEscapeSequence.put("&ETH;", Character.valueOf('\u00d0'));
            htmlEscapeSequence.put("&Ntilde;", Character.valueOf('\u00d1'));
            htmlEscapeSequence.put("&Ograve;", Character.valueOf('\u00d2'));
            htmlEscapeSequence.put("&Oacute;", Character.valueOf('\u00d3'));
            htmlEscapeSequence.put("&Ocirc;", Character.valueOf('\u00d4'));
            htmlEscapeSequence.put("&Otilde;", Character.valueOf('\u00d5'));
            htmlEscapeSequence.put("&Ouml;", Character.valueOf('\u00d6'));
            htmlEscapeSequence.put("&times;", Character.valueOf('\u00d7'));
            htmlEscapeSequence.put("&Oslash;", Character.valueOf('\u00d8'));
            htmlEscapeSequence.put("&Ugrave;", Character.valueOf('\u00d9'));
            htmlEscapeSequence.put("&Uacute;", Character.valueOf('\u00da'));
            htmlEscapeSequence.put("&Ucirc;", Character.valueOf('\u00db'));
            htmlEscapeSequence.put("&Uuml;", Character.valueOf('\u00dc'));
            htmlEscapeSequence.put("&Yacute;", Character.valueOf('\u00dd'));
            htmlEscapeSequence.put("&THORN;", Character.valueOf('\u00de'));
            htmlEscapeSequence.put("&szlig;", Character.valueOf('\u00df'));
            htmlEscapeSequence.put("&agrave;", Character.valueOf('\u00e0'));
            htmlEscapeSequence.put("&aacute;", Character.valueOf('\u00e1'));
            htmlEscapeSequence.put("&acirc;", Character.valueOf('\u00e2'));
            htmlEscapeSequence.put("&atilde;", Character.valueOf('\u00e3'));
            htmlEscapeSequence.put("&auml;", Character.valueOf('\u00e4'));
            htmlEscapeSequence.put("&aring;", Character.valueOf('\u00e5'));
            htmlEscapeSequence.put("&aelig;", Character.valueOf('\u00e6'));
            htmlEscapeSequence.put("&ccedil;", Character.valueOf('\u00e7'));
            htmlEscapeSequence.put("&egrave;", Character.valueOf('\u00e8'));
            htmlEscapeSequence.put("&eacute;", Character.valueOf('\u00e9'));
            htmlEscapeSequence.put("&ecirc;", Character.valueOf('\u00ea'));
            htmlEscapeSequence.put("&euml;", Character.valueOf('\u00eb'));
            htmlEscapeSequence.put("&igrave;", Character.valueOf('\u00ec'));
            htmlEscapeSequence.put("&iacute;", Character.valueOf('\u00ed'));
            htmlEscapeSequence.put("&icirc;", Character.valueOf('\u00ee'));
            htmlEscapeSequence.put("&iuml;", Character.valueOf('\u00ef'));
            htmlEscapeSequence.put("&eth;", Character.valueOf('\u00f0'));
            htmlEscapeSequence.put("&ntilde;", Character.valueOf('\u00f1'));
            htmlEscapeSequence.put("&ograve;", Character.valueOf('\u00f2'));
            htmlEscapeSequence.put("&oacute;", Character.valueOf('\u00f3'));
            htmlEscapeSequence.put("&ocirc;", Character.valueOf('\u00f4'));
            htmlEscapeSequence.put("&otilde;", Character.valueOf('\u00f5'));
            htmlEscapeSequence.put("&ouml;", Character.valueOf('\u00f6'));
            htmlEscapeSequence.put("&divide;", Character.valueOf('\u00f7'));
            htmlEscapeSequence.put("&oslash;", Character.valueOf('\u00f8'));
            htmlEscapeSequence.put("&ugrave;", Character.valueOf('\u00f9'));
            htmlEscapeSequence.put("&uacute;", Character.valueOf('\u00fa'));
            htmlEscapeSequence.put("&ucirc;", Character.valueOf('\u00fb'));
            htmlEscapeSequence.put("&uuml;", Character.valueOf('\u00fc'));
            htmlEscapeSequence.put("&yacute;", Character.valueOf('\u00fd'));
            htmlEscapeSequence.put("&thorn;", Character.valueOf('\u00fe'));
            htmlEscapeSequence.put("&yuml;", Character.valueOf('\u00ff'));
            htmlEscapeSequence.put("&OElig;", Character.valueOf('\u0152'));
            htmlEscapeSequence.put("&oelig;", Character.valueOf('\u0153'));
            htmlEscapeSequence.put("&Scaron;", Character.valueOf('\u0160'));
            htmlEscapeSequence.put("&scaron;", Character.valueOf('\u0161'));
            htmlEscapeSequence.put("&Yuml;", Character.valueOf('\u0178'));
            htmlEscapeSequence.put("&fnof;", Character.valueOf('\u0192'));
            htmlEscapeSequence.put("&circ;", Character.valueOf('\u02c6'));
            htmlEscapeSequence.put("&tilde;", Character.valueOf('\u02dc'));
            htmlEscapeSequence.put("&Alpha;", Character.valueOf('\u0391'));
            htmlEscapeSequence.put("&Beta;", Character.valueOf('\u0392'));
            htmlEscapeSequence.put("&Gamma;", Character.valueOf('\u0393'));
            htmlEscapeSequence.put("&Delta;", Character.valueOf('\u0394'));
            htmlEscapeSequence.put("&Epsilon;", Character.valueOf('\u0395'));
            htmlEscapeSequence.put("&Zeta;", Character.valueOf('\u0396'));
            htmlEscapeSequence.put("&Eta;", Character.valueOf('\u0397'));
            htmlEscapeSequence.put("&Theta;", Character.valueOf('\u0398'));
            htmlEscapeSequence.put("&Iota;", Character.valueOf('\u0399'));
            htmlEscapeSequence.put("&Kappa;", Character.valueOf('\u039a'));
            htmlEscapeSequence.put("&Lambda;", Character.valueOf('\u039b'));
            htmlEscapeSequence.put("&Mu;", Character.valueOf('\u039c'));
            htmlEscapeSequence.put("&Nu;", Character.valueOf('\u039d'));
            htmlEscapeSequence.put("&Xi;", Character.valueOf('\u039e'));
            htmlEscapeSequence.put("&Omicron;", Character.valueOf('\u039f'));
            htmlEscapeSequence.put("&Pi;", Character.valueOf('\u03a0'));
            htmlEscapeSequence.put("&Rho;", Character.valueOf('\u03a1'));
            htmlEscapeSequence.put("&Sigma;", Character.valueOf('\u03a3'));
            htmlEscapeSequence.put("&Tau;", Character.valueOf('\u03a4'));
            htmlEscapeSequence.put("&Upsilon;", Character.valueOf('\u03a5'));
            htmlEscapeSequence.put("&Phi;", Character.valueOf('\u03a6'));
            htmlEscapeSequence.put("&Chi;", Character.valueOf('\u03a7'));
            htmlEscapeSequence.put("&Psi;", Character.valueOf('\u03a8'));
            htmlEscapeSequence.put("&Omega;", Character.valueOf('\u03a9'));
            htmlEscapeSequence.put("&alpha;", Character.valueOf('\u03b1'));
            htmlEscapeSequence.put("&beta;", Character.valueOf('\u03b2'));
            htmlEscapeSequence.put("&gamma;", Character.valueOf('\u03b3'));
            htmlEscapeSequence.put("&delta;", Character.valueOf('\u03b4'));
            htmlEscapeSequence.put("&epsilon;", Character.valueOf('\u03b5'));
            htmlEscapeSequence.put("&zeta;", Character.valueOf('\u03b6'));
            htmlEscapeSequence.put("&eta;", Character.valueOf('\u03b7'));
            htmlEscapeSequence.put("&theta;", Character.valueOf('\u03b8'));
            htmlEscapeSequence.put("&iota;", Character.valueOf('\u03b9'));
            htmlEscapeSequence.put("&kappa;", Character.valueOf('\u03ba'));
            htmlEscapeSequence.put("&lambda;", Character.valueOf('\u03bb'));
            htmlEscapeSequence.put("&mu;", Character.valueOf('\u03bc'));
            htmlEscapeSequence.put("&nu;", Character.valueOf('\u03bd'));
            htmlEscapeSequence.put("&xi;", Character.valueOf('\u03be'));
            htmlEscapeSequence.put("&omicron;", Character.valueOf('\u03bf'));
            htmlEscapeSequence.put("&pi;", Character.valueOf('\u03c0'));
            htmlEscapeSequence.put("&rho;", Character.valueOf('\u03c1'));
            htmlEscapeSequence.put("&sigmaf;", Character.valueOf('\u03c2'));
            htmlEscapeSequence.put("&sigma;", Character.valueOf('\u03c3'));
            htmlEscapeSequence.put("&tau;", Character.valueOf('\u03c4'));
            htmlEscapeSequence.put("&upsilon;", Character.valueOf('\u03c5'));
            htmlEscapeSequence.put("&phi;", Character.valueOf('\u03c6'));
            htmlEscapeSequence.put("&chi;", Character.valueOf('\u03c7'));
            htmlEscapeSequence.put("&psi;", Character.valueOf('\u03c8'));
            htmlEscapeSequence.put("&omega;", Character.valueOf('\u03c9'));
            htmlEscapeSequence.put("&thetasym;", Character.valueOf('\u03d1'));
            htmlEscapeSequence.put("&upsih;", Character.valueOf('\u03d2'));
            htmlEscapeSequence.put("&piv;", Character.valueOf('\u03d6'));
            htmlEscapeSequence.put("&ensp;", Character.valueOf('\u2002'));
            htmlEscapeSequence.put("&emsp;", Character.valueOf('\u2003'));
            htmlEscapeSequence.put("&thinsp;", Character.valueOf('\u2009'));
            htmlEscapeSequence.put("&zwnj;", Character.valueOf('\u200c'));
            htmlEscapeSequence.put("&zwj;", Character.valueOf('\u200d'));
            htmlEscapeSequence.put("&lrm;", Character.valueOf('\u200e'));
            htmlEscapeSequence.put("&rlm;", Character.valueOf('\u200f'));
            htmlEscapeSequence.put("&ndash;", Character.valueOf('\u2013'));
            htmlEscapeSequence.put("&mdash;", Character.valueOf('\u2014'));
            htmlEscapeSequence.put("&lsquo;", Character.valueOf('\u2018'));
            htmlEscapeSequence.put("&rsquo;", Character.valueOf('\u2019'));
            htmlEscapeSequence.put("&sbquo;", Character.valueOf('\u201a'));
            htmlEscapeSequence.put("&ldquo;", Character.valueOf('\u201c'));
            htmlEscapeSequence.put("&rdquo;", Character.valueOf('\u201d'));
            htmlEscapeSequence.put("&bdquo;", Character.valueOf('\u201e'));
            htmlEscapeSequence.put("&dagger;", Character.valueOf('\u2020'));
            htmlEscapeSequence.put("&Dagger;", Character.valueOf('\u2021'));
            htmlEscapeSequence.put("&bull;", Character.valueOf('\u2022'));
            htmlEscapeSequence.put("&hellip;", Character.valueOf('\u2026'));
            htmlEscapeSequence.put("&permil;", Character.valueOf('\u2030'));
            htmlEscapeSequence.put("&prime;", Character.valueOf('\u2032'));
            htmlEscapeSequence.put("&Prime;", Character.valueOf('\u2033'));
            htmlEscapeSequence.put("&lsaquo;", Character.valueOf('\u2039'));
            htmlEscapeSequence.put("&rsaquo;", Character.valueOf('\u203a'));
            htmlEscapeSequence.put("&oline;", Character.valueOf('\u203e'));
            htmlEscapeSequence.put("&frasl;", Character.valueOf('\u2044'));
            htmlEscapeSequence.put("&euro;", Character.valueOf('\u20ac'));
            htmlEscapeSequence.put("&image;", Character.valueOf('\u20ad'));
            htmlEscapeSequence.put("&weierp;", Character.valueOf('\u2118'));
            htmlEscapeSequence.put("&real;", Character.valueOf('\u211c'));
            htmlEscapeSequence.put("&trade;", Character.valueOf('\u2122'));
            htmlEscapeSequence.put("&alefsym;", Character.valueOf('\u2135'));
            htmlEscapeSequence.put("&larr;", Character.valueOf('\u2190'));
            htmlEscapeSequence.put("&uarr;", Character.valueOf('\u2191'));
            htmlEscapeSequence.put("&rarr;", Character.valueOf('\u2192'));
            htmlEscapeSequence.put("&darr;", Character.valueOf('\u2193'));
            htmlEscapeSequence.put("&harr;", Character.valueOf('\u2194'));
            htmlEscapeSequence.put("&crarr;", Character.valueOf('\u21b5'));
            htmlEscapeSequence.put("&lArr;", Character.valueOf('\u21d0'));
            htmlEscapeSequence.put("&uArr;", Character.valueOf('\u21d1'));
            htmlEscapeSequence.put("&rArr;", Character.valueOf('\u21d2'));
            htmlEscapeSequence.put("&dArr;", Character.valueOf('\u21d3'));
            htmlEscapeSequence.put("&hArr;", Character.valueOf('\u21d4'));
            htmlEscapeSequence.put("&forall;", Character.valueOf('\u2200'));
            htmlEscapeSequence.put("&part;", Character.valueOf('\u2202'));
            htmlEscapeSequence.put("&exist;", Character.valueOf('\u2203'));
            htmlEscapeSequence.put("&empty;", Character.valueOf('\u2205'));
            htmlEscapeSequence.put("&nabla;", Character.valueOf('\u2207'));
            htmlEscapeSequence.put("&isin;", Character.valueOf('\u2208'));
            htmlEscapeSequence.put("&notin;", Character.valueOf('\u2209'));
            htmlEscapeSequence.put("&ni;", Character.valueOf('\u220b'));
            htmlEscapeSequence.put("&prod;", Character.valueOf('\u220f'));
            htmlEscapeSequence.put("&sum;", Character.valueOf('\u2211'));
            htmlEscapeSequence.put("&minus;", Character.valueOf('\u2212'));
            htmlEscapeSequence.put("&lowast;", Character.valueOf('\u2217'));
            htmlEscapeSequence.put("&radic;", Character.valueOf('\u221a'));
            htmlEscapeSequence.put("&prop;", Character.valueOf('\u221d'));
            htmlEscapeSequence.put("&infin;", Character.valueOf('\u221e'));
            htmlEscapeSequence.put("&ang;", Character.valueOf('\u2220'));
            htmlEscapeSequence.put("&and;", Character.valueOf('\u2227'));
            htmlEscapeSequence.put("&or;", Character.valueOf('\u2228'));
            htmlEscapeSequence.put("&cap;", Character.valueOf('\u2229'));
            htmlEscapeSequence.put("&cup;", Character.valueOf('\u222a'));
            htmlEscapeSequence.put("&int;", Character.valueOf('\u222b'));
            htmlEscapeSequence.put("&there4;", Character.valueOf('\u2234'));
            htmlEscapeSequence.put("&sim;", Character.valueOf('\u223c'));
            htmlEscapeSequence.put("&cong;", Character.valueOf('\u2245'));
            htmlEscapeSequence.put("&asymp;", Character.valueOf('\u2248'));
            htmlEscapeSequence.put("&ne;", Character.valueOf('\u2260'));
            htmlEscapeSequence.put("&equiv;", Character.valueOf('\u2261'));
            htmlEscapeSequence.put("&le;", Character.valueOf('\u2264'));
            htmlEscapeSequence.put("&ge;", Character.valueOf('\u2265'));
            htmlEscapeSequence.put("&sub;", Character.valueOf('\u2282'));
            htmlEscapeSequence.put("&sup;", Character.valueOf('\u2283'));
            htmlEscapeSequence.put("&nsub;", Character.valueOf('\u2284'));
            htmlEscapeSequence.put("&sube;", Character.valueOf('\u2286'));
            htmlEscapeSequence.put("&supe;", Character.valueOf('\u2287'));
            htmlEscapeSequence.put("&oplus;", Character.valueOf('\u2295'));
            htmlEscapeSequence.put("&otimes;", Character.valueOf('\u2297'));
            htmlEscapeSequence.put("&perp;", Character.valueOf('\u22a5'));
            htmlEscapeSequence.put("&sdot;", Character.valueOf('\u22c5'));
            htmlEscapeSequence.put("&lceil;", Character.valueOf('\u2308'));
            htmlEscapeSequence.put("&rceil;", Character.valueOf('\u2309'));
            htmlEscapeSequence.put("&lfloor;", Character.valueOf('\u230a'));
            htmlEscapeSequence.put("&rfloor;", Character.valueOf('\u230b'));
            htmlEscapeSequence.put("&lang;", Character.valueOf('\u2329'));
            htmlEscapeSequence.put("&rang;", Character.valueOf('\u232a'));
            htmlEscapeSequence.put("&loz;", Character.valueOf('\u25ca'));
            htmlEscapeSequence.put("&spades;", Character.valueOf('\u2660'));
            htmlEscapeSequence.put("&clubs;", Character.valueOf('\u2663'));
            htmlEscapeSequence.put("&hearts;", Character.valueOf('\u2665'));
            htmlEscapeSequence.put("&diams;", Character.valueOf('\u2666'));
        }
        return htmlEscapeSequence;
    }

    private static StiHtmlTag2 convertStringToTag(String st) {
        StiHtmlTag2 tag2 = new StiHtmlTag2();
        if ((st = st.trim()).endsWith("/")) {
            tag2.state = StiHtmlTag2State.Empty;
            st = st.substring(0, st.length() - 1).trim();
        }
        tag2.attributes = StiTextRendererParseHtml.parseTagIntoPairs(st);
        if (tag2.attributes.size() == 0) {
            return tag2;
        }
        String tag = tag2.attributes.get((int)0).Key;
        if (tag.startsWith("/")) {
            tag2.state = StiHtmlTag2State.End;
            tag = tag.substring(1);
        }
        if ("p".equals(tag)) {
            tag2.tag = StiHtmlTag.P;
        } else if ("br".equals(tag)) {
            tag2.tag = StiHtmlTag.Br;
        } else if ("ol".equals(tag)) {
            tag2.tag = StiHtmlTag.OrderedList;
        } else if ("ul".equals(tag)) {
            tag2.tag = StiHtmlTag.UnorderedList;
        } else if ("li".equals(tag)) {
            tag2.tag = StiHtmlTag.ListItem;
        } else if ("a".equals(tag)) {
            tag2.tag = StiHtmlTag.A;
        } else if (!"strong".equals(tag)) {
            if ("b".equals(tag)) {
                tag2.tag = StiHtmlTag.B;
            } else if (!"em".equals(tag)) {
                if ("i".equals(tag)) {
                    tag2.tag = StiHtmlTag.I;
                } else if ("u".equals(tag)) {
                    tag2.tag = StiHtmlTag.U;
                } else if (!"strike".equals(tag)) {
                    if ("s".equals(tag)) {
                        tag2.tag = StiHtmlTag.S;
                    } else if ("sup".equals(tag)) {
                        tag2.tag = StiHtmlTag.Sup;
                    } else if ("sub".equals(tag)) {
                        tag2.tag = StiHtmlTag.Sub;
                    } else if ("letter-spacing".equals(tag)) {
                        tag2.tag = StiHtmlTag.LetterSpacing;
                    } else if ("word-spacing".equals(tag)) {
                        tag2.tag = StiHtmlTag.WordSpacing;
                    } else if ("line-height".equals(tag)) {
                        tag2.tag = StiHtmlTag.LineHeight;
                    } else if ("text-align".equals(tag)) {
                        tag2.tag = StiHtmlTag.TextAlign;
                    } else if ("font".equals(tag)) {
                        tag2.tag = StiHtmlTag.Font;
                    } else if (!"font-face".equals(tag) && !"font-family".equals(tag)) {
                        if ("font-name".equals(tag)) {
                            tag2.tag = StiHtmlTag.FontName;
                        } else if ("font-size".equals(tag)) {
                            tag2.tag = StiHtmlTag.FontSize;
                        } else if (!"font-color".equals(tag)) {
                            if ("color".equals(tag)) {
                                tag2.tag = StiHtmlTag.FontColor;
                            } else if ("background-color".equals(tag)) {
                                tag2.tag = StiHtmlTag.Backcolor;
                            }
                        }
                    }
                }
            }
        }
        if (tag2.tag == StiHtmlTag.None && !StiValidationUtil.isNullOrWhiteSpace((String)tag)) {
            tag2.tag = StiHtmlTag.Unknown;
            tag2.tagName = tag;
        }
        return tag2;
    }

    public static List<StiHtmlState> parseHtmlToStates(String inputHtml, StiHtmlState baseState) {
        return StiTextRendererParseHtml.parseHtmlToStates(inputHtml, baseState, false);
    }

    public static List<StiHtmlState> parseHtmlToStates(String inputHtml, StiHtmlState baseState, boolean storeStack) {
        ArrayList<StiHtmlState> resultList = new ArrayList<StiHtmlState>();
        StiHtmlState state = baseState;
        ArrayList<StiHtmlTagsState> stack = new ArrayList<StiHtmlTagsState>();
        int pos = 0;
        boolean lastSymIsSpace = false;
        if (inputHtml == null) {
            inputHtml = "";
        }
        while (pos < inputHtml.length()) {
            if (inputHtml.charAt(pos) != '<') {
                char ch = inputHtml.charAt(pos);
                if (Character.isWhitespace(ch) && ch != '\u00a0') {
                    if (!lastSymIsSpace) {
                        state.text.append(' ');
                        lastSymIsSpace = true;
                    }
                } else if (Character.getType(ch) != 0) {
                    state.text.append(ch);
                    lastSymIsSpace = false;
                }
                ++pos;
                continue;
            }
            if (state.text.length() > 0) {
                resultList.add(state);
                state = new StiHtmlState(state);
                state.posBegin = pos;
                if (state.ts.tag.tag == StiHtmlTag.ListItem) {
                    state.ts.tag.tag = StiHtmlTag.None;
                }
            }
            while (pos < inputHtml.length() && inputHtml.charAt(pos) == '<') {
                int posEnd;
                for (posEnd = ++pos; posEnd < inputHtml.length() && inputHtml.charAt(posEnd) != '>'; ++posEnd) {
                }
                String tag = inputHtml.substring(pos, posEnd);
                pos = posEnd;
                ++pos;
                StiHtmlTag2 tag2 = StiTextRendererParseHtml.convertStringToTag(tag);
                if (tag2.isEndTag(StiHtmlTag.P)) {
                    state.text.append('\n');
                    resultList.add(state);
                    state = new StiHtmlState(state);
                    state.posBegin = pos;
                    lastSymIsSpace = true;
                    state.ts.tag = new StiHtmlTag2(StiHtmlTag.P, StiHtmlTag2State.End);
                    if (pos < inputHtml.length() && !StiValidationUtil.isNullOrWhiteSpace((String)inputHtml.substring(pos))) {
                        double paragraphLineHeight = 0.7;
                        String attrLH = state.ts.getStyleAttribute("margin-bottom");
                        if (!StiValidationUtil.isNullOrWhiteSpace((String)attrLH)) {
                            if ((attrLH = attrLH.trim().replace(",", ".")).endsWith("px")) {
                                attrLH = attrLH.substring(0, attrLH.length() - 2);
                                paragraphLineHeight = StiTextRendererParseHtml.toDouble(attrLH) / (double)state.ts.fontSize;
                            } else {
                                paragraphLineHeight = StiTextRendererParseHtml.toDouble(attrLH);
                            }
                        }
                        state.text.append('\n');
                        double storedLineHeight = state.ts.lineHeight;
                        state.ts.lineHeight = paragraphLineHeight;
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.posBegin = pos;
                        state.ts.lineHeight = storedLineHeight;
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.None);
                    }
                    if (state.ts.indent <= 0) continue;
                    state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent));
                    resultList.add(state);
                    state = new StiHtmlState(state);
                    continue;
                }
                if (tag2.isStartTag(StiHtmlTag.P)) {
                    StiRefObject<StiHtmlState> ref = new StiRefObject<StiHtmlState>(state);
                    StiTextRendererParseHtml.parseStyleAttributes(tag2, ref, baseState.ts);
                    state = (StiHtmlState)ref.argvalue;
                    boolean isPreviousTagPClose = resultList.size() > 0 && resultList.get((int)(resultList.size() - 1)).ts.tag.tag == StiHtmlTag.P;
                    if (isPreviousTagPClose) continue;
                    if (resultList.size() > 1 || resultList.size() == 1 && resultList.get((int)0).text.toString().trim().length() != 0) {
                        state.text.append('\n');
                        resultList.add(state);
                        state = new StiHtmlState(state);
                    }
                    state.posBegin = pos;
                    lastSymIsSpace = true;
                    double paragraphLineHeight = 0.7;
                    String attrLH = state.ts.getStyleAttribute("margin-top");
                    if (!StiValidationUtil.isNullOrWhiteSpace((String)attrLH)) {
                        if ((attrLH = attrLH.trim().replace(",", ".")).endsWith("px")) {
                            attrLH = attrLH.substring(0, attrLH.length() - 2);
                            paragraphLineHeight = StiTextRendererParseHtml.toDouble(attrLH) / (double)state.ts.fontSize;
                        } else {
                            paragraphLineHeight = StiTextRendererParseHtml.toDouble(attrLH);
                        }
                    }
                    state.text.append('\n');
                    double storedLineHeight = state.ts.lineHeight;
                    state.ts.lineHeight = paragraphLineHeight;
                    state.ts.tag = new StiHtmlTag2(StiHtmlTag.P);
                    resultList.add(state);
                    state = new StiHtmlState(state);
                    state.ts.lineHeight = storedLineHeight;
                    state.posBegin = pos;
                    if (state.ts.indent <= 0) continue;
                    state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent));
                    resultList.add(state);
                    state = new StiHtmlState(state);
                    continue;
                }
                if (tag2.tag == StiHtmlTag.Br) {
                    lastSymIsSpace = true;
                    state.text.append('\n');
                    resultList.add(state);
                    state = new StiHtmlState(state);
                    state.posBegin = pos;
                    if (state.ts.indent <= 0) continue;
                    state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent));
                    continue;
                }
                if (tag2.isStartTag(StiHtmlTag.ListItem)) {
                    boolean isPreviousTagListItem;
                    boolean bl = isPreviousTagListItem = resultList.size() > 0 && resultList.get((int)(resultList.size() - 1)).ts.tag.tag == StiHtmlTag.ListItem;
                    if (!isPreviousTagListItem) {
                        lastSymIsSpace = true;
                        state.text.append('\n');
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        state.posBegin = pos;
                        if (state.ts.indent == 0 && state.listLevels == null) {
                            state.listLevels = new ArrayList<Integer>();
                            state.listLevels.add(0);
                            ++state.ts.indent;
                        }
                        state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent));
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.None);
                        state.posBegin = pos;
                    }
                    if (state.ts.indent == 0) {
                        ++state.ts.indent;
                    }
                    if (state.listLevels == null) {
                        state.listLevels = new ArrayList<Integer>();
                    }
                    while (state.ts.indent > state.listLevels.size()) {
                        state.listLevels.add(0);
                    }
                    StiHtmlState state1 = resultList.get(resultList.size() - 1);
                    state = StiTextRendererParseHtml.parseMarkerTypeAttribute(tag2.attributes, state);
                    StiTextRendererParseHtml.insertMarker(state1.text, state.listLevels.get(state.ts.indent - 1), state.ts.indent);
                    if (state.listLevels.get(state.ts.indent - 1) > 0) {
                        state.listLevels = new ArrayList<Integer>(state.listLevels);
                        state.listLevels.set(state.ts.indent - 1, state.listLevels.get(state.ts.indent - 1) + 1);
                    }
                    resultList.set(resultList.size() - 1, state1);
                    continue;
                }
                if (tag2.isEndTag(StiHtmlTag.ListItem)) {
                    boolean isPreviousTagListItem = resultList.size() > 0 && resultList.get((int)(resultList.size() - 1)).ts.tag.tag == StiHtmlTag.ListItem;
                    if (isPreviousTagListItem) continue;
                    lastSymIsSpace = true;
                    state.text.append('\n');
                    state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                    resultList.add(state);
                    state = new StiHtmlState(state);
                    state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                    state.posBegin = pos;
                    state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent));
                    resultList.add(state);
                    state = new StiHtmlState(state);
                    state.ts.tag = new StiHtmlTag2(StiHtmlTag.None);
                    state.posBegin = pos;
                    continue;
                }
                if (tag2.isStartTag(StiHtmlTag.UnorderedList)) {
                    boolean isPreviousTagListItem;
                    StiRefObject<StiHtmlState> ref = new StiRefObject<StiHtmlState>(state);
                    StiTextRendererParseHtml.parseStyleAttributes(tag2, ref, baseState.ts);
                    state = (StiHtmlState)ref.argvalue;
                    boolean bl = isPreviousTagListItem = resultList.size() > 0 && resultList.get((int)(resultList.size() - 1)).ts.tag.tag == StiHtmlTag.ListItem;
                    if (!isPreviousTagListItem) {
                        lastSymIsSpace = true;
                        if (resultList.size() <= 0 || !"\n".equals(resultList.get((int)(resultList.size() - 1)).text.toString())) {
                            state.text.append('\n');
                            state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                            resultList.add(state);
                            state = new StiHtmlState(state);
                        }
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        state.posBegin = pos;
                        state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent + 1));
                        ++state.ts.indent;
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.None);
                        state.posBegin = pos;
                    } else {
                        ++state.ts.indent;
                        StiHtmlState state1 = resultList.get(resultList.size() - 1);
                        state1.text.append(StiTextRendererParseHtml.getIndentString(1));
                        ++state1.ts.indent;
                        resultList.set(resultList.size() - 1, state1);
                    }
                    if (state.listLevels == null) {
                        state.listLevels = new ArrayList<Integer>();
                    }
                    while (state.listLevels.size() < state.ts.indent) {
                        state.listLevels.add(0);
                    }
                    state.listLevels.set(state.ts.indent - 1, 1 - state.ts.indent);
                    state = StiTextRendererParseHtml.parseMarkerTypeAttribute(tag2.attributes, state);
                    continue;
                }
                if (tag2.isEndTag(StiHtmlTag.UnorderedList)) {
                    boolean isPreviousTagListItem;
                    boolean bl = isPreviousTagListItem = resultList.size() > 0 && resultList.get((int)(resultList.size() - 1)).ts.tag.tag == StiHtmlTag.ListItem;
                    if (!isPreviousTagListItem) {
                        lastSymIsSpace = true;
                        state.text.append('\n');
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        state.posBegin = pos;
                        if (state.ts.indent > 0) {
                            --state.ts.indent;
                        }
                        state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent));
                        if (state.ts.indent == 0) {
                            state.listLevels = null;
                        }
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.None);
                        state.posBegin = pos;
                        continue;
                    }
                    if (state.ts.indent > 0) {
                        --state.ts.indent;
                    }
                    StiHtmlState state1 = resultList.get(resultList.size() - 1);
                    if (state1.ts.indent > 0) {
                        --state1.ts.indent;
                    }
                    state1.text = new StringBuilder(StiTextRendererParseHtml.getIndentString(state1.ts.indent));
                    if (state.ts.indent == 0) {
                        state.listLevels = null;
                        state1.listLevels = null;
                    }
                    resultList.set(resultList.size() - 1, state1);
                    state.posBegin = pos;
                    continue;
                }
                if (tag2.isStartTag(StiHtmlTag.OrderedList)) {
                    boolean isPreviousTagListItem;
                    StiRefObject<StiHtmlState> ref = new StiRefObject<StiHtmlState>(state);
                    StiTextRendererParseHtml.parseStyleAttributes(tag2, ref, baseState.ts);
                    state = (StiHtmlState)ref.argvalue;
                    boolean bl = isPreviousTagListItem = resultList.size() > 0 && resultList.get((int)(resultList.size() - 1)).ts.tag.tag == StiHtmlTag.ListItem;
                    if (!isPreviousTagListItem) {
                        lastSymIsSpace = true;
                        if (resultList.size() <= 0 || !"\n".equals(resultList.get((int)(resultList.size() - 1)).text.toString())) {
                            state.text.append('\n');
                            state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                            resultList.add(state);
                            state = new StiHtmlState(state);
                        }
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        state.posBegin = pos;
                        state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent + 1));
                        ++state.ts.indent;
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.None);
                        state.posBegin = pos;
                    } else {
                        ++state.ts.indent;
                        StiHtmlState state1 = resultList.get(resultList.size() - 1);
                        state1.text.append(StiTextRendererParseHtml.getIndentString(1));
                        ++state1.ts.indent;
                        resultList.set(resultList.size() - 1, state1);
                    }
                    if (state.listLevels == null) {
                        state.listLevels = new ArrayList<Integer>();
                    }
                    while (state.listLevels.size() < state.ts.indent) {
                        state.listLevels.add(1);
                    }
                    state.listLevels.set(state.ts.indent - 1, 1);
                    state = StiTextRendererParseHtml.parseMarkerTypeAttribute(tag2.attributes, state);
                    StiHtmlState state2 = resultList.get(resultList.size() - 1);
                    state2.listLevels = state.listLevels;
                    resultList.set(resultList.size() - 1, state2);
                    continue;
                }
                if (tag2.isEndTag(StiHtmlTag.OrderedList)) {
                    boolean isPreviousTagListItem;
                    boolean bl = isPreviousTagListItem = resultList.size() > 0 && resultList.get((int)(resultList.size() - 1)).ts.tag.tag == StiHtmlTag.ListItem;
                    if (!isPreviousTagListItem) {
                        lastSymIsSpace = true;
                        state.text.append('\n');
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.ListItem);
                        state.posBegin = pos;
                        if (state.ts.indent > 0) {
                            --state.ts.indent;
                        }
                        state.text.append(StiTextRendererParseHtml.getIndentString(state.ts.indent));
                        if (state.ts.indent == 0) {
                            state.listLevels = null;
                        }
                        resultList.add(state);
                        state = new StiHtmlState(state);
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.None);
                        state.posBegin = pos;
                        continue;
                    }
                    if (state.ts.indent > 0) {
                        --state.ts.indent;
                    }
                    StiHtmlState state1 = resultList.get(resultList.size() - 1);
                    if (state1.ts.indent > 0) {
                        --state1.ts.indent;
                    }
                    state1.text = new StringBuilder(StiTextRendererParseHtml.getIndentString(state1.ts.indent));
                    if (state.ts.indent == 0) {
                        state.listLevels = null;
                        state1.listLevels = null;
                    }
                    resultList.set(resultList.size() - 1, state1);
                    state.posBegin = pos;
                    continue;
                }
                if (tag2.tag != StiHtmlTag.None) {
                    StiHtmlTagsState tsOld = new StiHtmlTagsState(state.ts);
                    StiTextRendererParseHtml.parseHtmlTag(tag2, state, stack, baseState);
                    if (tsOld.fontSize != state.ts.fontSize) {
                        StiHtmlState newState = new StiHtmlState(state);
                        newState.text = state.text;
                        state.ts = tsOld;
                        state.text = new StringBuilder();
                        resultList.add(state);
                        state = newState;
                        state.ts.tag = new StiHtmlTag2(StiHtmlTag.Font);
                    }
                }
                if (!storeStack || stack.size() <= 0) continue;
                state.tagsStack = new ArrayList();
                for (StiHtmlTagsState tagState : stack) {
                    state.tagsStack.add(new StiHtmlTagsState(tagState));
                }
            }
        }
        if (state.text.length() > 0) {
            resultList.add(state);
        }
        if (resultList.size() == 0) {
            resultList.add(state);
        }
        return resultList;
    }

    private static void parseHtmlTag(StiHtmlTag2 tag2, StiHtmlState state, List<StiHtmlTagsState> stack, StiHtmlState baseState) {
        StiHtmlTagsState tsLast = new StiHtmlTagsState(state.ts);
        TagPair de = tag2.attributes.get(0);
        switch (tag2.tag) {
            case B: {
                state.ts.bold = tag2.isStart();
                break;
            }
            case I: {
                state.ts.italic = tag2.isStart();
                break;
            }
            case U: {
                state.ts.underline = tag2.isStart();
                break;
            }
            case S: {
                state.ts.strikeout = tag2.isStart();
                break;
            }
            case Sup: {
                state.ts.superscript = tag2.isStart();
                state.ts.subscript = false;
                break;
            }
            case Sub: {
                state.ts.subscript = tag2.isStart();
                state.ts.superscript = false;
                break;
            }
            case LetterSpacing: {
                if (!tag2.isStart()) break;
                double letterSpacing = 0.0;
                if (!"normal".equals(de.Value)) {
                    try {
                        letterSpacing = Double.parseDouble(de.Value);
                    }
                    catch (Exception e) {
                        letterSpacing = 0.0;
                    }
                }
                state.ts.letterSpacing = letterSpacing;
                break;
            }
            case WordSpacing: {
                if (!tag2.isStart()) break;
                double wordSpacing = 0.0;
                if (!"normal".equals(de.Value)) {
                    try {
                        wordSpacing = Double.parseDouble(de.Value);
                    }
                    catch (Exception e) {
                        wordSpacing = 0.0;
                    }
                }
                state.ts.wordSpacing = wordSpacing;
                break;
            }
            case LineHeight: {
                if (!tag2.isStart()) break;
                double lineHeight = 1.0;
                if (!"normal".equals(de.Value)) {
                    try {
                        lineHeight = Double.parseDouble(de.Value);
                    }
                    catch (Exception e) {
                        lineHeight = 1.0;
                    }
                }
                if (lineHeight < 0.0) {
                    lineHeight = 1.0;
                }
                state.ts.lineHeight = lineHeight;
                break;
            }
            case TextAlign: {
                if (!tag2.isStart()) break;
                try {
                    String align = de.Value.toLowerCase();
                    if ("left".equals(align)) {
                        state.ts.textAlign = StiTextHorAlignment.Left;
                    }
                    if ("right".equals(align)) {
                        state.ts.textAlign = StiTextHorAlignment.Right;
                    }
                    if ("center".equals(align)) {
                        state.ts.textAlign = StiTextHorAlignment.Center;
                    }
                    if (!"justify".equals(align)) break;
                    state.ts.textAlign = StiTextHorAlignment.Width;
                }
                catch (Exception align) {}
                break;
            }
            case Font: {
                if (!tag2.isStart() || tag2.attributes.size() <= 1) break;
                for (int indexDE = 1; indexDE < tag2.attributes.size(); ++indexDE) {
                    TagPair def = tag2.attributes.get(indexDE);
                    if ("color".equals(def.Key)) {
                        try {
                            state.ts.fontColor = StiTextRendererParseHtml.parseColor(def.Value, baseState.ts.fontColor);
                            state.ts.colorChanged = true;
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if ("face".equals(def.Key) || "family".equals(def.Key) || "name".equals(def.Key)) {
                        try {
                            state.ts.fontName = def.Value;
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if ("size".equals(def.Key)) {
                        float ffontSize;
                        state.ts.fontSize = ffontSize = StiTextRendererParseHtml.parseFontSize(def.Value);
                        continue;
                    }
                    if (!"style".equals(def.Key)) continue;
                    state.ts.htmlStyle = def.Value;
                }
                break;
            }
            case FontName: {
                if (!tag2.isStart()) break;
                try {
                    state.ts.fontName = de.Value;
                }
                catch (Exception indexDE) {}
                break;
            }
            case FontSize: {
                float fontSize;
                if (!tag2.isStart()) break;
                state.ts.fontSize = fontSize = StiTextRendererParseHtml.parseFontSize(de.Value);
                break;
            }
            case FontColor: {
                if (!tag2.isStart()) break;
                try {
                    state.ts.fontColor = StiTextRendererParseHtml.parseColor(de.Value, baseState.ts.fontColor);
                    state.ts.colorChanged = true;
                }
                catch (Exception fontSize) {}
                break;
            }
            case Backcolor: {
                if (!tag2.isStart()) break;
                try {
                    state.ts.backColor = StiTextRendererParseHtml.parseColor(de.Value, baseState.ts.backColor);
                    state.ts.backcolorChanged = true;
                }
                catch (Exception fontSize) {}
                break;
            }
            case A: {
                if (!tag2.isStart()) break;
                try {
                    String href;
                    if (tag2.attributes.size() <= 0 || !"href".equals(tag2.attributes.get((int)1).Key) || StiValidationUtil.isNullOrWhiteSpace((String)(href = tag2.attributes.get((int)1).Value))) break;
                    state.ts.href = href.trim();
                    state.ts.fontColor = StiColorEnum.Blue.color();
                    state.ts.colorChanged = true;
                }
                catch (Exception href) {}
                break;
            }
            case Unknown: {
                if ("stihtml".equals(tag2.tagName)) {
                    stack.clear();
                    try {
                        if (tag2.attributes.size() > 1 && tag2.attributes.get((int)1).KeyBase != null) {
                            stack.addAll(StiTextRendererParseHtml.stringToStack(tag2.attributes.get((int)1).KeyBase, baseState.ts));
                        }
                    }
                    catch (Exception href) {
                        // empty catch block
                    }
                }
                if (!"stihtml2".equals(tag2.tagName)) break;
                try {
                    int lineInfoIndent;
                    if (tag2.attributes.size() <= 2 || tag2.attributes.get((int)2).Key == null) break;
                    state.listLevels = StiTextRendererParseHtml.stringToListLevels(tag2.attributes.get((int)2).Key);
                    if (state.listLevels != null) {
                        state.ts.indent = state.listLevels.size();
                    }
                    if ((lineInfoIndent = Integer.parseInt(tag2.attributes.get((int)1).Key)) <= 0) break;
                    state.ts.indent = -lineInfoIndent;
                    break;
                }
                catch (Exception lineInfoIndent) {
                    // empty catch block
                }
            }
        }
        if (tag2.isEnd()) {
            if (stack.size() > 0) {
                for (int index = stack.size() - 1; index >= 0; --index) {
                    StiHtmlTagsState ts = stack.get(index);
                    if (!ts.tag.equals(tag2)) continue;
                    state.ts = ts;
                    stack.removeAll(stack.subList(index, stack.size()));
                    break;
                }
            }
        } else if (tag2.tag != StiHtmlTag.None) {
            tsLast.tag = tag2;
            stack.add(tsLast);
        }
        if (tag2.isStart() && tag2.attributes.size() > 1) {
            StiRefObject<StiHtmlState> ref = new StiRefObject<StiHtmlState>(state);
            StiTextRendererParseHtml.parseStyleAttributes(tag2, ref, baseState.ts);
            state = (StiHtmlState)ref.argvalue;
        }
    }

    private static List<TagPair> parseTagIntoPairs(String tag) {
        int pos;
        ArrayList<TagPair> attr = new ArrayList<TagPair>();
        for (pos = 0; pos < tag.length() && tag.charAt(pos) == ' '; ++pos) {
        }
        while (pos < tag.length()) {
            int pos2;
            TagPair pair = new TagPair();
            for (pos2 = pos; pos2 < tag.length() && tag.charAt(pos2) != ' ' && tag.charAt(pos2) != '='; ++pos2) {
            }
            pair.KeyBase = tag.substring(pos, pos2);
            pair.Key = pair.KeyBase.toLowerCase();
            for (pos = pos2; pos < tag.length() && tag.charAt(pos) == ' '; ++pos) {
            }
            if (pos < tag.length() && tag.charAt(pos) == '=') {
                ++pos;
                while (pos < tag.length() && tag.charAt(pos) == ' ') {
                    ++pos;
                }
                if (pos < tag.length()) {
                    if (tag.charAt(pos) == '\"') {
                        for (pos2 = ++pos; pos2 < tag.length() && tag.charAt(pos2) != '\"'; ++pos2) {
                        }
                        pair.Value = tag.substring(pos, pos2);
                        pos = pos2;
                        ++pos;
                    } else {
                        for (pos2 = pos; pos2 < tag.length() && tag.charAt(pos2) != ' '; ++pos2) {
                        }
                        pair.Value = tag.substring(pos, pos2);
                        pos = pos2;
                    }
                }
            }
            while (pos < tag.length() && tag.charAt(pos) == ' ') {
                ++pos;
            }
            attr.add(pair);
        }
        return attr;
    }

    private static StiHtmlState parseMarkerTypeAttribute(List<TagPair> attr, StiHtmlState state) {
        for (TagPair pair : attr) {
            if (!"type".equals(pair.KeyBase) || StiValidationUtil.isNullOrWhiteSpace((String)pair.Value) || state.listLevels == null) continue;
            int marker = pair.Value.charAt(0);
            if ("disc".equals(pair.Value)) {
                marker = 8226;
            }
            if ("circle".equals(pair.Value)) {
                marker = 9702;
            }
            if ("square".equals(pair.Value)) {
                marker = 9642;
            }
            if ("none".equals(pair.Value)) {
                marker = 32;
            }
            state.listLevels.set(state.listLevels.size() - 1, state.listLevels.get(state.listLevels.size() - 1) - marker);
        }
        return state;
    }

    private static void parseStyleAttributes(StiHtmlTag2 tag2, StiRefObject<StiHtmlState> state, StiHtmlTagsState baseTS) {
        for (int indexDE = 1; indexDE < tag2.attributes.size(); ++indexDE) {
            TagPair def = tag2.attributes.get(indexDE);
            if (!"style".equals(def.Key)) continue;
            StiTextRendererParseHtml.parseStyleAttribute(def.Value, state, baseTS);
        }
    }

    private static void parseStyleAttribute(String style, StiRefObject<StiHtmlState> state, StiHtmlTagsState baseTS) {
        String[] pairs;
        if (StiValidationUtil.isNullOrEmpty((String)style)) {
            return;
        }
        String delimiter = ".";
        for (String pair : pairs = style.trim().split(";")) {
            String value;
            String[] parts = pair.split(":");
            boolean hasValue = parts.length > 1;
            String key = parts[0].trim();
            String string = value = hasValue ? parts[1].trim() : null;
            if ("color".equals(key)) {
                try {
                    ((StiHtmlState)state.argvalue).ts.fontColor = StiTextRendererParseHtml.parseColor(value, baseTS.fontColor);
                    ((StiHtmlState)state.argvalue).ts.colorChanged = true;
                }
                catch (Exception exception) {}
                continue;
            }
            if ("background-color".equals(key)) {
                try {
                    ((StiHtmlState)state.argvalue).ts.backColor = StiTextRendererParseHtml.parseColor(value, baseTS.backColor);
                    ((StiHtmlState)state.argvalue).ts.backcolorChanged = true;
                }
                catch (Exception exception) {}
                continue;
            }
            if ("text-decoration".equals(key)) {
                if ("underline".equals(value)) {
                    ((StiHtmlState)state.argvalue).ts.underline = true;
                }
                if ("line-through".equals(value)) {
                    ((StiHtmlState)state.argvalue).ts.strikeout = true;
                }
                if (!"none".equals(value)) continue;
                ((StiHtmlState)state.argvalue).ts.underline = false;
                ((StiHtmlState)state.argvalue).ts.strikeout = false;
                continue;
            }
            if ("font-weight".equals(key)) {
                ((StiHtmlState)state.argvalue).ts.bold = "bold".equals(value) || "bolder".equals(value) || "600".equals(value) || "700".equals(value) || "800".equals(value) || "900".equals(value);
                continue;
            }
            if ("font-style".equals(key)) {
                if ("normal".equals(value)) {
                    ((StiHtmlState)state.argvalue).ts.italic = false;
                }
                if (!"italic".equals(value) && !"oblique".equals(value)) continue;
                ((StiHtmlState)state.argvalue).ts.italic = true;
                continue;
            }
            if ("font-size".equals(key)) {
                float fontSize;
                ((StiHtmlState)state.argvalue).ts.fontSize = fontSize = StiTextRendererParseHtml.parseFontSize(value);
                continue;
            }
            if ("font-face".equals(key) || "font-family".equals(key) || "font-name".equals(key)) {
                try {
                    ((StiHtmlState)state.argvalue).ts.fontName = value.replaceAll("'", "").replaceAll("\"", "");
                    if (((StiHtmlState)state.argvalue).ts.fontName.indexOf(",") <= 0) continue;
                    ((StiHtmlState)state.argvalue).ts.fontName = ((StiHtmlState)state.argvalue).ts.fontName.substring(0, ((StiHtmlState)state.argvalue).ts.fontName.indexOf(","));
                }
                catch (Exception fontSize) {}
                continue;
            }
            if ("vertical-align".equals(key)) {
                if ("baseline".equals(value)) {
                    ((StiHtmlState)state.argvalue).ts.subscript = false;
                    ((StiHtmlState)state.argvalue).ts.superscript = false;
                }
                if ("sub".equals(value)) {
                    ((StiHtmlState)state.argvalue).ts.subscript = true;
                    ((StiHtmlState)state.argvalue).ts.superscript = false;
                }
                if (!"super".equals(value)) continue;
                ((StiHtmlState)state.argvalue).ts.subscript = false;
                ((StiHtmlState)state.argvalue).ts.superscript = true;
                continue;
            }
            if ("letter-spacing".equals(key)) {
                double letterSpacing = 0.0;
                if (!"normal".equals(value)) {
                    try {
                        letterSpacing = Double.parseDouble(value.replace(',', '.'));
                    }
                    catch (Exception e) {
                        letterSpacing = 0.0;
                    }
                }
                ((StiHtmlState)state.argvalue).ts.letterSpacing = letterSpacing;
                continue;
            }
            if ("word-spacing".equals(key)) {
                double wordSpacing = 0.0;
                if (!"normal".equals(value)) {
                    try {
                        wordSpacing = Double.parseDouble(value.replace(',', '.'));
                    }
                    catch (Exception e) {
                        wordSpacing = 0.0;
                    }
                }
                ((StiHtmlState)state.argvalue).ts.wordSpacing = wordSpacing;
                continue;
            }
            if ("line-height".equals(key)) {
                double lineHeight = 1.0;
                if (!"normal".equals(value)) {
                    try {
                        lineHeight = Double.parseDouble(value.replace(',', '.'));
                    }
                    catch (Exception e) {
                        lineHeight = 1.0;
                    }
                }
                if (lineHeight < 0.0) {
                    lineHeight = 1.0;
                }
                ((StiHtmlState)state.argvalue).ts.lineHeight = lineHeight;
                continue;
            }
            if ("text-align".equals(key)) {
                String align = value.toLowerCase();
                if ("left".equals(align)) {
                    ((StiHtmlState)state.argvalue).ts.textAlign = StiTextHorAlignment.Left;
                }
                if ("right".equals(align)) {
                    ((StiHtmlState)state.argvalue).ts.textAlign = StiTextHorAlignment.Right;
                }
                if ("center".equals(align)) {
                    ((StiHtmlState)state.argvalue).ts.textAlign = StiTextHorAlignment.Center;
                }
                if (!"justify".equals(align)) continue;
                ((StiHtmlState)state.argvalue).ts.textAlign = StiTextHorAlignment.Width;
                continue;
            }
            if (StiValidationUtil.isNullOrWhiteSpace((String)key)) continue;
            if (((StiHtmlState)state.argvalue).ts.styleAttributes == null) {
                ((StiHtmlState)state.argvalue).ts.styleAttributes = new HashMap();
            }
            ((StiHtmlState)state.argvalue).ts.styleAttributes.put(key, value);
        }
    }

    public static StringBuilder PrepareStateText(StringBuilder stateText) {
        StringBuilder sbTemp = new StringBuilder();
        int indexChar = 0;
        while (indexChar < stateText.length()) {
            boolean flag = false;
            if (stateText.charAt(indexChar) == '&' && indexChar + 3 < stateText.length()) {
                int indexChar2;
                StringBuilder sbTemp2 = new StringBuilder();
                if (stateText.charAt(indexChar2) == '#') {
                    if (stateText.charAt(++indexChar2) == 'x') {
                        ++indexChar2;
                        while (indexChar2 < stateText.length() && Character.isLetterOrDigit(stateText.charAt(indexChar2))) {
                            sbTemp2.append(stateText.charAt(indexChar2));
                            ++indexChar2;
                        }
                        if (sbTemp2.length() > 0 && indexChar2 < stateText.length() && stateText.charAt(indexChar2) == ';') {
                            ++indexChar2;
                            try {
                                long num = Long.parseLong(sbTemp2.toString(), 16);
                                sbTemp.append((char)num);
                                indexChar = indexChar2;
                                flag = true;
                            }
                            catch (Exception num) {}
                        }
                    } else {
                        while (indexChar2 < stateText.length() && Character.isDigit(stateText.charAt(indexChar2))) {
                            sbTemp2.append(stateText.charAt(indexChar2));
                            ++indexChar2;
                        }
                        if (sbTemp2.length() > 0 && indexChar2 < stateText.length() && stateText.charAt(indexChar2) == ';') {
                            sbTemp.append((char)Long.parseLong(sbTemp2.toString()));
                            indexChar = ++indexChar2;
                            flag = true;
                        }
                    }
                } else {
                    Character es;
                    for (indexChar2 = indexChar + 1; indexChar2 < stateText.length() && Character.isLetterOrDigit(stateText.charAt(indexChar2)); ++indexChar2) {
                        sbTemp2.append(stateText.charAt(indexChar2));
                    }
                    if (sbTemp2.length() > 0 && indexChar2 < stateText.length() && stateText.charAt(indexChar2) == ';' && (es = StiTextRendererParseHtml.getHtmlEscapeSequence().get("&" + sbTemp2 + ";")) != null) {
                        sbTemp.append(es.charValue());
                        indexChar = ++indexChar2;
                        flag = true;
                    }
                }
            }
            if (flag) continue;
            sbTemp.append(stateText.charAt(indexChar));
            ++indexChar;
        }
        return sbTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StiColor parseColor(String colorAttribute, StiColor inheritColor) {
        if ("inherit".equalsIgnoreCase(colorAttribute)) {
            return inheritColor;
        }
        StiColor color = StiColor.Transparent;
        if (colorAttribute.length() > 1) {
            if (colorAttribute.charAt(0) == '#') {
                String colorSt = colorAttribute.substring(1).toLowerCase();
                StringBuilder sbc = new StringBuilder();
                for (int i = 0; i < colorSt.length(); ++i) {
                    char ch = colorSt.charAt(i);
                    if (ch != '0' && ch != '1' && ch != '2' && ch != '3' && ch != '4' && ch != '5' && ch != '6' && ch != '7' && ch != '8' && ch != '9' && ch != 'a' && ch != 'b' && ch != 'c' && ch != 'd' && ch != 'e' && ch != 'f') continue;
                    sbc.append(ch);
                }
                colorSt = sbc.length() == 3 ? String.format("%s%s%s%s%s%s", Character.valueOf(sbc.charAt(0)), Character.valueOf(sbc.charAt(0)), Character.valueOf(sbc.charAt(1)), Character.valueOf(sbc.charAt(1)), Character.valueOf(sbc.charAt(2)), Character.valueOf(sbc.charAt(2))) : sbc.toString();
                if (colorSt.length() == 6) {
                    long colorInt = Long.parseLong(colorSt, 16);
                    color = StiColor.fromArgb(255, (int)(colorInt >> 16) & 0xFF, (int)(colorInt >> 8) & 0xFF, (int)colorInt & 0xFF);
                }
            } else if (colorAttribute.startsWith("rgb")) {
                String[] colors = colorAttribute.trim().replace("rgba(", "").replace("rgb(", "").replace(")", "").split(",");
                if (colors.length == 3 || colors.length == 4) {
                    int[] colorsInt = new int[]{colors[0].endsWith("%") ? (int)Math.round((double)StiTextRendererParseHtml.toInt32(colors[0].substring(0, colors[0].length() - 1)) * 2.55) : StiTextRendererParseHtml.toInt32(colors[0]), colors[1].endsWith("%") ? (int)Math.round((double)StiTextRendererParseHtml.toInt32(colors[1].substring(0, colors[1].length() - 1)) * 2.55) : StiTextRendererParseHtml.toInt32(colors[1]), colors[2].endsWith("%") ? (int)Math.round((double)StiTextRendererParseHtml.toInt32(colors[2].substring(0, colors[2].length() - 1)) * 2.55) : StiTextRendererParseHtml.toInt32(colors[2])};
                    int a = colors.length == 4 ? (int)Math.round(255.0 * StiTextRendererParseHtml.toDouble(colors[3])) : 255;
                    color = StiColor.fromArgb(a, colorsInt[0], colorsInt[1], colorsInt[2]);
                }
            } else {
                Object colors = lockHtmlNameToColor;
                synchronized (colors) {
                    Object object = lockHtmlNameToColor;
                    synchronized (object) {
                        if (htmlNameToColor == null) {
                            String[][] initData = new String[][]{{"AliceBlue", "#F0F8FF"}, {"AntiqueWhite", "#FAEBD7"}, {"Aqua", "#00FFFF"}, {"Aquamarine", "#7FFFD4"}, {"Azure", "#F0FFFF"}, {"Beige", "#F5F5DC"}, {"Bisque", "#FFE4C4"}, {"Black", "#000000"}, {"BlanchedAlmond", "#FFEBCD"}, {"Blue", "#0000FF"}, {"BlueViolet", "#8A2BE2"}, {"Brown", "#A52A2A"}, {"BurlyWood", "#DEB887"}, {"CadetBlue", "#5F9EA0"}, {"Chartreuse", "#7FFF00"}, {"Chocolate", "#D2691E"}, {"Coral", "#FF7F50"}, {"CornflowerBlue", "#6495ED"}, {"Cornsilk", "#FFF8DC"}, {"Crimson", "#DC143C"}, {"Cyan", "#00FFFF"}, {"DarkBlue", "#00008B"}, {"DarkCyan", "#008B8B"}, {"DarkGoldenRod", "#B8860B"}, {"DarkGray", "#A9A9A9"}, {"DarkGrey", "#A9A9A9"}, {"DarkGreen", "#006400"}, {"DarkKhaki", "#BDB76B"}, {"DarkMagenta", "#8B008B"}, {"DarkOliveGreen", "#556B2F"}, {"Darkorange", "#FF8C00"}, {"DarkOrchid", "#9932CC"}, {"DarkRed", "#8B0000"}, {"DarkSalmon", "#E9967A"}, {"DarkSeaGreen", "#8FBC8F"}, {"DarkSlateBlue", "#483D8B"}, {"DarkSlateGray", "#2F4F4F"}, {"DarkSlateGrey", "#2F4F4F"}, {"DarkTurquoise", "#00CED1"}, {"DarkViolet", "#9400D3"}, {"DeepPink", "#FF1493"}, {"DeepSkyBlue", "#00BFFF"}, {"DimGray", "#696969"}, {"DimGrey", "#696969"}, {"DodgerBlue", "#1E90FF"}, {"FireBrick", "#B22222"}, {"FloralWhite", "#FFFAF0"}, {"ForestGreen", "#228B22"}, {"Fuchsia", "#FF00FF"}, {"Gainsboro", "#DCDCDC"}, {"GhostWhite", "#F8F8FF"}, {"Gold", "#FFD700"}, {"GoldenRod", "#DAA520"}, {"Gray", "#808080"}, {"Grey", "#808080"}, {"Green", "#008000"}, {"GreenYellow", "#ADFF2F"}, {"HoneyDew", "#F0FFF0"}, {"HotPink", "#FF69B4"}, {"IndianRed", "#CD5C5C"}, {"Indigo", "#4B0082"}, {"Ivory", "#FFFFF0"}, {"Khaki", "#F0E68C"}, {"Lavender", "#E6E6FA"}, {"LavenderBlush", "#FFF0F5"}, {"LawnGreen", "#7CFC00"}, {"LemonChiffon", "#FFFACD"}, {"LightBlue", "#ADD8E6"}, {"LightCoral", "#F08080"}, {"LightCyan", "#E0FFFF"}, {"LightGoldenRodYellow", "#FAFAD2"}, {"LightGray", "#D3D3D3"}, {"LightGrey", "#D3D3D3"}, {"LightGreen", "#90EE90"}, {"LightPink", "#FFB6C1"}, {"LightSalmon", "#FFA07A"}, {"LightSeaGreen", "#20B2AA"}, {"LightSkyBlue", "#87CEFA"}, {"LightSlateGray", "#778899"}, {"LightSlateGrey", "#778899"}, {"LightSteelBlue", "#B0C4DE"}, {"LightYellow", "#FFFFE0"}, {"Lime", "#00FF00"}, {"LimeGreen", "#32CD32"}, {"Linen", "#FAF0E6"}, {"Magenta", "#FF00FF"}, {"Maroon", "#800000"}, {"MediumAquaMarine", "#66CDAA"}, {"MediumBlue", "#0000CD"}, {"MediumOrchid", "#BA55D3"}, {"MediumPurple", "#9370D8"}, {"MediumSeaGreen", "#3CB371"}, {"MediumSlateBlue", "#7B68EE"}, {"MediumSpringGreen", "#00FA9A"}, {"MediumTurquoise", "#48D1CC"}, {"MediumVioletRed", "#C71585"}, {"MidnightBlue", "#191970"}, {"MintCream", "#F5FFFA"}, {"MistyRose", "#FFE4E1"}, {"Moccasin", "#FFE4B5"}, {"NavajoWhite", "#FFDEAD"}, {"Navy", "#000080"}, {"OldLace", "#FDF5E6"}, {"Olive", "#808000"}, {"OliveDrab", "#6B8E23"}, {"Orange", "#FFA500"}, {"OrangeRed", "#FF4500"}, {"Orchid", "#DA70D6"}, {"PaleGoldenRod", "#EEE8AA"}, {"PaleGreen", "#98FB98"}, {"PaleTurquoise", "#AFEEEE"}, {"PaleVioletRed", "#D87093"}, {"PapayaWhip", "#FFEFD5"}, {"PeachPuff", "#FFDAB9"}, {"Peru", "#CD853F"}, {"Pink", "#FFC0CB"}, {"Plum", "#DDA0DD"}, {"PowderBlue", "#B0E0E6"}, {"Purple", "#800080"}, {"Red", "#FF0000"}, {"RosyBrown", "#BC8F8F"}, {"RoyalBlue", "#4169E1"}, {"SaddleBrown", "#8B4513"}, {"Salmon", "#FA8072"}, {"SandyBrown", "#F4A460"}, {"SeaGreen", "#2E8B57"}, {"SeaShell", "#FFF5EE"}, {"Sienna", "#A0522D"}, {"Silver", "#C0C0C0"}, {"SkyBlue", "#87CEEB"}, {"SlateBlue", "#6A5ACD"}, {"SlateGray", "#708090"}, {"SlateGrey", "#708090"}, {"Snow", "#FFFAFA"}, {"SpringGreen", "#00FF7F"}, {"SteelBlue", "#4682B4"}, {"Tan", "#D2B48C"}, {"Teal", "#008080"}, {"Thistle", "#D8BFD8"}, {"Tomato", "#FF6347"}, {"Turquoise", "#40E0D0"}, {"Violet", "#EE82EE"}, {"Wheat", "#F5DEB3"}, {"White", "#FFFFFF"}, {"WhiteSmoke", "#F5F5F5"}, {"Yellow", "#FFFF00"}, {"YellowGreen", "#9ACD32"}, {"ActiveBorder", "#B4B4B4"}, {"ActiveCaption", "#99B4D1"}, {"AppWorkspace", "#ABABAB"}, {"Background", "#000000"}, {"ButtonAlternateFace", "#000000"}, {"ButtonDkShadow", "#696969"}, {"ButtonFace", "#F0F0F0"}, {"ButtonHighlight", "#FFFFFF"}, {"ButtonLight", "#E3E3E3"}, {"ButtonShadow", "#A0A0A0"}, {"ButtonText", "#000000"}, {"GradientActiveTitle", "#B9D1EA"}, {"GradientInactiveTitle", "#D7E4F2"}, {"GrayText", "#6D6D6D"}, {"Highlight", "#0078D7"}, {"HighlightText", "#FFFFFF"}, {"HotTrackingColor", "#0066CC"}, {"InactiveBorder", "#F4F7FC"}, {"InactiveCaption", "#BFCDDB"}, {"InactiveCaptionText", "#000000"}, {"InfoText", "#000000"}, {"InfoBackground", "#FFFFFF"}, {"Menu", "#F0F0F0"}, {"MenuBar", "#F0F0F0"}, {"MenuHighlight", "#0078D7"}, {"MenuText", "#000000"}, {"Scrollbar", "#C8C8C8"}, {"CaptionText", "#000000"}, {"Window", "#FFFFFF"}, {"WindowFrame", "#646464"}, {"WindowText", "#000000"}};
                            htmlNameToColor = new HashMap();
                            for (int index = 0; index < initData.length; ++index) {
                                String key = initData[index][0].toLowerCase();
                                int colorInt = Integer.parseInt(initData[index][1].substring(1), 16);
                                StiColor value = StiColor.parseIntRGB(colorInt);
                                htmlNameToColor.put(key, value);
                            }
                        }
                    }
                }
                String colorSt = colorAttribute.toLowerCase();
                if (htmlNameToColor.containsKey(colorSt)) {
                    color = htmlNameToColor.get(colorSt);
                }
            }
        }
        return color;
    }

    private static String colorToHtml(StiColor color) {
        String colorSt = color.toHTML();
        if (color.getA() != 255) {
            colorSt = "#ttt";
        }
        return colorSt;
    }

    private static float parseFontSize(String fontSizeAttribute) {
        StiGraphicsUnit unit = StiGraphicsUnit.Point;
        if (fontSizeAttribute.endsWith("px")) {
            unit = StiGraphicsUnit.Pixel;
            fontSizeAttribute = fontSizeAttribute.substring(0, fontSizeAttribute.length() - 2);
        }
        float ffontSize = 8.0f;
        try {
            ffontSize = Float.parseFloat(fontSizeAttribute.replace("pt", "").replace(',', '.'));
        }
        catch (Exception e) {
            ffontSize = 8.0f;
        }
        if ((double)ffontSize < 0.5) {
            ffontSize = 0.5f;
        }
        if (unit == StiGraphicsUnit.Pixel) {
            ffontSize *= 0.75f;
        }
        return ffontSize;
    }

    private static String StateToHtml(StiHtmlState state, StiHtmlState state2, String text, int lineInfoIndent) {
        StringBuilder sbb = new StringBuilder();
        sbb.append(String.format("<font name=\"%s\" size=\"%s\">", state.getTs().fontName, Float.valueOf(state.getTs().fontSize)));
        if (state.getTs().isColorChanged()) {
            sbb.append(String.format("<font-color=\"%s\">", StiTextRendererParseHtml.colorToHtml(state.getTs().fontColor)));
        }
        if (state.getTs().isBackcolorChanged()) {
            sbb.append(String.format("<background-color=\"%s\">", StiTextRendererParseHtml.colorToHtml(state.getTs().backColor)));
        }
        sbb.append(String.format("<%sb>", state.getTs().bold ? "" : "/"));
        sbb.append(String.format("<%si>", state.getTs().italic ? "" : "/"));
        sbb.append(String.format("<%su>", state.getTs().underline ? "" : "/"));
        sbb.append(String.format("<%ss>", state.getTs().strikeout ? "" : "/"));
        sbb.append(String.format("<%ssup>", state.getTs().superscript ? "" : "/"));
        sbb.append(String.format("<%ssub>", state.getTs().subscript ? "" : "/"));
        sbb.append(String.format("<letter-spacing=\"%s\">", state.getTs().letterSpacing));
        sbb.append(String.format("<word-spacing=\"%s\">", state.getTs().wordSpacing));
        sbb.append(String.format("<line-height=\"%s\">", state2.getTs().lineHeight));
        String align = "left";
        if (state.getTs().textAlign == StiTextHorAlignment.Center) {
            align = "center";
        }
        if (state.getTs().textAlign == StiTextHorAlignment.Right) {
            align = "right";
        }
        if (state.getTs().textAlign == StiTextHorAlignment.Width) {
            align = "justify";
        }
        sbb.append(String.format("<text-align=\"%s\">", align));
        sbb.append("<StiHtml " + StiTextRendererParseHtml.stackToString(state.tagsStack) + ">");
        if (state2.getTs().indent > 0) {
            sbb.append(String.format("<StiHtml2 %s %s>", lineInfoIndent, StiTextRendererParseHtml.listLevelsToString(state2.listLevels, state2.getTs().indent)));
        }
        if (text != null) {
            sbb.append(text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        }
        return sbb.toString();
    }

    private static String getIndentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indent; ++index) {
            sb.append("\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0");
        }
        return sb.toString();
    }

    private static void insertMarker(StringBuilder sb, Integer markerInt, int indent) {
        int offsetMarker;
        String marker = bulletBlack;
        if (markerInt > 0) {
            marker = markerInt.toString() + '.';
        } else {
            int markerInt2 = (0 - markerInt) % 2;
            if (markerInt2 == 1) {
                marker = bulletWhite;
            }
        }
        int n = offsetMarker = markerInt > 0 ? 2 : 3;
        if (sb.length() > 3) {
            if (marker.length() >= sb.length() - offsetMarker) {
                sb.delete(0, sb.length() - offsetMarker);
                sb.insert(0, marker);
            } else {
                int offset = sb.length() - offsetMarker - marker.length();
                for (int index = 0; index < marker.length(); ++index) {
                    sb.setCharAt(offset + index, marker.charAt(index));
                }
            }
        }
    }

    private static String stackToString(List<StiHtmlTagsState> stack) {
        if (stack == null || stack.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (int index = 0; index < stack.size(); ++index) {
                boolean first;
                StiHtmlTagsState state = stack.get(index);
                StiHtmlTagsState prevState = new StiHtmlTagsState();
                boolean bl = first = index == 0;
                if (!first) {
                    prevState = stack.get(index - 1);
                }
                int lastPos = sb.length();
                if (state.isBackcolorChanged()) {
                    sb.append(String.format("bc%s:", state.backColor.toArgbHTML().substring(1)));
                }
                if (state.bold && (first || state.bold != prevState.bold)) {
                    sb.append("bd:");
                }
                if (state.isColorChanged()) {
                    sb.append(String.format("fc%s:", state.fontColor.toArgbHTML().substring(1)));
                }
                if (!(StiValidationUtil.isNullOrEmpty((String)state.fontName) || !first && state.fontName.equals(prevState.fontName))) {
                    sb.append(String.format("fn%s:", state.fontName));
                }
                if (first || state.fontSize != prevState.fontSize) {
                    sb.append(String.format("fs%s:", Float.valueOf(state.fontSize)));
                }
                if (state.italic && (first || state.italic != prevState.italic)) {
                    sb.append("it:");
                }
                if (first || state.letterSpacing != prevState.letterSpacing) {
                    sb.append(String.format("ls%s:", state.letterSpacing));
                }
                if (first || state.lineHeight != prevState.lineHeight) {
                    sb.append(String.format("lh%s:", state.lineHeight));
                }
                if (state.strikeout && (first || state.strikeout != prevState.strikeout)) {
                    sb.append("st:");
                }
                if (state.subscript && (first || state.subscript != prevState.subscript)) {
                    sb.append("sb:");
                }
                if (state.superscript && (first || state.superscript != prevState.superscript)) {
                    sb.append("sp:");
                }
                if (first || !state.tag.equals(prevState.tag)) {
                    sb.append(String.format("tg%s:", state.tag.tag != StiHtmlTag.Unknown ? String.valueOf(state.tag.tag.ordinal()) : "'" + state.tag.tagName + "'"));
                }
                if (first || state.textAlign != prevState.textAlign) {
                    sb.append(String.format("ta%s:", new Object[]{state.textAlign}));
                }
                if (state.underline && (first || state.underline != prevState.underline)) {
                    sb.append("un:");
                }
                if (first || state.wordSpacing != prevState.wordSpacing) {
                    sb.append(String.format("ws%s:", state.wordSpacing));
                }
                if (sb.charAt(sb.length() - 1) == ':') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                if (index >= stack.size() - 1 || sb.length() <= lastPos) continue;
                sb.append(";");
            }
            while (sb.length() > 1 && sb.charAt(sb.length() - 1) == ';') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private static ArrayList<StiHtmlTagsState> stringToStack(String inputString, StiHtmlTagsState baseState) {
        StiHtmlTagsState lastState = new StiHtmlTagsState(baseState);
        ArrayList<StiHtmlTagsState> output = new ArrayList<StiHtmlTagsState>();
        try {
            String[] arr;
            for (String stState : arr = inputString.split(";")) {
                String[] arr2;
                StiHtmlTagsState state = new StiHtmlTagsState(lastState);
                for (String stPart : arr2 = stState.split(":")) {
                    String stParam = stPart.substring(2);
                    String st = stPart.substring(0, 2);
                    if ("bc".equals(st)) {
                        state.backColor = new StiColor(Integer.parseInt(stParam.substring(0, 2), 16), Integer.parseInt(stParam.substring(2, 4), 16), Integer.parseInt(stParam.substring(4, 6), 16), Integer.parseInt(stParam.substring(6, 8), 16));
                        state.backcolorChanged = true;
                        continue;
                    }
                    if ("bd".equals(st)) {
                        state.bold = true;
                        continue;
                    }
                    if ("fc".equals(st)) {
                        state.fontColor = new StiColor(Integer.parseInt(stParam.substring(0, 2), 16), Integer.parseInt(stParam.substring(2, 4), 16), Integer.parseInt(stParam.substring(4, 6), 16), Integer.parseInt(stParam.substring(6, 8), 16));
                        state.colorChanged = true;
                        continue;
                    }
                    if ("fn".equals(st)) {
                        state.fontName = stParam;
                        continue;
                    }
                    if ("fs".equals(st)) {
                        state.fontSize = Float.parseFloat(stParam);
                        continue;
                    }
                    if ("it".equals(st)) {
                        state.italic = true;
                        continue;
                    }
                    if ("ls".equals(st)) {
                        state.letterSpacing = Double.parseDouble(stParam);
                        continue;
                    }
                    if ("lh".equals(st)) {
                        state.lineHeight = Double.parseDouble(stParam);
                        continue;
                    }
                    if ("st".equals(st)) {
                        state.strikeout = true;
                        continue;
                    }
                    if ("sb".equals(st)) {
                        state.subscript = true;
                        continue;
                    }
                    if ("sp".equals(st)) {
                        state.superscript = true;
                        continue;
                    }
                    if ("tg".equals(st)) {
                        if (stParam.startsWith("'")) {
                            state.tag = StiTextRendererParseHtml.convertStringToTag(stParam.substring(1, stParam.length() - 1));
                            continue;
                        }
                        state.tag = new StiHtmlTag2(StiHtmlTag.values()[Integer.parseInt(stParam)]);
                        continue;
                    }
                    if ("ta".equals(st)) {
                        state.textAlign = StiTextHorAlignment.forValue(Integer.parseInt(stParam));
                        continue;
                    }
                    if ("un".equals(st)) {
                        state.underline = true;
                        continue;
                    }
                    if (!"ws".equals(st)) continue;
                    state.wordSpacing = Double.parseDouble(stParam);
                }
                output.add(state);
                lastState = state;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    private static String listLevelsToString(List<Integer> list, int indent) {
        if (list == null || list.size() == 0) {
            list = new ArrayList<Integer>();
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (int index = 0; index < indent; ++index) {
                if (index < list.size()) {
                    sb.append(list.get(index).toString());
                } else {
                    sb.append("0");
                }
                if (index >= indent - 1) continue;
                sb.append(";");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private static List<Integer> stringToListLevels(String inputString) {
        ArrayList<Integer> output = new ArrayList<Integer>();
        try {
            String[] arr;
            for (String marker : arr = inputString.split(";")) {
                output.add(Integer.parseInt(marker));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public static int toInt32(Object value) {
        int result = 0;
        try {
            result = Integer.parseInt(String.valueOf(value).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List<List<StiGlyph>> getGlyphsGrouped(List<StiGlyph> gls) {
        ArrayList<List<StiGlyph>> result = new ArrayList<List<StiGlyph>>();
        ArrayList<StiGlyph> out = new ArrayList<StiGlyph>();
        int i = 0;
        while (i < gls.size()) {
            if (i < gls.size() - 1 && ".".equals(gls.get((int)i).text) && " ".equals(gls.get((int)(i + 1)).text)) {
                if (out.size() > 0) {
                    result.add(out);
                }
                out = new ArrayList();
                out.add(gls.get(i));
                out.add(gls.get(i + 1));
                result.add(out);
                out = new ArrayList();
                i += 2;
                continue;
            }
            if (!(i <= 0 || (Character.isLetter(gls.get((int)(i - 1)).text.charAt(0)) || Character.isWhitespace(gls.get((int)(i - 1)).text.charAt(0))) && gls.get((int)i).ts.bold == gls.get((int)(i - 1)).ts.bold && gls.get((int)i).ts.italic == gls.get((int)(i - 1)).ts.italic && gls.get((int)i).ts.underline == gls.get((int)(i - 1)).ts.underline && gls.get((int)i).ts.strikeout == gls.get((int)(i - 1)).ts.strikeout && StiValidationUtil.equals((Object)gls.get((int)i).ts.href, (Object)gls.get((int)(i - 1)).ts.href) && gls.get((int)i).ts.subscript == gls.get((int)(i - 1)).ts.subscript && gls.get((int)i).ts.superscript == gls.get((int)(i - 1)).ts.superscript && gls.get((int)i).ts.backColor.equals(gls.get((int)(i - 1)).ts.backColor) && gls.get((int)i).ts.fontColor.equals(gls.get((int)(i - 1)).ts.fontColor) && gls.get((int)i).font.equals(gls.get((int)(i - 1)).font))) {
                if (out.size() > 0) {
                    result.add(out);
                }
                out = new ArrayList();
            }
            if (!"\n".equals(gls.get((int)i).text)) {
                out.add(gls.get(i));
            }
            ++i;
        }
        if (out.size() > 0) {
            result.add(out);
        }
        return result;
    }

    public static List<StiGlyph> getGlyphs(List<StiHtmlState> htmlStates, Graphics2D g) {
        double cf = 100.0;
        ArrayList<StiGlyph> glyphs = new ArrayList<StiGlyph>();
        for (StiHtmlState state : htmlStates) {
            StringBuilder txt = StiTextRendererParseHtml.PrepareStateText(state.text);
            StiEnumSet<StiFontStyle> style = StiEnumSet.noneOf(StiFontStyle.class);
            if (state.ts.bold) {
                style.add(StiFontStyle.Bold);
            }
            if (state.ts.italic) {
                style.add(StiFontStyle.Italic);
            }
            if (state.ts.underline) {
                style.add(StiFontStyle.Underline);
            }
            if (state.ts.strikeout) {
                style.add(StiFontStyle.Strikeout);
            }
            if (state.ts.superscript || state.ts.subscript) {
                state.ts.setFontSize(state.ts.getFontSize() / 1.5f);
            }
            StiFont font10 = new StiFont(state.ts.fontName, (double)state.ts.getFontSize() * cf, style);
            StiFont font = (StiFont)font10.clone();
            font.size /= cf;
            Font awtFont10 = font10.getAwtFont(1.0);
            Font awtFont = font.getAwtFont(1.0);
            if (txt.length() <= 0) continue;
            for (int i = 0; i < txt.length(); ++i) {
                String gl = txt.substring(i, i + 1);
                FontMetrics metrics = g.getFontMetrics(awtFont10);
                Rectangle2D bounds = metrics.getStringBounds(gl, g);
                LineMetrics lm = metrics.getLineMetrics(gl, g);
                StiGlyph glyph = new StiGlyph();
                glyph.awtFont = awtFont;
                glyph.font = font;
                glyph.height = (double)lm.getHeight() / (cf * 1.02);
                glyph.descent = (double)lm.getDescent() / cf;
                glyph.text = gl;
                glyph.underline = state.ts.underline;
                glyph.width = bounds.getWidth() / cf;
                glyph.color = state.ts.fontColor.getAwtColor();
                glyph.stiColor = state.ts.fontColor;
                glyph.backColor = state.ts.backColor.getAwtColor();
                glyph.underlineOffset = (double)lm.getUnderlineOffset() / cf;
                glyph.underlineThickness = (double)lm.getUnderlineThickness() / cf;
                glyph.ts = state.ts;
                if (state.ts.letterSpacing > 0.0) {
                    glyph.width *= state.ts.letterSpacing + 1.0;
                }
                glyphs.add(glyph);
            }
        }
        return glyphs;
    }

    public static int getNextLine(List<StiGlyph> glyphs, int pos, double width, Graphics2D g, StiRenderLine line) {
        StiRenderLine wordLine = new StiRenderLine();
        int wordPos = pos;
        StiTextHorAlignment align = pos < glyphs.size() ? glyphs.get((int)pos).ts.textAlign : StiTextHorAlignment.Left;
        boolean breakByNewLineSymbol = false;
        while (pos < glyphs.size()) {
            StiGlyph gl = glyphs.get(pos);
            if (line.width + gl.width > width) {
                if (line.glyphs.size() == 0) {
                    line.glyphs.add(gl);
                    line.width += gl.width;
                    line.height = gl.height;
                    line.descent = gl.descent;
                    line.ts = gl.ts;
                }
                if (wordLine.glyphs.size() <= 0) break;
                wordLine.copyTo(line);
                pos = wordPos;
                break;
            }
            line.glyphs.add(gl);
            line.width += gl.width;
            if (gl.width > 0.0) {
                line.height = Math.max(line.height, gl.height);
                line.descent = Math.max(line.descent, gl.descent);
            }
            ++pos;
            if (Character.isWhitespace(gl.text.charAt(0))) {
                line.copyTo(wordLine);
                wordPos = pos;
            } else {
                line.ts = gl.ts;
            }
            if (line.glyphs.size() == 1 && "\n".equals(line.glyphs.get((int)0).text)) {
                line.height = Math.max(line.height, gl.height);
                line.descent = Math.max(line.descent, gl.descent);
            }
            if (pos >= glyphs.size() || !"\n".equals(gl.text)) continue;
            breakByNewLineSymbol = true;
            break;
        }
        if (align == StiTextHorAlignment.Width && pos < glyphs.size() && !breakByNewLineSymbol) {
            ArrayList<StiGlyph> spaces = new ArrayList<StiGlyph>();
            for (StiGlyph gl : line.glyphs) {
                if (!Character.isWhitespace(gl.text.charAt(0))) continue;
                spaces.add(gl);
            }
            if (spaces.size() > 0) {
                double cx = (width - line.width) / (double)spaces.size();
                for (StiGlyph gl : spaces) {
                    gl.width += cx;
                    line.width += cx;
                }
            }
        }
        line.height *= line.glyphs.get((int)0).ts.lineHeight;
        return pos;
    }

    static double toDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static class StiRenderLine {
        public double width;
        public double height;
        public double descent;
        public List<StiGlyph> glyphs = new ArrayList<StiGlyph>();
        public StiHtmlTagsState ts;

        public void copyTo(StiRenderLine toLine) {
            toLine.width = this.width;
            toLine.height = this.height;
            toLine.descent = this.descent;
            toLine.ts = this.ts;
            toLine.glyphs.clear();
            for (StiGlyph gl : this.glyphs) {
                toLine.glyphs.add(gl);
            }
        }
    }
}

